/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.typehierarchy;

import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IMember;
import org.eclipse.wst.jsdt.core.IMethod;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.ITypeHierarchy;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.internal.corext.util.MethodOverrideTester;
import org.eclipse.wst.jsdt.internal.ui.typehierarchy.MethodsViewer;
import org.eclipse.wst.jsdt.internal.ui.typehierarchy.TypeHierarchyLifeCycle;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.AppearanceAwareLabelProvider;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.ColoredString;
import org.eclipse.wst.jsdt.ui.JavaElementLabels;

public class MethodsLabelProvider
extends AppearanceAwareLabelProvider {
    private boolean fShowDefiningType;
    private TypeHierarchyLifeCycle fHierarchy;
    private MethodsViewer fMethodsViewer;
    private IPropertyChangeListener fColorRegistryListener;

    public MethodsLabelProvider(TypeHierarchyLifeCycle typeHierarchyLifeCycle, MethodsViewer methodsViewer) {
        super(36283885813801L, 1);
        this.fHierarchy = typeHierarchyLifeCycle;
        this.fShowDefiningType = false;
        this.fMethodsViewer = methodsViewer;
        this.fColorRegistryListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getProperty().equals("org.eclipse.wst.jsdt.ui.ColoredLabels.inherited")) {
                    MethodsLabelProvider.this.fireLabelProviderChanged(new LabelProviderChangedEvent((IBaseLabelProvider)MethodsLabelProvider.this, null));
                }
            }
        };
        JFaceResources.getColorRegistry().addListener(this.fColorRegistryListener);
    }

    public void setShowDefiningType(boolean bl) {
        this.fShowDefiningType = bl;
    }

    public boolean isShowDefiningType() {
        return this.fShowDefiningType;
    }

    private IType getDefiningType(Object object) throws JavaModelException {
        int n = ((IJavaElement)object).getElementType();
        if (n != 9 && n != 8 && n != 10) {
            return null;
        }
        IType iType = ((IMember)object).getDeclaringType();
        if (n != 9) {
            return iType;
        }
        ITypeHierarchy iTypeHierarchy = this.fHierarchy.getHierarchy();
        if (iTypeHierarchy == null) {
            return iType;
        }
        MethodOverrideTester methodOverrideTester = new MethodOverrideTester(iType, iTypeHierarchy);
        IMethod iMethod = (IMethod)object;
        IMethod iMethod2 = methodOverrideTester.findDeclaringMethod(iMethod, true);
        if (iMethod2 == null || iMethod.equals(iMethod2)) {
            return iType;
        }
        return iMethod2.getDeclaringType();
    }

    public String getText(Object object) {
        String string = super.getText(object);
        String string2 = this.getQualifier(object);
        if (string2 != null) {
            return String.valueOf(string2) + string;
        }
        return string;
    }

    public ColoredString getRichTextLabel(Object object) {
        ColoredString coloredString = super.getRichTextLabel(object);
        String string = this.getQualifier(object);
        if (string != null) {
            return new ColoredString(string).append(coloredString);
        }
        return coloredString;
    }

    private String getQualifier(Object object) {
        if (this.fShowDefiningType) {
            try {
                IType iType = this.getDefiningType(object);
                if (iType != null) {
                    return String.valueOf(super.getText(iType)) + JavaElementLabels.CONCAT_STRING;
                }
            }
            catch (JavaModelException javaModelException) {}
        }
        return null;
    }

    public Color getForeground(Object object) {
        IMethod iMethod;
        IType iType;
        if (this.fMethodsViewer.isShowInheritedMethods() && object instanceof IMethod && ((iType = (iMethod = (IMethod)object).getDeclaringType()) == null || !iType.equals(this.fMethodsViewer.getInput()))) {
            return JFaceResources.getColorRegistry().get("org.eclipse.wst.jsdt.ui.ColoredLabels.inherited");
        }
        return null;
    }

    public void dispose() {
        JFaceResources.getColorRegistry().removeListener(this.fColorRegistryListener);
        this.fColorRegistryListener = null;
        super.dispose();
    }
}

