/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.typehierarchy;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.wst.jsdt.core.ElementChangedEvent;
import org.eclipse.wst.jsdt.core.IClassFile;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IElementChangedListener;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IJavaElementDelta;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.core.IRegion;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.ITypeHierarchy;
import org.eclipse.wst.jsdt.core.ITypeHierarchyChangedListener;
import org.eclipse.wst.jsdt.core.JavaCore;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.internal.corext.util.JavaModelUtil;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.typehierarchy.ITypeHierarchyLifeCycleListener;

public class TypeHierarchyLifeCycle
implements ITypeHierarchyChangedListener,
IElementChangedListener {
    private boolean fHierarchyRefreshNeeded;
    private ITypeHierarchy fHierarchy = null;
    private IJavaElement fInputElement = null;
    private boolean fIsSuperTypesOnly;
    private List fChangeListeners;

    public TypeHierarchyLifeCycle() {
        this(false);
    }

    public TypeHierarchyLifeCycle(boolean bl) {
        this.fIsSuperTypesOnly = bl;
        this.fChangeListeners = new ArrayList(2);
    }

    public ITypeHierarchy getHierarchy() {
        return this.fHierarchy;
    }

    public IJavaElement getInputElement() {
        return this.fInputElement;
    }

    public void freeHierarchy() {
        if (this.fHierarchy != null) {
            this.fHierarchy.removeTypeHierarchyChangedListener((ITypeHierarchyChangedListener)this);
            JavaCore.removeElementChangedListener((IElementChangedListener)this);
            this.fHierarchy = null;
            this.fInputElement = null;
        }
    }

    public void removeChangedListener(ITypeHierarchyLifeCycleListener iTypeHierarchyLifeCycleListener) {
        this.fChangeListeners.remove(iTypeHierarchyLifeCycleListener);
    }

    public void addChangedListener(ITypeHierarchyLifeCycleListener iTypeHierarchyLifeCycleListener) {
        if (!this.fChangeListeners.contains(iTypeHierarchyLifeCycleListener)) {
            this.fChangeListeners.add(iTypeHierarchyLifeCycleListener);
        }
    }

    private void fireChange(IType[] iTypeArray) {
        int n = this.fChangeListeners.size() - 1;
        while (n >= 0) {
            ITypeHierarchyLifeCycleListener iTypeHierarchyLifeCycleListener = (ITypeHierarchyLifeCycleListener)this.fChangeListeners.get(n);
            iTypeHierarchyLifeCycleListener.typeHierarchyChanged(this, iTypeArray);
            --n;
        }
    }

    public void ensureRefreshedTypeHierarchy(final IJavaElement iJavaElement, IRunnableContext iRunnableContext) throws InvocationTargetException, InterruptedException {
        boolean bl;
        if (iJavaElement == null || !iJavaElement.exists()) {
            this.freeHierarchy();
            return;
        }
        boolean bl2 = bl = this.fHierarchy == null || !iJavaElement.equals(this.fInputElement);
        if (bl || this.fHierarchyRefreshNeeded) {
            IRunnableWithProgress iRunnableWithProgress = new IRunnableWithProgress(){

                public void run(IProgressMonitor iProgressMonitor) throws InvocationTargetException, InterruptedException {
                    try {
                        TypeHierarchyLifeCycle.this.doHierarchyRefresh(iJavaElement, iProgressMonitor);
                    }
                    catch (JavaModelException javaModelException) {
                        throw new InvocationTargetException(javaModelException);
                    }
                    catch (OperationCanceledException operationCanceledException) {
                        throw new InterruptedException();
                    }
                }
            };
            this.fHierarchyRefreshNeeded = true;
            iRunnableContext.run(true, true, iRunnableWithProgress);
            this.fHierarchyRefreshNeeded = false;
        }
    }

    private ITypeHierarchy createTypeHierarchy(IJavaElement iJavaElement, IProgressMonitor iProgressMonitor) throws JavaModelException {
        IJavaProject iJavaProject;
        if (iJavaElement.getElementType() == 7) {
            IType iType = (IType)iJavaElement;
            if (this.fIsSuperTypesOnly) {
                return iType.newSupertypeHierarchy(iProgressMonitor);
            }
            return iType.newTypeHierarchy(iProgressMonitor);
        }
        IRegion iRegion = JavaCore.newRegion();
        if (iJavaElement.getElementType() == 2) {
            iJavaProject = ((IJavaProject)iJavaElement).getPackageFragmentRoots();
            int n = 0;
            while (n < ((IPackageFragmentRoot[])iJavaProject).length) {
                if (!iJavaProject[n].isExternal()) {
                    iRegion.add((IJavaElement)iJavaProject[n]);
                }
                ++n;
            }
        } else if (iJavaElement.getElementType() == 4) {
            iJavaProject = iJavaElement.getJavaProject().getPackageFragmentRoots();
            String string = iJavaElement.getElementName();
            int n = 0;
            while (n < ((IJavaProject)iJavaProject).length) {
                IPackageFragment iPackageFragment = iJavaProject[n].getPackageFragment(string);
                if (iPackageFragment.exists()) {
                    iRegion.add((IJavaElement)iPackageFragment);
                }
                ++n;
            }
        } else {
            iRegion.add(iJavaElement);
        }
        iJavaProject = iJavaElement.getJavaProject();
        return iJavaProject.newTypeHierarchy(iRegion, iProgressMonitor);
    }

    public synchronized void doHierarchyRefresh(IJavaElement iJavaElement, IProgressMonitor iProgressMonitor) throws JavaModelException {
        boolean bl;
        boolean bl2 = bl = this.fHierarchy == null || !iJavaElement.equals(this.fInputElement);
        if (this.fHierarchy != null) {
            this.fHierarchy.removeTypeHierarchyChangedListener((ITypeHierarchyChangedListener)this);
            JavaCore.removeElementChangedListener((IElementChangedListener)this);
        }
        if (bl) {
            this.fHierarchy = this.createTypeHierarchy(iJavaElement, iProgressMonitor);
            if (iProgressMonitor != null && iProgressMonitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            this.fInputElement = iJavaElement;
        } else {
            this.fHierarchy.refresh(iProgressMonitor);
        }
        this.fHierarchy.addTypeHierarchyChangedListener((ITypeHierarchyChangedListener)this);
        JavaCore.addElementChangedListener((IElementChangedListener)this);
        this.fHierarchyRefreshNeeded = false;
    }

    public void typeHierarchyChanged(ITypeHierarchy iTypeHierarchy) {
        this.fHierarchyRefreshNeeded = true;
        this.fireChange(null);
    }

    public void elementChanged(ElementChangedEvent elementChangedEvent) {
        if (this.fChangeListeners.isEmpty()) {
            return;
        }
        if (this.fHierarchyRefreshNeeded) {
            return;
        }
        ArrayList arrayList = new ArrayList();
        this.processDelta(elementChangedEvent.getDelta(), arrayList);
        if (arrayList.size() > 0) {
            this.fireChange(arrayList.toArray(new IType[arrayList.size()]));
        }
    }

    private void processDelta(IJavaElementDelta iJavaElementDelta, ArrayList arrayList) {
        IJavaElement iJavaElement = iJavaElementDelta.getElement();
        switch (iJavaElement.getElementType()) {
            case 7: {
                this.processTypeDelta((IType)iJavaElement, arrayList);
                this.processChildrenDelta(iJavaElementDelta, arrayList);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                this.processChildrenDelta(iJavaElementDelta, arrayList);
                break;
            }
            case 5: {
                ICompilationUnit iCompilationUnit = (ICompilationUnit)iJavaElement;
                if (!JavaModelUtil.isPrimary(iCompilationUnit)) {
                    return;
                }
                if (iJavaElementDelta.getKind() == 4 && this.isPossibleStructuralChange(iJavaElementDelta.getFlags())) {
                    try {
                        if (!iCompilationUnit.exists()) break;
                        IType[] iTypeArray = iCompilationUnit.getAllTypes();
                        int n = 0;
                        while (n < iTypeArray.length) {
                            this.processTypeDelta(iTypeArray[n], arrayList);
                            ++n;
                        }
                    }
                    catch (JavaModelException javaModelException) {
                        JavaPlugin.log(javaModelException);
                    }
                    break;
                }
                this.processChildrenDelta(iJavaElementDelta, arrayList);
                break;
            }
            case 6: {
                if (iJavaElementDelta.getKind() == 4) {
                    IType iType = ((IClassFile)iJavaElement).getType();
                    this.processTypeDelta(iType, arrayList);
                    break;
                }
                this.processChildrenDelta(iJavaElementDelta, arrayList);
            }
        }
    }

    private boolean isPossibleStructuralChange(int n) {
        return (n & 0x4001) == 1;
    }

    private void processTypeDelta(IType iType, ArrayList arrayList) {
        if (this.getHierarchy().contains(iType)) {
            arrayList.add(iType);
        }
    }

    private void processChildrenDelta(IJavaElementDelta iJavaElementDelta, ArrayList arrayList) {
        IJavaElementDelta[] iJavaElementDeltaArray = iJavaElementDelta.getAffectedChildren();
        int n = 0;
        while (n < iJavaElementDeltaArray.length) {
            this.processDelta(iJavaElementDeltaArray[n], arrayList);
            ++n;
        }
    }
}

