/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.typehierarchy;

import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.internal.ui.packageview.SelectionTransferDropAdapter;
import org.eclipse.wst.jsdt.internal.ui.typehierarchy.TypeHierarchyViewPart;
import org.eclipse.wst.jsdt.internal.ui.util.OpenTypeHierarchyUtil;
import org.eclipse.wst.jsdt.internal.ui.util.SelectionUtil;

public class TypeHierarchyTransferDropAdapter
extends SelectionTransferDropAdapter {
    private static final int OPERATION = 4;
    private TypeHierarchyViewPart fTypeHierarchyViewPart;

    public TypeHierarchyTransferDropAdapter(TypeHierarchyViewPart typeHierarchyViewPart, AbstractTreeViewer abstractTreeViewer) {
        super((StructuredViewer)abstractTreeViewer);
        this.setFullWidthMatchesItem(false);
        this.fTypeHierarchyViewPart = typeHierarchyViewPart;
    }

    public void validateDrop(Object object, DropTargetEvent dropTargetEvent, int n) {
        dropTargetEvent.detail = 0;
        this.initializeSelection();
        if (object != null) {
            super.validateDrop(object, dropTargetEvent, n);
            return;
        }
        if (TypeHierarchyTransferDropAdapter.getInputElement(this.getSelection()) != null) {
            dropTargetEvent.detail = 4;
        }
    }

    public boolean isEnabled(DropTargetEvent dropTargetEvent) {
        return true;
    }

    public void drop(Object object, DropTargetEvent dropTargetEvent) {
        if (object != null || dropTargetEvent.detail != 4) {
            super.drop(object, dropTargetEvent);
            return;
        }
        IJavaElement iJavaElement = TypeHierarchyTransferDropAdapter.getInputElement(this.getSelection());
        this.fTypeHierarchyViewPart.setInputElement(iJavaElement);
    }

    private static IJavaElement getInputElement(ISelection iSelection) {
        Object object = SelectionUtil.getSingleElement(iSelection);
        if (object == null) {
            return null;
        }
        IJavaElement[] iJavaElementArray = OpenTypeHierarchyUtil.getCandidates(object);
        if (iJavaElementArray != null && iJavaElementArray.length > 0) {
            return iJavaElementArray[0];
        }
        return null;
    }
}

