/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.viewsupport;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.swt.widgets.Control;
import org.eclipse.wst.jsdt.core.JavaCore;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.ProblemTreeViewer;

public class FilterUpdater
implements IResourceChangeListener {
    private ProblemTreeViewer fViewer;

    public FilterUpdater(ProblemTreeViewer problemTreeViewer) {
        Assert.isNotNull((Object)problemTreeViewer);
        this.fViewer = problemTreeViewer;
    }

    public void resourceChanged(IResourceChangeEvent iResourceChangeEvent) {
        if (this.fViewer.getInput() == null) {
            return;
        }
        IResourceDelta iResourceDelta = iResourceChangeEvent.getDelta();
        if (iResourceDelta == null) {
            return;
        }
        IResourceDelta[] iResourceDeltaArray = iResourceDelta.getAffectedChildren(4);
        int n = 0;
        while (n < iResourceDeltaArray.length) {
            IProject iProject;
            IResourceDelta iResourceDelta2 = iResourceDeltaArray[n];
            if ((iResourceDelta2.getFlags() & 0x80000) != 0 && this.needsRefiltering(iProject = (IProject)iResourceDelta2.getResource())) {
                final Control control = this.fViewer.getControl();
                if (control != null && !control.isDisposed()) {
                    control.getDisplay().asyncExec(new Runnable(){

                        public void run() {
                            if (!control.isDisposed()) {
                                FilterUpdater.this.fViewer.refresh(false);
                            }
                        }
                    });
                }
                return;
            }
            ++n;
        }
    }

    private boolean needsRefiltering(IProject iProject) {
        try {
            IProject iProject2 = iProject;
            if (iProject.hasNature("org.eclipse.wst.jsdt.core.jsNature")) {
                iProject2 = JavaCore.create((IProject)iProject);
            }
            boolean bl = this.fViewer.testFindItem(iProject2) != null;
            boolean bl2 = !this.fViewer.isFiltered(iProject2, this.fViewer.getInput());
            return bl ^ bl2;
        }
        catch (CoreException coreException) {
            return true;
        }
    }
}

