/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.viewsupport;

import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.HistoryDropDownAction;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.HistoryListAction;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.ViewHistory;

class HistoryDropDownAction
extends Action {
    public static final int RESULTS_IN_DROP_DOWN = 10;
    private ViewHistory fHistory;
    private Menu fMenu;

    public HistoryDropDownAction(ViewHistory viewHistory) {
        this.fHistory = viewHistory;
        this.fMenu = null;
        this.setMenuCreator(new HistoryMenuCreator());
        this.fHistory.configureHistoryDropDownAction((IAction)this);
    }

    public void run() {
        new HistoryListAction(this.fHistory).run();
    }

    private class HistoryAction
    extends Action {
        private final Object fElement;

        public HistoryAction(Object object, int n) {
            super("", 8);
            Assert.isNotNull((Object)object);
            this.fElement = object;
            String string = HistoryDropDownAction.this.fHistory.getText(object);
            if (n < 10) {
                string = "" + '&' + n + ' ' + string;
            }
            this.setText(string);
            this.setImageDescriptor(HistoryDropDownAction.this.fHistory.getImageDescriptor(object));
        }

        public void run() {
            HistoryDropDownAction.this.fHistory.setActiveEntry(this.fElement);
        }
    }

    private class HistoryMenuCreator
    implements IMenuCreator {
        private HistoryMenuCreator() {
        }

        public Menu getMenu(Menu menu) {
            return null;
        }

        public Menu getMenu(Control control) {
            if (HistoryDropDownAction.this.fMenu != null) {
                HistoryDropDownAction.this.fMenu.dispose();
            }
            MenuManager menuManager = new MenuManager();
            menuManager.setRemoveAllWhenShown(true);
            menuManager.addMenuListener(new IMenuListener(this, menuManager){
                final /* synthetic */ HistoryMenuCreator this$1;
                private final /* synthetic */ MenuManager val$manager;
                {
                    this.this$1 = historyMenuCreator;
                    this.val$manager = menuManager;
                }

                public void menuAboutToShow(IMenuManager iMenuManager) {
                    List list = HistoryDropDownAction.access$0(HistoryMenuCreator.access$1(this.this$1)).getHistoryEntries();
                    boolean bl = this.addEntryMenuItems(iMenuManager, list);
                    iMenuManager.add((IContributionItem)new Separator());
                    HistoryListAction historyListAction = new HistoryListAction(HistoryDropDownAction.access$0(HistoryMenuCreator.access$1(this.this$1)));
                    historyListAction.setChecked(bl);
                    iMenuManager.add((IAction)historyListAction);
                    Action action = HistoryDropDownAction.access$0(HistoryMenuCreator.access$1(this.this$1)).getClearAction();
                    if (action != null) {
                        iMenuManager.add((IAction)action);
                    }
                    iMenuManager.add((IContributionItem)new Separator("additions"));
                    HistoryDropDownAction.access$0(HistoryMenuCreator.access$1(this.this$1)).addMenuEntries(this.val$manager);
                }

                private boolean addEntryMenuItems(IMenuManager iMenuManager, List list) {
                    if (list.isEmpty()) {
                        return false;
                    }
                    boolean bl = true;
                    int n = Math.min(list.size(), 10);
                    int n2 = 0;
                    while (n2 < n) {
                        E e = list.get(n2);
                        HistoryAction historyAction = HistoryMenuCreator.access$1(this.this$1).new HistoryAction(e, n2 + 1);
                        boolean bl2 = e.equals(HistoryDropDownAction.access$0(HistoryMenuCreator.access$1(this.this$1)).getCurrentEntry());
                        historyAction.setChecked(bl2);
                        if (bl2) {
                            bl = false;
                        }
                        iMenuManager.add((IAction)historyAction);
                        ++n2;
                    }
                    return bl;
                }
            });
            HistoryDropDownAction.this.fMenu = menuManager.createContextMenu(control);
            Display display = control.getDisplay();
            HistoryDropDownAction.this.fMenu.addMenuListener((MenuListener)new MenuAdapter(this, display, menuManager){
                final /* synthetic */ HistoryMenuCreator this$1;
                private final /* synthetic */ Display val$display;
                private final /* synthetic */ MenuManager val$manager;
                {
                    this.this$1 = historyMenuCreator;
                    this.val$display = display;
                    this.val$manager = menuManager;
                }

                public void menuHidden(MenuEvent menuEvent) {
                    this.val$display.asyncExec(new Runnable(this, this.val$manager){
                        final /* synthetic */ 2 this$2;
                        private final /* synthetic */ MenuManager val$manager;
                        {
                            this.this$2 = var1_1;
                            this.val$manager = menuManager;
                        }

                        public void run() {
                            this.val$manager.removeAll();
                            if (HistoryDropDownAction.access$1(HistoryMenuCreator.access$1(2.access$0(this.this$2))) != null) {
                                HistoryDropDownAction.access$1(HistoryMenuCreator.access$1(2.access$0(this.this$2))).dispose();
                                HistoryDropDownAction.access$2(HistoryMenuCreator.access$1(2.access$0(this.this$2)), null);
                            }
                        }
                    });
                }

                static /* synthetic */ HistoryMenuCreator access$0(2 var0) {
                    return var0.this$1;
                }
            });
            return HistoryDropDownAction.this.fMenu;
        }

        public void dispose() {
            HistoryDropDownAction.this.fHistory = null;
            if (HistoryDropDownAction.this.fMenu != null) {
                HistoryDropDownAction.this.fMenu.dispose();
                HistoryDropDownAction.this.fMenu = null;
            }
        }

        static /* synthetic */ HistoryDropDownAction access$1(HistoryMenuCreator historyMenuCreator) {
            return historyMenuCreator.HistoryDropDownAction.this;
        }
    }
}

