/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IWorkbench;
import org.eclipse.wst.jsdt.core.ClasspathContainerInitializer;
import org.eclipse.wst.jsdt.core.IAccessRule;
import org.eclipse.wst.jsdt.core.IClasspathContainer;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.JavaCore;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.IClasspathContainerInitialzerExtension;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.JavaPluginImages;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.ImageDescriptorRegistry;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.JavaElementImageProvider;
import org.eclipse.wst.jsdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.AccessRulesLabelProvider;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.ArchiveFileFilter;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.CPListElement;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.CPListElementAttribute;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.CPUserLibraryElement;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.ClasspathAttributeConfigurationDescriptors;
import org.eclipse.wst.jsdt.ui.ISharedImages;
import org.eclipse.wst.jsdt.ui.JavaElementImageDescriptor;
import org.eclipse.wst.jsdt.ui.JavaElementLabels;
import org.eclipse.wst.jsdt.ui.JavaUI;
import org.eclipse.wst.jsdt.ui.wizards.ClasspathAttributeConfiguration;

public class CPListLabelProvider
extends LabelProvider {
    private String fNewLabel = NewWizardMessages.CPListLabelProvider_new;
    private String fClassLabel = NewWizardMessages.CPListLabelProvider_classcontainer;
    private String fCreateLabel = NewWizardMessages.CPListLabelProvider_willbecreated;
    private ImageDescriptorRegistry fRegistry = JavaPlugin.getImageDescriptorRegistry();
    private ISharedImages fSharedImages = JavaUI.getSharedImages();
    private ImageDescriptor fProjectImage;
    private ClasspathAttributeConfigurationDescriptors fAttributeDescriptors;

    public CPListLabelProvider() {
        IWorkbench iWorkbench = JavaPlugin.getDefault().getWorkbench();
        this.fProjectImage = iWorkbench.getSharedImages().getImageDescriptor("IMG_OBJ_PROJECT");
        this.fAttributeDescriptors = JavaPlugin.getDefault().getClasspathAttributeConfigurationDescriptors();
    }

    public String getText(Object object) {
        if (object instanceof CPListElement) {
            return this.getCPListElementText((CPListElement)object);
        }
        if (object instanceof CPListElementAttribute) {
            CPListElementAttribute cPListElementAttribute = (CPListElementAttribute)object;
            String string = this.getCPListElementAttributeText(cPListElementAttribute);
            return string;
        }
        if (object instanceof CPUserLibraryElement) {
            return this.getCPUserLibraryText((CPUserLibraryElement)object);
        }
        if (object instanceof IAccessRule) {
            IAccessRule iAccessRule = (IAccessRule)object;
            return Messages.format(NewWizardMessages.CPListLabelProvider_access_rules_label, new String[]{AccessRulesLabelProvider.getResolutionLabel(iAccessRule.getKind()), iAccessRule.getPattern().toString()});
        }
        return super.getText(object);
    }

    public String getCPUserLibraryText(CPUserLibraryElement cPUserLibraryElement) {
        String string = cPUserLibraryElement.getName();
        if (cPUserLibraryElement.isSystemLibrary()) {
            string = Messages.format(NewWizardMessages.CPListLabelProvider_systemlibrary, string);
        }
        return string;
    }

    public String getCPListElementAttributeText(CPListElementAttribute cPListElementAttribute) {
        String string = NewWizardMessages.CPListLabelProvider_none;
        String string2 = cPListElementAttribute.getKey();
        if (string2.equals("sourcepath")) {
            IPath iPath = (IPath)cPListElementAttribute.getValue();
            String string3 = iPath != null && !iPath.isEmpty() ? (cPListElementAttribute.getParent().getEntryKind() == 4 ? this.getVariableString(iPath) : this.getPathString(iPath, iPath.getDevice() != null)) : string;
            return Messages.format(NewWizardMessages.CPListLabelProvider_source_attachment_label, new String[]{string3});
        }
        if (string2.equals("output")) {
            String string4 = null;
            IPath iPath = (IPath)cPListElementAttribute.getValue();
            string4 = iPath != null ? iPath.makeRelative().toString() : NewWizardMessages.CPListLabelProvider_default_output_folder_label;
            return Messages.format(NewWizardMessages.CPListLabelProvider_output_folder_label, new String[]{string4});
        }
        if (string2.equals("exclusion")) {
            String string5 = null;
            IPath[] iPathArray = (IPath[])cPListElementAttribute.getValue();
            if (iPathArray != null && iPathArray.length > 0) {
                int n = 0;
                StringBuffer stringBuffer = new StringBuffer();
                int n2 = 0;
                while (n2 < iPathArray.length) {
                    String string6 = iPathArray[n2].toString();
                    if (string6.length() > 0) {
                        if (n > 0) {
                            stringBuffer.append(NewWizardMessages.CPListLabelProvider_exclusion_filter_separator);
                        }
                        stringBuffer.append(string6);
                        ++n;
                    }
                    ++n2;
                }
                string5 = n > 0 ? stringBuffer.toString() : string;
            } else {
                string5 = string;
            }
            return Messages.format(NewWizardMessages.CPListLabelProvider_exclusion_filter_label, new String[]{string5});
        }
        if (string2.equals("inclusion")) {
            String string7 = null;
            IPath[] iPathArray = (IPath[])cPListElementAttribute.getValue();
            if (iPathArray != null && iPathArray.length > 0) {
                int n = 0;
                StringBuffer stringBuffer = new StringBuffer();
                int n3 = 0;
                while (n3 < iPathArray.length) {
                    String string8 = iPathArray[n3].toString();
                    if (string8.length() > 0) {
                        if (n > 0) {
                            stringBuffer.append(NewWizardMessages.CPListLabelProvider_inclusion_filter_separator);
                        }
                        stringBuffer.append(string8);
                        ++n;
                    }
                    ++n3;
                }
                string7 = n > 0 ? stringBuffer.toString() : string;
            } else {
                string7 = NewWizardMessages.CPListLabelProvider_all;
            }
            return Messages.format(NewWizardMessages.CPListLabelProvider_inclusion_filter_label, new String[]{string7});
        }
        if (string2.equals("accessrules")) {
            IAccessRule[] iAccessRuleArray = (IAccessRule[])cPListElementAttribute.getValue();
            int n = iAccessRuleArray != null ? iAccessRuleArray.length : 0;
            int n4 = cPListElementAttribute.getParent().getEntryKind();
            if (n4 == 2) {
                Boolean bl = (Boolean)cPListElementAttribute.getParent().getAttribute("combineaccessrules");
                if (n > 0) {
                    if (bl.booleanValue()) {
                        return Messages.format(NewWizardMessages.CPListLabelProvider_project_access_rules_combined, String.valueOf(n));
                    }
                    return Messages.format(NewWizardMessages.CPListLabelProvider_project_access_rules_not_combined, String.valueOf(n));
                }
                return NewWizardMessages.CPListLabelProvider_project_access_rules_no_rules;
            }
            if (n4 == 5) {
                if (n > 0) {
                    return Messages.format(NewWizardMessages.CPListLabelProvider_container_access_rules, String.valueOf(n));
                }
                return NewWizardMessages.CPListLabelProvider_container_no_access_rules;
            }
            if (n > 0) {
                return Messages.format(NewWizardMessages.CPListLabelProvider_access_rules_enabled, String.valueOf(n));
            }
            return NewWizardMessages.CPListLabelProvider_access_rules_disabled;
        }
        ClasspathAttributeConfiguration classpathAttributeConfiguration = this.fAttributeDescriptors.get(string2);
        if (classpathAttributeConfiguration != null) {
            ClasspathAttributeConfiguration.ClasspathAttributeAccess classpathAttributeAccess = cPListElementAttribute.getClasspathAttributeAccess();
            String string9 = classpathAttributeConfiguration.getNameLabel(classpathAttributeAccess);
            String string10 = classpathAttributeConfiguration.getValueLabel(classpathAttributeAccess);
            return Messages.format(NewWizardMessages.CPListLabelProvider_attribute_label, new String[]{string9, string10});
        }
        String string11 = (String)cPListElementAttribute.getValue();
        if (string11 == null) {
            string11 = string;
        }
        return Messages.format(NewWizardMessages.CPListLabelProvider_attribute_label, new String[]{string2, string11});
    }

    public String getCPListElementText(CPListElement cPListElement) {
        IPath iPath = cPListElement.getPath();
        switch (cPListElement.getEntryKind()) {
            case 1: {
                Object object;
                ClasspathContainerInitializer classpathContainerInitializer = cPListElement.getContainerInitializer();
                if (classpathContainerInitializer != null && (object = classpathContainerInitializer.getDescription(cPListElement.getPath(), cPListElement.getJavaProject())) != null) {
                    return object;
                }
                object = cPListElement.getResource();
                if (object instanceof IContainer) {
                    StringBuffer stringBuffer = new StringBuffer(iPath.makeRelative().toString());
                    IPath iPath2 = cPListElement.getLinkTarget();
                    if (iPath2 != null) {
                        stringBuffer.append(JavaElementLabels.CONCAT_STRING);
                        stringBuffer.append(iPath2.toOSString());
                    }
                    stringBuffer.append(' ');
                    stringBuffer.append(this.fClassLabel);
                    if (!object.exists()) {
                        stringBuffer.append(' ');
                        if (cPListElement.isMissing()) {
                            stringBuffer.append(this.fCreateLabel);
                        } else {
                            stringBuffer.append(this.fNewLabel);
                        }
                    }
                    return stringBuffer.toString();
                }
                if (ArchiveFileFilter.isArchivePath(iPath)) {
                    return this.getPathString(iPath, object == null);
                }
                return iPath.makeRelative().toString();
            }
            case 4: {
                return this.getVariableString(iPath);
            }
            case 2: {
                return iPath.lastSegment();
            }
            case 5: {
                try {
                    IClasspathContainer iClasspathContainer = JavaCore.getClasspathContainer((IPath)iPath, (IJavaProject)cPListElement.getJavaProject());
                    if (iClasspathContainer != null) {
                        return iClasspathContainer.getDescription();
                    }
                    ClasspathContainerInitializer classpathContainerInitializer = JavaCore.getClasspathContainerInitializer((String)iPath.segment(0));
                    if (classpathContainerInitializer != null) {
                        String string = classpathContainerInitializer.getDescription(iPath, cPListElement.getJavaProject());
                        return Messages.format(NewWizardMessages.CPListLabelProvider_unbound_library, string);
                    }
                }
                catch (JavaModelException javaModelException) {}
                return iPath.toString();
            }
            case 3: {
                IResource iResource;
                StringBuffer stringBuffer = new StringBuffer(iPath.makeRelative().toString());
                IPath iPath3 = cPListElement.getLinkTarget();
                if (iPath3 != null) {
                    stringBuffer.append(JavaElementLabels.CONCAT_STRING);
                    stringBuffer.append(iPath3.toOSString());
                }
                if ((iResource = cPListElement.getResource()) != null && !iResource.exists()) {
                    stringBuffer.append(' ');
                    if (cPListElement.isMissing()) {
                        stringBuffer.append(this.fCreateLabel);
                    } else {
                        stringBuffer.append(this.fNewLabel);
                    }
                } else if (cPListElement.getOrginalPath() == null) {
                    stringBuffer.append(' ');
                    stringBuffer.append(this.fNewLabel);
                }
                return stringBuffer.toString();
            }
        }
        return NewWizardMessages.CPListLabelProvider_unknown_element_label;
    }

    private String getPathString(IPath iPath, boolean bl) {
        if (ArchiveFileFilter.isArchivePath(iPath)) {
            IPath iPath2 = iPath.removeLastSegments(1);
            String string = bl ? iPath2.toOSString() : iPath2.makeRelative().toString();
            return Messages.format(NewWizardMessages.CPListLabelProvider_twopart, new String[]{iPath.lastSegment(), string});
        }
        return bl ? iPath.toOSString() : iPath.makeRelative().toString();
    }

    private String getVariableString(IPath iPath) {
        String string = iPath.makeRelative().toString();
        IPath iPath2 = JavaCore.getClasspathVariable((String)iPath.segment(0));
        if (iPath2 != null) {
            String string2 = iPath2.append(iPath.removeFirstSegments(1)).toOSString();
            return Messages.format(NewWizardMessages.CPListLabelProvider_twopart, new String[]{string, string2});
        }
        return string;
    }

    private ImageDescriptor getCPListElementBaseImage(CPListElement cPListElement) {
        IPath iPath;
        IPath iPath2;
        ClasspathContainerInitializer classpathContainerInitializer = cPListElement.getContainerInitializer();
        if (classpathContainerInitializer != null && classpathContainerInitializer instanceof IClasspathContainerInitialzerExtension) {
            iPath2 = cPListElement.getPath();
            iPath = ((IClasspathContainerInitialzerExtension)classpathContainerInitializer).getImage(classpathContainerInitializer.getPath(), iPath2.toString(), cPListElement.getJavaProject());
            if (iPath != null) {
                return iPath;
            }
        }
        switch (cPListElement.getEntryKind()) {
            case 3: {
                if (cPListElement.getPath().segmentCount() == 1) {
                    return this.fProjectImage;
                }
                return this.fSharedImages.getImageDescriptor("org.eclipse.wst.jsdt.ui.packagefolder_obj.gif");
            }
            case 1: {
                iPath2 = cPListElement.getResource();
                iPath = (IPath)cPListElement.getAttribute("sourcepath");
                if (iPath2 == null) {
                    if (iPath == null || iPath.isEmpty()) {
                        return this.fSharedImages.getImageDescriptor("org.eclipse.wst.jsdt.ui.jar_l_obj.gif");
                    }
                    return this.fSharedImages.getImageDescriptor("org.eclipse.wst.jsdt.ui.jar_lsrc_obj.gif");
                }
                if (iPath2 instanceof IFile) {
                    if (iPath == null || iPath.isEmpty()) {
                        return this.fSharedImages.getImageDescriptor("org.eclipse.wst.jsdt.ui.jar_obj.gif");
                    }
                    return this.fSharedImages.getImageDescriptor("org.eclipse.wst.jsdt.ui.jar_src_obj.gif");
                }
                return this.fSharedImages.getImageDescriptor("org.eclipse.wst.jsdt.ui.packagefolder_obj.gif");
            }
            case 2: {
                return this.fProjectImage;
            }
            case 4: {
                ImageDescriptor imageDescriptor = this.fSharedImages.getImageDescriptor("org.eclipse.wst.jsdt.ui.envvar_obj.gif");
                if (cPListElement.isDeprecated()) {
                    return new JavaElementImageDescriptor(imageDescriptor, 1024, JavaElementImageProvider.SMALL_SIZE);
                }
                return imageDescriptor;
            }
            case 5: {
                return this.fSharedImages.getImageDescriptor("org.eclipse.wst.jsdt.ui.library_obj.gif");
            }
        }
        return null;
    }

    public Image getImage(Object object) {
        if (object instanceof CPListElement) {
            CPListElement cPListElement = (CPListElement)object;
            Object object2 = this.getCPListElementBaseImage(cPListElement);
            if (object2 != null) {
                if (cPListElement.isMissing()) {
                    object2 = new JavaElementImageDescriptor((ImageDescriptor)object2, 32, JavaElementImageProvider.SMALL_SIZE);
                }
                return this.fRegistry.get((ImageDescriptor)object2);
            }
        } else {
            if (object instanceof CPListElementAttribute) {
                CPListElementAttribute cPListElementAttribute = (CPListElementAttribute)object;
                String string = cPListElementAttribute.getKey();
                if (string.equals("sourcepath")) {
                    return this.fRegistry.get(JavaPluginImages.DESC_OBJS_SOURCE_ATTACH_ATTRIB);
                }
                if (string.equals("output")) {
                    return this.fRegistry.get(JavaPluginImages.DESC_OBJS_OUTPUT_FOLDER_ATTRIB);
                }
                if (string.equals("exclusion")) {
                    return this.fRegistry.get(JavaPluginImages.DESC_OBJS_EXCLUSION_FILTER_ATTRIB);
                }
                if (string.equals("inclusion")) {
                    return this.fRegistry.get(JavaPluginImages.DESC_OBJS_INCLUSION_FILTER_ATTRIB);
                }
                if (string.equals("accessrules")) {
                    return this.fRegistry.get(JavaPluginImages.DESC_OBJS_ACCESSRULES_ATTRIB);
                }
                ClasspathAttributeConfiguration classpathAttributeConfiguration = this.fAttributeDescriptors.get(string);
                if (classpathAttributeConfiguration != null) {
                    return this.fRegistry.get(classpathAttributeConfiguration.getImageDescriptor(cPListElementAttribute.getClasspathAttributeAccess()));
                }
                return this.fSharedImages.getImage("org.eclipse.wst.jsdt.ui.envvar_obj.gif");
            }
            if (object instanceof CPUserLibraryElement) {
                return this.fSharedImages.getImage("org.eclipse.wst.jsdt.ui.library_obj.gif");
            }
            if (object instanceof IAccessRule) {
                IAccessRule iAccessRule = (IAccessRule)object;
                return AccessRulesLabelProvider.getResolutionImage(iAccessRule.getKind());
            }
        }
        return null;
    }
}

