/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.jsdt.core.IClasspathContainer;
import org.eclipse.wst.jsdt.core.IClasspathEntry;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.CPListElement;

public class CPUserLibraryElement {
    private String fName;
    private List fChildren;
    private boolean fIsSystemLibrary;

    public CPUserLibraryElement(String string, IClasspathContainer iClasspathContainer, IJavaProject iJavaProject) {
        this.fName = string;
        this.fChildren = new ArrayList();
        if (iClasspathContainer != null) {
            IClasspathEntry[] iClasspathEntryArray = iClasspathContainer.getClasspathEntries();
            CPListElement[] cPListElementArray = new CPListElement[iClasspathEntryArray.length];
            int n = 0;
            while (n < cPListElementArray.length) {
                IClasspathEntry iClasspathEntry = iClasspathEntryArray[n];
                CPListElement cPListElement = CPListElement.createFromExisting(this, iClasspathEntry, iJavaProject);
                this.fChildren.add(cPListElement);
                ++n;
            }
            this.fIsSystemLibrary = iClasspathContainer.getKind() == 2;
        } else {
            this.fIsSystemLibrary = false;
        }
    }

    public CPUserLibraryElement(String string, boolean bl, CPListElement[] cPListElementArray) {
        this.fName = string;
        this.fChildren = new ArrayList();
        if (cPListElementArray != null) {
            int n = 0;
            while (n < cPListElementArray.length) {
                this.fChildren.add(cPListElementArray[n]);
                ++n;
            }
        }
        this.fIsSystemLibrary = bl;
    }

    public CPListElement[] getChildren() {
        return this.fChildren.toArray(new CPListElement[this.fChildren.size()]);
    }

    public String getName() {
        return this.fName;
    }

    public IPath getPath() {
        return new Path("org.eclipse.wst.jsdt.USER_LIBRARY").append(this.fName);
    }

    public boolean isSystemLibrary() {
        return this.fIsSystemLibrary;
    }

    public void add(CPListElement cPListElement) {
        if (!this.fChildren.contains(cPListElement)) {
            this.fChildren.add(cPListElement);
        }
    }

    private List moveUp(List list, List list2) {
        int n = list.size();
        ArrayList arrayList = new ArrayList(n);
        Object e = null;
        int n2 = 0;
        while (n2 < n) {
            Object e2 = list.get(n2);
            if (list2.contains(e2)) {
                arrayList.add(e2);
            } else {
                if (e != null) {
                    arrayList.add(e);
                }
                e = e2;
            }
            ++n2;
        }
        if (e != null) {
            arrayList.add(e);
        }
        return arrayList;
    }

    public void moveUp(List list) {
        if (list.size() > 0) {
            this.fChildren = this.moveUp(this.fChildren, list);
        }
    }

    public void moveDown(List list) {
        if (list.size() > 0) {
            Collections.reverse(this.fChildren);
            this.fChildren = this.moveUp(this.fChildren, list);
            Collections.reverse(this.fChildren);
        }
    }

    public void remove(CPListElement cPListElement) {
        this.fChildren.remove(cPListElement);
    }

    public void replace(CPListElement cPListElement, CPListElement cPListElement2) {
        if (this.fChildren.contains(cPListElement2)) {
            this.fChildren.remove(cPListElement);
        } else {
            int n = this.fChildren.indexOf(cPListElement);
            if (n != -1) {
                this.fChildren.set(n, cPListElement2);
            } else {
                this.fChildren.add(cPListElement2);
            }
            cPListElement2.setAttributesFromExisting(cPListElement);
        }
    }

    public IClasspathContainer getUpdatedContainer() {
        return new UpdatedClasspathContainer();
    }

    public boolean hasChanges(IClasspathContainer iClasspathContainer) {
        if (iClasspathContainer == null || iClasspathContainer.getKind() == 2 != this.fIsSystemLibrary) {
            return true;
        }
        IClasspathEntry[] iClasspathEntryArray = iClasspathContainer.getClasspathEntries();
        if (this.fChildren.size() != iClasspathEntryArray.length) {
            return true;
        }
        int n = 0;
        while (n < iClasspathEntryArray.length) {
            CPListElement cPListElement = (CPListElement)this.fChildren.get(n);
            if (!cPListElement.getClasspathEntry().equals(iClasspathEntryArray[n])) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private class UpdatedClasspathContainer
    implements IClasspathContainer {
        private UpdatedClasspathContainer() {
        }

        public IClasspathEntry[] getClasspathEntries() {
            CPListElement[] cPListElementArray = CPUserLibraryElement.this.getChildren();
            IClasspathEntry[] iClasspathEntryArray = new IClasspathEntry[cPListElementArray.length];
            int n = 0;
            while (n < iClasspathEntryArray.length) {
                iClasspathEntryArray[n] = cPListElementArray[n].getClasspathEntry();
                ++n;
            }
            return iClasspathEntryArray;
        }

        public String getDescription() {
            return CPUserLibraryElement.this.getName();
        }

        public int getKind() {
            return CPUserLibraryElement.this.isSystemLibrary() ? 2 : 1;
        }

        public IPath getPath() {
            return CPUserLibraryElement.this.getPath();
        }
    }
}

