/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.newsourcepage;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IPostSelectionProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.part.ISetSelectionTarget;
import org.eclipse.wst.jsdt.core.IClasspathEntry;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.internal.corext.buildpath.ClasspathModifier;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.filters.LibraryFilter;
import org.eclipse.wst.jsdt.internal.ui.filters.OutputFolderFilter;
import org.eclipse.wst.jsdt.internal.ui.packageview.PackageExplorerContentProvider;
import org.eclipse.wst.jsdt.internal.ui.packageview.PackageFragmentRootContainer;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.AppearanceAwareLabelProvider;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.DecoratingJavaLabelProvider;
import org.eclipse.wst.jsdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.CPListElement;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.CPListElementAttribute;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.CPListLabelProvider;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.newsourcepage.DialogPackageExplorerActionGroup;
import org.eclipse.wst.jsdt.internal.ui.workingsets.WorkingSetModel;
import org.eclipse.wst.jsdt.ui.JavaElementComparator;

public class DialogPackageExplorer
implements IMenuListener,
ISelectionProvider,
IPostSelectionProvider,
ISetSelectionTarget {
    private TreeViewer fPackageViewer;
    private Menu fContextMenu;
    private DialogPackageExplorerActionGroup fActionGroup = null;
    private boolean fShowOutputFolders = false;
    private IStructuredSelection fCurrentSelection = new StructuredSelection();
    private IJavaProject fCurrJProject = null;
    private PackageContentProvider fContentProvider;

    public Control createControl(Composite composite) {
        this.fPackageViewer = new TreeViewer(composite, 2);
        this.fPackageViewer.setComparer(WorkingSetModel.COMPARER);
        this.fPackageViewer.addFilter((ViewerFilter)new PackageFilter());
        this.fPackageViewer.setComparator((ViewerComparator)new ExtendedJavaElementSorter());
        this.fPackageViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent doubleClickEvent) {
                CPListElementAttribute cPListElementAttribute;
                Object object = ((IStructuredSelection)doubleClickEvent.getSelection()).getFirstElement();
                if (DialogPackageExplorer.this.fPackageViewer.isExpandable(object)) {
                    DialogPackageExplorer.this.fPackageViewer.setExpandedState(object, !DialogPackageExplorer.this.fPackageViewer.getExpandedState(object));
                } else if (object instanceof CPListElementAttribute && (cPListElementAttribute = (CPListElementAttribute)object).getKey().equals("output")) {
                    DialogPackageExplorer.this.fActionGroup.getEditOutputFolderAction().run();
                }
            }
        });
        MenuManager menuManager = new MenuManager("#PopupMenu");
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener((IMenuListener)this);
        this.fContextMenu = menuManager.createContextMenu((Control)this.fPackageViewer.getTree());
        this.fPackageViewer.getTree().setMenu(this.fContextMenu);
        composite.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                DialogPackageExplorer.this.fContextMenu.dispose();
            }
        });
        return this.fPackageViewer.getControl();
    }

    public void setActionGroup(DialogPackageExplorerActionGroup dialogPackageExplorerActionGroup) {
        this.fActionGroup = dialogPackageExplorerActionGroup;
    }

    public void menuAboutToShow(IMenuManager iMenuManager) {
        if (this.fActionGroup == null) {
            return;
        }
        JavaPlugin.createStandardGroups(iMenuManager);
        this.fActionGroup.fillContextMenu(iMenuManager);
    }

    public void setContentProvider() {
        if (this.fContentProvider != null) {
            this.fContentProvider.dispose();
        }
        this.fContentProvider = new PackageContentProvider();
        this.fContentProvider.setIsFlatLayout(true);
        PackageLabelProvider packageLabelProvider = new PackageLabelProvider(36421324767273L, 3);
        this.fPackageViewer.setContentProvider((IContentProvider)this.fContentProvider);
        this.fPackageViewer.setLabelProvider((IBaseLabelProvider)new DecoratingJavaLabelProvider(packageLabelProvider, false));
    }

    public void setInput(IJavaProject iJavaProject) {
        IJavaProject iJavaProject2 = this.fCurrJProject;
        this.fCurrJProject = iJavaProject;
        if (this.fContentProvider != null) {
            this.fContentProvider.inputChanged((Viewer)this.fPackageViewer, iJavaProject2, this.fCurrJProject);
        }
        this.fPackageViewer.setInput((Object)new Object[0]);
        ArrayList<IJavaProject> arrayList = new ArrayList<IJavaProject>();
        arrayList.add(this.fCurrJProject);
        this.setSelection(arrayList);
    }

    public void dispose() {
        if (this.fContentProvider != null) {
            this.fContentProvider.dispose();
            this.fContentProvider = null;
        }
        if (this.fActionGroup != null) {
            this.fActionGroup.dispose();
            this.fActionGroup = null;
        }
        this.fPackageViewer = null;
    }

    public void setSelection(final List list) {
        if (list == null || list.size() == 0) {
            return;
        }
        try {
            ResourcesPlugin.getWorkspace().run(new IWorkspaceRunnable(){

                public void run(IProgressMonitor iProgressMonitor) throws CoreException {
                    DialogPackageExplorer.this.fPackageViewer.refresh();
                    StructuredSelection structuredSelection = new StructuredSelection(list);
                    DialogPackageExplorer.this.fPackageViewer.setSelection((ISelection)structuredSelection, true);
                    DialogPackageExplorer.this.fPackageViewer.getTree().setFocus();
                    if (list.size() == 1 && list.get(0) instanceof IJavaProject) {
                        DialogPackageExplorer.this.fPackageViewer.expandToLevel(list.get(0), 1);
                    }
                }
            }, (ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot(), 1, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException coreException) {
            JavaPlugin.log(coreException);
        }
    }

    public ISelection getSelection() {
        return this.fCurrentSelection;
    }

    public Control getViewerControl() {
        return this.fPackageViewer.getControl();
    }

    public void showOutputFolders(boolean bl) {
        this.fShowOutputFolders = bl;
        this.fActionGroup.getEditOutputFolderAction().showOutputFolders(bl);
        this.fPackageViewer.refresh();
    }

    public void addSelectionChangedListener(ISelectionChangedListener iSelectionChangedListener) {
        this.fPackageViewer.addSelectionChangedListener(iSelectionChangedListener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener iSelectionChangedListener) {
        this.fPackageViewer.removeSelectionChangedListener(iSelectionChangedListener);
    }

    public void setSelection(ISelection iSelection) {
        this.setSelection(((StructuredSelection)iSelection).toList());
    }

    public void addPostSelectionChangedListener(ISelectionChangedListener iSelectionChangedListener) {
        this.fPackageViewer.addPostSelectionChangedListener(iSelectionChangedListener);
    }

    public void removePostSelectionChangedListener(ISelectionChangedListener iSelectionChangedListener) {
        this.fPackageViewer.removePostSelectionChangedListener(iSelectionChangedListener);
    }

    public void selectReveal(ISelection iSelection) {
        this.setSelection(iSelection);
    }

    private final class ExtendedJavaElementSorter
    extends JavaElementComparator {
        public int compare(Viewer viewer, Object object, Object object2) {
            if (object instanceof CPListElementAttribute) {
                return -1;
            }
            if (object2 instanceof CPListElementAttribute) {
                return 1;
            }
            return super.compare(viewer, object, object2);
        }
    }

    private final class PackageContentProvider
    extends PackageExplorerContentProvider {
        public PackageContentProvider() {
            super(false);
        }

        public Object[] getElements(Object object) {
            if (DialogPackageExplorer.this.fCurrJProject == null || !DialogPackageExplorer.this.fCurrJProject.exists()) {
                return new Object[0];
            }
            return new Object[]{DialogPackageExplorer.this.fCurrJProject};
        }

        public Object[] getChildren(Object object) {
            Object[] objectArray = super.getChildren(object);
            if ((object instanceof IPackageFragmentRoot && !((IPackageFragmentRoot)object).isArchive() || object instanceof IJavaProject && DialogPackageExplorer.this.fCurrJProject.isOnClasspath((IJavaElement)DialogPackageExplorer.this.fCurrJProject)) && DialogPackageExplorer.this.fShowOutputFolders) {
                try {
                    IClasspathEntry iClasspathEntry = object instanceof IPackageFragmentRoot ? ((IPackageFragmentRoot)object).getRawClasspathEntry() : ClasspathModifier.getClasspathEntryFor(DialogPackageExplorer.this.fCurrJProject.getPath(), DialogPackageExplorer.this.fCurrJProject, 3);
                    CPListElement cPListElement = CPListElement.createFromExisting(iClasspathEntry, DialogPackageExplorer.this.fCurrJProject);
                    CPListElementAttribute cPListElementAttribute = new CPListElementAttribute(cPListElement, "output", cPListElement.getAttribute("output"), true);
                    Object[] objectArray2 = new Object[objectArray.length + 1];
                    System.arraycopy(objectArray, 0, objectArray2, 1, objectArray.length);
                    objectArray2[0] = cPListElementAttribute;
                    return objectArray2;
                }
                catch (JavaModelException javaModelException) {
                    JavaPlugin.log(javaModelException);
                    return null;
                }
            }
            return objectArray;
        }
    }

    private final class PackageFilter
    extends LibraryFilter {
        private OutputFolderFilter fOutputFolderFilter = new OutputFolderFilter();

        private PackageFilter() {
        }

        public boolean select(Viewer viewer, Object object, Object object2) {
            block13: {
                block12: {
                    block11: {
                        block10: {
                            if (!(object2 instanceof IFile)) break block10;
                            IFile iFile = (IFile)object2;
                            if (iFile.getName().equals(".jsdtscope") || iFile.getName().equals(".project")) {
                                return false;
                            }
                        }
                        if (!(object2 instanceof IPackageFragmentRoot)) break block11;
                        IClasspathEntry iClasspathEntry = ((IPackageFragmentRoot)object2).getRawClasspathEntry();
                        if (iClasspathEntry == null || iClasspathEntry.getEntryKind() == 5 || iClasspathEntry.getEntryKind() == 1 || iClasspathEntry.getEntryKind() == 4) {
                            return false;
                        }
                    }
                    if (!(object2 instanceof PackageFragmentRootContainer)) break block12;
                    return false;
                }
                if (!(object2 instanceof IPackageFragment)) break block13;
                IPackageFragment iPackageFragment = (IPackageFragment)object2;
                if (iPackageFragment.isDefaultPackage() && !iPackageFragment.hasChildren()) {
                    return false;
                }
            }
            try {
                IFolder iFolder;
                if (object2 instanceof IFolder && (iFolder = (IFolder)object2).getName().startsWith(".")) {
                    return false;
                }
            }
            catch (JavaModelException javaModelException) {
                JavaPlugin.log(javaModelException);
            }
            return this.fOutputFolderFilter.select(viewer, object, object2);
        }
    }

    private final class PackageLabelProvider
    extends AppearanceAwareLabelProvider {
        private CPListLabelProvider outputFolderLabel = new CPListLabelProvider();

        public PackageLabelProvider(long l, int n) {
            super(l, n);
        }

        public String getText(Object object) {
            if (object instanceof CPListElementAttribute) {
                return this.outputFolderLabel.getText(object);
            }
            String string = super.getText(object);
            try {
                IClasspathEntry iClasspathEntry;
                IPackageFragmentRoot iPackageFragmentRoot;
                if (object instanceof IPackageFragmentRoot && (iPackageFragmentRoot = (IPackageFragmentRoot)object).exists() && ClasspathModifier.filtersSet(iPackageFragmentRoot)) {
                    iClasspathEntry = iPackageFragmentRoot.getRawClasspathEntry();
                    int n = iClasspathEntry.getExclusionPatterns().length;
                    if (n == 1) {
                        return Messages.format(NewWizardMessages.DialogPackageExplorer_LabelProvider_SingleExcluded, string);
                    }
                    if (n > 1) {
                        return Messages.format(NewWizardMessages.DialogPackageExplorer_LabelProvider_MultiExcluded, new Object[]{string, new Integer(n)});
                    }
                }
                if (object instanceof IJavaProject && (iPackageFragmentRoot = (IJavaProject)object).exists() && iPackageFragmentRoot.isOnClasspath((IJavaElement)iPackageFragmentRoot) && ClasspathModifier.filtersSet((IPackageFragmentRoot)(iClasspathEntry = iPackageFragmentRoot.findPackageFragmentRoot(iPackageFragmentRoot.getPath())))) {
                    IClasspathEntry iClasspathEntry2 = iClasspathEntry.getRawClasspathEntry();
                    int n = iClasspathEntry2.getExclusionPatterns().length;
                    if (n == 1) {
                        return Messages.format(NewWizardMessages.DialogPackageExplorer_LabelProvider_SingleExcluded, string);
                    }
                    if (n > 1) {
                        return Messages.format(NewWizardMessages.DialogPackageExplorer_LabelProvider_MultiExcluded, new Object[]{string, new Integer(n)});
                    }
                }
                if ((object instanceof IFile || object instanceof IFolder) && (iPackageFragmentRoot = (IResource)object).exists() && ClasspathModifier.isExcluded((IResource)iPackageFragmentRoot, DialogPackageExplorer.this.fCurrJProject)) {
                    return Messages.format(NewWizardMessages.DialogPackageExplorer_LabelProvider_Excluded, string);
                }
            }
            catch (JavaModelException javaModelException) {
                JavaPlugin.log(javaModelException);
            }
            return string;
        }

        public Color getForeground(Object object) {
            try {
                IPackageFragmentRoot iPackageFragmentRoot;
                IPackageFragmentRoot iPackageFragmentRoot2;
                if (object instanceof IPackageFragmentRoot && (iPackageFragmentRoot2 = (IPackageFragmentRoot)object).exists() && ClasspathModifier.filtersSet(iPackageFragmentRoot2)) {
                    return this.getBlueColor();
                }
                if (object instanceof IJavaProject && (iPackageFragmentRoot2 = (IJavaProject)object).exists() && iPackageFragmentRoot2.isOnClasspath((IJavaElement)iPackageFragmentRoot2) && (iPackageFragmentRoot = iPackageFragmentRoot2.findPackageFragmentRoot(iPackageFragmentRoot2.getPath())) != null && ClasspathModifier.filtersSet(iPackageFragmentRoot)) {
                    return this.getBlueColor();
                }
                if ((object instanceof IFile || object instanceof IFolder) && (iPackageFragmentRoot2 = (IResource)object).exists() && ClasspathModifier.isExcluded((IResource)iPackageFragmentRoot2, DialogPackageExplorer.this.fCurrJProject)) {
                    return this.getBlueColor();
                }
            }
            catch (JavaModelException javaModelException) {
                JavaPlugin.log(javaModelException);
            }
            return null;
        }

        private Color getBlueColor() {
            return Display.getCurrent().getSystemColor(9);
        }

        public Image getImage(Object object) {
            if (object instanceof CPListElementAttribute) {
                return this.outputFolderLabel.getImage(object);
            }
            return super.getImage(object);
        }

        public void dispose() {
            this.outputFolderLabel.dispose();
            super.dispose();
        }
    }
}

