/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.newsourcepage;

import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ISetSelectionTarget;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.internal.corext.buildpath.BuildpathDelta;
import org.eclipse.wst.jsdt.internal.corext.buildpath.ClasspathModifier;
import org.eclipse.wst.jsdt.internal.ui.JavaPluginImages;
import org.eclipse.wst.jsdt.internal.ui.util.ExceptionHandler;
import org.eclipse.wst.jsdt.internal.ui.util.PixelConverter;
import org.eclipse.wst.jsdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.CPListElement;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.EditFilterWizard;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.newsourcepage.BuildpathModifierAction;
import org.eclipse.wst.jsdt.ui.PreferenceConstants;

public class EditFilterAction
extends BuildpathModifierAction {
    public EditFilterAction(IWorkbenchSite iWorkbenchSite) {
        this(iWorkbenchSite, null, (IRunnableContext)PlatformUI.getWorkbench().getProgressService());
    }

    public EditFilterAction(IRunnableContext iRunnableContext, ISetSelectionTarget iSetSelectionTarget) {
        this(null, iSetSelectionTarget, iRunnableContext);
    }

    private EditFilterAction(IWorkbenchSite iWorkbenchSite, ISetSelectionTarget iSetSelectionTarget, IRunnableContext iRunnableContext) {
        super(iWorkbenchSite, iSetSelectionTarget, 4);
        this.setText(NewWizardMessages.NewSourceContainerWorkbookPage_ToolBar_Edit_label);
        this.setImageDescriptor(JavaPluginImages.DESC_ELCL_CONFIGURE_BUILDPATH_FILTERS);
        this.setToolTipText(NewWizardMessages.NewSourceContainerWorkbookPage_ToolBar_Edit_tooltip);
        this.setDescription(NewWizardMessages.PackageExplorerActionGroup_FormText_Edit);
        this.setDisabledImageDescriptor(JavaPluginImages.DESC_DLCL_CONFIGURE_BUILDPATH_FILTERS);
    }

    public String getDetailedDescription() {
        if (!this.isEnabled()) {
            return null;
        }
        return NewWizardMessages.PackageExplorerActionGroup_FormText_Edit;
    }

    public void run() {
        Shell shell = this.getShell();
        try {
            EditFilterWizard editFilterWizard = this.createWizard();
            editFilterWizard.init(PlatformUI.getWorkbench(), (IStructuredSelection)new StructuredSelection(this.getSelectedElements().get(0)));
            WizardDialog wizardDialog = new WizardDialog(shell, (IWizard)editFilterWizard);
            PixelConverter pixelConverter = new PixelConverter(JFaceResources.getDialogFont());
            wizardDialog.setMinimumPageSize(pixelConverter.convertWidthInCharsToPixels(70), pixelConverter.convertHeightInCharsToPixels(20));
            wizardDialog.create();
            int n = wizardDialog.open();
            if (n == 0) {
                BuildpathDelta buildpathDelta = new BuildpathDelta(this.getToolTipText());
                ArrayList arrayList = editFilterWizard.getExistingEntries();
                buildpathDelta.setNewEntries(arrayList.toArray(new CPListElement[arrayList.size()]));
                IResource iResource = editFilterWizard.getCreatedElement().getCorrespondingResource();
                buildpathDelta.addCreatedResource(iResource);
                buildpathDelta.setDefaultOutputLocation(editFilterWizard.getOutputLocation());
                this.informListeners(buildpathDelta);
                this.selectAndReveal((ISelection)new StructuredSelection((Object)editFilterWizard.getCreatedElement()));
            }
            this.notifyResult(n == 0);
        }
        catch (CoreException coreException) {
            String string = NewWizardMessages.AbstractOpenWizardAction_createerror_title;
            String string2 = NewWizardMessages.AbstractOpenWizardAction_createerror_message;
            ExceptionHandler.handle(coreException, shell, string, string2);
        }
    }

    private EditFilterWizard createWizard() throws CoreException {
        IJavaProject iJavaProject = null;
        Object e = this.getSelectedElements().get(0);
        iJavaProject = e instanceof IJavaProject ? (IJavaProject)e : ((IPackageFragmentRoot)e).getJavaProject();
        CPListElement[] cPListElementArray = CPListElement.createFromExisting(iJavaProject);
        CPListElement cPListElement = EditFilterAction.findElement((IJavaElement)e, cPListElementArray);
        return new EditFilterWizard(cPListElementArray, cPListElement, this.getOutputLocation(iJavaProject));
    }

    private IPath getOutputLocation(IJavaProject iJavaProject) {
        try {
            return iJavaProject.getOutputLocation();
        }
        catch (CoreException coreException) {
            IProject iProject = iJavaProject.getProject();
            IPath iPath = iProject.getFullPath();
            return iPath.append(PreferenceConstants.getPreferenceStore().getString("org.eclipse.wst.jsdt.ui.wizards.srcBinFoldersBinName"));
        }
    }

    private static CPListElement findElement(IJavaElement iJavaElement, CPListElement[] cPListElementArray) {
        IPath iPath = iJavaElement.getPath();
        int n = 0;
        while (n < cPListElementArray.length) {
            CPListElement cPListElement = cPListElementArray[n];
            if (cPListElement.getEntryKind() == 3 && cPListElement.getPath().equals((Object)iPath)) {
                return cPListElement;
            }
            ++n;
        }
        return null;
    }

    protected boolean canHandle(IStructuredSelection iStructuredSelection) {
        block5: {
            IPackageFragmentRoot iPackageFragmentRoot;
            block6: {
                if (iStructuredSelection.size() != 1) {
                    return false;
                }
                try {
                    Object object = iStructuredSelection.getFirstElement();
                    if (object instanceof IJavaProject) {
                        return ClasspathModifier.isSourceFolder((IJavaProject)object);
                    }
                    if (!(object instanceof IPackageFragmentRoot)) break block5;
                    iPackageFragmentRoot = (IPackageFragmentRoot)object;
                    if (iPackageFragmentRoot.getKind() == 1) break block6;
                    return false;
                }
                catch (JavaModelException javaModelException) {}
            }
            return iPackageFragmentRoot.getJavaProject() != null;
        }
        return false;
    }
}

