/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.workingsets;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.IWorkingSetPage;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IJavaModel;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.core.JavaCore;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.JavaPluginImages;
import org.eclipse.wst.jsdt.internal.ui.actions.SelectionConverter;
import org.eclipse.wst.jsdt.internal.ui.filters.EmptyInnerPackageFilter;
import org.eclipse.wst.jsdt.internal.ui.util.JavaUIHelp;
import org.eclipse.wst.jsdt.internal.ui.util.SWTUtil;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.AppearanceAwareLabelProvider;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.ColoredViewersManager;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.DecoratingJavaLabelProvider;
import org.eclipse.wst.jsdt.internal.ui.workingsets.JavaWorkingSetPageContentProvider;
import org.eclipse.wst.jsdt.internal.ui.workingsets.WorkingSetMessages;
import org.eclipse.wst.jsdt.ui.JavaElementComparator;

public class JavaWorkingSetPage
extends WizardPage
implements IWorkingSetPage {
    private static final String PAGE_TITLE = WorkingSetMessages.JavaWorkingSetPage_title;
    private static final String PAGE_ID = "javaWorkingSetPage";
    private Text fWorkingSetName;
    private CheckboxTreeViewer fTree;
    private ITreeContentProvider fTreeContentProvider;
    private boolean fFirstCheck;
    private IWorkingSet fWorkingSet;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    public JavaWorkingSetPage() {
        super(PAGE_ID, PAGE_TITLE, JavaPluginImages.DESC_WIZBAN_JAVA_WORKINGSET);
        this.setDescription(WorkingSetMessages.JavaWorkingSetPage_workingSet_description);
        this.fFirstCheck = true;
    }

    public void createControl(Composite composite) {
        this.initializeDialogUnits((Control)composite);
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout());
        composite2.setLayoutData((Object)new GridData(256));
        this.setControl((Control)composite2);
        Label label = new Label(composite2, 64);
        label.setText(WorkingSetMessages.JavaWorkingSetPage_workingSet_name);
        GridData gridData = new GridData(772);
        label.setLayoutData((Object)gridData);
        this.fWorkingSetName = new Text(composite2, 2052);
        this.fWorkingSetName.setLayoutData((Object)new GridData(768));
        this.fWorkingSetName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                JavaWorkingSetPage.this.validateInput();
            }
        });
        this.fWorkingSetName.setFocus();
        label = new Label(composite2, 64);
        label.setText(WorkingSetMessages.JavaWorkingSetPage_workingSet_content);
        gridData = new GridData(772);
        label.setLayoutData((Object)gridData);
        this.fTree = new CheckboxTreeViewer(composite2, 2816);
        ColoredViewersManager.install((StructuredViewer)this.fTree);
        gridData = new GridData(1808);
        gridData.heightHint = this.convertHeightInCharsToPixels(15);
        this.fTree.getControl().setLayoutData((Object)gridData);
        this.fTreeContentProvider = new JavaWorkingSetPageContentProvider();
        this.fTree.setContentProvider((IContentProvider)this.fTreeContentProvider);
        AppearanceAwareLabelProvider appearanceAwareLabelProvider = new AppearanceAwareLabelProvider(36421324767273L, 3);
        this.fTree.setLabelProvider((IBaseLabelProvider)new DecoratingJavaLabelProvider(appearanceAwareLabelProvider));
        this.fTree.setComparator((ViewerComparator)new JavaElementComparator());
        this.fTree.addFilter((ViewerFilter)new EmptyInnerPackageFilter());
        this.fTree.setUseHashlookup(true);
        this.fTree.setInput((Object)JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot()));
        this.fTree.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent checkStateChangedEvent) {
                JavaWorkingSetPage.this.handleCheckStateChange(checkStateChangedEvent);
            }
        });
        this.fTree.addTreeListener(new ITreeViewerListener(){

            public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
            }

            public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
                Object object = treeExpansionEvent.getElement();
                if (!JavaWorkingSetPage.this.fTree.getGrayed(object)) {
                    BusyIndicator.showWhile((Display)JavaWorkingSetPage.this.getShell().getDisplay(), (Runnable)new Runnable(this, object){
                        final /* synthetic */ 3 this$1;
                        private final /* synthetic */ Object val$element;
                        {
                            this.this$1 = var1_1;
                            this.val$element = object;
                        }

                        public void run() {
                            JavaWorkingSetPage.access$2(3.access$0(this.this$1), this.val$element, JavaWorkingSetPage.access$1(3.access$0(this.this$1)).getChecked(this.val$element), false);
                        }
                    });
                }
            }

            static /* synthetic */ JavaWorkingSetPage access$0(3 var0) {
                return var0.JavaWorkingSetPage.this;
            }
        });
        Composite composite3 = new Composite(composite2, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        composite3.setLayout((Layout)gridLayout);
        composite3.setLayoutData((Object)new GridData(256));
        Button button = new Button(composite3, 8);
        button.setText(WorkingSetMessages.JavaWorkingSetPage_selectAll_label);
        button.setToolTipText(WorkingSetMessages.JavaWorkingSetPage_selectAll_toolTip);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                JavaWorkingSetPage.this.fTree.setCheckedElements(JavaWorkingSetPage.this.fTreeContentProvider.getElements(JavaWorkingSetPage.this.fTree.getInput()));
                JavaWorkingSetPage.this.validateInput();
            }
        });
        button.setLayoutData((Object)new GridData());
        SWTUtil.setButtonDimensionHint(button);
        Button button2 = new Button(composite3, 8);
        button2.setText(WorkingSetMessages.JavaWorkingSetPage_deselectAll_label);
        button2.setToolTipText(WorkingSetMessages.JavaWorkingSetPage_deselectAll_toolTip);
        button2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                JavaWorkingSetPage.this.fTree.setCheckedElements(new Object[0]);
                JavaWorkingSetPage.this.validateInput();
            }
        });
        button2.setLayoutData((Object)new GridData());
        SWTUtil.setButtonDimensionHint(button2);
        if (this.fWorkingSet != null) {
            this.fWorkingSetName.setText(this.fWorkingSet.getName());
        }
        this.initializeCheckedState();
        this.validateInput();
        Dialog.applyDialogFont((Control)composite2);
        JavaUIHelp.setHelp((StructuredViewer)this.fTree, "org.eclipse.wst.jsdt.ui.java_working_set_page_context");
    }

    public IWorkingSet getSelection() {
        return this.fWorkingSet;
    }

    public void setSelection(IWorkingSet iWorkingSet) {
        Assert.isNotNull((Object)iWorkingSet, (String)"Working set must not be null");
        this.fWorkingSet = iWorkingSet;
        if (this.getContainer() != null && this.getShell() != null && this.fWorkingSetName != null) {
            this.fFirstCheck = false;
            this.fWorkingSetName.setText(this.fWorkingSet.getName());
            this.initializeCheckedState();
            this.validateInput();
        }
    }

    public void finish() {
        String string = this.fWorkingSetName.getText();
        ArrayList<IAdaptable> arrayList = new ArrayList<IAdaptable>(10);
        this.findCheckedElements(arrayList, this.fTree.getInput());
        if (this.fWorkingSet == null) {
            IWorkingSetManager iWorkingSetManager = PlatformUI.getWorkbench().getWorkingSetManager();
            this.fWorkingSet = iWorkingSetManager.createWorkingSet(string, arrayList.toArray(new IAdaptable[arrayList.size()]));
        } else {
            IAdaptable[] iAdaptableArray = this.fWorkingSet.getElements();
            HashSet<IProject> hashSet = new HashSet<IProject>(arrayList.size());
            int n = 0;
            while (n < iAdaptableArray.length) {
                IProject iProject;
                IResource iResource = null;
                if (iAdaptableArray[n] instanceof IResource) {
                    iResource = (IResource)iAdaptableArray[n];
                } else {
                    IAdaptable iAdaptable = iAdaptableArray[n];
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = Class.forName("org.eclipse.core.resources.IResource");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    iResource = (IResource)iAdaptable.getAdapter((Class)clazz);
                }
                if (iResource != null && !iResource.isAccessible() && (hashSet.contains(iProject = iResource.getProject()) || arrayList.contains(iProject))) {
                    arrayList.add(iAdaptableArray[n]);
                    arrayList.remove(iProject);
                    hashSet.add(iProject);
                }
                ++n;
            }
            this.fWorkingSet.setName(string);
            this.fWorkingSet.setElements(arrayList.toArray(new IAdaptable[arrayList.size()]));
        }
    }

    private void validateInput() {
        String string = null;
        String string2 = null;
        String string3 = this.fWorkingSetName.getText();
        if (!string3.equals(string3.trim())) {
            string = WorkingSetMessages.JavaWorkingSetPage_warning_nameWhitespace;
        }
        if (string3.equals("")) {
            if (this.fFirstCheck) {
                this.setPageComplete(false);
                this.fFirstCheck = false;
                return;
            }
            string = WorkingSetMessages.JavaWorkingSetPage_warning_nameMustNotBeEmpty;
        }
        this.fFirstCheck = false;
        if (!(string != null || this.fWorkingSet != null && string3.equals(this.fWorkingSet.getName()))) {
            IWorkingSet[] iWorkingSetArray = PlatformUI.getWorkbench().getWorkingSetManager().getWorkingSets();
            int n = 0;
            while (n < iWorkingSetArray.length) {
                if (string3.equals(iWorkingSetArray[n].getName())) {
                    string = WorkingSetMessages.JavaWorkingSetPage_warning_workingSetExists;
                }
                ++n;
            }
        }
        if (!this.hasCheckedElement()) {
            string2 = WorkingSetMessages.JavaWorkingSetPage_warning_resourceMustBeChecked;
        }
        this.setMessage(string2, 1);
        this.setErrorMessage(string);
        this.setPageComplete(string == null);
    }

    private boolean hasCheckedElement() {
        TreeItem[] treeItemArray = this.fTree.getTree().getItems();
        int n = 0;
        while (n < treeItemArray.length) {
            if (treeItemArray[n].getChecked()) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private void findCheckedElements(List list, Object object) {
        Object[] objectArray = this.fTreeContentProvider.getChildren(object);
        int n = 0;
        while (n < objectArray.length) {
            if (this.fTree.getGrayed(objectArray[n])) {
                this.findCheckedElements(list, objectArray[n]);
            } else if (this.fTree.getChecked(objectArray[n])) {
                list.add(objectArray[n]);
            }
            ++n;
        }
    }

    void handleCheckStateChange(final CheckStateChangedEvent checkStateChangedEvent) {
        BusyIndicator.showWhile((Display)this.getShell().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                IAdaptable iAdaptable = (IAdaptable)checkStateChangedEvent.getElement();
                boolean bl = checkStateChangedEvent.getChecked();
                JavaWorkingSetPage.this.fTree.setGrayed((Object)iAdaptable, false);
                if (JavaWorkingSetPage.this.isExpandable(iAdaptable)) {
                    JavaWorkingSetPage.this.setSubtreeChecked(iAdaptable, bl, bl);
                }
                JavaWorkingSetPage.this.updateParentState(iAdaptable, bl);
                JavaWorkingSetPage.this.validateInput();
            }
        });
    }

    private void setSubtreeChecked(Object object, boolean bl, boolean bl2) {
        if (!(object instanceof IAdaptable)) {
            return;
        }
        IAdaptable iAdaptable = (IAdaptable)object;
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.core.resources.IContainer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IContainer iContainer = (IContainer)iAdaptable.getAdapter((Class)clazz);
        if (!this.fTree.getExpandedState(object) && bl2 || iContainer != null && !iContainer.isAccessible()) {
            return;
        }
        Object[] objectArray = this.fTreeContentProvider.getChildren(object);
        int n = objectArray.length - 1;
        while (n >= 0) {
            Object object2 = objectArray[n];
            if (bl) {
                this.fTree.setChecked(object2, true);
                this.fTree.setGrayed(object2, false);
            } else {
                this.fTree.setGrayChecked(object2, false);
            }
            if (this.isExpandable(object2)) {
                this.setSubtreeChecked(object2, bl, true);
            }
            --n;
        }
    }

    private void updateParentState(Object object, boolean bl) {
        Object object2;
        if (object == null) {
            return;
        }
        if (object instanceof IAdaptable) {
            IAdaptable iAdaptable = (IAdaptable)object;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.core.resources.IResource");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((object2 = (IResource)iAdaptable.getAdapter((Class)clazz)) != null && !object2.isAccessible()) {
                return;
            }
        }
        if ((object2 = this.fTreeContentProvider.getParent(object)) == null) {
            return;
        }
        this.updateObjectState(object2, bl);
    }

    private void updateObjectState(Object object, boolean bl) {
        boolean bl2 = true;
        Object[] objectArray = this.fTreeContentProvider.getChildren(object);
        int n = objectArray.length - 1;
        while (n >= 0) {
            if (this.fTree.getChecked(objectArray[n]) != bl || this.fTree.getGrayed(objectArray[n])) {
                bl2 = false;
                break;
            }
            --n;
        }
        this.fTree.setGrayed(object, !bl2);
        this.fTree.setChecked(object, !bl2 || bl);
        this.updateParentState(object, bl);
    }

    private void initializeCheckedState() {
        BusyIndicator.showWhile((Display)this.getShell().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                Object object;
                Object[] objectArray;
                IWorkbenchPart iWorkbenchPart;
                if (JavaWorkingSetPage.this.fWorkingSet == null) {
                    IWorkbenchPage iWorkbenchPage = JavaPlugin.getActivePage();
                    if (iWorkbenchPage == null) {
                        return;
                    }
                    iWorkbenchPart = JavaPlugin.getActivePage().getActivePart();
                    if (iWorkbenchPart == null) {
                        return;
                    }
                    try {
                        objectArray = SelectionConverter.getStructuredSelection(iWorkbenchPart).toArray();
                        int n = 0;
                        while (n < objectArray.length) {
                            if (objectArray[n] instanceof IResource) {
                                IResource iResource = (IResource)objectArray[n];
                                Class<?> clazz = class$2;
                                if (clazz == null) {
                                    try {
                                        clazz = Class.forName("org.eclipse.wst.jsdt.core.IJavaElement");
                                    }
                                    catch (ClassNotFoundException classNotFoundException) {
                                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                    }
                                }
                                if ((object = (IJavaElement)iResource.getAdapter((Class)clazz)) != null && object.exists() && object.getJavaProject().isOnClasspath((IResource)objectArray[n])) {
                                    objectArray[n] = object;
                                }
                            }
                            ++n;
                        }
                    }
                    catch (JavaModelException javaModelException) {
                        return;
                    }
                }
                objectArray = JavaWorkingSetPage.this.fWorkingSet.getElements();
                int n = 0;
                while (n < objectArray.length) {
                    IJavaProject iJavaProject;
                    IProject iProject;
                    iWorkbenchPart = objectArray[n];
                    if (iWorkbenchPart instanceof IResource && !(iProject = ((IResource)iWorkbenchPart).getProject()).isAccessible()) {
                        objectArray[n] = iProject;
                    }
                    if (iWorkbenchPart instanceof IJavaElement && (iJavaProject = ((IJavaElement)iWorkbenchPart).getJavaProject()) != null && !iJavaProject.getProject().isAccessible()) {
                        objectArray[n] = iJavaProject.getProject();
                    }
                    ++n;
                }
                JavaWorkingSetPage.this.fTree.setCheckedElements(objectArray);
                HashSet<IJavaElement> hashSet = new HashSet<IJavaElement>();
                int n2 = 0;
                while (n2 < objectArray.length) {
                    block26: {
                        Object object2;
                        block25: {
                            object2 = objectArray[n2];
                            if (JavaWorkingSetPage.this.isExpandable(object2)) {
                                JavaWorkingSetPage.this.setSubtreeChecked(object2, true, true);
                            }
                            if (!(object2 instanceof IAdaptable)) break block25;
                            IAdaptable iAdaptable = (IAdaptable)object2;
                            Class<?> clazz = class$0;
                            if (clazz == null) {
                                try {
                                    clazz = Class.forName("org.eclipse.core.resources.IResource");
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                }
                            }
                            if ((object = (IResource)iAdaptable.getAdapter((Class)clazz)) != null && !object.isAccessible()) break block26;
                        }
                        if ((object = JavaWorkingSetPage.this.fTreeContentProvider.getParent(object2)) != null) {
                            hashSet.add((IJavaElement)object);
                        }
                    }
                    ++n2;
                }
                Iterator iterator = hashSet.iterator();
                while (iterator.hasNext()) {
                    JavaWorkingSetPage.this.updateObjectState(iterator.next(), true);
                }
            }
        });
    }

    private boolean isExpandable(Object object) {
        return object instanceof IJavaProject || object instanceof IPackageFragmentRoot || object instanceof IPackageFragment || object instanceof IJavaModel || object instanceof IContainer;
    }
}

