/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.workingsets;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetUpdater;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.jsdt.core.ElementChangedEvent;
import org.eclipse.wst.jsdt.core.IElementChangedListener;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IJavaElementDelta;
import org.eclipse.wst.jsdt.core.IJavaModel;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.JavaCore;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.workingsets.WorkingSetModel;

public class OthersWorkingSetUpdater
implements IWorkingSetUpdater {
    public static final String ID = "org.eclipse.wst.jsdt.internal.ui.OthersWorkingSet";
    private IWorkingSet fWorkingSet;
    private WorkingSetModel fWorkingSetModel;
    private IResourceChangeListener fResourceChangeListener;
    private IPropertyChangeListener fWorkingSetListener;
    private IElementChangedListener fJavaElementChangeListener;
    static /* synthetic */ Class class$0;

    public void add(IWorkingSet iWorkingSet) {
        Assert.isTrue((this.fWorkingSet == null && this.fWorkingSetModel != null ? 1 : 0) != 0);
        this.fWorkingSet = iWorkingSet;
    }

    public boolean remove(IWorkingSet iWorkingSet) {
        Assert.isTrue((this.fWorkingSet == iWorkingSet ? 1 : 0) != 0);
        this.fWorkingSet = null;
        return true;
    }

    public boolean contains(IWorkingSet iWorkingSet) {
        return this.fWorkingSet == iWorkingSet;
    }

    public void init(WorkingSetModel workingSetModel) {
        this.fWorkingSetModel = workingSetModel;
        this.fResourceChangeListener = new ResourceChangeListener();
        ResourcesPlugin.getWorkspace().addResourceChangeListener(this.fResourceChangeListener, 1);
        this.fWorkingSetListener = new WorkingSetListener();
        PlatformUI.getWorkbench().getWorkingSetManager().addPropertyChangeListener(this.fWorkingSetListener);
        this.fJavaElementChangeListener = new JavaElementChangeListener();
        JavaCore.addElementChangedListener((IElementChangedListener)this.fJavaElementChangeListener, (int)1);
    }

    public void dispose() {
        if (this.fResourceChangeListener != null) {
            ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.fResourceChangeListener);
            this.fResourceChangeListener = null;
        }
        if (this.fWorkingSetListener != null) {
            PlatformUI.getWorkbench().getWorkingSetManager().removePropertyChangeListener(this.fWorkingSetListener);
            this.fWorkingSetListener = null;
        }
        if (this.fJavaElementChangeListener != null) {
            JavaCore.removeElementChangedListener((IElementChangedListener)this.fJavaElementChangeListener);
        }
    }

    public void updateElements() {
        int n;
        IJavaProject[] iJavaProjectArray;
        Assert.isTrue((this.fWorkingSet != null && this.fWorkingSetModel != null ? 1 : 0) != 0);
        IWorkingSet[] iWorkingSetArray = this.fWorkingSetModel.getActiveWorkingSets();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        HashSet<IResource> hashSet = new HashSet<IResource>();
        int n2 = 0;
        while (n2 < iWorkingSetArray.length) {
            if (iWorkingSetArray[n2] != this.fWorkingSet) {
                iJavaProjectArray = iWorkingSetArray[n2].getElements();
                n = 0;
                while (n < iJavaProjectArray.length) {
                    IResource iResource;
                    IJavaProject iJavaProject = iJavaProjectArray[n];
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = Class.forName("org.eclipse.core.resources.IResource");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if ((iResource = (IResource)iJavaProject.getAdapter((Class)clazz)) != null && iResource.getType() == 4) {
                        hashSet.add(iResource);
                    }
                    ++n;
                }
            }
            ++n2;
        }
        IJavaModel iJavaModel = JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot());
        try {
            iJavaProjectArray = iJavaModel.getJavaProjects();
            n = 0;
            while (n < iJavaProjectArray.length) {
                if (!hashSet.contains(iJavaProjectArray[n].getProject())) {
                    arrayList.add(iJavaProjectArray[n]);
                }
                ++n;
            }
            Object[] objectArray = iJavaModel.getNonJavaResources();
            int n3 = 0;
            while (n3 < objectArray.length) {
                if (!hashSet.contains(objectArray[n3])) {
                    arrayList.add(objectArray[n3]);
                }
                ++n3;
            }
        }
        catch (JavaModelException javaModelException) {
            JavaPlugin.log(javaModelException);
        }
        this.fWorkingSet.setElements(arrayList.toArray(new IAdaptable[arrayList.size()]));
    }

    private class JavaElementChangeListener
    implements IElementChangedListener {
        private JavaElementChangeListener() {
        }

        public void elementChanged(ElementChangedEvent elementChangedEvent) {
            if (OthersWorkingSetUpdater.this.fWorkingSet == null) {
                return;
            }
            this.processJavaDelta(new ArrayList<IAdaptable>(Arrays.asList(OthersWorkingSetUpdater.this.fWorkingSet.getElements())), elementChangedEvent.getDelta());
        }

        private void processJavaDelta(List list, IJavaElementDelta iJavaElementDelta) {
            IJavaElement iJavaElement = iJavaElementDelta.getElement();
            int n = iJavaElement.getElementType();
            if (n == 2) {
                int n2 = list.indexOf(iJavaElement);
                int n3 = iJavaElementDelta.getKind();
                int n4 = iJavaElementDelta.getFlags();
                if (n3 == 4) {
                    if (n2 != -1 && (n4 & 0x400) != 0) {
                        list.set(n2, ((IJavaProject)iJavaElement).getProject());
                        OthersWorkingSetUpdater.this.fWorkingSet.setElements(list.toArray(new IAdaptable[list.size()]));
                    } else if ((n4 & 0x200) != 0 && (n2 = list.indexOf(((IJavaProject)iJavaElement).getProject())) != -1) {
                        list.set(n2, iJavaElement);
                        OthersWorkingSetUpdater.this.fWorkingSet.setElements(list.toArray(new IAdaptable[list.size()]));
                    }
                }
                return;
            }
            IJavaElementDelta[] iJavaElementDeltaArray = iJavaElementDelta.getAffectedChildren();
            int n5 = 0;
            while (n5 < iJavaElementDeltaArray.length) {
                this.processJavaDelta(list, iJavaElementDeltaArray[n5]);
                ++n5;
            }
        }
    }

    private class ResourceChangeListener
    implements IResourceChangeListener {
        private ResourceChangeListener() {
        }

        public void resourceChanged(IResourceChangeEvent iResourceChangeEvent) {
            if (OthersWorkingSetUpdater.this.fWorkingSet == null) {
                return;
            }
            IResourceDelta iResourceDelta = iResourceChangeEvent.getDelta();
            IResourceDelta[] iResourceDeltaArray = iResourceDelta.getAffectedChildren(3, 4);
            if (iResourceDeltaArray.length > 0) {
                OthersWorkingSetUpdater.this.updateElements();
            } else {
                iResourceDeltaArray = iResourceDelta.getAffectedChildren(4, 4);
                int n = 0;
                while (n < iResourceDeltaArray.length) {
                    IResourceDelta iResourceDelta2 = iResourceDeltaArray[n];
                    if ((iResourceDelta2.getFlags() & 0x80000) != 0) {
                        OthersWorkingSetUpdater.this.updateElements();
                        return;
                    }
                    ++n;
                }
            }
        }
    }

    private class WorkingSetListener
    implements IPropertyChangeListener {
        private WorkingSetListener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            IWorkingSet iWorkingSet;
            if ("workingSetContentChange".equals(propertyChangeEvent.getProperty()) && (iWorkingSet = (IWorkingSet)propertyChangeEvent.getNewValue()) != OthersWorkingSetUpdater.this.fWorkingSet && OthersWorkingSetUpdater.this.fWorkingSetModel.isActiveWorkingSet(iWorkingSet)) {
                OthersWorkingSetUpdater.this.updateElements();
            }
        }
    }
}

