/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.workingsets;

import com.ibm.icu.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.IWorkingSetNewWizard;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.eclipse.wst.jsdt.internal.ui.workingsets.WorkingSetConfigurationBlock;
import org.eclipse.wst.jsdt.internal.ui.workingsets.WorkingSetMessages;

public class SimpleWorkingSetSelectionDialog
extends SelectionDialog {
    private final IWorkingSet[] fWorkingSets;
    private final IWorkingSet[] fInitialSelection;
    private final ArrayList fCreatedWorkingSets;
    private CheckboxTableViewer fTableViewer;
    private IWorkingSet[] fCheckedElements;
    private Button fSelectAll;
    private Button fDeselectAll;
    private Button fNewWorkingSet;

    public SimpleWorkingSetSelectionDialog(Shell shell, String[] stringArray, IWorkingSet[] iWorkingSetArray) {
        super(shell);
        this.setTitle(WorkingSetMessages.SimpleWorkingSetSelectionDialog_SimpleSelectWorkingSetDialog_title);
        this.setHelpAvailable(false);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.fWorkingSets = WorkingSetConfigurationBlock.filter(PlatformUI.getWorkbench().getWorkingSetManager().getWorkingSets(), stringArray);
        this.fInitialSelection = iWorkingSetArray;
        this.fCheckedElements = this.fInitialSelection;
        this.fCreatedWorkingSets = new ArrayList();
    }

    protected final Control createDialogArea(Composite composite) {
        Composite composite2 = (Composite)super.createDialogArea(composite);
        composite2.setFont(composite.getFont());
        this.createMessageArea(composite2);
        Composite composite3 = new Composite(composite2, 0);
        composite3.setFont(composite2.getFont());
        composite3.setLayoutData((Object)new GridData(1808));
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        composite3.setLayout((Layout)gridLayout);
        Composite composite4 = new Composite(composite3, 0);
        composite4.setFont(composite2.getFont());
        composite4.setLayoutData((Object)new GridData(4, 4, true, true));
        gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        composite4.setLayout((Layout)gridLayout);
        this.fTableViewer = this.createTableViewer(composite4);
        this.createRightButtonBar(composite3);
        this.createBottomButtonBar(composite2);
        return composite2;
    }

    public IWorkingSet[] getSelection() {
        return this.fCheckedElements;
    }

    protected CheckboxTableViewer createTableViewer(Composite composite) {
        CheckboxTableViewer checkboxTableViewer = CheckboxTableViewer.newCheckList((Composite)composite, (int)2050);
        checkboxTableViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent checkStateChangedEvent) {
                SimpleWorkingSetSelectionDialog.this.checkedStateChanged();
            }
        });
        GridData gridData = new GridData(1808);
        gridData.heightHint = this.convertHeightInCharsToPixels(20);
        gridData.widthHint = this.convertWidthInCharsToPixels(50);
        checkboxTableViewer.getTable().setLayoutData((Object)gridData);
        checkboxTableViewer.getTable().setFont(composite.getFont());
        checkboxTableViewer.addFilter(this.createTableFilter());
        checkboxTableViewer.setLabelProvider((IBaseLabelProvider)this.createTableLabelProvider());
        checkboxTableViewer.setSorter(this.createTableSorter());
        checkboxTableViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object object) {
                return (Object[])object;
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object object, Object object2) {
            }
        });
        checkboxTableViewer.setInput((Object)this.fWorkingSets);
        checkboxTableViewer.setCheckedElements((Object[])this.fInitialSelection);
        return checkboxTableViewer;
    }

    protected ViewerSorter createTableSorter() {
        return new ViewerSorter(){

            public int compare(Viewer viewer, Object object, Object object2) {
                IWorkingSet iWorkingSet = (IWorkingSet)object;
                IWorkingSet iWorkingSet2 = (IWorkingSet)object2;
                return Collator.getInstance().compare(iWorkingSet.getLabel(), iWorkingSet2.getLabel());
            }
        };
    }

    protected LabelProvider createTableLabelProvider() {
        return new WorkingSetLabelProvider();
    }

    protected ViewerFilter createTableFilter() {
        return new Filter();
    }

    protected void createRightButtonBar(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setFont(composite.getFont());
        composite2.setLayoutData((Object)new GridData(1040));
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        composite2.setLayout((Layout)gridLayout);
        this.createButtonsForRightButtonBar(composite2);
    }

    protected void createButtonsForRightButtonBar(Composite composite) {
        this.fSelectAll = new Button(composite, 8);
        this.fSelectAll.setText(WorkingSetMessages.SimpleWorkingSetSelectionDialog_SelectAll_button);
        this.fSelectAll.setFont(composite.getFont());
        this.setButtonLayoutData(this.fSelectAll);
        this.fSelectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                SimpleWorkingSetSelectionDialog.this.selectAll();
            }
        });
        this.fDeselectAll = new Button(composite, 8);
        this.fDeselectAll.setText(WorkingSetMessages.SimpleWorkingSetSelectionDialog_DeselectAll_button);
        this.fDeselectAll.setFont(composite.getFont());
        this.setButtonLayoutData(this.fDeselectAll);
        this.fDeselectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                SimpleWorkingSetSelectionDialog.this.deselectAll();
            }
        });
        new Label(composite, 0);
        this.fNewWorkingSet = new Button(composite, 8);
        this.fNewWorkingSet.setText(WorkingSetMessages.SimpleWorkingSetSelectionDialog_New_button);
        this.fNewWorkingSet.setFont(composite.getFont());
        this.setButtonLayoutData(this.fNewWorkingSet);
        this.fNewWorkingSet.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                IWorkingSet iWorkingSet = SimpleWorkingSetSelectionDialog.this.newWorkingSet();
            }
        });
    }

    protected void createBottomButtonBar(Composite composite) {
    }

    protected void checkedStateChanged() {
        List<Object> list = Arrays.asList(this.fTableViewer.getCheckedElements());
        this.fCheckedElements = list.toArray(new IWorkingSet[list.size()]);
    }

    protected void selectAll() {
        this.fTableViewer.setAllChecked(true);
        this.checkedStateChanged();
    }

    protected void deselectAll() {
        this.fTableViewer.setAllChecked(false);
        this.checkedStateChanged();
    }

    protected IWorkingSet newWorkingSet() {
        IWorkingSet iWorkingSet;
        Filter filter;
        IWorkingSetManager iWorkingSetManager = PlatformUI.getWorkbench().getWorkingSetManager();
        IWorkingSetNewWizard iWorkingSetNewWizard = iWorkingSetManager.createWorkingSetNewWizard(new String[]{"org.eclipse.wst.jsdt.ui.JavaWorkingSetPage"});
        WizardDialog wizardDialog = new WizardDialog(this.getShell(), (IWizard)iWorkingSetNewWizard);
        wizardDialog.create();
        if (wizardDialog.open() == 0 && (filter = new Filter()).select(null, null, iWorkingSet = iWorkingSetNewWizard.getSelection())) {
            this.addNewWorkingSet(iWorkingSet);
            this.checkedStateChanged();
            iWorkingSetManager.addWorkingSet(iWorkingSet);
            this.fCreatedWorkingSets.add(iWorkingSet);
            return iWorkingSet;
        }
        return null;
    }

    protected void addNewWorkingSet(IWorkingSet iWorkingSet) {
        this.fTableViewer.add((Object)iWorkingSet);
        this.fTableViewer.setSelection((ISelection)new StructuredSelection((Object)iWorkingSet), true);
        this.fTableViewer.setChecked((Object)iWorkingSet, true);
    }

    protected void cancelPressed() {
        IWorkingSetManager iWorkingSetManager = PlatformUI.getWorkbench().getWorkingSetManager();
        int n = 0;
        while (n < this.fCreatedWorkingSets.size()) {
            iWorkingSetManager.removeWorkingSet((IWorkingSet)this.fCreatedWorkingSets.get(n));
            ++n;
        }
        super.cancelPressed();
    }

    private class Filter
    extends ViewerFilter {
        private Filter() {
        }

        public boolean select(Viewer viewer, Object object, Object object2) {
            return this.isCompatible((IWorkingSet)object2);
        }

        private boolean isCompatible(IWorkingSet iWorkingSet) {
            if (iWorkingSet.isAggregateWorkingSet() || !iWorkingSet.isSelfUpdating()) {
                return false;
            }
            if (!iWorkingSet.isVisible()) {
                return false;
            }
            return iWorkingSet.isEditable();
        }
    }

    private static class WorkingSetLabelProvider
    extends LabelProvider {
        private Map fIcons = new Hashtable();

        public void dispose() {
            Iterator iterator = this.fIcons.values().iterator();
            while (iterator.hasNext()) {
                Image image = (Image)iterator.next();
                image.dispose();
            }
            super.dispose();
        }

        public Image getImage(Object object) {
            Assert.isTrue((boolean)(object instanceof IWorkingSet));
            IWorkingSet iWorkingSet = (IWorkingSet)object;
            ImageDescriptor imageDescriptor = iWorkingSet.getImageDescriptor();
            if (imageDescriptor == null) {
                return null;
            }
            Image image = (Image)this.fIcons.get(imageDescriptor);
            if (image == null) {
                image = imageDescriptor.createImage();
                this.fIcons.put(imageDescriptor, image);
            }
            return image;
        }

        public String getText(Object object) {
            Assert.isTrue((boolean)(object instanceof IWorkingSet));
            IWorkingSet iWorkingSet = (IWorkingSet)object;
            return iWorkingSet.getName();
        }
    }
}

