/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.workingsets;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.IElementComparer;
import org.eclipse.ui.ILocalWorkingSetManager;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetUpdater;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.internal.ui.workingsets.OthersWorkingSetUpdater;
import org.eclipse.wst.jsdt.internal.ui.workingsets.WorkingSetMessages;

public class WorkingSetModel {
    public static final String CHANGE_WORKING_SET_MODEL_CONTENT = "workingSetModelChanged";
    public static final IElementComparer COMPARER = new WorkingSetComparar();
    private static final String TAG_LOCAL_WORKING_SET_MANAGER = "localWorkingSetManager";
    private static final String TAG_ACTIVE_WORKING_SET = "activeWorkingSet";
    private static final String TAG_WORKING_SET_NAME = "workingSetName";
    private static final String TAG_CONFIGURED = "configured";
    private ILocalWorkingSetManager fLocalWorkingSetManager;
    private List fActiveWorkingSets;
    private ListenerList fListeners;
    private IPropertyChangeListener fWorkingSetManagerListener;
    private OthersWorkingSetUpdater fOthersWorkingSetUpdater;
    private ElementMapper fElementMapper = new ElementMapper();
    private boolean fConfigured;
    static /* synthetic */ Class class$0;

    public WorkingSetModel(IMemento iMemento) {
        this.fLocalWorkingSetManager = PlatformUI.getWorkbench().createLocalWorkingSetManager();
        this.addListenersToWorkingSetManagers();
        this.fActiveWorkingSets = new ArrayList(2);
        if (iMemento == null || !this.restoreState(iMemento)) {
            IWorkingSet iWorkingSet = this.fLocalWorkingSetManager.createWorkingSet(WorkingSetMessages.WorkingSetModel_others_name, new IAdaptable[0]);
            iWorkingSet.setId("org.eclipse.wst.jsdt.internal.ui.OthersWorkingSet");
            this.fLocalWorkingSetManager.addWorkingSet(iWorkingSet);
            this.fActiveWorkingSets.add(iWorkingSet);
        }
        Assert.isNotNull((Object)this.fOthersWorkingSetUpdater);
        this.fElementMapper.rebuild(this.getActiveWorkingSets());
        this.fOthersWorkingSetUpdater.updateElements();
    }

    private void addListenersToWorkingSetManagers() {
        this.fListeners = new ListenerList(1);
        this.fWorkingSetManagerListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                WorkingSetModel.this.workingSetManagerChanged(propertyChangeEvent);
            }
        };
        PlatformUI.getWorkbench().getWorkingSetManager().addPropertyChangeListener(this.fWorkingSetManagerListener);
        this.fLocalWorkingSetManager.addPropertyChangeListener(this.fWorkingSetManagerListener);
    }

    public void dispose() {
        if (this.fWorkingSetManagerListener != null) {
            PlatformUI.getWorkbench().getWorkingSetManager().removePropertyChangeListener(this.fWorkingSetManagerListener);
            this.fLocalWorkingSetManager.removePropertyChangeListener(this.fWorkingSetManagerListener);
            this.fLocalWorkingSetManager.dispose();
            this.fWorkingSetManagerListener = null;
        }
    }

    public IAdaptable[] getChildren(IWorkingSet iWorkingSet) {
        return iWorkingSet.getElements();
    }

    public Object getParent(Object object) {
        if (object instanceof IWorkingSet && this.fActiveWorkingSets.contains(object)) {
            return this;
        }
        return this.fElementMapper.getFirstWorkingSet(object);
    }

    public Object[] getAllParents(Object object) {
        if (object instanceof IWorkingSet && this.fActiveWorkingSets.contains(object)) {
            return new Object[]{this};
        }
        return this.fElementMapper.getAllWorkingSets(object).toArray();
    }

    public Object[] addWorkingSets(Object[] objectArray) {
        ArrayList<Object> arrayList = null;
        int n = 0;
        while (n < objectArray.length) {
            Object object = objectArray[n];
            List list = null;
            list = object instanceof IResource ? this.fElementMapper.getAllWorkingSetsForResource((IResource)object) : this.fElementMapper.getAllWorkingSets(object);
            if (list != null && list.size() > 0) {
                if (arrayList == null) {
                    arrayList = new ArrayList<Object>(Arrays.asList(objectArray));
                }
                arrayList.addAll(list);
            }
            ++n;
        }
        if (arrayList == null) {
            return objectArray;
        }
        return arrayList.toArray();
    }

    public boolean needsConfiguration() {
        return !this.fConfigured && this.fActiveWorkingSets.size() == 1 && "org.eclipse.wst.jsdt.internal.ui.OthersWorkingSet".equals(((IWorkingSet)this.fActiveWorkingSets.get(0)).getId());
    }

    public void configured() {
        this.fConfigured = true;
    }

    public void addPropertyChangeListener(IPropertyChangeListener iPropertyChangeListener) {
        this.fListeners.add((Object)iPropertyChangeListener);
    }

    public void removePropertyChangeListener(IPropertyChangeListener iPropertyChangeListener) {
        this.fListeners.remove((Object)iPropertyChangeListener);
    }

    public IWorkingSet[] getActiveWorkingSets() {
        return this.fActiveWorkingSets.toArray(new IWorkingSet[this.fActiveWorkingSets.size()]);
    }

    public IWorkingSet[] getAllWorkingSets() {
        ArrayList<IWorkingSet> arrayList = new ArrayList<IWorkingSet>();
        arrayList.addAll(this.fActiveWorkingSets);
        IWorkingSet[] iWorkingSetArray = this.fLocalWorkingSetManager.getWorkingSets();
        int n = 0;
        while (n < iWorkingSetArray.length) {
            if (!arrayList.contains(iWorkingSetArray[n])) {
                arrayList.add(iWorkingSetArray[n]);
            }
            ++n;
        }
        IWorkingSet[] iWorkingSetArray2 = PlatformUI.getWorkbench().getWorkingSetManager().getWorkingSets();
        int n2 = 0;
        while (n2 < iWorkingSetArray2.length) {
            if (!arrayList.contains(iWorkingSetArray2[n2])) {
                arrayList.add(iWorkingSetArray2[n2]);
            }
            ++n2;
        }
        return arrayList.toArray(new IWorkingSet[arrayList.size()]);
    }

    public void setActiveWorkingSets(IWorkingSet[] iWorkingSetArray) {
        this.fActiveWorkingSets = new ArrayList<IWorkingSet>(Arrays.asList(iWorkingSetArray));
        this.fElementMapper.rebuild(this.getActiveWorkingSets());
        this.fOthersWorkingSetUpdater.updateElements();
        this.fireEvent(new PropertyChangeEvent((Object)this, CHANGE_WORKING_SET_MODEL_CONTENT, null, null));
    }

    public void saveState(IMemento iMemento) {
        iMemento.putString(TAG_CONFIGURED, Boolean.toString(this.fConfigured));
        this.fLocalWorkingSetManager.saveState(iMemento.createChild(TAG_LOCAL_WORKING_SET_MANAGER));
        Iterator iterator = this.fActiveWorkingSets.iterator();
        while (iterator.hasNext()) {
            IMemento iMemento2 = iMemento.createChild(TAG_ACTIVE_WORKING_SET);
            IWorkingSet iWorkingSet = (IWorkingSet)iterator.next();
            iMemento2.putString(TAG_WORKING_SET_NAME, iWorkingSet.getName());
        }
    }

    public List getNonProjectTopLevelElements() {
        return this.fElementMapper.getNonProjectTopLevelElements();
    }

    private boolean restoreState(IMemento iMemento) {
        String string = iMemento.getString(TAG_CONFIGURED);
        if (string == null) {
            return false;
        }
        this.fConfigured = Boolean.valueOf(string);
        this.fLocalWorkingSetManager.restoreState(iMemento.getChild(TAG_LOCAL_WORKING_SET_MANAGER));
        IMemento[] iMementoArray = iMemento.getChildren(TAG_ACTIVE_WORKING_SET);
        int n = 0;
        while (n < iMementoArray.length) {
            String string2 = iMementoArray[n].getString(TAG_WORKING_SET_NAME);
            if (string2 != null) {
                IWorkingSet iWorkingSet = this.fLocalWorkingSetManager.getWorkingSet(string2);
                if (iWorkingSet == null) {
                    iWorkingSet = PlatformUI.getWorkbench().getWorkingSetManager().getWorkingSet(string2);
                }
                if (iWorkingSet != null) {
                    this.fActiveWorkingSets.add(iWorkingSet);
                }
            }
            ++n;
        }
        return true;
    }

    private void workingSetManagerChanged(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getProperty();
        if ("workingSetUpdaterInstalled".equals(string) && propertyChangeEvent.getSource() == this.fLocalWorkingSetManager) {
            IWorkingSetUpdater iWorkingSetUpdater = (IWorkingSetUpdater)propertyChangeEvent.getNewValue();
            if (iWorkingSetUpdater instanceof OthersWorkingSetUpdater) {
                this.fOthersWorkingSetUpdater = (OthersWorkingSetUpdater)iWorkingSetUpdater;
                this.fOthersWorkingSetUpdater.init(this);
            }
            return;
        }
        if (!this.isAffected(propertyChangeEvent)) {
            return;
        }
        if ("workingSetContentChange".equals(string)) {
            IWorkingSet iWorkingSet = (IWorkingSet)propertyChangeEvent.getNewValue();
            IAdaptable[] iAdaptableArray = this.fElementMapper.refresh(iWorkingSet);
            if (iAdaptableArray != null) {
                this.fireEvent(propertyChangeEvent);
            }
        } else if ("workingSetRemove".equals(string)) {
            IWorkingSet iWorkingSet = (IWorkingSet)propertyChangeEvent.getOldValue();
            ArrayList arrayList = new ArrayList(this.fActiveWorkingSets);
            arrayList.remove(iWorkingSet);
            this.setActiveWorkingSets(arrayList.toArray(new IWorkingSet[arrayList.size()]));
        } else if ("workingSetNameChange".equals(string)) {
            this.fireEvent(propertyChangeEvent);
        }
    }

    private void fireEvent(PropertyChangeEvent propertyChangeEvent) {
        Object[] objectArray = this.fListeners.getListeners();
        int n = 0;
        while (n < objectArray.length) {
            ((IPropertyChangeListener)objectArray[n]).propertyChange(propertyChangeEvent);
            ++n;
        }
    }

    private boolean isAffected(PropertyChangeEvent propertyChangeEvent) {
        if (this.fActiveWorkingSets == null) {
            return false;
        }
        Object object = propertyChangeEvent.getOldValue();
        Object object2 = propertyChangeEvent.getNewValue();
        return object != null && this.fActiveWorkingSets.contains(object) || object2 != null && this.fActiveWorkingSets.contains(object2);
    }

    public boolean isActiveWorkingSet(IWorkingSet iWorkingSet) {
        return this.fActiveWorkingSets.contains(iWorkingSet);
    }

    private static class ElementMapper {
        private Map fElementToWorkingSet = new HashMap();
        private Map fWorkingSetToElement = new IdentityHashMap();
        private Map fResourceToWorkingSet = new HashMap();
        private List fNonProjectTopLevelElements = new ArrayList();

        private ElementMapper() {
        }

        public void clear() {
            this.fElementToWorkingSet.clear();
            this.fWorkingSetToElement.clear();
            this.fResourceToWorkingSet.clear();
            this.fNonProjectTopLevelElements.clear();
        }

        public void rebuild(IWorkingSet[] iWorkingSetArray) {
            this.clear();
            int n = 0;
            while (n < iWorkingSetArray.length) {
                this.put(iWorkingSetArray[n]);
                ++n;
            }
        }

        public IAdaptable[] remove(IWorkingSet iWorkingSet) {
            IAdaptable[] iAdaptableArray = (IAdaptable[])this.fWorkingSetToElement.remove(iWorkingSet);
            if (iAdaptableArray != null) {
                int n = 0;
                while (n < iAdaptableArray.length) {
                    this.removeElement(iAdaptableArray[n], iWorkingSet);
                    ++n;
                }
            }
            return iAdaptableArray;
        }

        public IAdaptable[] refresh(IWorkingSet iWorkingSet) {
            IAdaptable[] iAdaptableArray = (IAdaptable[])this.fWorkingSetToElement.get(iWorkingSet);
            if (iAdaptableArray == null) {
                return null;
            }
            IAdaptable[] iAdaptableArray2 = iWorkingSet.getElements();
            ArrayList<IAdaptable> arrayList = new ArrayList<IAdaptable>(Arrays.asList(iAdaptableArray));
            ArrayList<IAdaptable> arrayList2 = new ArrayList<IAdaptable>(Arrays.asList(iAdaptableArray2));
            this.computeDelta(arrayList, arrayList2, iAdaptableArray, iAdaptableArray2);
            Iterator iterator = arrayList2.iterator();
            while (iterator.hasNext()) {
                this.addElement((IAdaptable)iterator.next(), iWorkingSet);
            }
            iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                this.removeElement((IAdaptable)iterator.next(), iWorkingSet);
            }
            if (arrayList.size() > 0 || arrayList2.size() > 0) {
                this.fWorkingSetToElement.put(iWorkingSet, iAdaptableArray2);
            }
            return iAdaptableArray;
        }

        private void computeDelta(List list, List list2, IAdaptable[] iAdaptableArray, IAdaptable[] iAdaptableArray2) {
            int n = 0;
            while (n < iAdaptableArray.length) {
                list2.remove(iAdaptableArray[n]);
                ++n;
            }
            n = 0;
            while (n < iAdaptableArray2.length) {
                list.remove(iAdaptableArray2[n]);
                ++n;
            }
        }

        public IWorkingSet getFirstWorkingSet(Object object) {
            return (IWorkingSet)this.getFirstElement(this.fElementToWorkingSet, object);
        }

        public List getAllWorkingSets(Object object) {
            List list = this.getAllElements(this.fElementToWorkingSet, object);
            if (list.isEmpty() && object instanceof IJavaElement) {
                list = this.getAllElements(this.fElementToWorkingSet, ((IJavaElement)object).getResource());
            }
            return list;
        }

        public IWorkingSet getFirstWorkingSetForResource(IResource iResource) {
            return (IWorkingSet)this.getFirstElement(this.fResourceToWorkingSet, iResource);
        }

        public List getAllWorkingSetsForResource(IResource iResource) {
            return this.getAllElements(this.fResourceToWorkingSet, iResource);
        }

        public List getNonProjectTopLevelElements() {
            return this.fNonProjectTopLevelElements;
        }

        private void put(IWorkingSet iWorkingSet) {
            if (this.fWorkingSetToElement.containsKey(iWorkingSet)) {
                return;
            }
            IAdaptable[] iAdaptableArray = iWorkingSet.getElements();
            this.fWorkingSetToElement.put(iWorkingSet, iAdaptableArray);
            int n = 0;
            while (n < iAdaptableArray.length) {
                IAdaptable iAdaptable = iAdaptableArray[n];
                this.addElement(iAdaptable, iWorkingSet);
                if (!(iAdaptable instanceof IProject) && !(iAdaptable instanceof IJavaProject)) {
                    this.fNonProjectTopLevelElements.add(iAdaptable);
                }
                ++n;
            }
        }

        private void addElement(IAdaptable iAdaptable, IWorkingSet iWorkingSet) {
            IResource iResource;
            this.addToMap(this.fElementToWorkingSet, iAdaptable, iWorkingSet);
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.core.resources.IResource");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((iResource = (IResource)iAdaptable.getAdapter((Class)clazz)) != null) {
                this.addToMap(this.fResourceToWorkingSet, (IAdaptable)iResource, iWorkingSet);
            }
        }

        private void removeElement(IAdaptable iAdaptable, IWorkingSet iWorkingSet) {
            IResource iResource;
            this.removeFromMap(this.fElementToWorkingSet, iAdaptable, iWorkingSet);
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.core.resources.IResource");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((iResource = (IResource)iAdaptable.getAdapter((Class)clazz)) != null) {
                this.removeFromMap(this.fResourceToWorkingSet, (IAdaptable)iResource, iWorkingSet);
            }
        }

        private void addToMap(Map map, IAdaptable iAdaptable, IWorkingSet iWorkingSet) {
            Object v = map.get(iAdaptable);
            if (v == null) {
                map.put(iAdaptable, iWorkingSet);
            } else if (v instanceof IWorkingSet) {
                ArrayList<Object> arrayList = new ArrayList<Object>(2);
                arrayList.add(v);
                arrayList.add(iWorkingSet);
                map.put(iAdaptable, arrayList);
            } else if (v instanceof List) {
                ((List)v).add(iWorkingSet);
            }
        }

        private void removeFromMap(Map map, IAdaptable iAdaptable, IWorkingSet iWorkingSet) {
            Object v = map.get(iAdaptable);
            if (v == null) {
                return;
            }
            if (v instanceof List) {
                List list = (List)v;
                list.remove(iWorkingSet);
                switch (list.size()) {
                    case 0: {
                        map.remove(iAdaptable);
                        break;
                    }
                    case 1: {
                        map.put(iAdaptable, list.get(0));
                    }
                }
            } else if (v == iWorkingSet) {
                map.remove(iAdaptable);
            }
        }

        private Object getFirstElement(Map map, Object object) {
            Object v = map.get(object);
            if (v instanceof List) {
                return ((List)v).get(0);
            }
            return v;
        }

        private List getAllElements(Map map, Object object) {
            Object v = map.get(object);
            if (v instanceof List) {
                return (List)v;
            }
            if (v == null) {
                return Collections.EMPTY_LIST;
            }
            ArrayList arrayList = new ArrayList(1);
            arrayList.add(v);
            return arrayList;
        }
    }

    private static class WorkingSetComparar
    implements IElementComparer {
        private WorkingSetComparar() {
        }

        public boolean equals(Object object, Object object2) {
            IWorkingSet iWorkingSet;
            IWorkingSet iWorkingSet2 = object instanceof IWorkingSet ? (IWorkingSet)object : null;
            IWorkingSet iWorkingSet3 = iWorkingSet = object2 instanceof IWorkingSet ? (IWorkingSet)object2 : null;
            if (iWorkingSet2 == null || iWorkingSet == null) {
                return object.equals(object2);
            }
            return iWorkingSet2 == iWorkingSet;
        }

        public int hashCode(Object object) {
            if (object instanceof IWorkingSet) {
                return System.identityHashCode(object);
            }
            return object.hashCode();
        }
    }
}

