/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.ui.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IField;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IMember;
import org.eclipse.wst.jsdt.core.IMethod;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.internal.corext.codemanipulation.AddJavaDocStubOperation;
import org.eclipse.wst.jsdt.internal.corext.util.JavaModelUtil;
import org.eclipse.wst.jsdt.internal.ui.actions.ActionMessages;
import org.eclipse.wst.jsdt.internal.ui.actions.ActionUtil;
import org.eclipse.wst.jsdt.internal.ui.actions.SelectionConverter;
import org.eclipse.wst.jsdt.internal.ui.actions.WorkbenchRunnableAdapter;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.CompilationUnitEditor;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.EditorUtility;
import org.eclipse.wst.jsdt.internal.ui.util.ElementValidator;
import org.eclipse.wst.jsdt.internal.ui.util.ExceptionHandler;
import org.eclipse.wst.jsdt.ui.JavaUI;
import org.eclipse.wst.jsdt.ui.actions.SelectionDispatchAction;

public class AddJavaDocStubAction
extends SelectionDispatchAction {
    private CompilationUnitEditor fEditor;

    public AddJavaDocStubAction(IWorkbenchSite iWorkbenchSite) {
        super(iWorkbenchSite);
        this.setText(ActionMessages.AddJavaDocStubAction_label);
        this.setDescription(ActionMessages.AddJavaDocStubAction_description);
        this.setToolTipText(ActionMessages.AddJavaDocStubAction_tooltip);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.wst.jsdt.ui.add_javadoc_stub_action");
    }

    public AddJavaDocStubAction(CompilationUnitEditor compilationUnitEditor) {
        this((IWorkbenchSite)compilationUnitEditor.getEditorSite());
        this.fEditor = compilationUnitEditor;
        this.setEnabled(this.checkEnabledEditor());
    }

    public void selectionChanged(IStructuredSelection iStructuredSelection) {
        IMember[] iMemberArray = this.getSelectedMembers(iStructuredSelection);
        this.setEnabled(iMemberArray != null && iMemberArray.length > 0);
    }

    public void run(IStructuredSelection iStructuredSelection) {
        IMember[] iMemberArray = this.getSelectedMembers(iStructuredSelection);
        if (iMemberArray == null || iMemberArray.length == 0) {
            return;
        }
        try {
            ICompilationUnit iCompilationUnit = iMemberArray[0].getCompilationUnit();
            if (!ActionUtil.isEditable(this.getShell(), (IJavaElement)iCompilationUnit)) {
                return;
            }
            IEditorPart iEditorPart = JavaUI.openInEditor((IJavaElement)iCompilationUnit);
            if (ElementValidator.check((IJavaElement[])iMemberArray, this.getShell(), this.getDialogTitle(), false)) {
                this.run(iCompilationUnit, iMemberArray);
            }
            JavaModelUtil.reconcile(iCompilationUnit);
            EditorUtility.revealInEditor(iEditorPart, (IJavaElement)iMemberArray[0]);
        }
        catch (CoreException coreException) {
            ExceptionHandler.handle(coreException, this.getShell(), this.getDialogTitle(), ActionMessages.AddJavaDocStubsAction_error_actionFailed);
        }
    }

    public void selectionChanged(ITextSelection iTextSelection) {
    }

    private boolean checkEnabledEditor() {
        return this.fEditor != null && SelectionConverter.canOperateOn(this.fEditor);
    }

    public void run(ITextSelection iTextSelection) {
        try {
            int n;
            IJavaElement iJavaElement = SelectionConverter.getElementAtOffset(this.fEditor);
            if (!ActionUtil.isEditable(this.fEditor, this.getShell(), iJavaElement)) {
                return;
            }
            int n2 = n = iJavaElement != null ? iJavaElement.getElementType() : -1;
            if (n != 9 && n != 7 && n != 8 && (iJavaElement = SelectionConverter.getTypeAtOffset(this.fEditor)) == null) {
                MessageDialog.openInformation((Shell)this.getShell(), (String)this.getDialogTitle(), (String)ActionMessages.AddJavaDocStubsAction_not_applicable);
                return;
            }
            IMember[] iMemberArray = new IMember[]{(IMember)iJavaElement};
            if (ElementValidator.checkValidateEdit((IJavaElement[])iMemberArray, this.getShell(), this.getDialogTitle())) {
                this.run(iMemberArray[0].getCompilationUnit(), iMemberArray);
            }
        }
        catch (CoreException coreException) {
            ExceptionHandler.handle(coreException, this.getShell(), this.getDialogTitle(), ActionMessages.AddJavaDocStubsAction_error_actionFailed);
        }
    }

    public void run(ICompilationUnit iCompilationUnit, IMember[] iMemberArray) {
        try {
            AddJavaDocStubOperation addJavaDocStubOperation = new AddJavaDocStubOperation(iMemberArray);
            PlatformUI.getWorkbench().getProgressService().runInUI((IRunnableContext)PlatformUI.getWorkbench().getProgressService(), (IRunnableWithProgress)new WorkbenchRunnableAdapter(addJavaDocStubOperation, addJavaDocStubOperation.getScheduleRule()), addJavaDocStubOperation.getScheduleRule());
        }
        catch (InvocationTargetException invocationTargetException) {
            ExceptionHandler.handle(invocationTargetException, this.getShell(), this.getDialogTitle(), ActionMessages.AddJavaDocStubsAction_error_actionFailed);
        }
        catch (InterruptedException interruptedException) {}
    }

    private IMember[] getSelectedMembers(IStructuredSelection iStructuredSelection) {
        List list = iStructuredSelection.toList();
        int n = list.size();
        if (n > 0) {
            IMember[] iMemberArray = new IMember[n];
            ICompilationUnit iCompilationUnit = null;
            int n2 = 0;
            while (n2 < n) {
                IMember iMember;
                Object e = list.get(n2);
                if (e instanceof IMethod || e instanceof IType || e instanceof IField) {
                    iMember = (IMember)e;
                    if (!iMember.exists()) {
                        return null;
                    }
                    if (n2 == 0 ? (iCompilationUnit = iMember.getCompilationUnit()) == null : !iCompilationUnit.equals(iMember.getCompilationUnit())) {
                        return null;
                    }
                    if (iMember instanceof IType && iMember.getElementName().length() == 0) {
                        return null;
                    }
                } else {
                    return null;
                }
                iMemberArray[n2] = iMember;
                ++n2;
            }
            return iMemberArray;
        }
        return null;
    }

    private String getDialogTitle() {
        return ActionMessages.AddJavaDocStubsAction_error_dialogTitle;
    }
}

