/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.ui.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.jsdt.core.IClasspathEntry;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.JavaCore;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.internal.corext.util.JavaModelUtil;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.actions.ActionMessages;
import org.eclipse.wst.jsdt.internal.ui.actions.WorkbenchRunnableAdapter;
import org.eclipse.wst.jsdt.internal.ui.util.ExceptionHandler;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.ArchiveFileFilter;
import org.eclipse.wst.jsdt.ui.actions.SelectionDispatchAction;

public class AddToClasspathAction
extends SelectionDispatchAction {
    static /* synthetic */ Class class$0;

    public AddToClasspathAction(IWorkbenchSite iWorkbenchSite) {
        super(iWorkbenchSite);
        this.setText(ActionMessages.AddToClasspathAction_label);
        this.setToolTipText(ActionMessages.AddToClasspathAction_toolTip);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.wst.jsdt.ui.addjtoclasspath_action_context");
    }

    public void selectionChanged(IStructuredSelection iStructuredSelection) {
        try {
            this.setEnabled(AddToClasspathAction.checkEnabled(iStructuredSelection));
        }
        catch (JavaModelException javaModelException) {
            if (JavaModelUtil.isExceptionToBeLogged((CoreException)((Object)javaModelException))) {
                JavaPlugin.log(javaModelException);
            }
            this.setEnabled(false);
        }
    }

    private static boolean checkEnabled(IStructuredSelection iStructuredSelection) throws JavaModelException {
        if (iStructuredSelection.isEmpty()) {
            return false;
        }
        Iterator iterator = iStructuredSelection.iterator();
        while (iterator.hasNext()) {
            if (AddToClasspathAction.canBeAddedToBuildPath(iterator.next())) continue;
            return false;
        }
        return true;
    }

    private static boolean canBeAddedToBuildPath(Object object) throws JavaModelException {
        return object instanceof IAdaptable && AddToClasspathAction.getCandidate((IAdaptable)object) != null;
    }

    private static IFile getCandidate(IAdaptable iAdaptable) throws JavaModelException {
        IResource iResource;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.core.resources.IResource");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (!((iResource = (IResource)iAdaptable.getAdapter((Class)clazz)) instanceof IFile) || !ArchiveFileFilter.isArchivePath(iResource.getFullPath())) {
            return null;
        }
        IJavaProject iJavaProject = JavaCore.create((IProject)iResource.getProject());
        if (iJavaProject != null && iJavaProject.exists() && iJavaProject.findPackageFragmentRoot(iResource.getFullPath()) == null) {
            return (IFile)iResource;
        }
        return null;
    }

    public void run(IStructuredSelection iStructuredSelection) {
        try {
            final IFile[] iFileArray = AddToClasspathAction.getJARFiles(iStructuredSelection);
            IWorkspaceRunnable iWorkspaceRunnable = new IWorkspaceRunnable(){

                public void run(IProgressMonitor iProgressMonitor) throws CoreException {
                    iProgressMonitor.beginTask(ActionMessages.AddToClasspathAction_progressMessage, iFileArray.length);
                    int n = 0;
                    while (n < iFileArray.length) {
                        iProgressMonitor.subTask(iFileArray[n].getFullPath().toString());
                        IJavaProject iJavaProject = JavaCore.create((IProject)iFileArray[n].getProject());
                        this.addToClassPath(iJavaProject, iFileArray[n].getFullPath(), (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
                        ++n;
                    }
                }

                private void addToClassPath(IJavaProject iJavaProject, IPath iPath, IProgressMonitor iProgressMonitor) throws JavaModelException {
                    if (iProgressMonitor.isCanceled()) {
                        throw new OperationCanceledException();
                    }
                    IClasspathEntry[] iClasspathEntryArray = iJavaProject.getRawClasspath();
                    IClasspathEntry[] iClasspathEntryArray2 = new IClasspathEntry[iClasspathEntryArray.length + 1];
                    System.arraycopy(iClasspathEntryArray, 0, iClasspathEntryArray2, 0, iClasspathEntryArray.length);
                    iClasspathEntryArray2[iClasspathEntryArray.length] = JavaCore.newLibraryEntry((IPath)iPath, null, null, (boolean)false);
                    iJavaProject.setRawClasspath(iClasspathEntryArray2, iProgressMonitor);
                }
            };
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().run(true, true, (IRunnableWithProgress)new WorkbenchRunnableAdapter(iWorkspaceRunnable));
        }
        catch (InvocationTargetException invocationTargetException) {
            ExceptionHandler.handle(invocationTargetException, this.getShell(), ActionMessages.AddToClasspathAction_error_title, ActionMessages.AddToClasspathAction_error_message);
        }
        catch (JavaModelException javaModelException) {
            ExceptionHandler.handle((CoreException)((Object)javaModelException), this.getShell(), ActionMessages.AddToClasspathAction_error_title, ActionMessages.AddToClasspathAction_error_message);
        }
        catch (InterruptedException interruptedException) {}
    }

    private static IFile[] getJARFiles(IStructuredSelection iStructuredSelection) throws JavaModelException {
        ArrayList<IFile> arrayList = new ArrayList<IFile>();
        Iterator iterator = iStructuredSelection.iterator();
        while (iterator.hasNext()) {
            IFile iFile;
            Object e = iterator.next();
            if (!(e instanceof IAdaptable) || (iFile = AddToClasspathAction.getCandidate((IAdaptable)e)) == null) continue;
            arrayList.add(iFile);
        }
        return arrayList.toArray(new IFile[arrayList.size()]);
    }
}

