/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.ui.actions;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.ISourceRange;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringAvailabilityTester;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringExecutionStarter;
import org.eclipse.wst.jsdt.internal.corext.util.JavaModelUtil;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.actions.ActionUtil;
import org.eclipse.wst.jsdt.internal.ui.actions.SelectionConverter;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.JavaTextSelection;
import org.eclipse.wst.jsdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.wst.jsdt.internal.ui.util.ExceptionHandler;
import org.eclipse.wst.jsdt.ui.actions.SelectionDispatchAction;

public class ConvertAnonymousToNestedAction
extends SelectionDispatchAction {
    private final JavaEditor fEditor;

    public ConvertAnonymousToNestedAction(JavaEditor javaEditor) {
        super((IWorkbenchSite)javaEditor.getEditorSite());
        this.setText(RefactoringMessages.ConvertAnonymousToNestedAction_Convert_Anonymous);
        this.fEditor = javaEditor;
        this.setEnabled(SelectionConverter.getInputAsCompilationUnit(this.fEditor) != null);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.wst.jsdt.ui.convert_anonymous_to_nested_action");
    }

    public ConvertAnonymousToNestedAction(IWorkbenchSite iWorkbenchSite) {
        super(iWorkbenchSite);
        this.fEditor = null;
        this.setText(RefactoringMessages.ConvertAnonymousToNestedAction_Convert_Anonymous);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.wst.jsdt.ui.convert_anonymous_to_nested_action");
    }

    public void selectionChanged(IStructuredSelection iStructuredSelection) {
        try {
            this.setEnabled(RefactoringAvailabilityTester.isConvertAnonymousAvailable(iStructuredSelection));
        }
        catch (JavaModelException javaModelException) {
            if (JavaModelUtil.isExceptionToBeLogged((CoreException)((Object)javaModelException))) {
                JavaPlugin.log(javaModelException);
            }
            this.setEnabled(false);
        }
    }

    public void run(IStructuredSelection iStructuredSelection) {
        IType iType = this.getElement(iStructuredSelection);
        if (iType == null) {
            return;
        }
        try {
            ISourceRange iSourceRange = iType.getNameRange();
            this.run(iType.getCompilationUnit(), iSourceRange.getOffset(), iSourceRange.getLength());
        }
        catch (JavaModelException javaModelException) {
            ExceptionHandler.handle((CoreException)((Object)javaModelException), RefactoringMessages.ConvertAnonymousToNestedAction_dialog_title, RefactoringMessages.NewTextRefactoringAction_exception);
        }
    }

    private IType getElement(IStructuredSelection iStructuredSelection) {
        if (iStructuredSelection.size() != 1) {
            return null;
        }
        Object object = iStructuredSelection.getFirstElement();
        if (!(object instanceof IType)) {
            return null;
        }
        IType iType = (IType)object;
        try {
            if (iType.isAnonymous()) {
                return iType;
            }
        }
        catch (JavaModelException javaModelException) {}
        return null;
    }

    public void run(ITextSelection iTextSelection) {
        try {
            this.run(SelectionConverter.getInputAsCompilationUnit(this.fEditor), iTextSelection.getOffset(), iTextSelection.getLength());
        }
        catch (JavaModelException javaModelException) {
            ExceptionHandler.handle((CoreException)((Object)javaModelException), RefactoringMessages.ConvertAnonymousToNestedAction_dialog_title, RefactoringMessages.NewTextRefactoringAction_exception);
        }
    }

    public void selectionChanged(ITextSelection iTextSelection) {
        this.setEnabled(this.fEditor != null && SelectionConverter.getInputAsCompilationUnit(this.fEditor) != null);
    }

    public void selectionChanged(JavaTextSelection javaTextSelection) {
        try {
            this.setEnabled(RefactoringAvailabilityTester.isConvertAnonymousAvailable(javaTextSelection));
        }
        catch (JavaModelException javaModelException) {
            this.setEnabled(false);
        }
    }

    private void run(ICompilationUnit iCompilationUnit, int n, int n2) throws JavaModelException {
        if (!ActionUtil.isEditable(this.fEditor, this.getShell(), (IJavaElement)iCompilationUnit)) {
            return;
        }
        RefactoringExecutionStarter.startConvertAnonymousRefactoring(iCompilationUnit, n, n2, this.getShell());
    }
}

