/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.ui.actions;

import java.util.Iterator;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.wst.jsdt.internal.ui.search.SearchMessages;
import org.eclipse.wst.jsdt.internal.ui.search.SearchUtil;
import org.eclipse.wst.jsdt.ui.actions.FindAction;
import org.eclipse.wst.jsdt.ui.actions.FindDeclarationsAction;
import org.eclipse.wst.jsdt.ui.actions.FindDeclarationsInHierarchyAction;
import org.eclipse.wst.jsdt.ui.actions.FindDeclarationsInProjectAction;
import org.eclipse.wst.jsdt.ui.actions.FindDeclarationsInWorkingSetAction;
import org.eclipse.wst.jsdt.ui.actions.SelectionDispatchAction;
import org.eclipse.wst.jsdt.ui.actions.WorkingSetFindAction;

public class DeclarationsSearchGroup
extends ActionGroup {
    private static final String MENU_TEXT = SearchMessages.group_declarations;
    private IWorkbenchSite fSite;
    private JavaEditor fEditor;
    private IActionBars fActionBars;
    private String fGroupId;
    private FindDeclarationsAction fFindDeclarationsAction;
    private FindDeclarationsInProjectAction fFindDeclarationsInProjectAction;
    private FindDeclarationsInWorkingSetAction fFindDeclarationsInWorkingSetAction;
    private FindDeclarationsInHierarchyAction fFindDeclarationsInHierarchyAction;

    public DeclarationsSearchGroup(IWorkbenchSite iWorkbenchSite) {
        this.fSite = iWorkbenchSite;
        this.fGroupId = "group.search";
        this.fFindDeclarationsAction = new FindDeclarationsAction(iWorkbenchSite);
        this.fFindDeclarationsAction.setActionDefinitionId("org.eclipse.wst.jsdt.ui.edit.text.java.search.declarations.in.workspace");
        this.fFindDeclarationsInProjectAction = new FindDeclarationsInProjectAction(iWorkbenchSite);
        this.fFindDeclarationsInProjectAction.setActionDefinitionId("org.eclipse.wst.jsdt.ui.edit.text.java.search.declarations.in.project");
        this.fFindDeclarationsInHierarchyAction = new FindDeclarationsInHierarchyAction(iWorkbenchSite);
        this.fFindDeclarationsInHierarchyAction.setActionDefinitionId("org.eclipse.wst.jsdt.ui.edit.text.java.search.declarations.in.hierarchy");
        this.fFindDeclarationsInWorkingSetAction = new FindDeclarationsInWorkingSetAction(iWorkbenchSite);
        this.fFindDeclarationsInWorkingSetAction.setActionDefinitionId("org.eclipse.wst.jsdt.ui.edit.text.java.search.declarations.in.working.set");
        ISelectionProvider iSelectionProvider = this.fSite.getSelectionProvider();
        ISelection iSelection = iSelectionProvider.getSelection();
        this.registerAction(this.fFindDeclarationsAction, iSelectionProvider, iSelection);
        this.registerAction(this.fFindDeclarationsInProjectAction, iSelectionProvider, iSelection);
        this.registerAction(this.fFindDeclarationsInHierarchyAction, iSelectionProvider, iSelection);
        this.registerAction(this.fFindDeclarationsInWorkingSetAction, iSelectionProvider, iSelection);
    }

    public DeclarationsSearchGroup(JavaEditor javaEditor) {
        Assert.isNotNull((Object)javaEditor);
        this.fEditor = javaEditor;
        this.fSite = this.fEditor.getSite();
        this.fGroupId = "group.find";
        this.fFindDeclarationsAction = new FindDeclarationsAction(this.fEditor);
        this.fFindDeclarationsAction.setActionDefinitionId("org.eclipse.wst.jsdt.ui.edit.text.java.search.declarations.in.workspace");
        this.fEditor.setAction("SearchDeclarationsInWorkspace", (IAction)this.fFindDeclarationsAction);
        this.fFindDeclarationsInProjectAction = new FindDeclarationsInProjectAction(this.fEditor);
        this.fFindDeclarationsInProjectAction.setActionDefinitionId("org.eclipse.wst.jsdt.ui.edit.text.java.search.declarations.in.project");
        this.fEditor.setAction("SearchDeclarationsInProjects", (IAction)this.fFindDeclarationsInProjectAction);
        this.fFindDeclarationsInHierarchyAction = new FindDeclarationsInHierarchyAction(this.fEditor);
        this.fFindDeclarationsInHierarchyAction.setActionDefinitionId("org.eclipse.wst.jsdt.ui.edit.text.java.search.declarations.in.hierarchy");
        this.fEditor.setAction("SearchDeclarationsInHierarchy", (IAction)this.fFindDeclarationsInHierarchyAction);
        this.fFindDeclarationsInWorkingSetAction = new FindDeclarationsInWorkingSetAction(this.fEditor);
        this.fFindDeclarationsInWorkingSetAction.setActionDefinitionId("org.eclipse.wst.jsdt.ui.edit.text.java.search.declarations.in.working.set");
        this.fEditor.setAction("SearchDeclarationsInWorkingSet", (IAction)this.fFindDeclarationsInWorkingSetAction);
    }

    private void registerAction(SelectionDispatchAction selectionDispatchAction, ISelectionProvider iSelectionProvider, ISelection iSelection) {
        selectionDispatchAction.update(iSelection);
        iSelectionProvider.addSelectionChangedListener((ISelectionChangedListener)selectionDispatchAction);
    }

    public void fillActionBars(IActionBars iActionBars) {
        Assert.isNotNull((Object)iActionBars);
        super.fillActionBars(iActionBars);
        this.fActionBars = iActionBars;
        this.updateGlobalActionHandlers();
    }

    private void addAction(IAction iAction, IMenuManager iMenuManager) {
        if (iAction.isEnabled()) {
            iMenuManager.add(iAction);
        }
    }

    private void addWorkingSetAction(IWorkingSet[] iWorkingSetArray, IMenuManager iMenuManager) {
        WorkingSetFindAction workingSetFindAction = this.fEditor != null ? new WorkingSetFindAction(this.fEditor, (FindAction)new FindDeclarationsInWorkingSetAction(this.fEditor, iWorkingSetArray), SearchUtil.toString(iWorkingSetArray)) : new WorkingSetFindAction(this.fSite, (FindAction)new FindDeclarationsInWorkingSetAction(this.fSite, iWorkingSetArray), SearchUtil.toString(iWorkingSetArray));
        workingSetFindAction.update(this.getContext().getSelection());
        this.addAction((IAction)workingSetFindAction, iMenuManager);
    }

    public void fillContextMenu(IMenuManager iMenuManager) {
        MenuManager menuManager = new MenuManager(MENU_TEXT, "group.search");
        this.addAction((IAction)this.fFindDeclarationsAction, (IMenuManager)menuManager);
        this.addAction((IAction)this.fFindDeclarationsInProjectAction, (IMenuManager)menuManager);
        this.addAction((IAction)this.fFindDeclarationsInHierarchyAction, (IMenuManager)menuManager);
        menuManager.add((IContributionItem)new Separator());
        Iterator iterator = SearchUtil.getLRUWorkingSets().sortedIterator();
        while (iterator.hasNext()) {
            this.addWorkingSetAction((IWorkingSet[])iterator.next(), (IMenuManager)menuManager);
        }
        this.addAction((IAction)this.fFindDeclarationsInWorkingSetAction, (IMenuManager)menuManager);
        if (!menuManager.isEmpty()) {
            iMenuManager.appendToGroup(this.fGroupId, (IContributionItem)menuManager);
        }
    }

    public void dispose() {
        ISelectionProvider iSelectionProvider = this.fSite.getSelectionProvider();
        if (iSelectionProvider != null) {
            this.disposeAction(this.fFindDeclarationsAction, iSelectionProvider);
            this.disposeAction(this.fFindDeclarationsInProjectAction, iSelectionProvider);
            this.disposeAction(this.fFindDeclarationsInHierarchyAction, iSelectionProvider);
            this.disposeAction(this.fFindDeclarationsInWorkingSetAction, iSelectionProvider);
        }
        this.fFindDeclarationsAction = null;
        this.fFindDeclarationsInProjectAction = null;
        this.fFindDeclarationsInHierarchyAction = null;
        this.fFindDeclarationsInWorkingSetAction = null;
        this.updateGlobalActionHandlers();
        super.dispose();
    }

    private void updateGlobalActionHandlers() {
        if (this.fActionBars != null) {
            this.fActionBars.setGlobalActionHandler("org.eclipse.wst.jsdt.ui.actions.DeclarationsInWorkspace", (IAction)this.fFindDeclarationsAction);
            this.fActionBars.setGlobalActionHandler("org.eclipse.wst.jsdt.ui.actions.DeclarationsInProject", (IAction)this.fFindDeclarationsInProjectAction);
            this.fActionBars.setGlobalActionHandler("org.eclipse.wst.jsdt.ui.actions.DeclarationsInHierarchy", (IAction)this.fFindDeclarationsInHierarchyAction);
            this.fActionBars.setGlobalActionHandler("org.eclipse.wst.jsdt.ui.actions.DeclarationsInWorkingSet", (IAction)this.fFindDeclarationsInWorkingSetAction);
        }
    }

    private void disposeAction(ISelectionChangedListener iSelectionChangedListener, ISelectionProvider iSelectionProvider) {
        if (iSelectionChangedListener != null) {
            iSelectionProvider.removeSelectionChangedListener(iSelectionChangedListener);
        }
    }
}

