/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.ui.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.text.DocumentRewriteSession;
import org.eclipse.jface.text.DocumentRewriteSessionType;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension;
import org.eclipse.jface.text.IDocumentExtension4;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.formatter.IFormattingContext;
import org.eclipse.jface.text.formatter.IFormattingStrategy;
import org.eclipse.jface.text.formatter.MultiPassContentFormatter;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.internal.corext.util.JavaModelUtil;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.corext.util.Resources;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.actions.ActionMessages;
import org.eclipse.wst.jsdt.internal.ui.actions.WorkbenchRunnableAdapter;
import org.eclipse.wst.jsdt.internal.ui.browsing.LogicalPackage;
import org.eclipse.wst.jsdt.internal.ui.dialogs.OptionalMessageDialog;
import org.eclipse.wst.jsdt.internal.ui.text.comment.CommentFormattingContext;
import org.eclipse.wst.jsdt.internal.ui.text.comment.CommentFormattingStrategy;
import org.eclipse.wst.jsdt.internal.ui.text.java.JavaFormattingStrategy;
import org.eclipse.wst.jsdt.internal.ui.util.ExceptionHandler;
import org.eclipse.wst.jsdt.ui.JavaUI;
import org.eclipse.wst.jsdt.ui.actions.SelectionDispatchAction;

public class FormatAllAction
extends SelectionDispatchAction {
    private DocumentRewriteSession fRewriteSession;

    public FormatAllAction(IWorkbenchSite iWorkbenchSite) {
        super(iWorkbenchSite);
        this.setText(ActionMessages.FormatAllAction_label);
        this.setToolTipText(ActionMessages.FormatAllAction_tooltip);
        this.setDescription(ActionMessages.FormatAllAction_description);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.wst.jsdt.ui.format_all_action");
    }

    public void selectionChanged(ITextSelection iTextSelection) {
    }

    public void selectionChanged(IStructuredSelection iStructuredSelection) {
        this.setEnabled(this.isEnabled(iStructuredSelection));
    }

    private ICompilationUnit[] getCompilationUnits(IStructuredSelection iStructuredSelection) {
        HashSet<Object> hashSet = new HashSet<Object>();
        Object[] objectArray = iStructuredSelection.toArray();
        int n = 0;
        while (n < objectArray.length) {
            block16: {
                try {
                    IPackageFragment[] iPackageFragmentArray;
                    if (objectArray[n] instanceof IJavaElement) {
                        iPackageFragmentArray = (IPackageFragment[])objectArray[n];
                        if (!iPackageFragmentArray.exists()) break block16;
                        switch (iPackageFragmentArray.getElementType()) {
                            case 7: {
                                if (iPackageFragmentArray.getParent().getElementType() == 5) {
                                    hashSet.add(iPackageFragmentArray.getParent());
                                    break;
                                }
                                break block16;
                            }
                            case 5: {
                                hashSet.add(iPackageFragmentArray);
                                break;
                            }
                            case 4: {
                                this.collectCompilationUnits((IPackageFragment)iPackageFragmentArray, hashSet);
                                break;
                            }
                            case 3: {
                                this.collectCompilationUnits((IPackageFragmentRoot)iPackageFragmentArray, hashSet);
                                break;
                            }
                            case 2: {
                                IPackageFragmentRoot[] iPackageFragmentRootArray = ((IJavaProject)iPackageFragmentArray).getPackageFragmentRoots();
                                int n2 = 0;
                                while (n2 < iPackageFragmentRootArray.length) {
                                    this.collectCompilationUnits(iPackageFragmentRootArray[n2], hashSet);
                                    ++n2;
                                }
                                break block1;
                            }
                        }
                        break block16;
                    }
                    if (objectArray[n] instanceof LogicalPackage) {
                        iPackageFragmentArray = ((LogicalPackage)((Object)objectArray[n])).getFragments();
                        int n3 = 0;
                        while (n3 < iPackageFragmentArray.length) {
                            IPackageFragment iPackageFragment = iPackageFragmentArray[n3];
                            if (iPackageFragment.exists()) {
                                this.collectCompilationUnits(iPackageFragment, hashSet);
                            }
                            ++n3;
                        }
                    }
                }
                catch (JavaModelException javaModelException) {
                    JavaPlugin.log(javaModelException);
                }
            }
            ++n;
        }
        return hashSet.toArray(new ICompilationUnit[hashSet.size()]);
    }

    private void collectCompilationUnits(IPackageFragment iPackageFragment, Collection collection) throws JavaModelException {
        collection.addAll(Arrays.asList(iPackageFragment.getCompilationUnits()));
    }

    private void collectCompilationUnits(IPackageFragmentRoot iPackageFragmentRoot, Collection collection) throws JavaModelException {
        if (iPackageFragmentRoot.getKind() == 1) {
            IJavaElement[] iJavaElementArray = iPackageFragmentRoot.getChildren();
            int n = 0;
            while (n < iJavaElementArray.length) {
                this.collectCompilationUnits((IPackageFragment)iJavaElementArray[n], collection);
                ++n;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isEnabled(IStructuredSelection iStructuredSelection) {
        Object[] objectArray = iStructuredSelection.toArray();
        int n = 0;
        while (n < objectArray.length) {
            block12: {
                try {
                    if (objectArray[n] instanceof IJavaElement) {
                        IJavaElement iJavaElement = (IJavaElement)objectArray[n];
                        if (iJavaElement.exists()) {
                            switch (iJavaElement.getElementType()) {
                                case 7: {
                                    return iJavaElement.getParent().getElementType() == 5;
                                }
                                case 5: {
                                    return true;
                                }
                                case 3: 
                                case 4: {
                                    IPackageFragmentRoot iPackageFragmentRoot = (IPackageFragmentRoot)iJavaElement.getAncestor(3);
                                    return iPackageFragmentRoot.getKind() == 1;
                                }
                                case 2: {
                                    return true;
                                }
                            }
                        }
                        break block12;
                    }
                    if (objectArray[n] instanceof LogicalPackage) {
                        return true;
                    }
                }
                catch (JavaModelException javaModelException) {
                    if (!JavaModelUtil.isExceptionToBeLogged((CoreException)((Object)javaModelException))) break block12;
                    JavaPlugin.log(javaModelException);
                }
            }
            ++n;
        }
        return false;
    }

    public void run(ITextSelection iTextSelection) {
    }

    public void run(IStructuredSelection iStructuredSelection) {
        ICompilationUnit[] iCompilationUnitArray = this.getCompilationUnits(iStructuredSelection);
        if (iCompilationUnitArray.length == 0) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)ActionMessages.FormatAllAction_EmptySelection_title, (String)ActionMessages.FormatAllAction_EmptySelection_description);
            return;
        }
        try {
            if (iCompilationUnitArray.length == 1) {
                JavaUI.openInEditor((IJavaElement)iCompilationUnitArray[0]);
            } else {
                int n = OptionalMessageDialog.open("FormatAll", this.getShell(), ActionMessages.FormatAllAction_noundo_title, null, ActionMessages.FormatAllAction_noundo_message, 4, new String[]{IDialogConstants.OK_LABEL, IDialogConstants.CANCEL_LABEL}, 0);
                if (n != 1025 && n != 0) {
                    return;
                }
            }
        }
        catch (CoreException coreException) {
            ExceptionHandler.handle(coreException, this.getShell(), ActionMessages.FormatAllAction_error_title, ActionMessages.FormatAllAction_error_message);
        }
        this.runOnMultiple(iCompilationUnitArray);
    }

    private IResource[] getResources(ICompilationUnit[] iCompilationUnitArray) {
        IResource[] iResourceArray = new IResource[iCompilationUnitArray.length];
        int n = 0;
        while (n < iResourceArray.length) {
            iResourceArray[n] = iCompilationUnitArray[n].getResource();
            ++n;
        }
        return iResourceArray;
    }

    public void runOnMultiple(final ICompilationUnit[] iCompilationUnitArray) {
        try {
            final MultiStatus multiStatus = new MultiStatus("org.eclipse.wst.jsdt.ui", 0, ActionMessages.FormatAllAction_status_description, null);
            IStatus iStatus = Resources.makeCommittable(this.getResources(iCompilationUnitArray), (Object)this.getShell());
            if (iStatus.matches(8)) {
                return;
            }
            multiStatus.merge(iStatus);
            if (!multiStatus.matches(4)) {
                PlatformUI.getWorkbench().getProgressService().run(true, true, (IRunnableWithProgress)new WorkbenchRunnableAdapter(new IWorkspaceRunnable(){

                    public void run(IProgressMonitor iProgressMonitor) {
                        FormatAllAction.this.doRunOnMultiple(iCompilationUnitArray, multiStatus, iProgressMonitor);
                    }
                }));
            }
            if (!multiStatus.isOK()) {
                String string = ActionMessages.FormatAllAction_multi_status_title;
                ErrorDialog.openError((Shell)this.getShell(), (String)string, null, (IStatus)multiStatus);
            }
        }
        catch (InvocationTargetException invocationTargetException) {
            ExceptionHandler.handle(invocationTargetException, this.getShell(), ActionMessages.FormatAllAction_error_title, ActionMessages.FormatAllAction_error_message);
        }
        catch (InterruptedException interruptedException) {}
    }

    private static Map getFomatterSettings(IJavaProject iJavaProject) {
        return new HashMap(iJavaProject.getOptions(true));
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void doFormat(IDocument iDocument, Map map) {
        CommentFormattingContext commentFormattingContext = new CommentFormattingContext();
        try {
            commentFormattingContext.setProperty("formatting.context.preferences", map);
            commentFormattingContext.setProperty("formatting.context.document", true);
            MultiPassContentFormatter multiPassContentFormatter = new MultiPassContentFormatter("___java_partitioning", "__dftl_partition_content_type");
            multiPassContentFormatter.setMasterStrategy((IFormattingStrategy)new JavaFormattingStrategy());
            multiPassContentFormatter.setSlaveStrategy((IFormattingStrategy)new CommentFormattingStrategy(), "__java_javadoc");
            multiPassContentFormatter.setSlaveStrategy((IFormattingStrategy)new CommentFormattingStrategy(), "__java_singleline_comment");
            multiPassContentFormatter.setSlaveStrategy((IFormattingStrategy)new CommentFormattingStrategy(), "__java_multiline_comment");
            try {
                this.startSequentialRewriteMode(iDocument);
                multiPassContentFormatter.format(iDocument, (IFormattingContext)commentFormattingContext);
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                this.stopSequentialRewriteMode(iDocument);
                throw throwable;
            }
            {
                Object var5_7 = null;
                this.stopSequentialRewriteMode(iDocument);
            }
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            commentFormattingContext.dispose();
            throw throwable;
        }
        {
            Object var7_10 = null;
        }
        commentFormattingContext.dispose();
    }

    private void startSequentialRewriteMode(IDocument iDocument) {
        if (iDocument instanceof IDocumentExtension4) {
            IDocumentExtension4 iDocumentExtension4 = (IDocumentExtension4)iDocument;
            this.fRewriteSession = iDocumentExtension4.startRewriteSession(DocumentRewriteSessionType.SEQUENTIAL);
        } else if (iDocument instanceof IDocumentExtension) {
            IDocumentExtension iDocumentExtension = (IDocumentExtension)iDocument;
            iDocumentExtension.startSequentialRewrite(false);
        }
    }

    private void stopSequentialRewriteMode(IDocument iDocument) {
        if (iDocument instanceof IDocumentExtension4) {
            IDocumentExtension4 iDocumentExtension4 = (IDocumentExtension4)iDocument;
            iDocumentExtension4.stopRewriteSession(this.fRewriteSession);
        } else if (iDocument instanceof IDocumentExtension) {
            IDocumentExtension iDocumentExtension = (IDocumentExtension)iDocument;
            iDocumentExtension.stopSequentialRewrite();
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void doRunOnMultiple(ICompilationUnit[] iCompilationUnitArray, MultiStatus multiStatus, IProgressMonitor iProgressMonitor) throws OperationCanceledException {
        if (iProgressMonitor == null) {
            iProgressMonitor = new NullProgressMonitor();
        }
        iProgressMonitor.setTaskName(ActionMessages.FormatAllAction_operation_description);
        iProgressMonitor.beginTask("", iCompilationUnitArray.length * 4);
        try {
            Map map = null;
            IJavaProject iJavaProject = null;
            int n = 0;
            while (n < iCompilationUnitArray.length) {
                block15: {
                    String string;
                    Object object;
                    IPath iPath;
                    block14: {
                        ICompilationUnit iCompilationUnit = iCompilationUnitArray[n];
                        iPath = iCompilationUnit.getPath();
                        if (iJavaProject == null || !iJavaProject.equals(iCompilationUnit.getJavaProject())) {
                            iJavaProject = iCompilationUnit.getJavaProject();
                            map = FormatAllAction.getFomatterSettings(iJavaProject);
                        }
                        if (iProgressMonitor.isCanceled()) {
                            throw new OperationCanceledException();
                        }
                        if (!iCompilationUnit.getResource().getResourceAttributes().isReadOnly()) break block14;
                        object = Messages.format(ActionMessages.FormatAllAction_read_only_skipped, iPath.toString());
                        multiStatus.add((IStatus)new Status(2, "org.eclipse.wst.jsdt.ui", 2, (String)object, null));
                        break block15;
                    }
                    object = FileBuffers.getTextFileBufferManager();
                    try {
                        try {
                            object.connect(iPath, LocationKind.IFILE, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
                            iProgressMonitor.subTask(iPath.makeRelative().toString());
                            ITextFileBuffer iTextFileBuffer = object.getTextFileBuffer(iPath, LocationKind.IFILE);
                            this.formatCompilationUnit(iTextFileBuffer, map);
                            if (iTextFileBuffer.isDirty() && !iTextFileBuffer.isShared()) {
                                iTextFileBuffer.commit((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 2), false);
                            } else {
                                iProgressMonitor.worked(2);
                            }
                        }
                        catch (Throwable throwable) {
                            string = null;
                            object.disconnect(iPath, LocationKind.IFILE, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
                            throw throwable;
                        }
                        {
                            string = null;
                            object.disconnect(iPath, LocationKind.IFILE, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
                        }
                    }
                    catch (CoreException coreException) {
                        string = Messages.format(ActionMessages.FormatAllAction_problem_accessing, new String[]{iPath.toString(), coreException.getLocalizedMessage()});
                        multiStatus.add((IStatus)new Status(2, "org.eclipse.wst.jsdt.ui", 2, string, (Throwable)coreException));
                    }
                }
                ++n;
            }
        }
        catch (Throwable throwable) {
            Object var13_15 = null;
            iProgressMonitor.done();
            throw throwable;
        }
        {
            Object var13_16 = null;
        }
        iProgressMonitor.done();
    }

    private void formatCompilationUnit(final ITextFileBuffer iTextFileBuffer, final Map map) {
        if (iTextFileBuffer.isShared()) {
            this.getShell().getDisplay().syncExec(new Runnable(){

                public void run() {
                    FormatAllAction.this.doFormat(iTextFileBuffer.getDocument(), map);
                }
            });
        } else {
            this.doFormat(iTextFileBuffer.getDocument(), map);
        }
    }

    public static class ObjectDelegate
    implements IObjectActionDelegate {
        private FormatAllAction fAction;

        public void setActivePart(IAction iAction, IWorkbenchPart iWorkbenchPart) {
            this.fAction = new FormatAllAction((IWorkbenchSite)iWorkbenchPart.getSite());
        }

        public void run(IAction iAction) {
            this.fAction.run();
        }

        public void selectionChanged(IAction iAction, ISelection iSelection) {
            if (this.fAction == null) {
                iAction.setEnabled(false);
            }
        }
    }
}

