/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.ui.actions;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.PerformChangeOperation;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.RefactoringStatusEntry;
import org.eclipse.ltk.ui.refactoring.RefactoringUI;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.ISourceRange;
import org.eclipse.wst.jsdt.internal.corext.refactoring.base.JavaStatusContext;
import org.eclipse.wst.jsdt.internal.corext.refactoring.surround.ISurroundWithTryCatchQuery;
import org.eclipse.wst.jsdt.internal.corext.refactoring.surround.SurroundWithTryCatchRefactoring;
import org.eclipse.wst.jsdt.internal.ui.actions.ActionUtil;
import org.eclipse.wst.jsdt.internal.ui.actions.SelectionConverter;
import org.eclipse.wst.jsdt.internal.ui.actions.WorkbenchRunnableAdapter;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.CompilationUnitEditor;
import org.eclipse.wst.jsdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.wst.jsdt.internal.ui.util.BusyIndicatorRunnableContext;
import org.eclipse.wst.jsdt.internal.ui.util.ElementValidator;
import org.eclipse.wst.jsdt.internal.ui.util.ExceptionHandler;
import org.eclipse.wst.jsdt.ui.actions.SelectionDispatchAction;

public class SurroundWithTryCatchAction
extends SelectionDispatchAction {
    private CompilationUnitEditor fEditor;

    public SurroundWithTryCatchAction(CompilationUnitEditor compilationUnitEditor) {
        super((IWorkbenchSite)compilationUnitEditor.getEditorSite());
        this.setText(RefactoringMessages.SurroundWithTryCatchAction_label);
        this.fEditor = compilationUnitEditor;
        this.setEnabled(this.fEditor != null && SelectionConverter.getInputAsCompilationUnit(this.fEditor) != null);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.wst.jsdt.ui.surround_with_try_catch_action");
    }

    public void run(ITextSelection iTextSelection) {
        if (!ActionUtil.isEditable(this.fEditor)) {
            return;
        }
        ICompilationUnit iCompilationUnit = SelectionConverter.getInputAsCompilationUnit(this.fEditor);
        if (iCompilationUnit == null || !ElementValidator.checkValidateEdit((IJavaElement)iCompilationUnit, this.getShell(), SurroundWithTryCatchAction.getDialogTitle())) {
            return;
        }
        SurroundWithTryCatchRefactoring surroundWithTryCatchRefactoring = SurroundWithTryCatchRefactoring.create(iCompilationUnit, iTextSelection, new Query(this.getShell()));
        if (surroundWithTryCatchRefactoring == null) {
            return;
        }
        try {
            RefactoringStatus refactoringStatus = surroundWithTryCatchRefactoring.checkInitialConditions((IProgressMonitor)new NullProgressMonitor());
            if (refactoringStatus.hasFatalError()) {
                RefactoringStatusEntry refactoringStatusEntry = refactoringStatus.getEntryMatchingSeverity(4);
                MessageDialog.openInformation((Shell)this.getShell(), (String)SurroundWithTryCatchAction.getDialogTitle(), (String)refactoringStatusEntry.getMessage());
                if (refactoringStatusEntry.getContext() instanceof JavaStatusContext && this.fEditor != null) {
                    JavaStatusContext javaStatusContext = (JavaStatusContext)refactoringStatusEntry.getContext();
                    ISourceRange iSourceRange = javaStatusContext.getSourceRange();
                    this.fEditor.setHighlightRange(iSourceRange.getOffset(), iSourceRange.getLength(), true);
                }
                return;
            }
            if (surroundWithTryCatchRefactoring.stopExecution()) {
                return;
            }
            Change change = surroundWithTryCatchRefactoring.createChange((IProgressMonitor)new NullProgressMonitor());
            change.initializeValidationData((IProgressMonitor)new NullProgressMonitor());
            PerformChangeOperation performChangeOperation = RefactoringUI.createUIAwareChangeOperation((Change)change);
            WorkbenchRunnableAdapter workbenchRunnableAdapter = new WorkbenchRunnableAdapter((IWorkspaceRunnable)performChangeOperation);
            PlatformUI.getWorkbench().getProgressService().runInUI((IRunnableContext)new BusyIndicatorRunnableContext(), (IRunnableWithProgress)workbenchRunnableAdapter, workbenchRunnableAdapter.getSchedulingRule());
        }
        catch (CoreException coreException) {
            ExceptionHandler.handle(coreException, SurroundWithTryCatchAction.getDialogTitle(), RefactoringMessages.SurroundWithTryCatchAction_exception);
        }
        catch (InvocationTargetException invocationTargetException) {
            ExceptionHandler.handle(invocationTargetException, SurroundWithTryCatchAction.getDialogTitle(), RefactoringMessages.SurroundWithTryCatchAction_exception);
        }
        catch (InterruptedException interruptedException) {}
    }

    public void selectionChanged(ITextSelection iTextSelection) {
        this.setEnabled(iTextSelection.getLength() > 0 && this.fEditor != null && SelectionConverter.getInputAsCompilationUnit(this.fEditor) != null);
    }

    private static String getDialogTitle() {
        return RefactoringMessages.SurroundWithTryCatchAction_dialog_title;
    }

    private static class Query
    implements ISurroundWithTryCatchQuery {
        private Shell fParent;

        public Query(Shell shell) {
            this.fParent = shell;
        }

        public boolean catchRuntimeException() {
            MessageDialog messageDialog = new MessageDialog(this, this.fParent, SurroundWithTryCatchAction.getDialogTitle(), null, RefactoringMessages.SurroundWithTryCatchAction_no_exceptions, 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, 1){
                final /* synthetic */ Query this$1;
                {
                    this.this$1 = query;
                }

                protected void createButtonsForButtonBar(Composite composite) {
                    super.createButtonsForButtonBar(composite);
                    Button button = this.getButton(1);
                    if (button != null) {
                        button.setFocus();
                    }
                }
            };
            return messageDialog.open() == 0;
        }
    }
}

