/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.ui.actions;

import java.util.Iterator;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.wst.jsdt.internal.ui.search.SearchMessages;
import org.eclipse.wst.jsdt.internal.ui.search.SearchUtil;
import org.eclipse.wst.jsdt.ui.actions.FindAction;
import org.eclipse.wst.jsdt.ui.actions.FindWriteReferencesAction;
import org.eclipse.wst.jsdt.ui.actions.FindWriteReferencesInHierarchyAction;
import org.eclipse.wst.jsdt.ui.actions.FindWriteReferencesInProjectAction;
import org.eclipse.wst.jsdt.ui.actions.FindWriteReferencesInWorkingSetAction;
import org.eclipse.wst.jsdt.ui.actions.SelectionDispatchAction;
import org.eclipse.wst.jsdt.ui.actions.WorkingSetFindAction;

public class WriteReferencesSearchGroup
extends ActionGroup {
    private static final String MENU_TEXT = SearchMessages.group_writeReferences;
    private IWorkbenchSite fSite;
    private JavaEditor fEditor;
    private IActionBars fActionBars;
    private String fGroupId;
    private FindWriteReferencesAction fFindWriteReferencesAction;
    private FindWriteReferencesInProjectAction fFindWriteReferencesInProjectAction;
    private FindWriteReferencesInHierarchyAction fFindWriteReferencesInHierarchyAction;
    private FindWriteReferencesInWorkingSetAction fFindWriteReferencesInWorkingSetAction;

    public WriteReferencesSearchGroup(IWorkbenchSite iWorkbenchSite) {
        this.fSite = iWorkbenchSite;
        this.fGroupId = "group.search";
        this.fFindWriteReferencesAction = new FindWriteReferencesAction(iWorkbenchSite);
        this.fFindWriteReferencesAction.setActionDefinitionId("org.eclipse.wst.jsdt.ui.edit.text.java.search.write.access.in.workspace");
        this.fFindWriteReferencesInProjectAction = new FindWriteReferencesInProjectAction(iWorkbenchSite);
        this.fFindWriteReferencesInProjectAction.setActionDefinitionId("org.eclipse.wst.jsdt.ui.edit.text.java.search.write.access.in.project");
        this.fFindWriteReferencesInHierarchyAction = new FindWriteReferencesInHierarchyAction(iWorkbenchSite);
        this.fFindWriteReferencesInHierarchyAction.setActionDefinitionId("org.eclipse.wst.jsdt.ui.edit.text.java.search.write.access.in.hierarchy");
        this.fFindWriteReferencesInWorkingSetAction = new FindWriteReferencesInWorkingSetAction(iWorkbenchSite);
        this.fFindWriteReferencesInWorkingSetAction.setActionDefinitionId("org.eclipse.wst.jsdt.ui.edit.text.java.search.write.access.in.working.set");
        ISelectionProvider iSelectionProvider = this.fSite.getSelectionProvider();
        ISelection iSelection = iSelectionProvider.getSelection();
        this.registerAction(this.fFindWriteReferencesAction, iSelectionProvider, iSelection);
        this.registerAction(this.fFindWriteReferencesInProjectAction, iSelectionProvider, iSelection);
        this.registerAction(this.fFindWriteReferencesInHierarchyAction, iSelectionProvider, iSelection);
        this.registerAction(this.fFindWriteReferencesInWorkingSetAction, iSelectionProvider, iSelection);
    }

    public WriteReferencesSearchGroup(JavaEditor javaEditor) {
        this.fEditor = javaEditor;
        this.fSite = this.fEditor.getSite();
        this.fGroupId = "group.find";
        this.fFindWriteReferencesAction = new FindWriteReferencesAction(this.fEditor);
        this.fFindWriteReferencesAction.setActionDefinitionId("org.eclipse.wst.jsdt.ui.edit.text.java.search.write.access.in.workspace");
        this.fEditor.setAction("SearchWriteAccessInWorkspace", (IAction)this.fFindWriteReferencesAction);
        this.fFindWriteReferencesInProjectAction = new FindWriteReferencesInProjectAction(this.fEditor);
        this.fFindWriteReferencesInProjectAction.setActionDefinitionId("org.eclipse.wst.jsdt.ui.edit.text.java.search.write.access.in.project");
        this.fEditor.setAction("SearchWriteAccessInProject", (IAction)this.fFindWriteReferencesInProjectAction);
        this.fFindWriteReferencesInHierarchyAction = new FindWriteReferencesInHierarchyAction(this.fEditor);
        this.fFindWriteReferencesInHierarchyAction.setActionDefinitionId("org.eclipse.wst.jsdt.ui.edit.text.java.search.write.access.in.hierarchy");
        this.fEditor.setAction("SearchWriteAccessInHierarchy", (IAction)this.fFindWriteReferencesInHierarchyAction);
        this.fFindWriteReferencesInWorkingSetAction = new FindWriteReferencesInWorkingSetAction(this.fEditor);
        this.fFindWriteReferencesInWorkingSetAction.setActionDefinitionId("org.eclipse.wst.jsdt.ui.edit.text.java.search.write.access.in.working.set");
        this.fEditor.setAction("SearchWriteAccessInWorkingSet", (IAction)this.fFindWriteReferencesInWorkingSetAction);
    }

    private void registerAction(SelectionDispatchAction selectionDispatchAction, ISelectionProvider iSelectionProvider, ISelection iSelection) {
        selectionDispatchAction.update(iSelection);
        iSelectionProvider.addSelectionChangedListener((ISelectionChangedListener)selectionDispatchAction);
    }

    private void addAction(IAction iAction, IMenuManager iMenuManager) {
        if (iAction.isEnabled()) {
            iMenuManager.add(iAction);
        }
    }

    private void addWorkingSetAction(IWorkingSet[] iWorkingSetArray, IMenuManager iMenuManager) {
        WorkingSetFindAction workingSetFindAction = this.fEditor != null ? new WorkingSetFindAction(this.fEditor, (FindAction)new FindWriteReferencesInWorkingSetAction(this.fEditor, iWorkingSetArray), SearchUtil.toString(iWorkingSetArray)) : new WorkingSetFindAction(this.fSite, (FindAction)new FindWriteReferencesInWorkingSetAction(this.fSite, iWorkingSetArray), SearchUtil.toString(iWorkingSetArray));
        workingSetFindAction.update(this.getContext().getSelection());
        this.addAction((IAction)workingSetFindAction, iMenuManager);
    }

    public void fillContextMenu(IMenuManager iMenuManager) {
        MenuManager menuManager = new MenuManager(MENU_TEXT, "group.search");
        this.addAction((IAction)this.fFindWriteReferencesAction, (IMenuManager)menuManager);
        this.addAction((IAction)this.fFindWriteReferencesInProjectAction, (IMenuManager)menuManager);
        this.addAction((IAction)this.fFindWriteReferencesInHierarchyAction, (IMenuManager)menuManager);
        menuManager.add((IContributionItem)new Separator());
        Iterator iterator = SearchUtil.getLRUWorkingSets().sortedIterator();
        while (iterator.hasNext()) {
            this.addWorkingSetAction((IWorkingSet[])iterator.next(), (IMenuManager)menuManager);
        }
        this.addAction((IAction)this.fFindWriteReferencesInWorkingSetAction, (IMenuManager)menuManager);
        if (!menuManager.isEmpty()) {
            iMenuManager.appendToGroup(this.fGroupId, (IContributionItem)menuManager);
        }
    }

    public void fillActionBars(IActionBars iActionBars) {
        Assert.isNotNull((Object)iActionBars);
        super.fillActionBars(iActionBars);
        this.fActionBars = iActionBars;
        this.updateGlobalActionHandlers();
    }

    public void dispose() {
        ISelectionProvider iSelectionProvider = this.fSite.getSelectionProvider();
        if (iSelectionProvider != null) {
            this.disposeAction(this.fFindWriteReferencesAction, iSelectionProvider);
            this.disposeAction(this.fFindWriteReferencesInProjectAction, iSelectionProvider);
            this.disposeAction(this.fFindWriteReferencesInHierarchyAction, iSelectionProvider);
            this.disposeAction(this.fFindWriteReferencesInWorkingSetAction, iSelectionProvider);
        }
        this.fFindWriteReferencesAction = null;
        this.fFindWriteReferencesInProjectAction = null;
        this.fFindWriteReferencesInHierarchyAction = null;
        this.fFindWriteReferencesInWorkingSetAction = null;
        this.updateGlobalActionHandlers();
        super.dispose();
    }

    private void updateGlobalActionHandlers() {
        if (this.fActionBars != null) {
            this.fActionBars.setGlobalActionHandler("org.eclipse.wst.jsdt.ui.actions.WriteAccessInWorkspace", (IAction)this.fFindWriteReferencesAction);
            this.fActionBars.setGlobalActionHandler("org.eclipse.wst.jsdt.ui.actions.WriteAccessInProject", (IAction)this.fFindWriteReferencesInProjectAction);
            this.fActionBars.setGlobalActionHandler("org.eclipse.wst.jsdt.ui.actions.WriteAccessInHierarchy", (IAction)this.fFindWriteReferencesInHierarchyAction);
            this.fActionBars.setGlobalActionHandler("org.eclipse.wst.jsdt.ui.actions.WriteAccessInWorkingSet", (IAction)this.fFindWriteReferencesInWorkingSetAction);
        }
    }

    private void disposeAction(ISelectionChangedListener iSelectionChangedListener, ISelectionProvider iSelectionProvider) {
        if (iSelectionChangedListener != null) {
            iSelectionProvider.removeSelectionChangedListener(iSelectionChangedListener);
        }
    }
}

