/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.ui.jarpackager;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.CRC32;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.jarpackager.JarPackagerUtil;
import org.eclipse.wst.jsdt.ui.jarpackager.JarPackageData;

public class JarWriter {
    private JarOutputStream fJarOutputStream;
    private JarPackageData fJarPackage;
    private Set fDirectories = new HashSet();

    public JarWriter(JarPackageData jarPackageData, Shell shell) throws CoreException {
        Assert.isNotNull((Object)jarPackageData, (String)"The JAR specification is null");
        this.fJarPackage = jarPackageData;
        Assert.isTrue((boolean)this.fJarPackage.isValid(), (String)"The JAR package specification is invalid");
        if (!this.canCreateJar(shell)) {
            throw new OperationCanceledException();
        }
        try {
            Object object;
            if (this.fJarPackage.usesManifest() && this.fJarPackage.areGeneratedFilesExported()) {
                object = this.fJarPackage.getManifestProvider().create(this.fJarPackage);
                this.fJarOutputStream = new JarOutputStream((OutputStream)new FileOutputStream(this.fJarPackage.getAbsoluteJarLocation().toOSString()), (Manifest)object);
            } else {
                this.fJarOutputStream = new JarOutputStream(new FileOutputStream(this.fJarPackage.getAbsoluteJarLocation().toOSString()));
            }
            object = jarPackageData.getComment();
            if (object != null) {
                this.fJarOutputStream.setComment((String)object);
            }
        }
        catch (IOException iOException) {
            throw JarPackagerUtil.createCoreException(iOException.getLocalizedMessage(), iOException);
        }
    }

    public void close() throws CoreException {
        if (this.fJarOutputStream != null) {
            try {
                this.fJarOutputStream.close();
                this.registerInWorkspaceIfNeeded();
            }
            catch (IOException iOException) {
                throw JarPackagerUtil.createCoreException(iOException.getLocalizedMessage(), iOException);
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void write(IFile iFile, IPath iPath) throws CoreException {
        File file;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        BufferedInputStream bufferedInputStream = null;
        try {
            try {
                int n;
                bufferedInputStream = new BufferedInputStream(iFile.getContents(false));
                int n2 = 4096;
                byte[] byArray = new byte[n2];
                while ((n = bufferedInputStream.read(byArray, 0, n2)) != -1) {
                    byteArrayOutputStream.write(byArray, 0, n);
                }
            }
            catch (IOException iOException) {
                throw JarPackagerUtil.createCoreException(iOException.getLocalizedMessage(), iOException);
            }
        }
        catch (Throwable throwable) {
            Object var8_12 = null;
            try {
                if (bufferedInputStream == null) throw throwable;
                bufferedInputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {
                throw JarPackagerUtil.createCoreException(iOException.getLocalizedMessage(), iOException);
            }
        }
        {
            file = null;
        }
        try {}
        catch (IOException iOException) {
            throw JarPackagerUtil.createCoreException(iOException.getLocalizedMessage(), iOException);
        }
        if (bufferedInputStream != null) {
            bufferedInputStream.close();
        }
        {
            IPath iPath2 = iFile.getLocation();
            long l = System.currentTimeMillis();
            file = null;
            if (iPath2 != null && (file = new File(iPath2.toOSString())).exists()) {
                l = file.lastModified();
            }
            if (this.fJarPackage.areDirectoryEntriesIncluded()) {
                this.addDirectories(iPath, file);
            }
            this.write(iPath, byteArrayOutputStream.toByteArray(), l);
            return;
        }
    }

    protected void write(IPath iPath, byte[] byArray, long l) throws IOException {
        JarEntry jarEntry = new JarEntry(iPath.toString().replace(File.separatorChar, '/'));
        if (this.fJarPackage.isCompressed()) {
            jarEntry.setMethod(8);
        } else {
            jarEntry.setMethod(0);
            jarEntry.setSize(byArray.length);
            CRC32 cRC32 = new CRC32();
            cRC32.update(byArray);
            jarEntry.setCrc(cRC32.getValue());
        }
        jarEntry.setTime(l);
        this.fJarOutputStream.putNextEntry(jarEntry);
        this.fJarOutputStream.write(byArray);
    }

    private void addDirectories(IPath iPath, File file) throws IOException {
        String string = iPath.toString().replace(File.separatorChar, '/');
        int n = string.lastIndexOf(47);
        ArrayList<JarEntry> arrayList = new ArrayList<JarEntry>(2);
        while (n != -1) {
            if (!this.fDirectories.add(string = string.substring(0, n + 1))) break;
            if (file != null) {
                file = file.getParentFile();
            }
            long l = file != null && file.exists() ? file.lastModified() : System.currentTimeMillis();
            JarEntry jarEntry = new JarEntry(string);
            jarEntry.setMethod(0);
            jarEntry.setSize(0L);
            jarEntry.setCrc(0L);
            jarEntry.setTime(l);
            arrayList.add(jarEntry);
            n = string.lastIndexOf(47, n - 1);
        }
        int n2 = arrayList.size() - 1;
        while (n2 >= 0) {
            this.fJarOutputStream.putNextEntry((JarEntry)arrayList.get(n2));
            --n2;
        }
    }

    protected boolean canCreateJar(Shell shell) {
        File file = this.fJarPackage.getAbsoluteJarLocation().toFile();
        if (file.exists()) {
            if (!file.canWrite()) {
                return false;
            }
            if (this.fJarPackage.allowOverwrite()) {
                return true;
            }
            return shell != null && JarPackagerUtil.askForOverwritePermission(shell, this.fJarPackage.getAbsoluteJarLocation().toOSString());
        }
        String string = file.getAbsolutePath();
        int n = string.lastIndexOf(File.separator);
        if (n == -1) {
            return true;
        }
        File file2 = new File(string.substring(0, n));
        if (!file2.exists()) {
            if (JarPackagerUtil.askToCreateDirectory(shell, file2)) {
                return file2.mkdirs();
            }
            return false;
        }
        return true;
    }

    private void registerInWorkspaceIfNeeded() {
        IPath iPath = this.fJarPackage.getAbsoluteJarLocation();
        IProject[] iProjectArray = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = 0;
        while (n < iProjectArray.length) {
            IProject iProject = iProjectArray[n];
            IPath iPath2 = iProject.getLocation();
            if (iPath2 != null && iPath2.isPrefixOf(iPath)) {
                try {
                    iPath = iPath.removeFirstSegments(iPath2.segmentCount());
                    iPath = iPath.removeLastSegments(1);
                    IResource iResource = iProject.findMember(iPath);
                    if (iResource != null && iResource.isAccessible()) {
                        iResource.refreshLocal(1, null);
                    }
                }
                catch (CoreException coreException) {
                    JavaPlugin.log(coreException);
                }
            }
            ++n;
        }
    }
}

