/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.ui.text.java;

import java.util.Arrays;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.wst.jsdt.core.ClasspathContainerInitializer;
import org.eclipse.wst.jsdt.core.CompletionContext;
import org.eclipse.wst.jsdt.core.CompletionProposal;
import org.eclipse.wst.jsdt.core.Flags;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.JSDScopeUtil;
import org.eclipse.wst.jsdt.core.Signature;
import org.eclipse.wst.jsdt.internal.core.util.Util;
import org.eclipse.wst.jsdt.internal.corext.template.java.SignatureUtil;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.IClasspathContainerInitialzerExtension;
import org.eclipse.wst.jsdt.internal.ui.JavaPluginImages;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.JavaElementImageProvider;
import org.eclipse.wst.jsdt.ui.JavaElementImageDescriptor;
import org.eclipse.wst.jsdt.ui.JavaElementLabels;
import org.eclipse.wst.jsdt.ui.text.java.JavaTextMessages;

public class CompletionProposalLabelProvider {
    private CompletionContext fContext;

    public String createParameterList(CompletionProposal completionProposal) {
        int n = completionProposal.getKind();
        switch (n) {
            case 6: {
                return this.appendUnboundedParameterList(new StringBuffer(), completionProposal).toString();
            }
            case 9: {
                return this.appendTypeParameterList(new StringBuffer(), completionProposal).toString();
            }
        }
        Assert.isLegal((boolean)false);
        return null;
    }

    private StringBuffer appendUnboundedParameterList(StringBuffer stringBuffer, CompletionProposal completionProposal) {
        char[] cArray = SignatureUtil.fix83600(completionProposal.getSignature());
        char[][] cArray2 = completionProposal.findParameterNames(null);
        char[][] cArray3 = Signature.getParameterTypes((char[])cArray);
        int n = 0;
        while (n < cArray3.length) {
            cArray3[n] = this.createTypeDisplayName(SignatureUtil.getLowerBound(cArray3[n]));
            ++n;
        }
        if (Flags.isVarargs((int)completionProposal.getFlags())) {
            n = cArray3.length - 1;
            cArray3[n] = this.convertToVararg(cArray3[n]);
        }
        return this.appendParameterSignature(stringBuffer, cArray3, cArray2);
    }

    private StringBuffer appendTypeParameterList(StringBuffer stringBuffer, CompletionProposal completionProposal) {
        char[] cArray = SignatureUtil.fix83600(completionProposal.getSignature());
        char[][] cArray2 = Signature.getTypeArguments((char[])cArray);
        int n = 0;
        while (n < cArray2.length) {
            char[] cArray3 = cArray2[n];
            cArray2[n] = Signature.toCharArray((char[])cArray3);
            ++n;
        }
        return this.appendParameterSignature(stringBuffer, cArray2, null);
    }

    private char[] convertToVararg(char[] cArray) {
        if (cArray == null) {
            return cArray;
        }
        int n = cArray.length;
        if (n < 2) {
            return cArray;
        }
        if (cArray[n - 1] != ']') {
            return cArray;
        }
        if (cArray[n - 2] != '[') {
            return cArray;
        }
        char[] cArray2 = new char[n + 1];
        System.arraycopy(cArray, 0, cArray2, 0, n - 2);
        cArray2[n - 2] = 46;
        cArray2[n - 1] = 46;
        cArray2[n] = 46;
        return cArray2;
    }

    private char[] createTypeDisplayName(char[] cArray) throws IllegalArgumentException {
        char[] cArray2 = Signature.getSimpleName((char[])Signature.toCharArray((char[])cArray));
        boolean bl = false;
        if (bl) {
            int n;
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(cArray2);
            do {
                if ((n = stringBuffer.indexOf("? extends ")) >= 0) {
                    stringBuffer.replace(n, n + 10, "+");
                    continue;
                }
                n = stringBuffer.indexOf("? super ");
                if (n < 0) continue;
                stringBuffer.replace(n, n + 8, "-");
            } while (n >= 0);
            return stringBuffer.toString().toCharArray();
        }
        return cArray2;
    }

    private final StringBuffer appendParameterSignature(StringBuffer stringBuffer, char[][] cArray, char[][] cArray2) {
        if (cArray != null) {
            int n = 0;
            while (n < cArray.length) {
                if (n > 0) {
                    stringBuffer.append(',');
                    stringBuffer.append(' ');
                }
                if (!Arrays.equals(Signature.ANY, cArray[n])) {
                    stringBuffer.append(cArray[n]);
                }
                if (cArray2 != null && cArray2[n] != null) {
                    stringBuffer.append(' ');
                    stringBuffer.append(cArray2[n]);
                }
                ++n;
            }
        }
        return stringBuffer;
    }

    String createMethodProposalLabel(CompletionProposal completionProposal) {
        Object object;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(completionProposal.getName());
        stringBuffer.append('(');
        this.appendUnboundedParameterList(stringBuffer, completionProposal);
        stringBuffer.append(')');
        if (!completionProposal.isConstructor() && !Arrays.equals(Signature.ANY, object = this.createTypeDisplayName(SignatureUtil.getUpperBound(Signature.getReturnType((char[])SignatureUtil.fix83600(completionProposal.getSignature())))))) {
            stringBuffer.append("  ");
            Util.insertTypeLabel((char[])object, (StringBuffer)stringBuffer);
        }
        stringBuffer.append(" - ");
        object = this.extractDeclaringTypeFQN(completionProposal);
        Util.insertTypeLabel((String)object, (StringBuffer)stringBuffer);
        return stringBuffer.toString();
    }

    String createJavadocMethodProposalLabel(CompletionProposal completionProposal) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(completionProposal.getCompletion());
        stringBuffer.append(" - ");
        String string = this.extractDeclaringTypeFQN(completionProposal);
        string = Signature.getSimpleName((String)string);
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    String createOverrideMethodProposalLabel(CompletionProposal completionProposal) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(completionProposal.getName());
        stringBuffer.append('(');
        this.appendUnboundedParameterList(stringBuffer, completionProposal);
        stringBuffer.append(")  ");
        char[] cArray = this.createTypeDisplayName(SignatureUtil.getUpperBound(Signature.getReturnType((char[])SignatureUtil.fix83600(completionProposal.getSignature()))));
        stringBuffer.append(cArray);
        stringBuffer.append(" - ");
        String string = this.extractDeclaringTypeFQN(completionProposal);
        string = Signature.getSimpleName((String)string);
        stringBuffer.append(Messages.format(JavaTextMessages.ResultCollector_overridingmethod, new String(string)));
        return stringBuffer.toString();
    }

    private String extractDeclaringTypeFQN(CompletionProposal completionProposal) {
        String string;
        IJavaProject iJavaProject;
        char[] cArray = completionProposal.getDeclarationSignature();
        char[] cArray2 = completionProposal.getDeclarationTypeName();
        ClasspathContainerInitializer classpathContainerInitializer = JSDScopeUtil.findLibraryInitializer((IPath)new Path(new String(cArray2)), (IJavaProject)(iJavaProject = completionProposal.getJavaProject()));
        if (classpathContainerInitializer != null && (string = classpathContainerInitializer.getDescription((IPath)new Path(new String(cArray2)), iJavaProject)) != null) {
            return "[" + string + "]";
        }
        if (cArray == null) {
            return "java.lang.Object";
        }
        return SignatureUtil.stripSignatureToFQN(String.valueOf(cArray));
    }

    String createTypeProposalLabel(CompletionProposal completionProposal) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(completionProposal.getCompletion());
        char[] cArray = completionProposal.getDeclarationSignature();
        if (cArray != null && cArray.length > 0) {
            stringBuffer.append(JavaElementLabels.CONCAT_STRING);
            stringBuffer.append(cArray);
        }
        return stringBuffer.toString();
    }

    String createJavadocTypeProposalLabel(CompletionProposal completionProposal) {
        char[] cArray = Signature.toCharArray((char[])completionProposal.getSignature());
        return this.createJavadocTypeProposalLabel(cArray);
    }

    String createJavadocSimpleProposalLabel(CompletionProposal completionProposal) {
        return this.createSimpleLabel(completionProposal);
    }

    String createTypeProposalLabel(char[] cArray) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(cArray);
        return stringBuffer.toString();
    }

    String createJavadocTypeProposalLabel(char[] cArray) {
        int n = this.findSimpleNameStart(cArray);
        StringBuffer stringBuffer = new StringBuffer("{@link ");
        stringBuffer.append(cArray, n, cArray.length - n);
        stringBuffer.append('}');
        if (n > 0) {
            stringBuffer.append(JavaElementLabels.CONCAT_STRING);
            stringBuffer.append(cArray, 0, n - 1);
        }
        return stringBuffer.toString();
    }

    private int findSimpleNameStart(char[] cArray) {
        int n = 0;
        int n2 = 0;
        int n3 = cArray.length;
        while (n2 < n3) {
            char c = cArray[n2];
            if (c == '<') {
                return n;
            }
            if (c == '.') {
                n = n2 + 1;
            }
            ++n2;
        }
        return n;
    }

    String createSimpleLabelWithType(CompletionProposal completionProposal) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(completionProposal.getCompletion());
        char[] cArray = Signature.getSignatureSimpleName((char[])completionProposal.getSignature());
        if (cArray.length > 0) {
            stringBuffer.append("    ");
            Util.insertTypeLabel((char[])cArray, (StringBuffer)stringBuffer);
        }
        return stringBuffer.toString();
    }

    private boolean isThisPrefix(char[] cArray) {
        if (cArray == null || cArray.length < 5) {
            return false;
        }
        return cArray[0] == 't' && cArray[1] == 'h' && cArray[2] == 'i' && cArray[3] == 's' && cArray[4] == '.';
    }

    String createLabelWithTypeAndDeclaration(CompletionProposal completionProposal) {
        char[] cArray;
        char[] cArray2 = completionProposal.getCompletion();
        if (!this.isThisPrefix(cArray2)) {
            cArray2 = completionProposal.getName();
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(cArray2);
        char[] cArray3 = Signature.getSignatureSimpleName((char[])completionProposal.getSignature());
        if (cArray3.length > 0 && !Arrays.equals(Signature.ANY, cArray3)) {
            stringBuffer.append("    ");
            Util.insertTypeLabel((char[])cArray3, (StringBuffer)stringBuffer);
        }
        if ((cArray = completionProposal.getDeclarationSignature()) != null && (cArray = Signature.getSignatureSimpleName((char[])cArray)).length > 0) {
            stringBuffer.append(" - ");
            Util.insertTypeLabel((char[])cArray, (StringBuffer)stringBuffer);
        }
        return stringBuffer.toString();
    }

    String createPackageProposalLabel(CompletionProposal completionProposal) {
        Assert.isTrue((completionProposal.getKind() == 8 ? 1 : 0) != 0);
        return String.valueOf(completionProposal.getDeclarationSignature());
    }

    String createSimpleLabel(CompletionProposal completionProposal) {
        return String.valueOf(completionProposal.getCompletion());
    }

    String createAnonymousTypeLabel(CompletionProposal completionProposal) {
        char[] cArray = completionProposal.getDeclarationSignature();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(Signature.getSignatureSimpleName((char[])cArray));
        stringBuffer.append('(');
        this.appendUnboundedParameterList(stringBuffer, completionProposal);
        stringBuffer.append(')');
        stringBuffer.append("  ");
        stringBuffer.append(JavaTextMessages.ResultCollector_anonymous_type);
        return stringBuffer.toString();
    }

    public String createLabel(CompletionProposal completionProposal) {
        switch (completionProposal.getKind()) {
            case 6: 
            case 11: 
            case 12: {
                if (this.fContext != null && this.fContext.isInJavadoc()) {
                    return this.createJavadocMethodProposalLabel(completionProposal);
                }
                return this.createMethodProposalLabel(completionProposal);
            }
            case 7: {
                return this.createOverrideMethodProposalLabel(completionProposal);
            }
            case 1: {
                return this.createAnonymousTypeLabel(completionProposal);
            }
            case 9: {
                return this.createTypeProposalLabel(completionProposal);
            }
            case 16: {
                return this.createJavadocTypeProposalLabel(completionProposal);
            }
            case 14: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                return this.createJavadocSimpleProposalLabel(completionProposal);
            }
            case 15: {
                return this.createJavadocMethodProposalLabel(completionProposal);
            }
            case 8: {
                return this.createPackageProposalLabel(completionProposal);
            }
            case 2: 
            case 13: {
                return this.createLabelWithTypeAndDeclaration(completionProposal);
            }
            case 5: 
            case 10: {
                return this.createSimpleLabelWithType(completionProposal);
            }
            case 3: 
            case 4: {
                return this.createSimpleLabel(completionProposal);
            }
        }
        Assert.isTrue((boolean)false);
        return null;
    }

    public ImageDescriptor createImageDescriptor(CompletionProposal completionProposal) {
        ImageDescriptor imageDescriptor;
        ImageDescriptor imageDescriptor2;
        char[] cArray = completionProposal.getDeclarationTypeName();
        char[] cArray2 = completionProposal.getName();
        IJavaProject iJavaProject = completionProposal.getJavaProject();
        ClasspathContainerInitializer classpathContainerInitializer = null;
        if (cArray != null && cArray2 != null) {
            classpathContainerInitializer = JSDScopeUtil.findLibraryInitializer((IPath)new Path(new String(cArray)), (IJavaProject)iJavaProject);
        }
        if (classpathContainerInitializer != null && classpathContainerInitializer instanceof IClasspathContainerInitialzerExtension && (imageDescriptor2 = ((IClasspathContainerInitialzerExtension)classpathContainerInitializer).getImage((IPath)new Path(new String(cArray)), new String(cArray2), iJavaProject)) != null) {
            return imageDescriptor2;
        }
        int n = completionProposal.getFlags();
        block0 : switch (completionProposal.getKind()) {
            case 6: 
            case 7: 
            case 11: 
            case 12: 
            case 13: {
                imageDescriptor = JavaElementImageProvider.getMethodImageDescriptor(false, n);
                break;
            }
            case 1: 
            case 9: {
                switch (Signature.getTypeSignatureKind((char[])completionProposal.getSignature())) {
                    case 1: {
                        imageDescriptor = JavaElementImageProvider.getTypeImageDescriptor(false, false, n, false);
                        break block0;
                    }
                    case 3: {
                        imageDescriptor = JavaPluginImages.DESC_OBJS_TYPEVARIABLE;
                        break block0;
                    }
                }
                imageDescriptor = null;
                break;
            }
            case 2: {
                imageDescriptor = JavaElementImageProvider.getFieldImageDescriptor(false, n);
                break;
            }
            case 5: 
            case 10: {
                imageDescriptor = JavaPluginImages.DESC_OBJS_LOCAL_VARIABLE;
                break;
            }
            case 8: {
                imageDescriptor = JavaPluginImages.DESC_OBJS_PACKAGE;
                break;
            }
            case 3: 
            case 4: {
                imageDescriptor = null;
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                imageDescriptor = JavaPluginImages.DESC_OBJS_JAVADOCTAG;
                break;
            }
            default: {
                imageDescriptor = null;
                Assert.isTrue((boolean)false);
            }
        }
        if (imageDescriptor == null) {
            return null;
        }
        return this.decorateImageDescriptor(imageDescriptor, completionProposal);
    }

    ImageDescriptor createMethodImageDescriptor(CompletionProposal completionProposal) {
        ImageDescriptor imageDescriptor;
        char[] cArray = completionProposal.getDeclarationTypeName();
        char[] cArray2 = completionProposal.getName();
        IJavaProject iJavaProject = completionProposal.getJavaProject();
        ClasspathContainerInitializer classpathContainerInitializer = JSDScopeUtil.findLibraryInitializer((IPath)new Path(new String(cArray)), (IJavaProject)iJavaProject);
        if (classpathContainerInitializer != null && classpathContainerInitializer instanceof IClasspathContainerInitialzerExtension && (imageDescriptor = ((IClasspathContainerInitialzerExtension)classpathContainerInitializer).getImage((IPath)new Path(new String(cArray)), new String(cArray2), iJavaProject)) != null) {
            return imageDescriptor;
        }
        int n = completionProposal.getFlags();
        return this.decorateImageDescriptor(JavaElementImageProvider.getMethodImageDescriptor(false, n), completionProposal);
    }

    ImageDescriptor createTypeImageDescriptor(CompletionProposal completionProposal) {
        int n = completionProposal.getFlags();
        boolean bl = Flags.isInterface((int)n) || Flags.isAnnotation((int)n);
        return this.decorateImageDescriptor(JavaElementImageProvider.getTypeImageDescriptor(true, bl, n, false), completionProposal);
    }

    ImageDescriptor createFieldImageDescriptor(CompletionProposal completionProposal) {
        ImageDescriptor imageDescriptor;
        ClasspathContainerInitializer classpathContainerInitializer;
        char[] cArray = completionProposal.getDeclarationTypeName();
        char[] cArray2 = completionProposal.getName();
        IJavaProject iJavaProject = completionProposal.getJavaProject();
        if (cArray != null && cArray.length > 0 && (classpathContainerInitializer = JSDScopeUtil.findLibraryInitializer((IPath)new Path(new String(cArray)), (IJavaProject)iJavaProject)) != null && classpathContainerInitializer instanceof IClasspathContainerInitialzerExtension && (imageDescriptor = ((IClasspathContainerInitialzerExtension)classpathContainerInitializer).getImage((IPath)new Path(new String(cArray)), new String(cArray2), iJavaProject)) != null) {
            return imageDescriptor;
        }
        int n = completionProposal.getFlags();
        return this.decorateImageDescriptor(JavaElementImageProvider.getFieldImageDescriptor(false, n), completionProposal);
    }

    ImageDescriptor createLocalImageDescriptor(CompletionProposal completionProposal) {
        return this.decorateImageDescriptor(JavaPluginImages.DESC_OBJS_LOCAL_VARIABLE, completionProposal);
    }

    ImageDescriptor createPackageImageDescriptor(CompletionProposal completionProposal) {
        return this.decorateImageDescriptor(JavaPluginImages.DESC_OBJS_PACKAGE, completionProposal);
    }

    private ImageDescriptor decorateImageDescriptor(ImageDescriptor imageDescriptor, CompletionProposal completionProposal) {
        int n = 0;
        int n2 = completionProposal.getFlags();
        int n3 = completionProposal.getKind();
        if (Flags.isDeprecated((int)n2)) {
            n |= 0x400;
        }
        if ((n3 == 2 || n3 == 7 || n3 == 7 || n3 == 12 || n3 == 6) && Flags.isStatic((int)n2)) {
            n |= 8;
        }
        if ((n3 == 7 || n3 == 7 || n3 == 12 || n3 == 6) && Flags.isSynchronized((int)n2)) {
            n |= 4;
        }
        if (n3 == 9 && Flags.isAbstract((int)n2) && !Flags.isInterface((int)n2)) {
            n |= 1;
        }
        return new JavaElementImageDescriptor(imageDescriptor, n, JavaElementImageProvider.SMALL_SIZE);
    }

    void setContext(CompletionContext completionContext) {
        this.fContext = completionContext;
    }
}

