/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.atf.resources;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public abstract class ResourceDeltaVisitor
implements IResourceDeltaVisitor {
    protected int resourceChangeType;

    public void setChangeType(int n) {
        this.resourceChangeType = n;
    }

    public boolean visit(IResourceDelta iResourceDelta) throws CoreException {
        IResource iResource = iResourceDelta.getResource();
        int n = iResourceDelta.getKind();
        switch (n) {
            case 1: {
                try {
                    this.handleResourceAdded(iResource);
                }
                catch (Exception exception) {
                    this.handleException(exception, "Error handling resource change");
                }
                return true;
            }
            case 8: {
                try {
                    this.handleResourcePhantomAdded(iResource);
                }
                catch (Exception exception) {
                    this.handleException(exception, "Error handling resource change");
                }
                return true;
            }
            case 4: {
                try {
                    this.handleResourceChanged(iResource);
                }
                catch (Exception exception) {
                    this.handleException(exception, "Error handling resource change");
                }
                return true;
            }
            case 4096: {
                try {
                    this.handleResourceMovedFrom(iResource);
                }
                catch (Exception exception) {
                    this.handleException(exception, "Error handling resource change");
                }
                return true;
            }
            case 8192: {
                try {
                    this.handleResourceMovedTo(iResource);
                }
                catch (Exception exception) {
                    this.handleException(exception, "Error handling resource change");
                }
                return true;
            }
            case 16384: {
                try {
                    this.handleResourceOpen(iResource);
                }
                catch (Exception exception) {
                    this.handleException(exception, "Error handling resource change");
                }
                return true;
            }
            case 2: {
                try {
                    this.handleResourceRemoved(iResource);
                }
                catch (Exception exception) {
                    this.handleException(exception, "Error handling resource change");
                }
                return true;
            }
            case 16: {
                try {
                    this.handleResourcePhantomRemoved(iResource);
                }
                catch (Exception exception) {
                    this.handleException(exception, "Error handling resource change");
                }
                return true;
            }
            case 262144: {
                try {
                    this.handleResourceReplaced(iResource);
                }
                catch (Exception exception) {
                    this.handleException(exception, "Error handling resource change");
                }
                return true;
            }
        }
        return true;
    }

    public abstract void handleResourceAdded(IResource var1) throws Exception;

    public abstract void handleResourcePhantomAdded(IResource var1) throws Exception;

    public abstract void handleResourceChanged(IResource var1) throws Exception;

    public abstract void handleResourceMovedFrom(IResource var1) throws Exception;

    public abstract void handleResourceMovedTo(IResource var1) throws Exception;

    public abstract void handleResourceOpen(IResource var1) throws Exception;

    public abstract void handleResourceRemoved(IResource var1) throws Exception;

    public abstract void handleResourcePhantomRemoved(IResource var1) throws Exception;

    public abstract void handleResourceReplaced(IResource var1) throws Exception;

    protected void handleException(Exception exception, String string) throws CoreException {
        throw new CoreException((IStatus)new Status(4, "org.eclipse.atf.core", 0, string, (Throwable)exception));
    }
}

