/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.web.core.internal.java;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.Position;
import org.eclipse.wst.jsdt.core.IBuffer;
import org.eclipse.wst.jsdt.web.core.internal.java.JsDataTypes;
import org.eclipse.wst.jsdt.web.core.internal.java.NodeHelper;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionList;

public class JsTranslator
extends Job
implements IDocumentListener {
    private static final boolean DEBUG;
    private static final boolean DEBUG_SAVE_OUTPUT;
    public static final String ENDL = "\n";
    private IStructuredDocumentRegion fCurrentNode;
    private StringBuffer fScriptText = new StringBuffer();
    private IStructuredDocument fStructuredDocument = null;
    private ArrayList importLocationsInHtml = new ArrayList();
    private boolean isGlobalJs = true;
    private ArrayList rawImports = new ArrayList();
    private ArrayList scriptLocationInHtml = new ArrayList();
    private int scriptOffset = 0;
    private byte[] fLock = new byte[0];
    private byte[] finished = new byte[0];
    private IBuffer compUnitBuff;
    private boolean cancelParse = false;
    private int missingEndTagRegionStart = -1;
    private static final boolean ADD_SEMICOLON_AT_INLINE = true;

    static {
        DEBUG_SAVE_OUTPUT = "true".equalsIgnoreCase(Platform.getDebugOption((String)"org.eclipse.wst.jsdt.web.core/debug/jsptranslationstodisk"));
        String string = Platform.getDebugOption((String)"org.eclipse.wst.jsdt.web.core/debug/jspjavamapping");
        DEBUG = string != null && string.equalsIgnoreCase("true");
    }

    private void advanceNextNode() {
        this.setCurrentNode(this.getCurrentNode().getNext());
    }

    public JsTranslator(IStructuredDocument iStructuredDocument, String string) {
        super("JavaScript translation for : " + string);
        this.fStructuredDocument = iStructuredDocument;
        this.fStructuredDocument.addDocumentListener((IDocumentListener)this);
        this.setPriority(30);
        this.setSystem(true);
        this.schedule();
        this.reset();
    }

    public JsTranslator(IStructuredDocument iStructuredDocument, String string, boolean bl) {
        super("JavaScript translation for : " + string);
        this.fStructuredDocument = iStructuredDocument;
        if (bl) {
            this.fStructuredDocument.addDocumentListener((IDocumentListener)this);
            this.setPriority(30);
            this.setSystem(true);
            this.schedule();
        }
        this.reset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getJsText() {
        byte[] byArray = this.finished;
        synchronized (this.finished) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.fScriptText.toString();
        }
    }

    public final IStructuredDocumentRegion getCurrentNode() {
        return this.fCurrentNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBuffer(IBuffer iBuffer) {
        this.compUnitBuff = iBuffer;
        byte[] byArray = this.finished;
        synchronized (this.finished) {
            this.compUnitBuff.setContents(this.fScriptText.toString());
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Position[] getHtmlLocations() {
        byte[] byArray = this.finished;
        synchronized (this.finished) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.scriptLocationInHtml.toArray(new Position[this.scriptLocationInHtml.size()]);
        }
    }

    public int getMissingEndTagRegionStart() {
        return this.missingEndTagRegionStart;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Position[] getImportHtmlRanges() {
        byte[] byArray = this.finished;
        synchronized (this.finished) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.importLocationsInHtml.toArray(new Position[this.importLocationsInHtml.size()]);
        }
    }

    private char[] getPad(int n) {
        char[] cArray = new char[n];
        Arrays.fill(cArray, ' ');
        return cArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getRawImports() {
        byte[] byArray = this.finished;
        synchronized (this.finished) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.rawImports.toArray(new String[this.rawImports.size()]);
        }
    }

    private boolean isCanceled() {
        return this.cancelParse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reset() {
        byte[] byArray = this.fLock;
        synchronized (this.fLock) {
            this.scriptOffset = 0;
            this.cancelParse = false;
            this.fScriptText = new StringBuffer();
            this.fCurrentNode = this.fStructuredDocument.getFirstStructuredDocumentRegion();
            this.rawImports.clear();
            this.importLocationsInHtml.clear();
            this.scriptLocationInHtml.clear();
            this.missingEndTagRegionStart = -1;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            this.translate();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IStructuredDocumentRegion setCurrentNode(IStructuredDocumentRegion iStructuredDocumentRegion) {
        byte[] byArray = this.fLock;
        synchronized (this.fLock) {
            this.fCurrentNode = iStructuredDocumentRegion;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return this.fCurrentNode;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void translate() {
        byte[] byArray = this.finished;
        synchronized (this.finished) {
            while (this.getCurrentNode() != null && !this.isCanceled()) {
                if (this.getCurrentNode().getType() == "XML_TAG_NAME") {
                    NodeHelper nodeHelper = new NodeHelper(this.getCurrentNode());
                    if ((!nodeHelper.isEndTag() || nodeHelper.isSelfClosingTag()) && nodeHelper.nameEquals("script")) {
                        if (NodeHelper.isInArray(JsDataTypes.JSVALIDDATATYPES, nodeHelper.getAttributeValue("type")) || NodeHelper.isInArray(JsDataTypes.JSVALIDDATATYPES, nodeHelper.getAttributeValue("language")) || this.isGlobalJs) {
                            if (nodeHelper.containsAttribute(new String[]{"src"})) {
                                this.translateScriptImportNode(this.getCurrentNode());
                            }
                            if (this.getCurrentNode().getNext() != null) {
                                this.translateJSNode(this.getCurrentNode().getNext());
                            }
                        }
                    } else if (nodeHelper.containsAttribute(JsDataTypes.HTMLATREVENTS)) {
                        this.translateInlineJSNode(this.getCurrentNode());
                    } else if (nodeHelper.nameEquals("META") && nodeHelper.attrEquals("http-equiv", "Content-Script-Type") && nodeHelper.containsAttribute(new String[]{"content"})) {
                        this.isGlobalJs = NodeHelper.isInArray(JsDataTypes.JSVALIDDATATYPES, nodeHelper.getAttributeValue("content"));
                    }
                }
                if (this.getCurrentNode() == null) continue;
                this.advanceNextNode();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            this.finishedTranslation();
            return;
        }
    }

    private void finishedTranslation() {
        if (this.compUnitBuff != null) {
            this.compUnitBuff.setContents(this.fScriptText.toString());
        }
    }

    public void translateInlineJSNode(IStructuredDocumentRegion iStructuredDocumentRegion) {
        new NodeHelper(iStructuredDocumentRegion);
        ITextRegionList iTextRegionList = iStructuredDocumentRegion.getRegions();
        Iterator iterator = iTextRegionList.iterator();
        while (iterator.hasNext() && !this.isCanceled()) {
            ITextRegion iTextRegion = (ITextRegion)iterator.next();
            if (iTextRegion.getType() != "XML_TAG_ATTRIBUTE_NAME") continue;
            int n = iTextRegion.getStart();
            int n2 = iTextRegion.getTextEnd();
            String string = iStructuredDocumentRegion.getText().substring(n, n2).trim();
            if (!NodeHelper.isInArray(JsDataTypes.HTMLATREVENTS, string)) continue;
            if (iterator.hasNext()) {
                iterator.next();
            }
            if (iterator.hasNext()) {
                iTextRegion = (ITextRegion)iterator.next();
            }
            if (iTextRegion.getType() != "XML_TAG_ATTRIBUTE_VALUE") continue;
            int n3 = iStructuredDocumentRegion.getStartOffset(iTextRegion);
            String string2 = iStructuredDocumentRegion.getText().substring(iTextRegion.getStart(), iTextRegion.getTextEnd());
            if (string2 == null || string2.length() == 0) {
                return;
            }
            switch (string2.charAt(0)) {
                case '\"': 
                case '\'': {
                    string2 = string2.substring(1);
                    ++n3;
                }
            }
            switch (string2.charAt(string2.length() - 1)) {
                case '\"': 
                case '\'': {
                    string2 = string2.substring(0, string2.length() - 1);
                }
            }
            string2 = String.valueOf(string2) + ";";
            Position position = new Position(n3, string2.length());
            this.scriptLocationInHtml.add(position);
            char[] cArray = this.getPad(n3 - this.scriptOffset);
            this.fScriptText.append(cArray);
            this.fScriptText.append(string2);
            this.scriptOffset = this.fScriptText.length();
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public void translateJSNode(IStructuredDocumentRegion var1_1) {
        var2_2 = var1_1;
        var3_3 = var2_2.getRegions().iterator();
        var4_4 = null;
        if (var1_1 == null) {
            return;
        }
        var5_5 = this.getPad(var1_1.getStartOffset() - this.scriptOffset);
        this.fScriptText.append(var5_5);
        this.scriptOffset = var1_1.getStartOffset();
        if (var1_1.getType() == "BLOCK_TEXT" || var1_1.getType() == "XML_CDATA_TEXT") ** GOTO lbl29
        return;
lbl-1000:
        // 1 sources

        {
            var4_4 = (ITextRegion)var3_3.next();
            var6_6 /* !! */  = var4_4.getType();
            if (var6_6 /* !! */  != "BLOCK_TEXT") continue;
            var7_7 = var1_1.getStartOffset();
            var8_9 = var1_1.getEndOffset() - var1_1.getStartOffset();
            var9_11 = var1_1.getText().substring(var4_4.getStart(), var4_4.getEnd());
            var9_11.length();
            var10_12 = new Position(var7_7, var8_9);
            this.scriptLocationInHtml.add(var10_12);
            var5_5 = this.getPad(var7_7 - this.scriptOffset);
            this.fScriptText.append(var5_5);
            this.fScriptText.append(var9_11);
            this.scriptOffset = this.fScriptText.length();
lbl29:
            // 3 sources

            ** while (var3_3.hasNext() && !this.isCanceled())
        }
lbl30:
        // 1 sources

        var6_6 /* !! */  = var1_1.getNext();
        if (var6_6 /* !! */  == null) {
            this.missingEndTagRegionStart = var1_1.getStartOffset();
        } else if (!(var6_6 /* !! */  == null || (var8_10 = (var7_8 = new NodeHelper(var6_6 /* !! */ )).getTagName()) != null && var8_10.trim().equalsIgnoreCase("script") && var7_8.isEndTag())) {
            this.missingEndTagRegionStart = var1_1.getStartOffset();
        }
    }

    public void translateScriptImportNode(IStructuredDocumentRegion iStructuredDocumentRegion) {
        NodeHelper nodeHelper = new NodeHelper(iStructuredDocumentRegion);
        String string = nodeHelper.getAttributeValue("src");
        if (string != null && !string.equals("")) {
            this.rawImports.add(string);
            Position position = new Position(iStructuredDocumentRegion.getStartOffset(), iStructuredDocumentRegion.getEndOffset());
            this.importLocationsInHtml.add(position);
        }
    }

    public void documentAboutToBeChanged(DocumentEvent documentEvent) {
        this.cancelParse = true;
    }

    public void documentChanged(DocumentEvent documentEvent) {
        this.reset();
    }

    protected IStatus run(IProgressMonitor iProgressMonitor) {
        return Status.OK_STATUS;
    }

    public void release() {
        this.fStructuredDocument.removeDocumentListener((IDocumentListener)this);
    }
}

