/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.web.core.internal.java.search;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.wst.jsdt.web.core.internal.JsCoreMessages;
import org.eclipse.wst.jsdt.web.core.internal.java.search.JsIndexManager;
import org.eclipse.wst.jsdt.web.core.internal.java.search.JsSearchSupport;
import org.eclipse.wst.jsdt.web.core.internal.validation.Util;

public class IndexWorkspaceJob
extends Job {
    static final boolean DEBUG;
    private IContentType fContentTypeJSP = null;

    static {
        String string = Platform.getDebugOption((String)"org.eclipse.wst.jsdt.web.core/debug/jspindexmanager");
        DEBUG = string != null && string.equalsIgnoreCase("true");
    }

    public IndexWorkspaceJob() {
        super(JsCoreMessages.JSPIndexManager_0);
        this.setPriority(30);
        this.setSystem(true);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected IStatus run(IProgressMonitor iProgressMonitor) {
        long l;
        IStatus iStatus;
        block10: {
            iStatus = Status.OK_STATUS;
            if (iProgressMonitor.isCanceled()) {
                this.setCanceledState();
                return Status.CANCEL_STATUS;
            }
            if (DEBUG) {
                System.out.println(" ^ IndexWorkspaceJob started: ");
            }
            l = System.currentTimeMillis();
            try {
                try {
                    JSPFileVisitor jSPFileVisitor = new JSPFileVisitor(iProgressMonitor);
                    ResourcesPlugin.getWorkspace().getRoot().accept((IResourceProxyVisitor)jSPFileVisitor, 2);
                    JsIndexManager.getInstance().indexFiles(jSPFileVisitor.getFiles());
                }
                catch (CoreException coreException) {
                    if (DEBUG) {
                        coreException.printStackTrace();
                    }
                }
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                if (iProgressMonitor != null) {
                    iProgressMonitor.done();
                }
                throw throwable;
            }
            {
                Object var6_9 = null;
                if (iProgressMonitor == null) break block10;
            }
            iProgressMonitor.done();
        }
        long l2 = System.currentTimeMillis();
        if (DEBUG) {
            System.out.println(" ^ IndexWorkspaceJob finished\n   total time running: " + (l2 - l));
        }
        return iStatus;
    }

    void setCanceledState() {
        JsIndexManager.getInstance().setIndexState(4);
    }

    private class JSPFileVisitor
    implements IResourceProxyVisitor {
        private List files = new ArrayList();
        IProgressMonitor fInnerMonitor = null;

        public JSPFileVisitor(IProgressMonitor iProgressMonitor) {
            this.fInnerMonitor = iProgressMonitor;
        }

        public final IFile[] getFiles() {
            return this.files.toArray(new IFile[this.files.size()]);
        }

        public boolean visit(IResourceProxy iResourceProxy) throws CoreException {
            IFile iFile;
            if (this.fInnerMonitor != null && this.fInnerMonitor.isCanceled()) {
                IndexWorkspaceJob.this.setCanceledState();
                return false;
            }
            if (JsSearchSupport.getInstance().isCanceled()) {
                IndexWorkspaceJob.this.setCanceledState();
                return false;
            }
            if (iResourceProxy.getType() == 1 && Util.isJsType(iResourceProxy.getName()) && (iFile = (IFile)iResourceProxy.requestResource()).exists()) {
                if (DEBUG) {
                    System.out.println("(+) IndexWorkspaceJob adding file: " + iFile.getName());
                }
                this.files.add(iFile);
                this.fInnerMonitor.subTask(iResourceProxy.getName());
                return false;
            }
            return true;
        }
    }
}

