/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.project.facet.ui.internal;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.eclipse.wst.common.project.facet.core.IListener;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntime;
import org.eclipse.wst.common.project.facet.core.runtime.RuntimeManager;
import org.eclipse.wst.common.project.facet.ui.internal.AbstractDataModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ChangeTargetedRuntimesDataModel
extends AbstractDataModel {
    public static final String EVENT_AVAILABLE_RUNTIMES_CHANGED = "availableRuntimesChanged";
    public static final String EVENT_TARGETABLE_RUNTIMES_CHANGED = "targetableRuntimesChanged";
    public static final String EVENT_TARGETED_RUNTIMES_CHANGED = "targetedRuntimesChanged";
    public static final String EVENT_PRIMARY_RUNTIME_CHANGED = "primaryRuntimeChanged";
    private final List<IRuntimeFilter> filters = new ArrayList<IRuntimeFilter>();
    private final Set<IRuntime> targetableRuntimes = new CopyOnWriteArraySet<IRuntime>();
    private final Set<IRuntime> targetedRuntimes;
    private IRuntime primaryRuntime;
    private IListener runtimeManagerListener;

    public ChangeTargetedRuntimesDataModel() {
        this.targetableRuntimes.addAll(this.getAllRuntimes());
        this.targetedRuntimes = new CopyOnWriteArraySet<IRuntime>();
        this.primaryRuntime = null;
        this.runtimeManagerListener = new IListener(){

            public void handle() {
                ChangeTargetedRuntimesDataModel.this.notifyListeners(ChangeTargetedRuntimesDataModel.EVENT_AVAILABLE_RUNTIMES_CHANGED);
                ChangeTargetedRuntimesDataModel.this.refreshTargetableRuntimes();
            }
        };
        RuntimeManager.addRuntimeListener((IListener)this.runtimeManagerListener);
    }

    public synchronized void addRuntimeFilter(IRuntimeFilter filter) {
        this.filters.add(filter);
        this.refreshTargetableRuntimes();
    }

    public synchronized void removeRuntimeFilter(IRuntimeFilter filter) {
        this.filters.remove(filter);
        this.refreshTargetableRuntimes();
    }

    public synchronized Set<IRuntime> getAllRuntimes() {
        return RuntimeManager.getRuntimes();
    }

    public synchronized Set<IRuntime> getTargetableRuntimes() {
        return this.targetableRuntimes;
    }

    public synchronized void refreshTargetableRuntimes() {
        HashSet<IRuntime> result = new HashSet<IRuntime>();
        for (IRuntime r : this.getAllRuntimes()) {
            boolean ok = true;
            for (IRuntimeFilter filter : this.filters) {
                if (filter.check(r)) continue;
                ok = false;
                break;
            }
            if (!ok) continue;
            result.add(r);
        }
        if (!this.targetableRuntimes.equals(result)) {
            this.targetableRuntimes.clear();
            this.targetableRuntimes.addAll(result);
            this.notifyListeners(EVENT_TARGETABLE_RUNTIMES_CHANGED);
            ArrayList<IRuntime> toRemove = new ArrayList<IRuntime>();
            for (IRuntime r : this.targetedRuntimes) {
                if (this.targetableRuntimes.contains(r)) continue;
                toRemove.add(r);
            }
            this.targetedRuntimes.removeAll(toRemove);
            if (!toRemove.isEmpty()) {
                this.notifyListeners(EVENT_TARGETED_RUNTIMES_CHANGED);
                if (this.primaryRuntime != null && !this.targetableRuntimes.contains(this.primaryRuntime)) {
                    this.autoAssignPrimaryRuntime();
                }
            }
        }
    }

    public synchronized Set<IRuntime> getTargetedRuntimes() {
        return this.targetedRuntimes;
    }

    public synchronized void setTargetedRuntimes(Set<IRuntime> runtimes) {
        if (!this.targetedRuntimes.equals(runtimes)) {
            this.targetedRuntimes.clear();
            for (IRuntime r : runtimes) {
                if (!this.targetableRuntimes.contains(r)) continue;
                this.targetedRuntimes.add(r);
            }
            this.notifyListeners(EVENT_TARGETED_RUNTIMES_CHANGED);
            if (this.primaryRuntime == null || !this.targetedRuntimes.contains(this.primaryRuntime)) {
                this.autoAssignPrimaryRuntime();
            }
        }
    }

    public synchronized void addTargetedRuntime(IRuntime runtime) {
        if (runtime == null) {
            throw new NullPointerException();
        }
        this.targetedRuntimes.add(runtime);
        this.notifyListeners(EVENT_TARGETED_RUNTIMES_CHANGED);
        if (this.primaryRuntime == null) {
            this.primaryRuntime = runtime;
            this.notifyListeners(EVENT_PRIMARY_RUNTIME_CHANGED);
        }
    }

    public synchronized void removeTargetedRuntime(IRuntime runtime) {
        if (runtime == null) {
            throw new NullPointerException();
        }
        if (this.targetedRuntimes.remove(runtime)) {
            this.notifyListeners(EVENT_TARGETED_RUNTIMES_CHANGED);
            if (runtime.equals(this.primaryRuntime)) {
                this.autoAssignPrimaryRuntime();
            }
        }
    }

    public synchronized IRuntime getPrimaryRuntime() {
        return this.primaryRuntime;
    }

    public synchronized void setPrimaryRuntime(IRuntime runtime) {
        if (!ChangeTargetedRuntimesDataModel.equals(this.primaryRuntime, runtime)) {
            if (runtime == null && this.targetedRuntimes.size() > 0) {
                throw new IllegalArgumentException();
            }
            if (this.targetedRuntimes.contains(runtime)) {
                this.primaryRuntime = runtime;
            }
            this.notifyListeners(EVENT_PRIMARY_RUNTIME_CHANGED);
        }
    }

    private void autoAssignPrimaryRuntime() {
        this.primaryRuntime = this.targetedRuntimes.isEmpty() ? null : this.targetedRuntimes.iterator().next();
        this.notifyListeners(EVENT_PRIMARY_RUNTIME_CHANGED);
    }

    public void dispose() {
        RuntimeManager.removeRuntimeListener((IListener)this.runtimeManagerListener);
    }

    private static boolean equals(IRuntime r1, IRuntime r2) {
        if (r1 == null && r2 == null) {
            return true;
        }
        if (r1 == null || r2 == null) {
            return false;
        }
        return r1.equals(r2);
    }

    public static interface IRuntimeFilter {
        public boolean check(IRuntime var1);
    }
}

