/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.ui.wizards;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.update.internal.ui.UpdateUI;
import org.eclipse.update.internal.ui.model.SiteBookmark;
import org.eclipse.update.internal.ui.wizards.NewUpdateSiteDialog;

public class EditSiteDialog
extends NewUpdateSiteDialog {
    SiteBookmark bookmark;
    private int ignoreBookmark = -1;

    public EditSiteDialog(Shell parentShell, SiteBookmark bookmark) {
        super(parentShell);
        this.bookmark = bookmark;
    }

    public EditSiteDialog(Shell parentShell, SiteBookmark bookmark, SiteBookmark[] siteBookmarks) {
        super(parentShell, siteBookmarks);
        this.bookmark = bookmark;
        this.ignoreBookmark(siteBookmarks);
    }

    public EditSiteDialog(Shell parentShell, SiteBookmark bookmark, boolean enableOK) {
        super(parentShell, enableOK);
        this.bookmark = bookmark;
    }

    public EditSiteDialog(Shell parentShell, SiteBookmark bookmark, SiteBookmark[] siteBookmarks, boolean enableOK) {
        super(parentShell, enableOK, siteBookmarks);
        this.bookmark = bookmark;
        this.ignoreBookmark(siteBookmarks);
    }

    protected void initializeFields() {
        this.name.setText(this.bookmark.getName());
        this.url.setText(this.bookmark.getURL().toString());
        this.url.setEditable(!this.bookmark.isLocal());
    }

    protected void update() {
        try {
            this.bookmark.setName(this.name.getText());
            this.bookmark.setURL(new URL(this.url.getText()));
            UpdateUI.getDefault().getUpdateModel().fireObjectChanged(this.bookmark, null);
        }
        catch (MalformedURLException malformedURLException) {}
    }

    private void ignoreBookmark(SiteBookmark[] siteBookmarks) {
        int i = 0;
        while (i < siteBookmarks.length) {
            if (siteBookmarks[i].getLabel().equals(this.bookmark.getLabel().trim()) && siteBookmarks[i].getURL().equals(this.bookmark.getURL())) {
                this.ignoreBookmark = i;
                return;
            }
            ++i;
        }
    }

    protected boolean isCurrentlyEditedSiteBookmark(int index) {
        return index == this.ignoreBookmark;
    }
}

