/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.web.ui.internal.hyperlink;

import com.ibm.icu.util.StringTokenizer;
import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetector;
import org.eclipse.jface.text.hyperlink.URLHyperlink;
import org.eclipse.wst.common.uriresolver.internal.provisional.URIResolverPlugin;
import org.eclipse.wst.jsdt.web.ui.internal.hyperlink.ExternalFileHyperlink;
import org.eclipse.wst.jsdt.web.ui.internal.hyperlink.WorkspaceFileHyperlink;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.utils.StringUtils;
import org.eclipse.wst.xml.core.internal.contentmodel.CMAttributeDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.CMElementDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.modelquery.ModelQuery;
import org.eclipse.wst.xml.core.internal.contentmodel.util.DOMNamespaceHelper;
import org.eclipse.wst.xml.core.internal.modelquery.ModelQueryUtil;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMAttr;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class XMLHyperlinkDetector
implements IHyperlinkDetector {
    private final String HTTP_PROTOCOL = "http://";
    private final String NO_NAMESPACE_SCHEMA_LOCATION = "noNamespaceSchemaLocation";
    private final String SCHEMA_LOCATION = "schemaLocation";
    private final String XMLNS = "xmlns";
    private final String XSI_NAMESPACE_URI = "http://www.w3.org/2001/XMLSchema-instance";

    private IHyperlink createHyperlink(String string, IRegion iRegion, IDocument iDocument, Node node) {
        Object object = null;
        if (this.isHttp(string)) {
            object = new URLHyperlink(iRegion, string);
        } else {
            File file = this.getFileFromUriString(string);
            if (file != null) {
                String string2 = file.getPath();
                IFile iFile = this.getFile(string2);
                object = iFile != null ? new WorkspaceFileHyperlink(iRegion, iFile) : new ExternalFileHyperlink(iRegion, file);
            }
        }
        return object;
    }

    public IHyperlink[] detectHyperlinks(ITextViewer iTextViewer, IRegion iRegion, boolean bl) {
        IDocument iDocument;
        Node node;
        ArrayList<IHyperlink> arrayList = new ArrayList<IHyperlink>(0);
        if (iRegion != null && iTextViewer != null && (node = this.getCurrentNode(iDocument = iTextViewer.getDocument(), iRegion.getOffset())) != null) {
            IHyperlink iHyperlink;
            Attr attr;
            String string = null;
            if (node.getNodeType() == 10) {
                string = this.getURIString(node, iDocument);
            } else if (node.getNodeType() == 1) {
                attr = this.getCurrentAttrNode(node, iRegion.getOffset());
                if (!(attr == null || (string = this.getURIString(attr, iDocument)) != null && this.isValidURI(string))) {
                    attr = null;
                }
                if (attr == null && (attr = this.getLinkableAttr((Element)node)) != null) {
                    string = this.getURIString(attr, iDocument);
                }
                node = attr;
            }
            if (string != null && node != null && this.isValidURI(string) && (iHyperlink = this.createHyperlink(string, (IRegion)(attr = this.getHyperlinkRegion(node)), iDocument, node)) != null) {
                arrayList.add(iHyperlink);
            }
        }
        if (arrayList.size() == 0) {
            return null;
        }
        return arrayList.toArray(new IHyperlink[0]);
    }

    /*
     * Exception decompiling
     */
    private String getBaseLocation(IDocument var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 148->151)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private CMElementDeclaration getCMElementDeclaration(Element element) {
        CMElementDeclaration cMElementDeclaration = null;
        ModelQuery modelQuery = ModelQueryUtil.getModelQuery((Document)element.getOwnerDocument());
        if (modelQuery != null) {
            cMElementDeclaration = modelQuery.getCMElementDeclaration(element);
        }
        return cMElementDeclaration;
    }

    private Attr getCurrentAttrNode(Node node, int n) {
        if (node instanceof IndexedRegion && ((IndexedRegion)node).contains(n) && node.hasAttributes()) {
            NamedNodeMap namedNodeMap = node.getAttributes();
            int n2 = 0;
            while (n2 < namedNodeMap.getLength()) {
                IndexedRegion indexedRegion = (IndexedRegion)namedNodeMap.item(n2);
                if (indexedRegion.contains(n)) {
                    return (Attr)namedNodeMap.item(n2);
                }
                ++n2;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Node getCurrentNode(IDocument iDocument, int n) {
        IndexedRegion indexedRegion;
        block6: {
            indexedRegion = null;
            IStructuredModel iStructuredModel = null;
            try {
                iStructuredModel = StructuredModelManager.getModelManager().getExistingModelForRead(iDocument);
                indexedRegion = iStructuredModel.getIndexedRegion(n);
                if (indexedRegion == null) {
                    indexedRegion = iStructuredModel.getIndexedRegion(n - 1);
                }
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                if (iStructuredModel != null) {
                    iStructuredModel.releaseFromRead();
                }
                throw throwable;
            }
            {
                Object var5_7 = null;
                if (iStructuredModel == null) break block6;
            }
            iStructuredModel.releaseFromRead();
        }
        if (indexedRegion instanceof Node) {
            return (Node)indexedRegion;
        }
        return null;
    }

    private IFile getFile(String string) {
        IFile iFile = null;
        if (string != null) {
            IFile[] iFileArray = ResourcesPlugin.getWorkspace().getRoot().findFilesForLocation((IPath)new Path(string));
            int n = 0;
            while (n < iFileArray.length && iFile == null) {
                if (iFileArray[n].exists()) {
                    iFile = iFileArray[n];
                }
                ++n;
            }
        }
        return iFile;
    }

    private File getFileFromUriString(String string) {
        File file = null;
        try {
            file = new File(string);
            URI uRI = new URI(string);
            file = new File(uRI);
        }
        catch (Exception exception) {}
        return file;
    }

    private IRegion getHyperlinkRegion(Node node) {
        Region region = null;
        if (node != null) {
            short s = node.getNodeType();
            if (s == 10) {
                IDOMNode iDOMNode = (IDOMNode)node;
                region = new Region(iDOMNode.getStartOffset(), iDOMNode.getEndOffset() - iDOMNode.getStartOffset());
            } else if (s == 2) {
                IDOMAttr iDOMAttr = (IDOMAttr)node;
                int n = iDOMAttr.getValueRegionStartOffset();
                ITextRegion iTextRegion = iDOMAttr.getValueRegion();
                if (iTextRegion != null) {
                    int n2 = iTextRegion.getTextLength();
                    String string = iDOMAttr.getValueRegionText();
                    if (StringUtils.isQuoted((String)string)) {
                        ++n;
                        n2 -= 2;
                    }
                    region = new Region(n, n2);
                }
            }
        }
        return region;
    }

    private Attr getLinkableAttr(Element element) {
        CMElementDeclaration cMElementDeclaration = this.getCMElementDeclaration(element);
        NamedNodeMap namedNodeMap = element.getAttributes();
        int n = 0;
        while (n < namedNodeMap.getLength()) {
            Attr attr = (Attr)namedNodeMap.item(n);
            if (this.isLinkableAttr(attr, cMElementDeclaration)) {
                return attr;
            }
            ++n;
        }
        return null;
    }

    private String getLocationHint(Element element, String string) {
        Attr attr = element.getAttributeNodeNS("http://www.w3.org/2001/XMLSchema-instance", "schemaLocation");
        if (attr != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(attr.getValue());
            while (stringTokenizer.hasMoreTokens()) {
                String string2;
                String string3 = stringTokenizer.hasMoreTokens() ? stringTokenizer.nextToken() : null;
                String string4 = string2 = stringTokenizer.hasMoreTokens() ? stringTokenizer.nextToken() : null;
                if (!string.equalsIgnoreCase(string3)) continue;
                return string2;
            }
        }
        return null;
    }

    private String getURIString(Node node, IDocument iDocument) {
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        short s = node.getNodeType();
        if (s == 10) {
            string2 = this.getBaseLocation(iDocument);
            string3 = ((DocumentType)node).getPublicId();
            string4 = ((DocumentType)node).getSystemId();
        } else if (s == 2) {
            Attr attr = (Attr)node;
            String string5 = attr.getName();
            String string6 = attr.getValue();
            if ((string6 = StringUtils.strip((String)string6)) != null && string6.length() > 0) {
                string2 = this.getBaseLocation(iDocument);
                String string7 = DOMNamespaceHelper.getPrefix((String)string5);
                String string8 = DOMNamespaceHelper.getUnprefixedName((String)string5);
                if ("xmlns".equals(string7) || "xmlns".equals(string8)) {
                    string3 = string6;
                    string4 = this.getLocationHint(attr.getOwnerElement(), string3);
                    if (string4 == null) {
                        string4 = string6;
                    }
                } else if ("http://www.w3.org/2001/XMLSchema-instance".equals(DOMNamespaceHelper.getNamespaceURI((Node)attr)) && "schemaLocation".equals(string8)) {
                    StringTokenizer stringTokenizer = new StringTokenizer(string6);
                    string3 = stringTokenizer.hasMoreTokens() ? stringTokenizer.nextToken() : null;
                    string4 = stringTokenizer.hasMoreTokens() ? stringTokenizer.nextToken() : null;
                } else {
                    string4 = string6;
                }
            }
        }
        string = this.resolveURI(string2, string3, string4);
        return string;
    }

    private boolean isHttp(String string) {
        String string2;
        boolean bl = false;
        if (string != null && (string2 = string.toLowerCase()).startsWith("http://")) {
            bl = true;
        }
        return bl;
    }

    private boolean isLinkableAttr(Attr attr, CMElementDeclaration cMElementDeclaration) {
        CMAttributeDeclaration cMAttributeDeclaration;
        String string = attr.getName();
        String string2 = DOMNamespaceHelper.getPrefix((String)string);
        String string3 = DOMNamespaceHelper.getUnprefixedName((String)string);
        if ("xmlns".equals(string2) || "xmlns".equals(string3)) {
            return true;
        }
        if ("http://www.w3.org/2001/XMLSchema-instance".equals(DOMNamespaceHelper.getNamespaceURI((Node)attr)) && ("schemaLocation".equals(string3) || "noNamespaceSchemaLocation".equals(string3))) {
            return true;
        }
        return cMElementDeclaration != null && (cMAttributeDeclaration = (CMAttributeDeclaration)cMElementDeclaration.getAttributes().getNamedItem(string)) != null && cMAttributeDeclaration.getAttrType() != null && "URI".equals(cMAttributeDeclaration.getAttrType().getDataTypeName());
    }

    private boolean isValidURI(String string) {
        boolean bl = false;
        if (this.isHttp(string)) {
            bl = true;
        } else {
            File file = this.getFileFromUriString(string);
            if (file != null) {
                bl = file.isFile();
            }
        }
        return bl;
    }

    private String resolveURI(String string, String string2, String string3) {
        if (string == null && string2 == null && string3 == null) {
            return null;
        }
        return URIResolverPlugin.createResolver().resolve(string, string2, string3);
    }
}

