/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.jsdoc;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.StringTokenizer;
import org.eclipse.wst.jsdt.jsdoc.MappingException;
import org.eclipse.wst.jsdt.jsdoc.XSLTMap;

public class Util {
    public static final String XSL_HEADER = "<?xml version=\"1.0\"?> <xsl:stylesheet xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\" version=\"1.0\">";
    public static final String XSL_FOOTER = "</xsl:stylesheet>";
    public static final String NEW_LINE = System.getProperty("line.separator");
    private static final String BUFFER_DIR = "./webCache";
    public static final boolean VERBOSE = true;

    private static File getTempDir() {
        File file = new File(BUFFER_DIR);
        if (file.exists()) {
            return file;
        }
        file.mkdir();
        return file;
    }

    public static String retrieveFromUrl(String string, boolean bl, boolean bl2) throws IOException {
        String string2;
        System.gc();
        String string3 = String.valueOf(Util.getTempDir().getAbsolutePath()) + "\\" + Util.toUniqueFileName(string);
        String string4 = null;
        if (bl) {
            try {
                string4 = Util.fileToString(string3);
            }
            catch (IOException iOException) {}
            if (string4 != null) {
                return string4;
            }
        }
        StringBuffer stringBuffer = new StringBuffer();
        URL uRL = new URL(string);
        URLConnection uRLConnection = uRL.openConnection();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(uRLConnection.getInputStream()));
        while ((string2 = bufferedReader.readLine()) != null) {
            stringBuffer.append(string2);
        }
        bufferedReader.close();
        if (bl) {
            System.out.println("Caching URL.. " + string);
            Util.stringToFile(stringBuffer.toString(), string3, false, bl2);
        }
        return stringBuffer.toString();
    }

    public static String toUniqueFileName(String string) {
        String string2 = string.replace('/', '_');
        string2 = string2.replace('\\', '_');
        string2 = string2.replace(':', '_');
        string2 = string2.replace('#', '_');
        string2 = string2.replace('?', '_');
        string2 = string2.replace('%', '_');
        string2 = string2.replace('=', '_');
        string2 = string2.replace('&', '_');
        string2 = string2.replace(';', '_');
        string2 = string2.replace('(', '_');
        string2 = string2.replace(')', '_');
        string2 = string2.replace('\'', '_');
        string2 = string2.replace(',', '_');
        string2 = string2.replace('$', '_');
        return string2;
    }

    public static String retrieveFromUrlFixEncode(String string, boolean bl, boolean bl2) throws IOException {
        String string2 = "ISO-8859-1";
        String string3 = Util.retrieveFromUrl(string, bl, bl2);
        string3 = string3.replaceAll("UTF-8", string2);
        string3 = string3.replaceAll("UTF-16", string2);
        return string3;
    }

    public static String applyTranslation(String string, File file) throws MappingException {
        XSLTMap xSLTMap = new XSLTMap(file);
        return xSLTMap.applyMap(string);
    }

    public static File dataToTempFile(String string) {
        File file = null;
        try {
            file = File.createTempFile(String.valueOf(System.currentTimeMillis()) + "_tmp", ".tmp");
            file.deleteOnExit();
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));
            bufferedWriter.write(string);
            bufferedWriter.close();
        }
        catch (IOException iOException) {}
        return file;
    }

    public static String fileToString(String string) throws IOException {
        System.gc();
        File file = new File(string);
        FileInputStream fileInputStream = new FileInputStream(file);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(fileInputStream));
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = null;
        while ((string2 = bufferedReader.readLine()) != null) {
            stringBuffer.append(string2);
        }
        fileInputStream.close();
        bufferedReader.close();
        return stringBuffer.toString();
    }

    public static File stringToFile(String string, String string2, boolean bl, boolean bl2) {
        File file = null;
        System.gc();
        try {
            file = new File(string2);
            if (bl2) {
                file.deleteOnExit();
            }
            FileWriter fileWriter = new FileWriter(file, bl);
            BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
            StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
            String string3 = null;
            while (stringTokenizer.hasMoreTokens()) {
                string3 = stringTokenizer.nextToken();
                if (bl) {
                    bufferedWriter.append(string3);
                    continue;
                }
                bufferedWriter.write(string3);
            }
            bufferedWriter.close();
        }
        catch (IOException iOException) {}
        return file;
    }

    public static String getBaseUrl(String string) {
        int n = string.lastIndexOf(47);
        if (n < 0) {
            return string;
        }
        return string.substring(0, n);
    }
}

