/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.atf.project;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.atf.runtime.IRuntime;
import org.eclipse.atf.runtime.IRuntimeInstance;
import org.eclipse.atf.runtime.RuntimeInstance;
import org.eclipse.atf.runtime.RuntimeManager;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.helpers.DefaultHandler;

public class ProjectUtils {
    private static final String EL_TOOLKIT = "toolkit";
    private static final String ATTR_TYPE = "type";
    private static final String ATTR_VERSION = "version";
    private static final String ATTR_NAME = "name";
    private static final String SETTINGS_FILE = ".settings/org.eclipse.atf.settings.xml";

    public static void saveSettings(IProject iProject, Object[] objectArray) throws CoreException {
        byte[] byArray;
        Object object;
        IFile iFile = iProject.getFile(SETTINGS_FILE);
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        String string = System.getProperty("line.separator");
        printWriter.print("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        printWriter.print(string);
        printWriter.print("<atf-settings>");
        printWriter.print(string);
        int n = 0;
        while (n < objectArray.length) {
            object = (IRuntimeInstance)objectArray[n];
            printWriter.print("  <toolkit type=\"");
            printWriter.print(object.getType().getId());
            printWriter.print("\" version=\"");
            printWriter.print(object.getVersion());
            printWriter.print("\" name=\"");
            printWriter.print(object.getName());
            printWriter.print("\"/>");
            printWriter.print(string);
            ++n;
        }
        printWriter.print("</atf-settings>");
        printWriter.print(string);
        try {
            byArray = stringWriter.getBuffer().toString().getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException);
        }
        object = new ByteArrayInputStream(byArray);
        if (iFile.exists()) {
            ProjectUtils.validateEdit(new IFile[]{iFile});
            iFile.setContents((InputStream)object, true, false, null);
        } else {
            IFolder iFolder = (IFolder)iFile.getParent();
            if (!iFolder.exists()) {
                iFolder.create(true, true, null);
            }
            iFile.create((InputStream)object, true, null);
        }
    }

    private static void validateEdit(IFile[] iFileArray) throws CoreException {
        IWorkspace iWorkspace = ResourcesPlugin.getWorkspace();
        IStatus iStatus = iWorkspace.validateEdit(iFileArray, IWorkspace.VALIDATE_PROMPT);
        if (iStatus.getSeverity() == 4) {
            throw new CoreException(iStatus);
        }
    }

    public static Object[] loadSettings(IProject iProject) throws CoreException {
        Serializable serializable;
        Object object;
        IFile iFile = iProject.getFile(SETTINGS_FILE);
        if (!iFile.exists()) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.atf.core", 4, "No settings found for project.", null));
        }
        Element element = null;
        try {
            object = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            ((DocumentBuilder)object).setErrorHandler(new DefaultHandler());
            serializable = iFile.getLocation().toFile();
            element = ((DocumentBuilder)object).parse((File)serializable).getDocumentElement();
        }
        catch (Exception exception) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.atf.core", 4, "Could not parse settings.", (Throwable)exception));
        }
        object = element.getChildNodes();
        serializable = new ArrayList();
        int n = 0;
        int n2 = object.getLength();
        while (n < n2) {
            Element element2;
            String string;
            Node node = object.item(n);
            if (node.getNodeType() == 1 && (string = (element2 = (Element)node).getNodeName()).equals(EL_TOOLKIT)) {
                String string2 = element2.getAttribute(ATTR_TYPE);
                IRuntime iRuntime = RuntimeManager.getInstance().getRuntime(string2);
                RuntimeInstance runtimeInstance = new RuntimeInstance();
                runtimeInstance.setType(iRuntime);
                runtimeInstance.setVersion(element2.getAttribute(ATTR_VERSION));
                runtimeInstance.setName(element2.getAttribute(ATTR_NAME));
                ((ArrayList)serializable).add(runtimeInstance);
            }
            ++n;
        }
        if (!((ArrayList)serializable).isEmpty()) {
            return ((ArrayList)serializable).toArray();
        }
        throw new CoreException((IStatus)new Status(4, "org.eclipse.atf.core", 4, "No settings found for project.", null));
    }
}

