/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.atf.runtime;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.atf.runtime.IRuntime;
import org.eclipse.atf.runtime.IRuntimeInstance;
import org.eclipse.atf.runtime.RuntimeInstance;
import org.eclipse.atf.runtime.installer.FileCopyRuntimeInstaller;
import org.eclipse.atf.runtime.installer.IRuntimeInstaller;
import org.eclipse.atf.runtime.validator.IRuntimeValidator;
import org.eclipse.atf.runtime.version.IVersionFinder;

public class Runtime
implements IRuntime {
    protected String id = null;
    protected String name = null;
    protected IRuntimeInstaller installer = null;
    protected IRuntimeValidator validator = null;
    protected IVersionFinder versionFinder = null;
    protected boolean allowUserInstances = true;
    protected boolean isUser = false;
    protected List instanceList = new ArrayList(2);

    public Runtime(String string, String string2) {
        this.id = string;
        this.name = string2;
        this.installer = new FileCopyRuntimeInstaller();
    }

    public String getId() {
        return this.id;
    }

    public void setId(String string) {
        if (this.isUser) {
            this.id = string;
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        if (this.isUser) {
            this.name = string;
        }
    }

    public void addInstance(RuntimeInstance runtimeInstance) {
        runtimeInstance.setType(this);
        this.instanceList.add(runtimeInstance);
    }

    public void removeInstance(RuntimeInstance runtimeInstance) {
        this.instanceList.remove(runtimeInstance);
        runtimeInstance.setType(null);
    }

    public IRuntimeInstance[] getRuntimeInstances() {
        return this.instanceList.toArray(new IRuntimeInstance[0]);
    }

    public IRuntimeInstaller getInstaller() {
        return this.installer;
    }

    public void setInstaller(IRuntimeInstaller iRuntimeInstaller) {
        this.installer = iRuntimeInstaller;
    }

    public IRuntimeValidator getValidator() {
        return this.validator;
    }

    public void setValidator(IRuntimeValidator iRuntimeValidator) {
        this.validator = iRuntimeValidator;
    }

    public IVersionFinder getVersionFinder() {
        return this.versionFinder;
    }

    public void setVersionFinder(IVersionFinder iVersionFinder) {
        this.versionFinder = iVersionFinder;
    }

    public boolean isAllowUserInstances() {
        return this.allowUserInstances;
    }

    public void setAllowUserInstances(boolean bl) {
        this.allowUserInstances = bl;
    }

    public boolean isUser() {
        return this.isUser;
    }

    public void setIsUser(boolean bl) {
        this.isUser = bl;
    }
}

