/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.edit.ui.util;

import java.lang.reflect.Method;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.common.ui.URIEditorInput;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.ui.EMFEditUIPlugin;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IURIEditorInput;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;
import org.osgi.framework.Bundle;

public class EditUIUtil {
    public static boolean openEditor(EObject eObject) throws PartInitException {
        URI uri;
        Resource resource;
        if (eObject != null && (resource = eObject.eResource()) != null && (uri = resource.getURI()) != null) {
            URIEditorInput editorInput = null;
            if (uri.isPlatformResource()) {
                String path = uri.toPlatformString(true);
                IResource workspaceResource = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)new Path(path));
                if (workspaceResource instanceof IFile) {
                    editorInput = EclipseUtil.createFileEditorInput((IFile)workspaceResource);
                }
            } else {
                editorInput = new URIEditorInput(uri);
            }
            if (editorInput != null) {
                IWorkbench workbench = PlatformUI.getWorkbench();
                IWorkbenchPage page = workbench.getActiveWorkbenchWindow().getActivePage();
                IEditorPart editorPart = page.openEditor((IEditorInput)editorInput, workbench.getEditorRegistry().getDefaultEditor(uri.lastSegment()).getId());
                return editorPart != null;
            }
        }
        return false;
    }

    public static URI getURI(IEditorInput editorInput) {
        URI result = null;
        if (EMFPlugin.IS_ECLIPSE_RUNNING) {
            result = EclipseUtil.getURI(editorInput);
        }
        if (result == null) {
            result = editorInput instanceof URIEditorInput ? ((URIEditorInput)editorInput).getURI().trimFragment() : URI.createURI((String)editorInput.getName());
        }
        return result;
    }

    private static class EclipseUtil {
        static final Class<?> FILE_CLASS;
        static final Class<?> FILE_REVISION_CLASS;
        static final Method FILE_REVISION_GET_URI_METHOD;
        static final Class<?> URI_EDITOR_INPUT_CLASS;

        static {
            Class<IFile> fileClass = null;
            try {
                fileClass = IFile.class;
            }
            catch (Throwable throwable) {}
            FILE_CLASS = fileClass;
            Class fileRevisionClass = null;
            Method fileRevisionGetURIMethod = null;
            Bundle bundle = Platform.getBundle((String)"org.eclipse.team.core");
            if (bundle != null && (bundle.getState() & 0x2C) != 0) {
                try {
                    fileRevisionClass = bundle.loadClass("org.eclipse.team.core.history.IFileRevision");
                    fileRevisionGetURIMethod = fileRevisionClass.getMethod("getURI", new Class[0]);
                }
                catch (Throwable throwable) {}
            }
            FILE_REVISION_CLASS = fileRevisionClass;
            FILE_REVISION_GET_URI_METHOD = fileRevisionGetURIMethod;
            Class<IURIEditorInput> uriEditorInputClass = null;
            try {
                uriEditorInputClass = IURIEditorInput.class;
            }
            catch (Throwable throwable) {}
            URI_EDITOR_INPUT_CLASS = uriEditorInputClass;
        }

        private EclipseUtil() {
        }

        public static URI getURI(IEditorInput editorInput) {
            Object fileRevision;
            IFile file;
            if (FILE_CLASS != null && (file = (IFile)editorInput.getAdapter(FILE_CLASS)) != null) {
                return URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)true);
            }
            if (FILE_REVISION_CLASS != null && (fileRevision = editorInput.getAdapter(FILE_REVISION_CLASS)) != null) {
                try {
                    return URI.createURI((String)((java.net.URI)FILE_REVISION_GET_URI_METHOD.invoke(fileRevision, new Object[0])).toString());
                }
                catch (Throwable exception) {
                    EMFEditUIPlugin.INSTANCE.log(exception);
                }
            }
            if (URI_EDITOR_INPUT_CLASS != null && editorInput instanceof IURIEditorInput) {
                return URI.createURI((String)((IURIEditorInput)editorInput).getURI().toString()).trimFragment();
            }
            return null;
        }

        public static IEditorInput createFileEditorInput(IFile file) {
            return new FileEditorInput(file);
        }
    }
}

