/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.wizards;

import org.eclipse.compare.structuremergeviewer.IDiffElement;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.synchronize.SyncInfo;
import org.eclipse.team.core.synchronize.SyncInfoSet;
import org.eclipse.team.internal.ccvs.ui.CVSUIMessages;
import org.eclipse.team.internal.ccvs.ui.CVSUIPlugin;
import org.eclipse.team.internal.ccvs.ui.CommitCommentArea;
import org.eclipse.team.internal.ccvs.ui.wizards.CommitWizard;
import org.eclipse.team.internal.ccvs.ui.wizards.CommitWizardParticipant;
import org.eclipse.team.internal.core.subscribers.ActiveChangeSet;
import org.eclipse.team.internal.core.subscribers.ChangeSet;
import org.eclipse.team.internal.ui.PixelConverter;
import org.eclipse.team.internal.ui.SWTUtils;
import org.eclipse.team.internal.ui.Utils;
import org.eclipse.team.internal.ui.synchronize.SyncInfoModelElement;
import org.eclipse.team.ui.synchronize.ISynchronizeModelElement;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;
import org.eclipse.team.ui.synchronize.ISynchronizeParticipant;
import org.eclipse.team.ui.synchronize.ParticipantPagePane;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.PageBook;

public class CommitWizardCommitPage
extends WizardPage
implements IPropertyChangeListener {
    private final CommitCommentArea fCommentArea;
    private ISynchronizePageConfiguration fConfiguration;
    protected final CommitWizard fWizard;
    private ParticipantPagePane fPagePane;
    private PageBook bottomChild;

    public CommitWizardCommitPage(IResource[] resources, CommitWizard wizard) {
        super(CVSUIMessages.CommitWizardCommitPage_0);
        this.setTitle(CVSUIMessages.CommitWizardCommitPage_0);
        this.setDescription(CVSUIMessages.CommitWizardCommitPage_2);
        this.fWizard = wizard;
        this.fCommentArea = new CommitCommentArea();
        this.fCommentArea.setProposedComment(this.getProposedComment(resources));
        if (resources.length > 0) {
            this.fCommentArea.setProject(resources[0].getProject());
        }
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Dialog.applyDialogFont((Control)parent);
        PixelConverter converter = new PixelConverter((Control)parent);
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)SWTUtils.createGridLayout((int)1, (PixelConverter)converter, (int)-1));
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.eclipse.team.cvs.ui.commit_comment_page_context");
        this.createCommentArea(composite, converter);
        this.createChangesArea(composite, converter);
        Dialog.applyDialogFont((Control)parent);
        this.setControl((Control)composite);
        this.fCommentArea.setFocus();
        this.validatePage(false);
    }

    private void createCommentArea(Composite parent, PixelConverter converter) {
        this.fCommentArea.createArea(parent);
        this.fCommentArea.getComposite().setLayoutData((Object)SWTUtils.createGridData((int)-1, (int)-1, (int)4, (int)4, (boolean)true, (boolean)true));
        this.fCommentArea.addPropertyChangeListener(this);
        this.createPlaceholder(parent);
    }

    private void createChangesArea(Composite parent, PixelConverter converter) {
        CommitWizardParticipant participant = this.fWizard.getParticipant();
        int size = participant.getSyncInfoSet().size();
        if (size > this.getFileDisplayThreshold()) {
            this.bottomChild = new PageBook(parent, 0);
            this.bottomChild.setLayoutData((Object)SWTUtils.createGridData((int)-1, (int)-1, (int)4, (int)4, (boolean)true, (boolean)false));
            Composite changeDesc = new Composite((Composite)this.bottomChild, 0);
            changeDesc.setLayout((Layout)SWTUtils.createGridLayout((int)1, (PixelConverter)converter, (int)0));
            SWTUtils.createLabel((Composite)changeDesc, (String)NLS.bind((String)CVSUIMessages.CommitWizardCommitPage_1, (Object[])new String[]{Integer.toString(size), Integer.toString(this.getFileDisplayThreshold())}));
            Button showChanges = new Button(changeDesc, 8);
            showChanges.setText(CVSUIMessages.CommitWizardCommitPage_5);
            showChanges.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    CommitWizardCommitPage.this.showChangesPane();
                }
            });
            showChanges.setLayoutData((Object)new GridData());
            this.bottomChild.showPage((Control)changeDesc);
        } else {
            Composite composite = new Composite(parent, 0);
            composite.setLayout((Layout)SWTUtils.createGridLayout((int)1, (PixelConverter)converter, (int)0));
            composite.setLayoutData((Object)SWTUtils.createGridData((int)-1, (int)-1, (int)4, (int)4, (boolean)true, (boolean)true));
            this.createPlaceholder(composite);
            Control c = this.createChangesPage(composite, participant);
            c.setLayoutData((Object)SWTUtils.createHVFillGridData());
        }
    }

    protected void showChangesPane() {
        Control c = this.createChangesPage((Composite)this.bottomChild, this.fWizard.getParticipant());
        this.bottomChild.setLayoutData((Object)SWTUtils.createGridData((int)-1, (int)-1, (int)4, (int)4, (boolean)true, (boolean)true));
        this.bottomChild.showPage(c);
        Dialog.applyDialogFont((Control)this.getControl());
        ((Composite)this.getControl()).layout();
    }

    private Control createChangesPage(Composite composite, CommitWizardParticipant participant) {
        this.fConfiguration = participant.createPageConfiguration();
        this.fPagePane = new ParticipantPagePane(this.getShell(), true, this.fConfiguration, (ISynchronizeParticipant)participant);
        Control control = this.fPagePane.createPartControl(composite);
        return control;
    }

    private int getFileDisplayThreshold() {
        return CVSUIPlugin.getPlugin().getPreferenceStore().getInt("pref_commit_files_display_threshold");
    }

    public void dispose() {
        super.dispose();
        if (this.fPagePane != null) {
            this.fPagePane.dispose();
        }
    }

    private void createPlaceholder(Composite composite) {
        Composite placeholder = new Composite(composite, 0);
        placeholder.setLayoutData((Object)new GridData(-1, this.convertHorizontalDLUsToPixels(4) / 3));
    }

    public String getComment(Shell shell) {
        return this.fCommentArea.getCommentWithPrompt(shell);
    }

    public boolean isPageComplete() {
        String comment;
        IPreferenceStore store = CVSUIPlugin.getPlugin().getPreferenceStore();
        String allowEmptyComment = store.getString("pref_allow_empty_commit_comment");
        if (allowEmptyComment.equals("never") && (comment = this.fCommentArea.getComment(false)).equals("")) {
            return false;
        }
        return super.isPageComplete();
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        this.expand();
        this.fCommentArea.setFocus();
    }

    protected void expand() {
        Viewer viewer;
        if (this.fConfiguration != null && (viewer = this.fConfiguration.getPage().getViewer()) instanceof TreeViewer) {
            try {
                viewer.getControl().setRedraw(false);
                ((TreeViewer)viewer).expandAll();
            }
            finally {
                viewer.getControl().setRedraw(true);
            }
        }
    }

    protected void updateForModelChange() {
        Control control = this.getControl();
        if (control == null || control.isDisposed()) {
            return;
        }
        this.expand();
        this.updateEnablements();
    }

    public void updateEnablements() {
        if (this.fConfiguration != null) {
            SyncInfoSet set = this.fConfiguration.getSyncInfoSet();
            if (set.hasConflicts()) {
                this.setErrorMessage(CVSUIMessages.CommitWizardCommitPage_4);
                this.setPageComplete(false);
                return;
            }
            if (set.isEmpty()) {
                this.setErrorMessage(null);
                this.setPageComplete(false);
                return;
            }
        }
        this.setErrorMessage(null);
        this.setPageComplete(true);
    }

    boolean validatePage(boolean setMessage) {
        IPreferenceStore store;
        String value;
        if (this.fCommentArea != null && this.fCommentArea.getComment(false).length() == 0 && "never".equals(value = (store = CVSUIPlugin.getPlugin().getPreferenceStore()).getString("pref_allow_empty_commit_comment"))) {
            this.setPageComplete(false);
            if (setMessage) {
                this.setErrorMessage(CVSUIMessages.CommitWizardCommitPage_3);
            }
            return false;
        }
        this.setPageComplete(true);
        this.setErrorMessage(null);
        return true;
    }

    public void setFocus() {
        this.fCommentArea.setFocus();
        this.validatePage(true);
    }

    protected IWizardContainer getContainer() {
        return super.getContainer();
    }

    public SyncInfoSet getInfosToCommit() {
        SyncInfoSet infos = new SyncInfoSet();
        if (this.fConfiguration == null) {
            return this.fWizard.getParticipant().getSyncInfoSet();
        }
        ISynchronizeModelElement root = (ISynchronizeModelElement)this.fConfiguration.getProperty("org.eclipse.team.ui.P_MODEL");
        IDiffElement[] elements = Utils.getDiffNodes((Object[])new IDiffElement[]{root});
        int i = 0;
        while (i < elements.length) {
            SyncInfo syncInfo;
            int direction;
            if (elements[i] instanceof SyncInfoModelElement && ((direction = (syncInfo = ((SyncInfoModelElement)elements[i]).getSyncInfo()).getKind() & 0xC) == 4 || direction == 12)) {
                infos.add(syncInfo);
            }
            ++i;
        }
        return infos;
    }

    public void propertyChange(PropertyChangeEvent event) {
        IWizardContainer container;
        if (event.getProperty().equals("OkRequested") && (container = this.getContainer()) instanceof WizardDialog) {
            WizardDialog dialog = (WizardDialog)container;
            if (this.getWizard().canFinish()) {
                try {
                    this.getWizard().performFinish();
                }
                finally {
                    dialog.close();
                }
            }
        }
        if (event.getProperty().equals("CommentModified")) {
            this.validatePage(true);
        }
    }

    private String getProposedComment(IResource[] resourcesToCommit) {
        StringBuffer comment = new StringBuffer();
        ChangeSet[] sets = CVSUIPlugin.getPlugin().getChangeSetManager().getSets();
        int numMatchedSets = 0;
        int i = 0;
        while (i < sets.length) {
            ChangeSet set = sets[i];
            if (this.isUserSet(set) && this.containsOne(set, resourcesToCommit)) {
                if (numMatchedSets > 0) {
                    comment.append(System.getProperty("line.separator"));
                }
                comment.append(set.getComment());
                ++numMatchedSets;
            }
            ++i;
        }
        return comment.toString();
    }

    private boolean isUserSet(ChangeSet set) {
        if (set instanceof ActiveChangeSet) {
            ActiveChangeSet acs = (ActiveChangeSet)set;
            return acs.isUserCreated();
        }
        return false;
    }

    private boolean containsOne(ChangeSet set, IResource[] resourcesToCommit) {
        int j = 0;
        while (j < resourcesToCommit.length) {
            ActiveChangeSet acs;
            IResource resource = resourcesToCommit[j];
            if (set.contains(resource)) {
                return true;
            }
            if (set instanceof ActiveChangeSet && (acs = (ActiveChangeSet)set).getDiffTree().members(resource).length > 0) {
                return true;
            }
            ++j;
        }
        return false;
    }
}

