/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core;

import org.eclipse.wst.jsdt.core.Signature;
import org.eclipse.wst.jsdt.internal.core.util.KeyKind;
import org.eclipse.wst.jsdt.internal.core.util.KeyToSignature;

public final class BindingKey {
    private String key;

    public BindingKey(String string) {
        this.key = string;
    }

    public static String createArrayTypeBindingKey(String string, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        while (n-- > 0) {
            stringBuffer.append('[');
        }
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    public static String createParameterizedTypeBindingKey(String string, String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(Signature.getTypeErasure(string));
        stringBuffer.insert(stringBuffer.length() - 1, '<');
        int n = 0;
        int n2 = stringArray.length;
        while (n < n2) {
            String string2 = stringArray[n];
            stringBuffer.insert(stringBuffer.length() - 1, string2);
            ++n;
        }
        stringBuffer.insert(stringBuffer.length() - 1, '>');
        return stringBuffer.toString();
    }

    public static String createTypeBindingKey(String string) {
        return Signature.createTypeSignature(string.replace('.', '/'), true);
    }

    public static String createTypeVariableBindingKey(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string2);
        stringBuffer.append(':');
        stringBuffer.append('T');
        stringBuffer.append(string);
        stringBuffer.append(';');
        return stringBuffer.toString();
    }

    public static String createWilcardTypeBindingKey(String string, char c) {
        switch (c) {
            case '*': {
                return "*";
            }
            case '-': {
                return String.valueOf('-') + string;
            }
            case '+': {
                return String.valueOf('+') + string;
            }
        }
        return null;
    }

    public String[] getThrownExceptions() {
        KeyToSignature keyToSignature = new KeyToSignature(this.key, 3);
        keyToSignature.parse();
        return keyToSignature.getThrownExceptions();
    }

    public String[] getTypeArguments() {
        KeyToSignature keyToSignature = new KeyToSignature(this.key, 1);
        keyToSignature.parse();
        return keyToSignature.getTypeArguments();
    }

    public boolean isRawType() {
        KeyKind keyKind = new KeyKind(this.key);
        keyKind.parse();
        return (keyKind.flags & 0x1001) != 0;
    }

    public boolean isParameterizedType() {
        KeyKind keyKind = new KeyKind(this.key);
        keyKind.parse();
        return (keyKind.flags & 0x1000) != 0;
    }

    public boolean isParameterizedMethod() {
        KeyKind keyKind = new KeyKind(this.key);
        keyKind.parse();
        return (keyKind.flags & 0x1011) == 4113;
    }

    public String toSignature() {
        KeyToSignature keyToSignature = new KeyToSignature(this.key, 0);
        keyToSignature.parse();
        return keyToSignature.signature.toString();
    }

    public String toString() {
        return this.key;
    }
}

