/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core;

import java.io.PrintStream;
import java.io.PrintWriter;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.wst.jsdt.core.IJavaModelStatus;
import org.eclipse.wst.jsdt.internal.core.JavaModelStatus;

public class JavaModelException
extends CoreException {
    private static final long serialVersionUID = -760398656505871287L;
    CoreException nestedCoreException;

    public JavaModelException(Throwable throwable, int n) {
        this(new JavaModelStatus(n, throwable));
    }

    public JavaModelException(CoreException coreException) {
        super(coreException.getStatus());
        this.nestedCoreException = coreException;
    }

    public JavaModelException(IJavaModelStatus iJavaModelStatus) {
        super((IStatus)iJavaModelStatus);
    }

    public Throwable getException() {
        if (this.nestedCoreException == null) {
            return this.getStatus().getException();
        }
        return this.nestedCoreException;
    }

    public IJavaModelStatus getJavaModelStatus() {
        IStatus iStatus = this.getStatus();
        if (iStatus instanceof IJavaModelStatus) {
            return (IJavaModelStatus)iStatus;
        }
        return new JavaModelStatus(this.nestedCoreException);
    }

    public boolean isDoesNotExist() {
        IJavaModelStatus iJavaModelStatus = this.getJavaModelStatus();
        return iJavaModelStatus != null && iJavaModelStatus.isDoesNotExist();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printStackTrace(PrintStream printStream) {
        PrintStream printStream2 = printStream;
        synchronized (printStream2) {
            super.printStackTrace(printStream);
            Throwable throwable = this.getException();
            if (throwable != null) {
                printStream.print("Caused by: ");
                throwable.printStackTrace(printStream);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printStackTrace(PrintWriter printWriter) {
        PrintWriter printWriter2 = printWriter;
        synchronized (printWriter2) {
            super.printStackTrace(printWriter);
            Throwable throwable = this.getException();
            if (throwable != null) {
                printWriter.print("Caused by: ");
                throwable.printStackTrace(printWriter);
            }
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Java Model Exception: ");
        if (this.getException() != null) {
            if (this.getException() instanceof CoreException) {
                CoreException coreException = (CoreException)this.getException();
                stringBuffer.append("Core Exception [code ");
                stringBuffer.append(coreException.getStatus().getCode());
                stringBuffer.append("] ");
                stringBuffer.append(coreException.getStatus().getMessage());
            } else {
                stringBuffer.append(this.getException().toString());
            }
        } else {
            stringBuffer.append(this.getStatus().toString());
        }
        return stringBuffer.toString();
    }
}

