/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.dom;

import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.dom.BindingResolver;
import org.eclipse.wst.jsdt.core.dom.DefaultValuePairBinding;
import org.eclipse.wst.jsdt.core.dom.IAnnotationBinding;
import org.eclipse.wst.jsdt.core.dom.IBinding;
import org.eclipse.wst.jsdt.core.dom.IMemberValuePairBinding;
import org.eclipse.wst.jsdt.core.dom.ITypeBinding;
import org.eclipse.wst.jsdt.core.dom.MemberValuePairBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ElementValuePair;
import org.eclipse.wst.jsdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.wst.jsdt.internal.compiler.util.HashtableOfObject;

class AnnotationBinding
implements IAnnotationBinding {
    static final AnnotationBinding[] NoAnnotations = new AnnotationBinding[0];
    private org.eclipse.wst.jsdt.internal.compiler.lookup.AnnotationBinding internalAnnotation;
    private BindingResolver bindingResolver;

    AnnotationBinding(org.eclipse.wst.jsdt.internal.compiler.lookup.AnnotationBinding annotationBinding, BindingResolver bindingResolver) {
        if (annotationBinding == null) {
            throw new IllegalStateException();
        }
        this.internalAnnotation = annotationBinding;
        this.bindingResolver = bindingResolver;
    }

    public IAnnotationBinding[] getAnnotations() {
        return NoAnnotations;
    }

    public ITypeBinding getAnnotationType() {
        ITypeBinding iTypeBinding = this.bindingResolver.getTypeBinding(this.internalAnnotation.getAnnotationType());
        if (iTypeBinding == null || !iTypeBinding.isAnnotation()) {
            return null;
        }
        return iTypeBinding;
    }

    public IMemberValuePairBinding[] getDeclaredMemberValuePairs() {
        ElementValuePair[] elementValuePairArray = this.internalAnnotation.getElementValuePairs();
        int n = elementValuePairArray.length;
        IMemberValuePairBinding[] iMemberValuePairBindingArray = n == 0 ? MemberValuePairBinding.NoPair : new MemberValuePairBinding[n];
        int n2 = 0;
        while (n2 < n) {
            iMemberValuePairBindingArray[n2] = this.bindingResolver.getMemberValuePairBinding(elementValuePairArray[n2]);
            ++n2;
        }
        return iMemberValuePairBindingArray;
    }

    public IMemberValuePairBinding[] getAllMemberValuePairs() {
        int n;
        IMemberValuePairBinding[] iMemberValuePairBindingArray = this.getDeclaredMemberValuePairs();
        ReferenceBinding referenceBinding = this.internalAnnotation.getAnnotationType();
        if (referenceBinding == null) {
            return iMemberValuePairBindingArray;
        }
        MethodBinding[] methodBindingArray = referenceBinding.availableMethods();
        int n2 = n = methodBindingArray == null ? 0 : methodBindingArray.length;
        if (n == 0) {
            return iMemberValuePairBindingArray;
        }
        int n3 = iMemberValuePairBindingArray.length;
        if (n3 == n) {
            return iMemberValuePairBindingArray;
        }
        HashtableOfObject hashtableOfObject = new HashtableOfObject(n3);
        int n4 = 0;
        while (n4 < n3) {
            hashtableOfObject.put(((MemberValuePairBinding)iMemberValuePairBindingArray[n4]).internalName(), iMemberValuePairBindingArray[n4]);
            ++n4;
        }
        IMemberValuePairBinding[] iMemberValuePairBindingArray2 = new IMemberValuePairBinding[n];
        int n5 = 0;
        while (n5 < n) {
            Object object = hashtableOfObject.get(methodBindingArray[n5].selector);
            iMemberValuePairBindingArray2[n5] = object == null ? new DefaultValuePairBinding(methodBindingArray[n5], this.bindingResolver) : (IMemberValuePairBinding)object;
            ++n5;
        }
        return iMemberValuePairBindingArray2;
    }

    public IJavaElement getJavaElement() {
        ITypeBinding iTypeBinding = this.getAnnotationType();
        if (iTypeBinding == null) {
            return null;
        }
        return iTypeBinding.getJavaElement();
    }

    public String getKey() {
        return null;
    }

    public int getKind() {
        return 5;
    }

    public int getModifiers() {
        return 0;
    }

    public String getName() {
        ITypeBinding iTypeBinding = this.getAnnotationType();
        if (iTypeBinding == null) {
            return new String(this.internalAnnotation.getAnnotationType().sourceName());
        }
        return iTypeBinding.getName();
    }

    public boolean isDeprecated() {
        ReferenceBinding referenceBinding = this.internalAnnotation.getAnnotationType();
        if (referenceBinding == null) {
            return false;
        }
        return referenceBinding.isDeprecated();
    }

    public boolean isEqualTo(IBinding iBinding) {
        IMemberValuePairBinding[] iMemberValuePairBindingArray;
        if (this == iBinding) {
            return true;
        }
        if (iBinding.getKind() != 5) {
            return false;
        }
        IAnnotationBinding iAnnotationBinding = (IAnnotationBinding)iBinding;
        if (!this.getAnnotationType().isEqualTo(iAnnotationBinding.getAnnotationType())) {
            return false;
        }
        IMemberValuePairBinding[] iMemberValuePairBindingArray2 = this.getDeclaredMemberValuePairs();
        if (iMemberValuePairBindingArray2.length != (iMemberValuePairBindingArray = iAnnotationBinding.getDeclaredMemberValuePairs()).length) {
            return false;
        }
        int n = 0;
        int n2 = iMemberValuePairBindingArray2.length;
        while (n < n2) {
            if (!iMemberValuePairBindingArray2[n].isEqualTo(iMemberValuePairBindingArray[n])) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public boolean isRecovered() {
        return false;
    }

    public boolean isSynthetic() {
        return false;
    }

    public String toString() {
        ITypeBinding iTypeBinding = this.getAnnotationType();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('@');
        if (iTypeBinding != null) {
            stringBuffer.append(iTypeBinding.getName());
        }
        stringBuffer.append('(');
        IMemberValuePairBinding[] iMemberValuePairBindingArray = this.getDeclaredMemberValuePairs();
        int n = 0;
        int n2 = iMemberValuePairBindingArray.length;
        while (n < n2) {
            if (n != 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(iMemberValuePairBindingArray[n].toString());
            ++n;
        }
        stringBuffer.append(')');
        return stringBuffer.toString();
    }
}

