/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.dom;

import java.util.Iterator;
import java.util.List;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.core.compiler.CharOperation;
import org.eclipse.wst.jsdt.core.dom.ASTParser;
import org.eclipse.wst.jsdt.core.dom.Annotation;
import org.eclipse.wst.jsdt.core.dom.AnnotationBinding;
import org.eclipse.wst.jsdt.core.dom.BindingResolver;
import org.eclipse.wst.jsdt.core.dom.CompilationUnit;
import org.eclipse.wst.jsdt.core.dom.IAnnotationBinding;
import org.eclipse.wst.jsdt.core.dom.IBinding;
import org.eclipse.wst.jsdt.core.dom.IPackageBinding;
import org.eclipse.wst.jsdt.core.dom.PackageDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.env.INameEnvironment;
import org.eclipse.wst.jsdt.internal.compiler.util.Util;
import org.eclipse.wst.jsdt.internal.core.NameLookup;
import org.eclipse.wst.jsdt.internal.core.SearchableEnvironment;

class PackageBinding
implements IPackageBinding {
    private static final String[] NO_NAME_COMPONENTS = CharOperation.NO_STRINGS;
    private static final String UNNAMED = Util.EMPTY_STRING;
    private static final char PACKAGE_NAME_SEPARATOR = '.';
    private org.eclipse.wst.jsdt.internal.compiler.lookup.PackageBinding binding;
    private String name;
    private BindingResolver resolver;
    private String[] components;

    PackageBinding(org.eclipse.wst.jsdt.internal.compiler.lookup.PackageBinding packageBinding, BindingResolver bindingResolver) {
        this.binding = packageBinding;
        this.resolver = bindingResolver;
    }

    public IAnnotationBinding[] getAnnotations() {
        try {
            INameEnvironment iNameEnvironment = this.binding.environment.nameEnvironment;
            if (!(iNameEnvironment instanceof SearchableEnvironment)) {
                return AnnotationBinding.NoAnnotations;
            }
            NameLookup nameLookup = ((SearchableEnvironment)iNameEnvironment).nameLookup;
            if (nameLookup == null) {
                return AnnotationBinding.NoAnnotations;
            }
            String string = this.getName();
            IPackageFragment[] iPackageFragmentArray = nameLookup.findPackageFragments(string, false);
            if (iPackageFragmentArray == null) {
                return AnnotationBinding.NoAnnotations;
            }
            int n = 0;
            int n2 = iPackageFragmentArray.length;
            while (n < n2) {
                int n3 = iPackageFragmentArray[n].getKind();
                switch (n3) {
                    case 1: {
                        String string2 = "package-info.js";
                        ICompilationUnit iCompilationUnit = iPackageFragmentArray[n].getCompilationUnit(string2);
                        if (iCompilationUnit == null) break;
                        ASTParser aSTParser = ASTParser.newParser(3);
                        aSTParser.setSource(iCompilationUnit);
                        aSTParser.setResolveBindings(true);
                        aSTParser.setUnitName(string2);
                        aSTParser.setFocalPosition(0);
                        aSTParser.setKind(8);
                        CompilationUnit compilationUnit = (CompilationUnit)aSTParser.createAST(null);
                        PackageDeclaration packageDeclaration = compilationUnit.getPackage();
                        if (packageDeclaration == null) break;
                        List list = packageDeclaration.annotations();
                        if (list == null || list.isEmpty()) {
                            return AnnotationBinding.NoAnnotations;
                        }
                        IAnnotationBinding[] iAnnotationBindingArray = new IAnnotationBinding[list.size()];
                        int n4 = 0;
                        Iterator iterator = list.iterator();
                        while (iterator.hasNext()) {
                            iAnnotationBindingArray[n4] = ((Annotation)iterator.next()).resolveAnnotationBinding();
                            if (iAnnotationBindingArray[n4] == null) {
                                return AnnotationBinding.NoAnnotations;
                            }
                            ++n4;
                        }
                        return iAnnotationBindingArray;
                    }
                }
                ++n;
            }
        }
        catch (JavaModelException javaModelException) {
            return AnnotationBinding.NoAnnotations;
        }
        return AnnotationBinding.NoAnnotations;
    }

    public String getName() {
        if (this.name == null) {
            this.computeNameAndComponents();
        }
        return this.name;
    }

    public boolean isUnnamed() {
        return this.getName().equals(UNNAMED);
    }

    public String[] getNameComponents() {
        if (this.components == null) {
            this.computeNameAndComponents();
        }
        return this.components;
    }

    public int getKind() {
        return 1;
    }

    public int getModifiers() {
        return 0;
    }

    public boolean isDeprecated() {
        return false;
    }

    public boolean isRecovered() {
        return false;
    }

    public boolean isSynthetic() {
        return false;
    }

    public IJavaElement getJavaElement() {
        INameEnvironment iNameEnvironment = this.binding.environment.nameEnvironment;
        if (!(iNameEnvironment instanceof SearchableEnvironment)) {
            return null;
        }
        NameLookup nameLookup = ((SearchableEnvironment)iNameEnvironment).nameLookup;
        if (nameLookup == null) {
            return null;
        }
        IPackageFragment[] iPackageFragmentArray = nameLookup.findPackageFragments(this.getName(), false);
        if (iPackageFragmentArray == null) {
            return null;
        }
        return iPackageFragmentArray[0];
    }

    public String getKey() {
        return new String(this.binding.computeUniqueKey());
    }

    public boolean isEqualTo(IBinding iBinding) {
        if (iBinding == this) {
            return true;
        }
        if (iBinding == null) {
            return false;
        }
        if (!(iBinding instanceof PackageBinding)) {
            return false;
        }
        org.eclipse.wst.jsdt.internal.compiler.lookup.PackageBinding packageBinding = ((PackageBinding)iBinding).binding;
        return CharOperation.equals(this.binding.compoundName, packageBinding.compoundName);
    }

    private void computeNameAndComponents() {
        char[][] cArray = this.binding.compoundName;
        if (cArray == CharOperation.NO_CHAR_CHAR || cArray == null) {
            this.name = UNNAMED;
            this.components = NO_NAME_COMPONENTS;
        } else {
            int n = cArray.length;
            this.components = new String[n];
            StringBuffer stringBuffer = new StringBuffer();
            int n2 = 0;
            while (n2 < n - 1) {
                this.components[n2] = new String(cArray[n2]);
                stringBuffer.append(cArray[n2]).append('.');
                ++n2;
            }
            this.components[n - 1] = new String(cArray[n - 1]);
            stringBuffer.append(cArray[n - 1]);
            this.name = stringBuffer.toString();
        }
    }

    public String toString() {
        return this.binding.toString();
    }
}

