/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.dom.rewrite;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.text.edits.TextEditGroup;
import org.eclipse.wst.jsdt.core.ITypeRoot;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.core.dom.AST;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.Block;
import org.eclipse.wst.jsdt.core.dom.ChildListPropertyDescriptor;
import org.eclipse.wst.jsdt.core.dom.CompilationUnit;
import org.eclipse.wst.jsdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.wst.jsdt.core.dom.rewrite.ITrackedNodePosition;
import org.eclipse.wst.jsdt.core.dom.rewrite.ListRewrite;
import org.eclipse.wst.jsdt.core.dom.rewrite.TargetSourceRangeComputer;
import org.eclipse.wst.jsdt.internal.core.dom.rewrite.ASTRewriteAnalyzer;
import org.eclipse.wst.jsdt.internal.core.dom.rewrite.LineInformation;
import org.eclipse.wst.jsdt.internal.core.dom.rewrite.NodeInfoStore;
import org.eclipse.wst.jsdt.internal.core.dom.rewrite.NodeRewriteEvent;
import org.eclipse.wst.jsdt.internal.core.dom.rewrite.RewriteEventStore;
import org.eclipse.wst.jsdt.internal.core.dom.rewrite.TrackedNodePosition;

public class ASTRewrite {
    private final AST ast;
    private final RewriteEventStore eventStore;
    private final NodeInfoStore nodeStore;
    private TargetSourceRangeComputer targetSourceRangeComputer = null;

    public static ASTRewrite create(AST aST) {
        return new ASTRewrite(aST);
    }

    protected ASTRewrite(AST aST) {
        this.ast = aST;
        this.eventStore = new RewriteEventStore();
        this.nodeStore = new NodeInfoStore(aST);
    }

    public final AST getAST() {
        return this.ast;
    }

    protected final RewriteEventStore getRewriteEventStore() {
        return this.eventStore;
    }

    protected final NodeInfoStore getNodeStore() {
        return this.nodeStore;
    }

    public TextEdit rewriteAST(IDocument iDocument, Map map) throws IllegalArgumentException {
        if (iDocument == null) {
            throw new IllegalArgumentException();
        }
        ASTNode aSTNode = this.getRootNode();
        if (aSTNode == null) {
            return new MultiTextEdit();
        }
        char[] cArray = iDocument.get().toCharArray();
        LineInformation lineInformation = LineInformation.create(iDocument);
        String string = TextUtilities.getDefaultLineDelimiter((IDocument)iDocument);
        ASTNode aSTNode2 = aSTNode.getRoot();
        List list = aSTNode2 instanceof CompilationUnit ? ((CompilationUnit)aSTNode2).getCommentList() : null;
        return this.internalRewriteAST(cArray, lineInformation, string, list, map, aSTNode);
    }

    public TextEdit rewriteAST() throws JavaModelException, IllegalArgumentException {
        ASTNode aSTNode = this.getRootNode();
        if (aSTNode == null) {
            return new MultiTextEdit();
        }
        ASTNode aSTNode2 = aSTNode.getRoot();
        if (!(aSTNode2 instanceof CompilationUnit)) {
            throw new IllegalArgumentException("This API can only be used if the AST is created from a compilation unit or class file");
        }
        CompilationUnit compilationUnit = (CompilationUnit)aSTNode2;
        ITypeRoot iTypeRoot = compilationUnit.getTypeRoot();
        if (iTypeRoot == null || iTypeRoot.getBuffer() == null) {
            throw new IllegalArgumentException("This API can only be used if the AST is created from a compilation unit or class file");
        }
        char[] cArray = iTypeRoot.getBuffer().getCharacters();
        LineInformation lineInformation = LineInformation.create(compilationUnit);
        String string = iTypeRoot.findRecommendedLineSeparator();
        Map map = iTypeRoot.getJavaProject().getOptions(true);
        return this.internalRewriteAST(cArray, lineInformation, string, compilationUnit.getCommentList(), map, aSTNode);
    }

    private TextEdit internalRewriteAST(char[] cArray, LineInformation lineInformation, String string, List list, Map map, ASTNode aSTNode) {
        MultiTextEdit multiTextEdit = new MultiTextEdit();
        TargetSourceRangeComputer targetSourceRangeComputer = this.getExtendedSourceRangeComputer();
        this.eventStore.prepareMovedNodes(targetSourceRangeComputer);
        ASTRewriteAnalyzer aSTRewriteAnalyzer = new ASTRewriteAnalyzer(cArray, lineInformation, string, (TextEdit)multiTextEdit, this.eventStore, this.nodeStore, list, map, targetSourceRangeComputer);
        aSTNode.accept(aSTRewriteAnalyzer);
        this.eventStore.revertMovedNodes();
        return multiTextEdit;
    }

    private ASTNode getRootNode() {
        ASTNode aSTNode = null;
        int n = -1;
        int n2 = -1;
        Iterator iterator = this.getRewriteEventStore().getChangeRootIterator();
        while (iterator.hasNext()) {
            ASTNode aSTNode2 = (ASTNode)iterator.next();
            if (RewriteEventStore.isNewNode(aSTNode2)) continue;
            int n3 = aSTNode2.getStartPosition();
            int n4 = n3 + aSTNode2.getLength();
            if (aSTNode == null || n3 < n && n4 > n2) {
                n = n3;
                n2 = n4;
                aSTNode = aSTNode2;
                continue;
            }
            if (n3 < n) {
                n = n3;
                continue;
            }
            if (n4 <= n2) continue;
            n2 = n4;
        }
        if (aSTNode != null) {
            int n5 = aSTNode.getStartPosition();
            int n6 = n5 + aSTNode.getLength();
            while (n < n5 || n2 > n6) {
                aSTNode = aSTNode.getParent();
                n5 = aSTNode.getStartPosition();
                n6 = n5 + aSTNode.getLength();
            }
            ASTNode aSTNode3 = aSTNode.getParent();
            while (aSTNode3 != null && aSTNode3.getStartPosition() == aSTNode.getStartPosition() && aSTNode3.getLength() == aSTNode.getLength()) {
                aSTNode = aSTNode3;
                aSTNode3 = aSTNode.getParent();
            }
        }
        return aSTNode;
    }

    public final void remove(ASTNode aSTNode, TextEditGroup textEditGroup) {
        if (aSTNode == null) {
            throw new IllegalArgumentException();
        }
        StructuralPropertyDescriptor structuralPropertyDescriptor = aSTNode.getLocationInParent();
        if (structuralPropertyDescriptor.isChildListProperty()) {
            this.getListRewrite(aSTNode.getParent(), (ChildListPropertyDescriptor)structuralPropertyDescriptor).remove(aSTNode, textEditGroup);
        } else {
            this.set(aSTNode.getParent(), structuralPropertyDescriptor, null, textEditGroup);
        }
    }

    public final void replace(ASTNode aSTNode, ASTNode aSTNode2, TextEditGroup textEditGroup) {
        if (aSTNode == null) {
            throw new IllegalArgumentException();
        }
        StructuralPropertyDescriptor structuralPropertyDescriptor = aSTNode.getLocationInParent();
        if (structuralPropertyDescriptor.isChildListProperty()) {
            this.getListRewrite(aSTNode.getParent(), (ChildListPropertyDescriptor)structuralPropertyDescriptor).replace(aSTNode, aSTNode2, textEditGroup);
        } else {
            this.set(aSTNode.getParent(), structuralPropertyDescriptor, aSTNode2, textEditGroup);
        }
    }

    public final void set(ASTNode aSTNode, StructuralPropertyDescriptor structuralPropertyDescriptor, Object object, TextEditGroup textEditGroup) {
        if (aSTNode == null || structuralPropertyDescriptor == null) {
            throw new IllegalArgumentException();
        }
        this.validateIsCorrectAST(aSTNode);
        this.validatePropertyType(structuralPropertyDescriptor, object);
        NodeRewriteEvent nodeRewriteEvent = this.eventStore.getNodeEvent(aSTNode, structuralPropertyDescriptor, true);
        nodeRewriteEvent.setNewValue(object);
        if (textEditGroup != null) {
            this.eventStore.setEventEditGroup(nodeRewriteEvent, textEditGroup);
        }
    }

    public Object get(ASTNode aSTNode, StructuralPropertyDescriptor structuralPropertyDescriptor) {
        if (aSTNode == null || structuralPropertyDescriptor == null) {
            throw new IllegalArgumentException();
        }
        if (structuralPropertyDescriptor.isChildListProperty()) {
            throw new IllegalArgumentException("Use the list rewriter to access nodes in a list");
        }
        return this.eventStore.getNewValue(aSTNode, structuralPropertyDescriptor);
    }

    public final ListRewrite getListRewrite(ASTNode aSTNode, ChildListPropertyDescriptor childListPropertyDescriptor) {
        if (aSTNode == null || childListPropertyDescriptor == null) {
            throw new IllegalArgumentException();
        }
        this.validateIsListProperty(childListPropertyDescriptor);
        return new ListRewrite(this, aSTNode, childListPropertyDescriptor);
    }

    public final ITrackedNodePosition track(ASTNode aSTNode) {
        if (aSTNode == null) {
            throw new IllegalArgumentException();
        }
        TextEditGroup textEditGroup = this.eventStore.getTrackedNodeData(aSTNode);
        if (textEditGroup == null) {
            textEditGroup = new TextEditGroup("internal");
            this.eventStore.setTrackedNodeData(aSTNode, textEditGroup);
        }
        return new TrackedNodePosition(textEditGroup, aSTNode);
    }

    private void validateIsExistingNode(ASTNode aSTNode) {
        if (aSTNode.getStartPosition() == -1) {
            throw new IllegalArgumentException("Node is not an existing node");
        }
    }

    private void validateIsCorrectAST(ASTNode aSTNode) {
        if (aSTNode.getAST() != this.getAST()) {
            throw new IllegalArgumentException("Node is not inside the AST");
        }
    }

    private void validateIsListProperty(StructuralPropertyDescriptor structuralPropertyDescriptor) {
        if (!structuralPropertyDescriptor.isChildListProperty()) {
            String string = String.valueOf(structuralPropertyDescriptor.getId()) + " is not a list property";
            throw new IllegalArgumentException(string);
        }
    }

    private void validatePropertyType(StructuralPropertyDescriptor structuralPropertyDescriptor, Object object) {
        if (structuralPropertyDescriptor.isChildListProperty()) {
            String string = "Can not modify a list property, use a list rewriter";
            throw new IllegalArgumentException(string);
        }
    }

    public final ASTNode createStringPlaceholder(String string, int n) {
        if (string == null) {
            throw new IllegalArgumentException();
        }
        ASTNode aSTNode = this.getNodeStore().newPlaceholderNode(n);
        if (aSTNode == null) {
            throw new IllegalArgumentException("String placeholder is not supported for type" + n);
        }
        this.getNodeStore().markAsStringPlaceholder(aSTNode, string);
        return aSTNode;
    }

    public final ASTNode createGroupNode(ASTNode[] aSTNodeArray) {
        if (aSTNodeArray == null || aSTNodeArray.length == 0) {
            throw new IllegalArgumentException();
        }
        Block block = this.getNodeStore().createCollapsePlaceholder();
        ListRewrite listRewrite = this.getListRewrite(block, Block.STATEMENTS_PROPERTY);
        int n = 0;
        while (n < aSTNodeArray.length) {
            listRewrite.insertLast(aSTNodeArray[n], null);
            ++n;
        }
        return block;
    }

    private ASTNode createTargetNode(ASTNode aSTNode, boolean bl) {
        if (aSTNode == null) {
            throw new IllegalArgumentException();
        }
        this.validateIsExistingNode(aSTNode);
        this.validateIsCorrectAST(aSTNode);
        RewriteEventStore.CopySourceInfo copySourceInfo = this.getRewriteEventStore().markAsCopySource(aSTNode.getParent(), aSTNode.getLocationInParent(), aSTNode, bl);
        ASTNode aSTNode2 = this.getNodeStore().newPlaceholderNode(aSTNode.getNodeType());
        if (aSTNode2 == null) {
            throw new IllegalArgumentException("Creating a target node is not supported for nodes of type" + aSTNode.getClass().getName());
        }
        this.getNodeStore().markAsCopyTarget(aSTNode2, copySourceInfo);
        return aSTNode2;
    }

    public final ASTNode createCopyTarget(ASTNode aSTNode) {
        return this.createTargetNode(aSTNode, false);
    }

    public final ASTNode createMoveTarget(ASTNode aSTNode) {
        return this.createTargetNode(aSTNode, true);
    }

    public final TargetSourceRangeComputer getExtendedSourceRangeComputer() {
        if (this.targetSourceRangeComputer == null) {
            this.targetSourceRangeComputer = new TargetSourceRangeComputer();
        }
        return this.targetSourceRangeComputer;
    }

    public final void setTargetSourceRangeComputer(TargetSourceRangeComputer targetSourceRangeComputer) {
        this.targetSourceRangeComputer = targetSourceRangeComputer;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Events:\n");
        if (this.eventStore != null) {
            stringBuffer.append(this.eventStore.toString());
        }
        return stringBuffer.toString();
    }
}

