/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.search;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.wst.jsdt.core.Flags;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.IWorkingCopy;
import org.eclipse.wst.jsdt.core.JavaCore;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.core.WorkingCopyOwner;
import org.eclipse.wst.jsdt.core.search.IJavaSearchResultCollector;
import org.eclipse.wst.jsdt.core.search.IJavaSearchScope;
import org.eclipse.wst.jsdt.core.search.ISearchPattern;
import org.eclipse.wst.jsdt.core.search.ITypeNameRequestor;
import org.eclipse.wst.jsdt.core.search.SearchMatch;
import org.eclipse.wst.jsdt.core.search.SearchParticipant;
import org.eclipse.wst.jsdt.core.search.SearchPattern;
import org.eclipse.wst.jsdt.core.search.SearchRequestor;
import org.eclipse.wst.jsdt.core.search.TypeNameMatch;
import org.eclipse.wst.jsdt.core.search.TypeNameMatchRequestor;
import org.eclipse.wst.jsdt.core.search.TypeNameRequestor;
import org.eclipse.wst.jsdt.internal.compiler.env.AccessRestriction;
import org.eclipse.wst.jsdt.internal.core.search.BasicSearchEngine;
import org.eclipse.wst.jsdt.internal.core.search.IRestrictedAccessTypeRequestor;
import org.eclipse.wst.jsdt.internal.core.search.TypeNameMatchRequestorWrapper;
import org.eclipse.wst.jsdt.internal.core.search.TypeNameRequestorWrapper;
import org.eclipse.wst.jsdt.internal.core.search.matching.DeclarationOfAccessedFieldsPattern;
import org.eclipse.wst.jsdt.internal.core.search.matching.DeclarationOfReferencedMethodsPattern;
import org.eclipse.wst.jsdt.internal.core.search.matching.DeclarationOfReferencedTypesPattern;

public class SearchEngine {
    private BasicSearchEngine basicEngine;

    public SearchEngine() {
        this.basicEngine = new BasicSearchEngine();
    }

    public SearchEngine(ICompilationUnit[] iCompilationUnitArray) {
        this.basicEngine = new BasicSearchEngine(iCompilationUnitArray);
    }

    public SearchEngine(IWorkingCopy[] iWorkingCopyArray) {
        int n = iWorkingCopyArray.length;
        ICompilationUnit[] iCompilationUnitArray = new ICompilationUnit[n];
        System.arraycopy(iWorkingCopyArray, 0, iCompilationUnitArray, 0, n);
        this.basicEngine = new BasicSearchEngine(iCompilationUnitArray);
    }

    public SearchEngine(WorkingCopyOwner workingCopyOwner) {
        this.basicEngine = new BasicSearchEngine(workingCopyOwner);
    }

    public static IJavaSearchScope createHierarchyScope(IType iType) throws JavaModelException {
        return BasicSearchEngine.createHierarchyScope(iType);
    }

    public static IJavaSearchScope createHierarchyScope(IType iType, WorkingCopyOwner workingCopyOwner) throws JavaModelException {
        return BasicSearchEngine.createHierarchyScope(iType, workingCopyOwner);
    }

    public static IJavaSearchScope createJavaSearchScope(IResource[] iResourceArray) {
        int n = iResourceArray.length;
        IJavaElement[] iJavaElementArray = new IJavaElement[n];
        int n2 = 0;
        while (n2 < n) {
            iJavaElementArray[n2] = JavaCore.create(iResourceArray[n2]);
            ++n2;
        }
        return SearchEngine.createJavaSearchScope(iJavaElementArray);
    }

    public static IJavaSearchScope createJavaSearchScope(IJavaElement[] iJavaElementArray) {
        return BasicSearchEngine.createJavaSearchScope(iJavaElementArray);
    }

    public static IJavaSearchScope createJavaSearchScope(IJavaElement[] iJavaElementArray, boolean bl) {
        return BasicSearchEngine.createJavaSearchScope(iJavaElementArray, bl);
    }

    public static IJavaSearchScope createJavaSearchScope(IJavaElement[] iJavaElementArray, int n) {
        return BasicSearchEngine.createJavaSearchScope(iJavaElementArray, n);
    }

    public static ISearchPattern createOrSearchPattern(ISearchPattern iSearchPattern, ISearchPattern iSearchPattern2) {
        SearchPattern searchPattern = ((SearchPatternAdapter)iSearchPattern).pattern;
        SearchPattern searchPattern2 = ((SearchPatternAdapter)iSearchPattern2).pattern;
        SearchPattern searchPattern3 = SearchPattern.createOrPattern(searchPattern, searchPattern2);
        return new SearchPatternAdapter(searchPattern3);
    }

    public static ISearchPattern createSearchPattern(String string, int n, int n2, boolean bl) {
        int n3 = string.indexOf(42) != -1 || string.indexOf(63) != -1 ? 2 : 0;
        int n4 = bl ? n3 | 8 : n3;
        return new SearchPatternAdapter(SearchPattern.createPattern(string, n, n2, n4));
    }

    public static ISearchPattern createSearchPattern(IJavaElement iJavaElement, int n) {
        return new SearchPatternAdapter(SearchPattern.createPattern(iJavaElement, n));
    }

    public static TypeNameMatch createTypeNameMatch(IType iType, int n) {
        return BasicSearchEngine.createTypeNameMatch(iType, n);
    }

    public static IJavaSearchScope createWorkspaceScope() {
        return BasicSearchEngine.createWorkspaceScope();
    }

    public static SearchParticipant getDefaultSearchParticipant() {
        return BasicSearchEngine.getDefaultSearchParticipant();
    }

    public void search(IWorkspace iWorkspace, String string, int n, int n2, IJavaSearchScope iJavaSearchScope, IJavaSearchResultCollector iJavaSearchResultCollector) throws JavaModelException {
        try {
            int n3 = string.indexOf(42) != -1 || string.indexOf(63) != -1 ? 2 : 0;
            this.search(SearchPattern.createPattern(string, n, n2, n3 | 8), new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()}, iJavaSearchScope, new ResultCollectorAdapter(iJavaSearchResultCollector), iJavaSearchResultCollector.getProgressMonitor());
        }
        catch (CoreException coreException) {
            if (coreException instanceof JavaModelException) {
                throw (JavaModelException)coreException;
            }
            throw new JavaModelException(coreException);
        }
    }

    public void search(IWorkspace iWorkspace, IJavaElement iJavaElement, int n, IJavaSearchScope iJavaSearchScope, IJavaSearchResultCollector iJavaSearchResultCollector) throws JavaModelException {
        this.search(iWorkspace, SearchEngine.createSearchPattern(iJavaElement, n), iJavaSearchScope, iJavaSearchResultCollector);
    }

    public void search(IWorkspace iWorkspace, ISearchPattern iSearchPattern, IJavaSearchScope iJavaSearchScope, IJavaSearchResultCollector iJavaSearchResultCollector) throws JavaModelException {
        try {
            this.search(((SearchPatternAdapter)iSearchPattern).pattern, new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()}, iJavaSearchScope, new ResultCollectorAdapter(iJavaSearchResultCollector), iJavaSearchResultCollector.getProgressMonitor());
        }
        catch (CoreException coreException) {
            if (coreException instanceof JavaModelException) {
                throw (JavaModelException)coreException;
            }
            throw new JavaModelException(coreException);
        }
    }

    public void search(SearchPattern searchPattern, SearchParticipant[] searchParticipantArray, IJavaSearchScope iJavaSearchScope, SearchRequestor searchRequestor, IProgressMonitor iProgressMonitor) throws CoreException {
        this.basicEngine.search(searchPattern, searchParticipantArray, iJavaSearchScope, searchRequestor, iProgressMonitor);
    }

    public void searchAllTypeNames(char[] cArray, char[] cArray2, int n, int n2, IJavaSearchScope iJavaSearchScope, TypeNameRequestor typeNameRequestor, int n3, IProgressMonitor iProgressMonitor) throws JavaModelException {
        this.searchAllTypeNames(cArray, 0, cArray2, n, n2, iJavaSearchScope, typeNameRequestor, n3, iProgressMonitor);
    }

    public void searchAllTypeNames(char[] cArray, int n, char[] cArray2, int n2, int n3, IJavaSearchScope iJavaSearchScope, TypeNameRequestor typeNameRequestor, int n4, IProgressMonitor iProgressMonitor) throws JavaModelException {
        TypeNameRequestorWrapper typeNameRequestorWrapper = new TypeNameRequestorWrapper(typeNameRequestor);
        this.basicEngine.searchAllTypeNames(cArray, n, cArray2, n2, n3, iJavaSearchScope, typeNameRequestorWrapper, n4, iProgressMonitor);
    }

    public void searchAllTypeNames(char[] cArray, int n, char[] cArray2, int n2, int n3, IJavaSearchScope iJavaSearchScope, TypeNameMatchRequestor typeNameMatchRequestor, int n4, IProgressMonitor iProgressMonitor) throws JavaModelException {
        TypeNameMatchRequestorWrapper typeNameMatchRequestorWrapper = new TypeNameMatchRequestorWrapper(typeNameMatchRequestor, iJavaSearchScope);
        this.basicEngine.searchAllTypeNames(cArray, n, cArray2, n2, n3, iJavaSearchScope, typeNameMatchRequestorWrapper, n4, iProgressMonitor);
    }

    public void searchAllTypeNames(char[][] cArray, char[][] cArray2, IJavaSearchScope iJavaSearchScope, TypeNameRequestor typeNameRequestor, int n, IProgressMonitor iProgressMonitor) throws JavaModelException {
        TypeNameRequestorWrapper typeNameRequestorWrapper = new TypeNameRequestorWrapper(typeNameRequestor);
        this.basicEngine.searchAllTypeNames(cArray, cArray2, 8, 0, iJavaSearchScope, typeNameRequestorWrapper, n, iProgressMonitor);
    }

    public void searchAllTypeNames(char[][] cArray, char[][] cArray2, IJavaSearchScope iJavaSearchScope, TypeNameMatchRequestor typeNameMatchRequestor, int n, IProgressMonitor iProgressMonitor) throws JavaModelException {
        TypeNameMatchRequestorWrapper typeNameMatchRequestorWrapper = new TypeNameMatchRequestorWrapper(typeNameMatchRequestor, iJavaSearchScope);
        this.basicEngine.searchAllTypeNames(cArray, cArray2, 8, 0, iJavaSearchScope, typeNameMatchRequestorWrapper, n, iProgressMonitor);
    }

    public void searchAllTypeNames(char[] cArray, char[] cArray2, int n, int n2, IJavaSearchScope iJavaSearchScope, ITypeNameRequestor iTypeNameRequestor, int n3, IProgressMonitor iProgressMonitor) throws JavaModelException {
        TypeNameRequestorAdapter typeNameRequestorAdapter = new TypeNameRequestorAdapter(iTypeNameRequestor);
        this.basicEngine.searchAllTypeNames(cArray, 0, cArray2, n, n2, iJavaSearchScope, typeNameRequestorAdapter, n3, iProgressMonitor);
    }

    public void searchAllTypeNames(IWorkspace iWorkspace, char[] cArray, char[] cArray2, int n, boolean bl, int n2, IJavaSearchScope iJavaSearchScope, ITypeNameRequestor iTypeNameRequestor, int n3, IProgressMonitor iProgressMonitor) throws JavaModelException {
        this.searchAllTypeNames(cArray, cArray2, bl ? n | 8 : n, n2, iJavaSearchScope, iTypeNameRequestor, n3, iProgressMonitor);
    }

    public void searchDeclarationsOfAccessedFields(IJavaElement iJavaElement, SearchRequestor searchRequestor, IProgressMonitor iProgressMonitor) throws JavaModelException {
        this.basicEngine.searchDeclarationsOfAccessedFields(iJavaElement, searchRequestor, iProgressMonitor);
    }

    public void searchDeclarationsOfAccessedFields(IWorkspace iWorkspace, IJavaElement iJavaElement, IJavaSearchResultCollector iJavaSearchResultCollector) throws JavaModelException {
        DeclarationOfAccessedFieldsPattern declarationOfAccessedFieldsPattern = new DeclarationOfAccessedFieldsPattern(iJavaElement);
        this.basicEngine.searchDeclarations(iJavaElement, new ResultCollectorAdapter(iJavaSearchResultCollector), declarationOfAccessedFieldsPattern, iJavaSearchResultCollector.getProgressMonitor());
    }

    public void searchDeclarationsOfReferencedTypes(IJavaElement iJavaElement, SearchRequestor searchRequestor, IProgressMonitor iProgressMonitor) throws JavaModelException {
        this.basicEngine.searchDeclarationsOfReferencedTypes(iJavaElement, searchRequestor, iProgressMonitor);
    }

    public void searchDeclarationsOfReferencedTypes(IWorkspace iWorkspace, IJavaElement iJavaElement, IJavaSearchResultCollector iJavaSearchResultCollector) throws JavaModelException {
        DeclarationOfReferencedTypesPattern declarationOfReferencedTypesPattern = new DeclarationOfReferencedTypesPattern(iJavaElement);
        this.basicEngine.searchDeclarations(iJavaElement, new ResultCollectorAdapter(iJavaSearchResultCollector), declarationOfReferencedTypesPattern, iJavaSearchResultCollector.getProgressMonitor());
    }

    public void searchDeclarationsOfSentMessages(IJavaElement iJavaElement, SearchRequestor searchRequestor, IProgressMonitor iProgressMonitor) throws JavaModelException {
        this.basicEngine.searchDeclarationsOfSentMessages(iJavaElement, searchRequestor, iProgressMonitor);
    }

    public void searchDeclarationsOfSentMessages(IWorkspace iWorkspace, IJavaElement iJavaElement, IJavaSearchResultCollector iJavaSearchResultCollector) throws JavaModelException {
        DeclarationOfReferencedMethodsPattern declarationOfReferencedMethodsPattern = new DeclarationOfReferencedMethodsPattern(iJavaElement);
        this.basicEngine.searchDeclarations(iJavaElement, new ResultCollectorAdapter(iJavaSearchResultCollector), declarationOfReferencedMethodsPattern, iJavaSearchResultCollector.getProgressMonitor());
    }

    static class ResultCollectorAdapter
    extends SearchRequestor {
        IJavaSearchResultCollector resultCollector;

        ResultCollectorAdapter(IJavaSearchResultCollector iJavaSearchResultCollector) {
            this.resultCollector = iJavaSearchResultCollector;
        }

        public void acceptSearchMatch(SearchMatch searchMatch) throws CoreException {
            this.resultCollector.accept(searchMatch.getResource(), searchMatch.getOffset(), searchMatch.getOffset() + searchMatch.getLength(), (IJavaElement)searchMatch.getElement(), searchMatch.getAccuracy());
        }

        public void beginReporting() {
            this.resultCollector.aboutToStart();
        }

        public void endReporting() {
            this.resultCollector.done();
        }
    }

    static class SearchPatternAdapter
    implements ISearchPattern {
        SearchPattern pattern;

        SearchPatternAdapter(SearchPattern searchPattern) {
            this.pattern = searchPattern;
        }
    }

    static class TypeNameRequestorAdapter
    implements IRestrictedAccessTypeRequestor {
        ITypeNameRequestor nameRequestor;

        TypeNameRequestorAdapter(ITypeNameRequestor iTypeNameRequestor) {
            this.nameRequestor = iTypeNameRequestor;
        }

        public void acceptType(int n, char[] cArray, char[] cArray2, char[][] cArray3, String string, AccessRestriction accessRestriction) {
            if (Flags.isInterface(n)) {
                this.nameRequestor.acceptInterface(cArray, cArray2, cArray3, string);
            } else {
                this.nameRequestor.acceptClass(cArray, cArray2, cArray3, string);
            }
        }
    }
}

