/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.codeassist;

import org.eclipse.wst.jsdt.core.compiler.CharOperation;
import org.eclipse.wst.jsdt.internal.codeassist.CompletionEngine;
import org.eclipse.wst.jsdt.internal.codeassist.complete.CompletionParser;
import org.eclipse.wst.jsdt.internal.codeassist.complete.CompletionScanner;
import org.eclipse.wst.jsdt.internal.compiler.ASTVisitor;
import org.eclipse.wst.jsdt.internal.compiler.ast.ASTNode;
import org.eclipse.wst.jsdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.Argument;
import org.eclipse.wst.jsdt.internal.compiler.ast.Block;
import org.eclipse.wst.jsdt.internal.compiler.ast.ConstructorDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.FieldDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.Initializer;
import org.eclipse.wst.jsdt.internal.compiler.ast.LocalDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.MethodDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.Statement;
import org.eclipse.wst.jsdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.lookup.BlockScope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ClassScope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.MethodScope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.Scope;
import org.eclipse.wst.jsdt.internal.compiler.util.SimpleSetOfCharArray;
import org.eclipse.wst.jsdt.internal.compiler.util.Util;

public class UnresolvedReferenceNameFinder
extends ASTVisitor {
    private static final int MAX_LINE_COUNT = 100;
    private static final int FAKE_BLOCKS_COUNT = 20;
    private UnresolvedReferenceNameRequestor requestor;
    private CompletionEngine completionEngine;
    private CompletionParser parser;
    private CompletionScanner completionScanner;
    private int parentsPtr;
    private ASTNode[] parents;
    private int potentialVariableNamesPtr;
    private char[][] potentialVariableNames;
    private int[] potentialVariableNameStarts;
    private SimpleSetOfCharArray acceptedNames = new SimpleSetOfCharArray();

    public UnresolvedReferenceNameFinder(CompletionEngine completionEngine) {
        this.completionEngine = completionEngine;
        this.parser = completionEngine.parser;
        this.completionScanner = (CompletionScanner)this.parser.scanner;
    }

    private void acceptName(char[] cArray) {
        if (cArray == null) {
            return;
        }
        if (!(CharOperation.prefixEquals(this.completionEngine.completionToken, cArray, false) || this.completionEngine.options.camelCaseMatch && CharOperation.camelCaseMatch(this.completionEngine.completionToken, cArray))) {
            return;
        }
        if (this.acceptedNames.includes(cArray)) {
            return;
        }
        this.acceptedNames.add(cArray);
        this.requestor.acceptName(cArray);
    }

    public void find(char[] cArray, Initializer initializer, ClassScope classScope, int n, char[][] cArray2, UnresolvedReferenceNameRequestor unresolvedReferenceNameRequestor) {
        MethodDeclaration methodDeclaration = this.findAfter(cArray, classScope, n, initializer.bodyEnd, 100, false, cArray2, unresolvedReferenceNameRequestor);
        if (methodDeclaration != null) {
            methodDeclaration.traverse((ASTVisitor)this, classScope);
        }
    }

    public void find(char[] cArray, AbstractMethodDeclaration abstractMethodDeclaration, int n, char[][] cArray2, UnresolvedReferenceNameRequestor unresolvedReferenceNameRequestor) {
        MethodDeclaration methodDeclaration = this.findAfter(cArray, abstractMethodDeclaration.scope, n, abstractMethodDeclaration.bodyEnd, 100, false, cArray2, unresolvedReferenceNameRequestor);
        if (methodDeclaration != null) {
            methodDeclaration.traverse((ASTVisitor)this, abstractMethodDeclaration.scope.classScope());
        }
    }

    public void findAfter(char[] cArray, Scope scope, ClassScope classScope, int n, int n2, char[][] cArray2, UnresolvedReferenceNameRequestor unresolvedReferenceNameRequestor) {
        MethodDeclaration methodDeclaration = this.findAfter(cArray, scope, n, n2, 50, true, cArray2, unresolvedReferenceNameRequestor);
        if (methodDeclaration != null) {
            methodDeclaration.traverse((ASTVisitor)this, classScope);
        }
    }

    private MethodDeclaration findAfter(char[] cArray, Scope scope, int n, int n2, int n3, boolean bl, char[][] cArray2, UnresolvedReferenceNameRequestor unresolvedReferenceNameRequestor) {
        int n4;
        this.requestor = unresolvedReferenceNameRequestor;
        this.completionScanner.cursorLocation = 0;
        if (!bl) {
            this.completionScanner.resetTo(n + 1, n2);
            this.completionScanner.jumpOverBlock();
            n2 = this.completionScanner.startPosition - 1;
        }
        int n5 = (n4 = this.completionScanner.getLineEnd(Util.getLineNumber(n, this.completionScanner.lineEnds, 0, this.completionScanner.linePtr) + n3)) < 0 ? n2 : (n4 < n2 ? n4 : n2);
        this.parser.startRecordingIdentifiers(n, n5);
        MethodDeclaration methodDeclaration = this.parser.parseSomeStatements(n, n5, bl ? 20 : 0, scope.compilationUnitScope().referenceContext);
        this.parser.stopRecordingIdentifiers();
        if (!this.initPotentialNamesTables(cArray2)) {
            return null;
        }
        this.parentsPtr = -1;
        this.parents = new ASTNode[10];
        return methodDeclaration;
    }

    public void findBefore(char[] cArray, Scope scope, ClassScope classScope, int n, int n2, int n3, char[][] cArray2, UnresolvedReferenceNameRequestor unresolvedReferenceNameRequestor) {
        MethodDeclaration methodDeclaration = this.findBefore(cArray, scope, n, n2, n3, 50, cArray2, unresolvedReferenceNameRequestor);
        if (methodDeclaration != null) {
            methodDeclaration.traverse((ASTVisitor)this, classScope);
        }
    }

    private MethodDeclaration findBefore(char[] cArray, Scope scope, int n, int n2, int n3, int n4, char[][] cArray2, UnresolvedReferenceNameRequestor unresolvedReferenceNameRequestor) {
        int n5;
        int n6;
        this.requestor = unresolvedReferenceNameRequestor;
        this.completionScanner.cursorLocation = 0;
        int n7 = this.completionScanner.getLineStart(Util.getLineNumber(n2, this.completionScanner.lineEnds, 0, this.completionScanner.linePtr) - n4);
        if (n7 <= n) {
            n6 = n;
            n5 = 0;
        } else {
            n6 = n7;
            n5 = 20;
        }
        this.parser.startRecordingIdentifiers(n6, n2);
        MethodDeclaration methodDeclaration = this.parser.parseSomeStatements(n6, n3, n5, scope.compilationUnitScope().referenceContext);
        this.parser.stopRecordingIdentifiers();
        if (!this.initPotentialNamesTables(cArray2)) {
            return null;
        }
        this.parentsPtr = -1;
        this.parents = new ASTNode[10];
        return methodDeclaration;
    }

    private boolean initPotentialNamesTables(char[][] cArray) {
        char[][] cArray2 = this.parser.potentialVariableNames;
        int[] nArray = this.parser.potentialVariableNameStarts;
        int n = this.parser.potentialVariableNamesPtr;
        if (n < 0) {
            return false;
        }
        int n2 = cArray == null ? 0 : cArray.length;
        int n3 = -1;
        int n4 = 0;
        while (n4 <= n) {
            block6: {
                char[] cArray3 = cArray2[n4];
                if (cArray3 != null) {
                    int n5 = 0;
                    while (n5 < n2) {
                        if (!CharOperation.equals(cArray3, cArray[n5], false)) {
                            ++n5;
                            continue;
                        }
                        break block6;
                    }
                    cArray2[n4] = null;
                    cArray2[++n3] = cArray3;
                    nArray[n3] = nArray[n4];
                }
            }
            ++n4;
        }
        n = n3;
        if (n < 0) {
            return false;
        }
        this.potentialVariableNames = cArray2;
        this.potentialVariableNameStarts = nArray;
        this.potentialVariableNamesPtr = n;
        return true;
    }

    private void popParent() {
        --this.parentsPtr;
    }

    private void pushParent(ASTNode aSTNode) {
        int n = this.parents.length;
        if (this.parentsPtr >= n - 1) {
            this.parents = new ASTNode[n * 2];
            System.arraycopy(this.parents, 0, this.parents, 0, n);
        }
        this.parents[++this.parentsPtr] = aSTNode;
    }

    private ASTNode getEnclosingDeclaration() {
        int n = this.parentsPtr;
        while (n > -1) {
            ASTNode aSTNode = this.parents[n];
            if (aSTNode instanceof AbstractMethodDeclaration) {
                return aSTNode;
            }
            if (aSTNode instanceof Initializer) {
                return aSTNode;
            }
            if (aSTNode instanceof FieldDeclaration) {
                return aSTNode;
            }
            if (aSTNode instanceof TypeDeclaration) {
                return aSTNode;
            }
            --n;
        }
        return null;
    }

    public boolean visit(Block block, BlockScope blockScope) {
        ASTNode aSTNode = this.getEnclosingDeclaration();
        this.removeLocals(block.statements, aSTNode.sourceStart, block.sourceEnd);
        this.pushParent(block);
        return true;
    }

    public boolean visit(ConstructorDeclaration constructorDeclaration, ClassScope classScope) {
        if ((constructorDeclaration.bits & 0x80) == 0 && !constructorDeclaration.isClinit()) {
            this.removeLocals(constructorDeclaration.arguments, constructorDeclaration.declarationSourceStart, constructorDeclaration.declarationSourceEnd);
            this.removeLocals(constructorDeclaration.statements, constructorDeclaration.declarationSourceStart, constructorDeclaration.declarationSourceEnd);
        }
        this.pushParent(constructorDeclaration);
        return true;
    }

    public boolean visit(FieldDeclaration fieldDeclaration, MethodScope methodScope) {
        this.pushParent(fieldDeclaration);
        return true;
    }

    public boolean visit(Initializer initializer, MethodScope methodScope) {
        this.pushParent(initializer);
        return true;
    }

    public boolean visit(MethodDeclaration methodDeclaration, Scope scope) {
        this.removeLocals(methodDeclaration.arguments, methodDeclaration.declarationSourceStart, methodDeclaration.declarationSourceEnd);
        this.removeLocals(methodDeclaration.statements, methodDeclaration.declarationSourceStart, methodDeclaration.declarationSourceEnd);
        this.pushParent(methodDeclaration);
        return true;
    }

    public boolean visit(TypeDeclaration typeDeclaration, BlockScope blockScope) {
        this.removeFields(typeDeclaration);
        this.pushParent(typeDeclaration);
        return true;
    }

    public boolean visit(TypeDeclaration typeDeclaration, ClassScope classScope) {
        this.removeFields(typeDeclaration);
        this.pushParent(typeDeclaration);
        return true;
    }

    public void endVisit(Block block, BlockScope blockScope) {
        this.popParent();
    }

    public void endVisit(Argument argument, BlockScope blockScope) {
        this.endVisitRemoved(argument.declarationSourceStart, argument.sourceEnd);
    }

    public void endVisit(Argument argument, ClassScope classScope) {
        this.endVisitRemoved(argument.declarationSourceStart, argument.sourceEnd);
    }

    public void endVisit(ConstructorDeclaration constructorDeclaration, ClassScope classScope) {
        if ((constructorDeclaration.bits & 0x80) == 0 && !constructorDeclaration.isClinit()) {
            this.endVisitPreserved(constructorDeclaration.bodyStart, constructorDeclaration.bodyEnd);
        }
        this.popParent();
    }

    public void endVisit(FieldDeclaration fieldDeclaration, MethodScope methodScope) {
        this.endVisitRemoved(fieldDeclaration.declarationSourceStart, fieldDeclaration.sourceEnd);
        this.endVisitPreserved(fieldDeclaration.sourceEnd, fieldDeclaration.declarationEnd);
        this.popParent();
    }

    public void endVisit(Initializer initializer, MethodScope methodScope) {
        this.endVisitPreserved(initializer.bodyStart, initializer.bodyEnd);
        this.popParent();
    }

    public void endVisit(LocalDeclaration localDeclaration, BlockScope blockScope) {
        this.endVisitRemoved(localDeclaration.declarationSourceStart, localDeclaration.sourceEnd);
    }

    public void endVisit(MethodDeclaration methodDeclaration, Scope scope) {
        this.endVisitPreserved(methodDeclaration.bodyStart, methodDeclaration.bodyEnd);
        this.popParent();
    }

    public void endVisit(TypeDeclaration typeDeclaration, BlockScope blockScope) {
        this.endVisitRemoved(typeDeclaration.sourceStart, typeDeclaration.declarationSourceEnd);
        this.popParent();
    }

    public void endVisit(TypeDeclaration typeDeclaration, ClassScope classScope) {
        this.endVisitRemoved(typeDeclaration.sourceStart, typeDeclaration.declarationSourceEnd);
        this.popParent();
    }

    private int indexOfFisrtNameAfter(int n) {
        int n2;
        int n3;
        int n4 = 0;
        int n5 = this.potentialVariableNamesPtr;
        while (true) {
            if (n5 < n4) {
                return -1;
            }
            n3 = n4 + (n5 - n4) / 2;
            n2 = this.potentialVariableNameStarts[n3];
            if (n2 < 0) {
                int n6 = this.indexOfNextName(n3);
                if (n6 < 0 || n5 < n6) {
                    n5 = n3 - 1;
                    continue;
                }
                n3 = n6;
                n2 = this.potentialVariableNameStarts[n6];
                if (n3 == n5) {
                    int n7 = this.potentialVariableNameStarts[n4];
                    if (n7 < 0 || n7 < n) {
                        int n8 = this.indexOfNextName(n4);
                        if (n8 < 0) {
                            return -1;
                        }
                        n4 = n8;
                        continue;
                    }
                    return n4;
                }
            }
            if (n4 == n5) break;
            if (n2 < n) {
                n4 = n3 + 1;
                continue;
            }
            n5 = n3;
        }
        if (n2 < n) {
            return -1;
        }
        return n3;
    }

    private int indexOfNextName(int n) {
        int n2 = n + 1;
        while (n2 <= this.potentialVariableNamesPtr && this.potentialVariableNames[n2] == null) {
            int n3 = -this.potentialVariableNameStarts[n2];
            if (n3 > 0) {
                n2 = n3;
                continue;
            }
            ++n2;
        }
        if (this.potentialVariableNamesPtr < n2) {
            if (n < this.potentialVariableNamesPtr) {
                this.potentialVariableNamesPtr = n;
            }
            return -1;
        }
        if (n + 1 < n2) {
            this.potentialVariableNameStarts[n + 1] = -n2;
        }
        return n2;
    }

    private void removeNameAt(int n) {
        this.potentialVariableNames[n] = null;
        int n2 = this.indexOfNextName(n);
        if (n2 != -1) {
            this.potentialVariableNameStarts[n] = -n2;
        } else {
            this.potentialVariableNamesPtr = n - 1;
        }
    }

    private void endVisitPreserved(int n, int n2) {
        int n3 = this.indexOfFisrtNameAfter(n);
        while (n3 != -1) {
            int n4 = this.potentialVariableNameStarts[n3];
            if (n < n4 && n4 < n2) {
                this.acceptName(this.potentialVariableNames[n3]);
                this.removeNameAt(n3);
            }
            if (n2 < n4) break;
            n3 = this.indexOfNextName(n3);
        }
    }

    private void endVisitRemoved(int n, int n2) {
        int n3 = this.indexOfFisrtNameAfter(n);
        while (n3 != -1) {
            int n4 = this.potentialVariableNameStarts[n3];
            if (n < n4 && n4 < n2) {
                this.removeNameAt(n3);
            }
            if (n2 < n4) break;
            n3 = this.indexOfNextName(n3);
        }
    }

    private void removeLocals(Statement[] statementArray, int n, int n2) {
        if (statementArray != null) {
            int n3 = 0;
            while (n3 < statementArray.length) {
                if (statementArray[n3] instanceof LocalDeclaration) {
                    LocalDeclaration localDeclaration = (LocalDeclaration)statementArray[n3];
                    int n4 = this.indexOfFisrtNameAfter(n);
                    while (n4 != -1) {
                        int n5 = this.potentialVariableNameStarts[n4];
                        if (n <= n5 && n5 <= n2 && CharOperation.equals(this.potentialVariableNames[n4], localDeclaration.name, false)) {
                            this.removeNameAt(n4);
                        }
                        if (n2 < n5) break;
                        n4 = this.indexOfNextName(n4);
                    }
                }
                ++n3;
            }
        }
    }

    private void removeFields(TypeDeclaration typeDeclaration) {
        int n = typeDeclaration.declarationSourceStart;
        int n2 = typeDeclaration.declarationSourceEnd;
        FieldDeclaration[] fieldDeclarationArray = typeDeclaration.fields;
        if (fieldDeclarationArray != null) {
            int n3 = 0;
            while (n3 < fieldDeclarationArray.length) {
                int n4 = this.indexOfFisrtNameAfter(n);
                while (n4 != -1) {
                    int n5 = this.potentialVariableNameStarts[n4];
                    if (n <= n5 && n5 <= n2 && CharOperation.equals(this.potentialVariableNames[n4], fieldDeclarationArray[n3].name, false)) {
                        this.removeNameAt(n4);
                    }
                    if (n2 < n5) break;
                    n4 = this.indexOfNextName(n4);
                }
                ++n3;
            }
        }
    }

    public static interface UnresolvedReferenceNameRequestor {
        public void acceptName(char[] var1);
    }
}

