/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.compiler.ast;

import org.eclipse.wst.jsdt.internal.compiler.ASTVisitor;
import org.eclipse.wst.jsdt.internal.compiler.ast.EmptyStatement;
import org.eclipse.wst.jsdt.internal.compiler.ast.Expression;
import org.eclipse.wst.jsdt.internal.compiler.ast.Statement;
import org.eclipse.wst.jsdt.internal.compiler.codegen.BranchLabel;
import org.eclipse.wst.jsdt.internal.compiler.codegen.CodeStream;
import org.eclipse.wst.jsdt.internal.compiler.flow.FlowContext;
import org.eclipse.wst.jsdt.internal.compiler.flow.FlowInfo;
import org.eclipse.wst.jsdt.internal.compiler.flow.LoopingFlowContext;
import org.eclipse.wst.jsdt.internal.compiler.flow.UnconditionalFlowInfo;
import org.eclipse.wst.jsdt.internal.compiler.impl.Constant;
import org.eclipse.wst.jsdt.internal.compiler.lookup.BlockScope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.TypeBinding;

public class DoStatement
extends Statement {
    public Expression condition;
    public Statement action;
    private BranchLabel breakLabel;
    private BranchLabel continueLabel;
    int mergedInitStateIndex = -1;

    public DoStatement(Expression expression, Statement statement, int n, int n2) {
        this.sourceStart = n;
        this.sourceEnd = n2;
        this.condition = expression;
        this.action = statement;
        if (statement instanceof EmptyStatement) {
            statement.bits |= 1;
        }
    }

    public FlowInfo analyseCode(BlockScope blockScope, FlowContext flowContext, FlowInfo flowInfo) {
        this.breakLabel = new BranchLabel();
        this.continueLabel = new BranchLabel();
        LoopingFlowContext loopingFlowContext = new LoopingFlowContext(flowContext, flowInfo, this, this.breakLabel, this.continueLabel, blockScope);
        Constant constant = this.condition.constant;
        boolean bl = constant != Constant.NotAConstant && constant.booleanValue();
        constant = this.condition.optimizedBooleanConstant();
        boolean bl2 = constant != Constant.NotAConstant && constant.booleanValue();
        boolean bl3 = constant != Constant.NotAConstant && !constant.booleanValue();
        int n = flowInfo.reachMode();
        UnconditionalFlowInfo unconditionalFlowInfo = flowInfo.nullInfoLessUnconditionalCopy();
        if (this.action != null && !this.action.isEmptyBlock()) {
            unconditionalFlowInfo = this.action.analyseCode(blockScope, loopingFlowContext, unconditionalFlowInfo).unconditionalInits();
            if ((unconditionalFlowInfo.tagBits & loopingFlowContext.initsOnContinue.tagBits & 1) != 0) {
                this.continueLabel = null;
            }
        }
        unconditionalFlowInfo.setReachMode(n);
        LoopingFlowContext loopingFlowContext2 = new LoopingFlowContext(flowContext, flowInfo, this, null, null, blockScope);
        FlowInfo flowInfo2 = this.condition.analyseCode(blockScope, loopingFlowContext2, (this.action == null ? unconditionalFlowInfo : unconditionalFlowInfo.mergedWith(loopingFlowContext.initsOnContinue)).copy());
        if (!bl3 && this.continueLabel != null) {
            loopingFlowContext.complainOnDeferredFinalChecks(blockScope, flowInfo2);
            loopingFlowContext2.complainOnDeferredFinalChecks(blockScope, flowInfo2);
            loopingFlowContext.complainOnDeferredNullChecks(blockScope, flowInfo.unconditionalCopy().addPotentialNullInfoFrom(flowInfo2.initsWhenTrue().unconditionalInits()));
            loopingFlowContext2.complainOnDeferredNullChecks(blockScope, unconditionalFlowInfo.addPotentialNullInfoFrom(flowInfo2.initsWhenTrue().unconditionalInits()));
        }
        UnconditionalFlowInfo unconditionalFlowInfo2 = FlowInfo.mergedOptimizedBranches((loopingFlowContext.initsOnBreak.tagBits & 1) != 0 ? loopingFlowContext.initsOnBreak : flowInfo.unconditionalCopy().addInitializationsFrom(loopingFlowContext.initsOnBreak), bl2, (flowInfo2.tagBits & 1) == 0 ? flowInfo.addInitializationsFrom(flowInfo2.initsWhenFalse()) : flowInfo2, false, !bl);
        return unconditionalFlowInfo2;
    }

    public void generateCode(BlockScope blockScope, CodeStream codeStream) {
        Constant constant;
        boolean bl;
        boolean bl2;
        if ((this.bits & Integer.MIN_VALUE) == 0) {
            return;
        }
        int n = codeStream.position;
        BranchLabel branchLabel = new BranchLabel(codeStream);
        if (this.action != null) {
            branchLabel.tagBits |= 2;
        }
        branchLabel.place();
        this.breakLabel.initialize(codeStream);
        boolean bl3 = bl2 = this.continueLabel != null;
        if (bl2) {
            this.continueLabel.initialize(codeStream);
        }
        if (this.action != null) {
            this.action.generateCode(blockScope, codeStream);
        }
        if (bl2) {
            this.continueLabel.place();
        }
        boolean bl4 = bl = (constant = this.condition.optimizedBooleanConstant()) != Constant.NotAConstant && !constant.booleanValue();
        if (bl) {
            this.condition.generateCode(blockScope, codeStream, false);
        } else if (bl2) {
            this.condition.generateOptimizedBoolean(blockScope, codeStream, branchLabel, null, true);
        }
        if (this.mergedInitStateIndex != -1) {
            codeStream.removeNotDefinitelyAssignedVariables(blockScope, this.mergedInitStateIndex);
            codeStream.addDefinitelyAssignedVariables(blockScope, this.mergedInitStateIndex);
        }
        if (this.breakLabel.forwardReferenceCount() > 0) {
            this.breakLabel.place();
        }
        codeStream.recordPositionsFrom(n, this.sourceStart);
    }

    public StringBuffer printStatement(int n, StringBuffer stringBuffer) {
        DoStatement.printIndent(n, stringBuffer).append("do");
        if (this.action == null) {
            stringBuffer.append(" ;\n");
        } else {
            stringBuffer.append('\n');
            this.action.printStatement(n + 1, stringBuffer).append('\n');
        }
        stringBuffer.append("while (");
        return this.condition.printExpression(0, stringBuffer).append(");");
    }

    public void resolve(BlockScope blockScope) {
        TypeBinding typeBinding = this.condition.resolveTypeExpecting(blockScope, TypeBinding.BOOLEAN);
        this.condition.computeConversion(blockScope, typeBinding, typeBinding);
        if (this.action != null) {
            this.action.resolve(blockScope);
        }
    }

    public void traverse(ASTVisitor aSTVisitor, BlockScope blockScope) {
        if (aSTVisitor.visit(this, blockScope)) {
            if (this.action != null) {
                this.action.traverse(aSTVisitor, blockScope);
            }
            this.condition.traverse(aSTVisitor, blockScope);
        }
        aSTVisitor.endVisit(this, blockScope);
    }
}

