/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.compiler.ast;

import org.eclipse.wst.jsdt.internal.compiler.ASTVisitor;
import org.eclipse.wst.jsdt.internal.compiler.CompilationResult;
import org.eclipse.wst.jsdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.Statement;
import org.eclipse.wst.jsdt.internal.compiler.ast.TypeParameter;
import org.eclipse.wst.jsdt.internal.compiler.ast.TypeReference;
import org.eclipse.wst.jsdt.internal.compiler.flow.ExceptionHandlingFlowContext;
import org.eclipse.wst.jsdt.internal.compiler.flow.FlowContext;
import org.eclipse.wst.jsdt.internal.compiler.flow.FlowInfo;
import org.eclipse.wst.jsdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.wst.jsdt.internal.compiler.lookup.BlockScope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.Scope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.wst.jsdt.internal.compiler.parser.Parser;
import org.eclipse.wst.jsdt.internal.compiler.problem.AbortMethod;

public class MethodDeclaration
extends AbstractMethodDeclaration {
    public TypeReference returnType;
    public TypeParameter[] typeParameters;

    public MethodDeclaration(CompilationResult compilationResult) {
        super(compilationResult);
    }

    public FlowInfo analyseCode(Scope scope, FlowContext flowContext, FlowInfo flowInfo) {
        if (this.ignoreFurtherInvestigation) {
            return flowInfo;
        }
        try {
            TypeBinding typeBinding;
            int n;
            int n2;
            if (this.binding == null) {
                return flowInfo;
            }
            if (!this.binding.isUsed() && (this.binding.isPrivate() || (this.binding.modifiers & 0x30000000) == 0 && this.binding.declaringClass.isLocalType()) && !scope.referenceCompilationUnit().compilationResult.hasSyntaxError) {
                this.scope.problemReporter().unusedPrivateMethod(this);
            }
            if (this.binding.isAbstract() || this.binding.isNative()) {
                return flowInfo;
            }
            ExceptionHandlingFlowContext exceptionHandlingFlowContext = new ExceptionHandlingFlowContext(flowContext, this, this.binding.thrownExceptions, this.scope, FlowInfo.DEAD_END);
            if (this.arguments != null) {
                n2 = 0;
                n = this.arguments.length;
                while (n2 < n) {
                    flowInfo.markAsDefinitelyAssigned(this.arguments[n2].binding);
                    ++n2;
                }
            }
            if (this.statements != null) {
                n2 = 0;
                n = 0;
                int n3 = this.statements.length;
                while (n < n3) {
                    Statement statement = this.statements[n];
                    if (!statement.complainIfUnreachable(flowInfo, this.scope, n2 != 0)) {
                        flowInfo = statement.analyseCode(this.scope, exceptionHandlingFlowContext, flowInfo);
                    } else {
                        n2 = 1;
                    }
                    ++n;
                }
            }
            if ((typeBinding = this.binding.returnType) == TypeBinding.VOID || this.isAbstract()) {
                this.needFreeReturn = (flowInfo.tagBits & 1) == 0;
            } else if (!(flowInfo == FlowInfo.DEAD_END || this.inferredMethod != null && this.inferredMethod.isConstructor)) {
                this.scope.problemReporter().shouldReturn(typeBinding, this);
            }
            this.scope.reportUnusedDeclarations();
        }
        catch (AbortMethod abortMethod) {
            this.ignoreFurtherInvestigation = true;
        }
        return flowInfo;
    }

    public boolean isMethod() {
        return true;
    }

    public void parseStatements(Parser parser, CompilationUnitDeclaration compilationUnitDeclaration) {
        if (this.ignoreFurtherInvestigation) {
            return;
        }
        parser.parse(this, compilationUnitDeclaration);
    }

    public StringBuffer printReturnType(int n, StringBuffer stringBuffer) {
        if (this.returnType == null) {
            return stringBuffer;
        }
        return this.returnType.printExpression(0, stringBuffer).append(' ');
    }

    public void resolveStatements() {
        long l;
        int n;
        if (this.returnType != null && this.binding != null) {
            this.returnType.resolvedType = this.binding.returnType;
        }
        if (this.typeParameters != null) {
            int n2 = 0;
            n = this.typeParameters.length;
            while (n2 < n) {
                this.typeParameters[n2].resolve(this.scope);
                ++n2;
            }
        }
        CompilerOptions compilerOptions = this.scope.compilerOptions();
        if (this.binding != null && (l = compilerOptions.sourceLevel) >= 0x310000L) {
            int n3 = this.binding.modifiers;
            boolean bl = (this.binding.tagBits & 0x2000000000000L) != 0L;
            boolean bl2 = this.binding.declaringClass.isInterface();
            if (bl) {
                if (!(!bl2 && (n3 & 0x10000008) == 0x10000000 || l >= 0x320000L && (n3 & 0x20000008) == 0x20000000)) {
                    this.scope.problemReporter().methodMustOverride(this);
                }
            } else if (!bl2 && (n3 & 0x10000008) == 0x10000000) {
                this.scope.problemReporter().missingOverrideAnnotation(this);
            }
        }
        super.resolveStatements();
        if (compilerOptions.getSeverity(0x2000000000000L) != -1 && this.binding != null && ((n = this.binding.modifiers) & 0x30000000) == 0x10000000 && (this.bits & 0x10) == 0) {
            this.scope.problemReporter().overridesMethodWithoutSuperInvocation(this.binding);
        }
    }

    public void traverse(ASTVisitor aSTVisitor, Scope scope) {
        if (aSTVisitor.visit(this, scope)) {
            int n;
            int n2;
            if (this.javadoc != null) {
                this.javadoc.traverse(aSTVisitor, this.scope);
            }
            if (this.annotations != null) {
                n2 = this.annotations.length;
                n = 0;
                while (n < n2) {
                    this.annotations[n].traverse(aSTVisitor, this.scope);
                    ++n;
                }
            }
            if (this.typeParameters != null) {
                n2 = this.typeParameters.length;
                n = 0;
                while (n < n2) {
                    this.typeParameters[n].traverse(aSTVisitor, this.scope);
                    ++n;
                }
            }
            if (this.returnType != null) {
                this.returnType.traverse(aSTVisitor, this.scope);
            }
            if (this.arguments != null) {
                n2 = this.arguments.length;
                n = 0;
                while (n < n2) {
                    this.arguments[n].traverse(aSTVisitor, this.scope);
                    ++n;
                }
            }
            if (this.thrownExceptions != null) {
                n2 = this.thrownExceptions.length;
                n = 0;
                while (n < n2) {
                    this.thrownExceptions[n].traverse(aSTVisitor, this.scope);
                    ++n;
                }
            }
            if (this.statements != null) {
                n2 = this.statements.length;
                n = 0;
                while (n < n2) {
                    this.statements[n].traverse(aSTVisitor, this.scope);
                    ++n;
                }
            }
        }
        aSTVisitor.endVisit(this, scope);
    }

    public void traverse(ASTVisitor aSTVisitor, BlockScope blockScope) {
        if (aSTVisitor.visit(this, (Scope)blockScope)) {
            int n;
            int n2;
            if (this.annotations != null) {
                n2 = this.annotations.length;
                n = 0;
                while (n < n2) {
                    this.annotations[n].traverse(aSTVisitor, this.scope);
                    ++n;
                }
            }
            if (this.typeParameters != null) {
                n2 = this.typeParameters.length;
                n = 0;
                while (n < n2) {
                    this.typeParameters[n].traverse(aSTVisitor, this.scope);
                    ++n;
                }
            }
            if (this.returnType != null) {
                this.returnType.traverse(aSTVisitor, this.scope);
            }
            if (this.arguments != null) {
                n2 = this.arguments.length;
                n = 0;
                while (n < n2) {
                    this.arguments[n].traverse(aSTVisitor, this.scope);
                    ++n;
                }
            }
            if (this.thrownExceptions != null) {
                n2 = this.thrownExceptions.length;
                n = 0;
                while (n < n2) {
                    this.thrownExceptions[n].traverse(aSTVisitor, this.scope);
                    ++n;
                }
            }
            if (this.statements != null) {
                n2 = this.statements.length;
                n = 0;
                while (n < n2) {
                    this.statements[n].traverse(aSTVisitor, this.scope);
                    ++n;
                }
            }
        }
        aSTVisitor.endVisit(this, (Scope)blockScope);
    }

    public TypeParameter[] typeParameters() {
        return this.typeParameters;
    }
}

