/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.compiler.ast;

import org.eclipse.wst.jsdt.internal.compiler.ASTVisitor;
import org.eclipse.wst.jsdt.internal.compiler.ast.Annotation;
import org.eclipse.wst.jsdt.internal.compiler.ast.MemberValuePair;
import org.eclipse.wst.jsdt.internal.compiler.ast.TypeReference;
import org.eclipse.wst.jsdt.internal.compiler.lookup.Binding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.BlockScope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ElementValuePair;

public class NormalAnnotation
extends Annotation {
    public MemberValuePair[] memberValuePairs;

    public NormalAnnotation(TypeReference typeReference, int n) {
        this.type = typeReference;
        this.sourceStart = n;
        this.sourceEnd = typeReference.sourceEnd;
    }

    public ElementValuePair[] computeElementValuePairs() {
        int n;
        int n2 = n = this.memberValuePairs == null ? 0 : this.memberValuePairs.length;
        if (n == 0) {
            return Binding.NO_ELEMENT_VALUE_PAIRS;
        }
        ElementValuePair[] elementValuePairArray = new ElementValuePair[n];
        int n3 = 0;
        while (n3 < n) {
            elementValuePairArray[n3] = this.memberValuePairs[n3].compilerElementPair;
            ++n3;
        }
        return elementValuePairArray;
    }

    public MemberValuePair[] memberValuePairs() {
        return this.memberValuePairs == null ? NoValuePairs : this.memberValuePairs;
    }

    public StringBuffer printExpression(int n, StringBuffer stringBuffer) {
        super.printExpression(n, stringBuffer);
        stringBuffer.append('(');
        if (this.memberValuePairs != null) {
            int n2 = 0;
            int n3 = this.memberValuePairs.length;
            while (n2 < n3) {
                if (n2 > 0) {
                    stringBuffer.append(',');
                }
                this.memberValuePairs[n2].print(n, stringBuffer);
                ++n2;
            }
        }
        stringBuffer.append(')');
        return stringBuffer;
    }

    public void traverse(ASTVisitor aSTVisitor, BlockScope blockScope) {
        if (aSTVisitor.visit(this, blockScope) && this.memberValuePairs != null) {
            int n = this.memberValuePairs.length;
            int n2 = 0;
            while (n2 < n) {
                this.memberValuePairs[n2].traverse(aSTVisitor, blockScope);
                ++n2;
            }
        }
        aSTVisitor.endVisit(this, blockScope);
    }
}

