/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.compiler.ast;

import org.eclipse.wst.jsdt.core.compiler.CategorizedProblem;
import org.eclipse.wst.jsdt.core.compiler.CharOperation;
import org.eclipse.wst.jsdt.internal.compiler.ASTVisitor;
import org.eclipse.wst.jsdt.internal.compiler.ClassFile;
import org.eclipse.wst.jsdt.internal.compiler.CompilationResult;
import org.eclipse.wst.jsdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.Annotation;
import org.eclipse.wst.jsdt.internal.compiler.ast.Argument;
import org.eclipse.wst.jsdt.internal.compiler.ast.Clinit;
import org.eclipse.wst.jsdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.ConstructorDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.Expression;
import org.eclipse.wst.jsdt.internal.compiler.ast.FieldDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.Initializer;
import org.eclipse.wst.jsdt.internal.compiler.ast.Javadoc;
import org.eclipse.wst.jsdt.internal.compiler.ast.MethodDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.QualifiedAllocationExpression;
import org.eclipse.wst.jsdt.internal.compiler.ast.SingleNameReference;
import org.eclipse.wst.jsdt.internal.compiler.ast.Statement;
import org.eclipse.wst.jsdt.internal.compiler.ast.SuperReference;
import org.eclipse.wst.jsdt.internal.compiler.ast.TypeParameter;
import org.eclipse.wst.jsdt.internal.compiler.ast.TypeReference;
import org.eclipse.wst.jsdt.internal.compiler.codegen.CodeStream;
import org.eclipse.wst.jsdt.internal.compiler.flow.FlowContext;
import org.eclipse.wst.jsdt.internal.compiler.flow.FlowInfo;
import org.eclipse.wst.jsdt.internal.compiler.flow.InitializationFlowContext;
import org.eclipse.wst.jsdt.internal.compiler.flow.UnconditionalFlowInfo;
import org.eclipse.wst.jsdt.internal.compiler.impl.ReferenceContext;
import org.eclipse.wst.jsdt.internal.compiler.lookup.Binding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.BlockScope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ClassScope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.CompilationUnitScope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.LocalTypeBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.MemberTypeBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.MethodScope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.NestedTypeBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.SyntheticArgumentBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.wst.jsdt.internal.compiler.lookup.TypeVariableBinding;
import org.eclipse.wst.jsdt.internal.compiler.parser.Parser;
import org.eclipse.wst.jsdt.internal.compiler.problem.AbortCompilation;
import org.eclipse.wst.jsdt.internal.compiler.problem.AbortCompilationUnit;
import org.eclipse.wst.jsdt.internal.compiler.problem.AbortMethod;
import org.eclipse.wst.jsdt.internal.compiler.problem.AbortType;
import org.eclipse.wst.jsdt.internal.compiler.problem.ProblemSeverities;

public class TypeDeclaration
extends Statement
implements ProblemSeverities,
ReferenceContext {
    public static final int CLASS_DECL = 1;
    public static final int INTERFACE_DECL = 2;
    public static final int ENUM_DECL = 3;
    public static final int ANNOTATION_TYPE_DECL = 4;
    public int modifiers = 0;
    public int modifiersSourceStart;
    public Annotation[] annotations;
    public char[] name;
    public TypeReference superclass;
    public TypeReference[] superInterfaces;
    public FieldDeclaration[] fields;
    public AbstractMethodDeclaration[] methods;
    public TypeDeclaration[] memberTypes;
    public SourceTypeBinding binding;
    public ClassScope scope;
    public MethodScope initializerScope;
    public MethodScope staticInitializerScope;
    public boolean ignoreFurtherInvestigation = false;
    public int maxFieldCount;
    public int declarationSourceStart;
    public int declarationSourceEnd;
    public int bodyStart;
    public int bodyEnd;
    public CompilationResult compilationResult;
    public MethodDeclaration[] missingAbstractMethods;
    public Javadoc javadoc;
    public QualifiedAllocationExpression allocation;
    public TypeDeclaration enclosingType;
    public FieldBinding enumValuesSyntheticfield;
    public TypeParameter[] typeParameters;

    public TypeDeclaration(CompilationResult compilationResult) {
        this.compilationResult = compilationResult;
    }

    public void abort(int n, CategorizedProblem categorizedProblem) {
        switch (n) {
            case 2: {
                throw new AbortCompilation(this.compilationResult, categorizedProblem);
            }
            case 4: {
                throw new AbortCompilationUnit(this.compilationResult, categorizedProblem);
            }
            case 16: {
                throw new AbortMethod(this.compilationResult, categorizedProblem);
            }
        }
        throw new AbortType(this.compilationResult, categorizedProblem);
    }

    public final void addClinit() {
        if (this.needClassInitMethod()) {
            AbstractMethodDeclaration[] abstractMethodDeclarationArray = this.methods;
            if (this.methods == null) {
                boolean bl = false;
                abstractMethodDeclarationArray = new AbstractMethodDeclaration[1];
            } else {
                int n = abstractMethodDeclarationArray.length;
                AbstractMethodDeclaration[] abstractMethodDeclarationArray2 = abstractMethodDeclarationArray;
                abstractMethodDeclarationArray = new AbstractMethodDeclaration[n + 1];
                System.arraycopy(abstractMethodDeclarationArray2, 0, abstractMethodDeclarationArray, 1, n);
            }
            Clinit clinit = new Clinit(this.compilationResult);
            abstractMethodDeclarationArray[0] = clinit;
            clinit.declarationSourceStart = clinit.sourceStart = this.sourceStart;
            clinit.declarationSourceEnd = clinit.sourceEnd = this.sourceEnd;
            clinit.bodyEnd = this.sourceEnd;
            this.methods = abstractMethodDeclarationArray;
        }
    }

    public MethodDeclaration addMissingAbstractMethodFor(MethodBinding methodBinding) {
        MethodDeclaration[] methodDeclarationArray;
        TypeBinding[] typeBindingArray = methodBinding.parameters;
        int n = typeBindingArray.length;
        MethodDeclaration methodDeclaration = new MethodDeclaration(this.compilationResult);
        methodDeclaration.selector = methodBinding.selector;
        methodDeclaration.sourceStart = this.sourceStart;
        methodDeclaration.sourceEnd = this.sourceEnd;
        methodDeclaration.modifiers = methodBinding.getAccessFlags() & 0xFFFFFBFF;
        if (n > 0) {
            methodDeclarationArray = "arg";
            methodDeclaration.arguments = new Argument[n];
            Argument[] argumentArray = methodDeclaration.arguments;
            int n2 = n;
            while (--n2 >= 0) {
                argumentArray[n2] = new Argument((String.valueOf(methodDeclarationArray) + n2).toCharArray(), 0L, null, 0);
            }
        }
        if (this.missingAbstractMethods == null) {
            this.missingAbstractMethods = new MethodDeclaration[]{methodDeclaration};
        } else {
            methodDeclarationArray = new MethodDeclaration[this.missingAbstractMethods.length + 1];
            System.arraycopy(this.missingAbstractMethods, 0, methodDeclarationArray, 1, this.missingAbstractMethods.length);
            methodDeclarationArray[0] = methodDeclaration;
            this.missingAbstractMethods = methodDeclarationArray;
        }
        methodDeclaration.binding = new MethodBinding(methodDeclaration.modifiers, methodBinding.selector, methodBinding.returnType, n == 0 ? Binding.NO_PARAMETERS : typeBindingArray, methodBinding.thrownExceptions, this.binding);
        methodDeclaration.scope = new MethodScope(this.scope, methodDeclaration, true);
        methodDeclaration.bindArguments();
        return methodDeclaration;
    }

    public FlowInfo analyseCode(BlockScope blockScope, FlowContext flowContext, FlowInfo flowInfo) {
        if (this.ignoreFurtherInvestigation) {
            return flowInfo;
        }
        try {
            if ((flowInfo.tagBits & 1) == 0) {
                this.bits |= Integer.MIN_VALUE;
                LocalTypeBinding localTypeBinding = (LocalTypeBinding)this.binding;
                localTypeBinding.setConstantPoolName(blockScope.compilationUnitScope().computeConstantPoolName(localTypeBinding));
            }
            this.manageEnclosingInstanceAccessIfNecessary(blockScope, flowInfo);
            this.updateMaxFieldCount();
            this.internalAnalyseCode(flowContext, flowInfo);
        }
        catch (AbortType abortType) {
            this.ignoreFurtherInvestigation = true;
        }
        return flowInfo;
    }

    public void analyseCode(ClassScope classScope) {
        if (this.ignoreFurtherInvestigation) {
            return;
        }
        try {
            this.updateMaxFieldCount();
            this.internalAnalyseCode(null, FlowInfo.initial(this.maxFieldCount));
        }
        catch (AbortType abortType) {
            this.ignoreFurtherInvestigation = true;
        }
    }

    public void analyseCode(ClassScope classScope, FlowContext flowContext, FlowInfo flowInfo) {
        if (this.ignoreFurtherInvestigation) {
            return;
        }
        try {
            if ((flowInfo.tagBits & 1) == 0) {
                this.bits |= Integer.MIN_VALUE;
                LocalTypeBinding localTypeBinding = (LocalTypeBinding)this.binding;
                localTypeBinding.setConstantPoolName(classScope.compilationUnitScope().computeConstantPoolName(localTypeBinding));
            }
            this.manageEnclosingInstanceAccessIfNecessary(classScope, flowInfo);
            this.updateMaxFieldCount();
            this.internalAnalyseCode(flowContext, flowInfo);
        }
        catch (AbortType abortType) {
            this.ignoreFurtherInvestigation = true;
        }
    }

    public void analyseCode(CompilationUnitScope compilationUnitScope) {
        if (this.ignoreFurtherInvestigation) {
            return;
        }
        try {
            this.internalAnalyseCode(null, FlowInfo.initial(this.maxFieldCount));
        }
        catch (AbortType abortType) {
            this.ignoreFurtherInvestigation = true;
        }
    }

    public boolean checkConstructors(Parser parser) {
        boolean bl = false;
        if (this.methods != null) {
            int n = this.methods.length;
            while (--n >= 0) {
                AbstractMethodDeclaration abstractMethodDeclaration = this.methods[n];
                if (!abstractMethodDeclaration.isConstructor()) continue;
                if (!CharOperation.equals(abstractMethodDeclaration.selector, this.name)) {
                    ConstructorDeclaration constructorDeclaration = (ConstructorDeclaration)abstractMethodDeclaration;
                    if (constructorDeclaration.constructorCall != null && !constructorDeclaration.constructorCall.isImplicitSuper()) continue;
                    MethodDeclaration methodDeclaration = parser.convertToMethodDeclaration(constructorDeclaration, this.compilationResult);
                    this.methods[n] = methodDeclaration;
                    continue;
                }
                switch (TypeDeclaration.kind(this.modifiers)) {
                    case 2: {
                        parser.problemReporter().interfaceCannotHaveConstructors((ConstructorDeclaration)abstractMethodDeclaration);
                        break;
                    }
                    case 4: {
                        parser.problemReporter().annotationTypeDeclarationCannotHaveConstructor((ConstructorDeclaration)abstractMethodDeclaration);
                    }
                }
                bl = true;
            }
        }
        return bl;
    }

    public CompilationResult compilationResult() {
        return this.compilationResult;
    }

    public ConstructorDeclaration createDefaultConstructor(boolean bl, boolean bl2) {
        ConstructorDeclaration constructorDeclaration = new ConstructorDeclaration(this.compilationResult);
        constructorDeclaration.bits |= 0x80;
        constructorDeclaration.selector = this.name;
        constructorDeclaration.modifiers = this.modifiers & 7;
        constructorDeclaration.declarationSourceStart = constructorDeclaration.sourceStart = this.sourceStart;
        constructorDeclaration.sourceEnd = constructorDeclaration.bodyEnd = this.sourceEnd;
        constructorDeclaration.declarationSourceEnd = constructorDeclaration.bodyEnd;
        if (bl) {
            constructorDeclaration.constructorCall = SuperReference.implicitSuperConstructorCall();
            constructorDeclaration.constructorCall.sourceStart = this.sourceStart;
            constructorDeclaration.constructorCall.sourceEnd = this.sourceEnd;
        }
        if (bl2) {
            if (this.methods == null) {
                this.methods = new AbstractMethodDeclaration[]{constructorDeclaration};
            } else {
                AbstractMethodDeclaration[] abstractMethodDeclarationArray = new AbstractMethodDeclaration[this.methods.length + 1];
                System.arraycopy(this.methods, 0, abstractMethodDeclarationArray, 1, this.methods.length);
                abstractMethodDeclarationArray[0] = constructorDeclaration;
                this.methods = abstractMethodDeclarationArray;
            }
        }
        return constructorDeclaration;
    }

    public MethodBinding createDefaultConstructorWithBinding(MethodBinding methodBinding) {
        MethodBinding[] methodBindingArray;
        int n;
        Object object;
        String string = "$anonymous";
        TypeBinding[] typeBindingArray = methodBinding.parameters;
        int n2 = typeBindingArray.length;
        ConstructorDeclaration constructorDeclaration = new ConstructorDeclaration(this.compilationResult);
        constructorDeclaration.selector = new char[]{'x'};
        constructorDeclaration.sourceStart = this.sourceStart;
        constructorDeclaration.sourceEnd = this.sourceEnd;
        int n3 = this.modifiers & 7;
        if (methodBinding.isVarargs()) {
            n3 |= 0x80;
        }
        constructorDeclaration.modifiers = n3;
        constructorDeclaration.bits |= 0x80;
        if (n2 > 0) {
            constructorDeclaration.arguments = new Argument[n2];
            object = constructorDeclaration.arguments;
            n = n2;
            while (--n >= 0) {
                object[n] = new Argument((String.valueOf(string) + n).toCharArray(), 0L, null, 0);
            }
        }
        constructorDeclaration.constructorCall = SuperReference.implicitSuperConstructorCall();
        constructorDeclaration.constructorCall.sourceStart = this.sourceStart;
        constructorDeclaration.constructorCall.sourceEnd = this.sourceEnd;
        if (n2 > 0) {
            constructorDeclaration.constructorCall.arguments = new Expression[n2];
            object = constructorDeclaration.constructorCall.arguments;
            n = n2;
            while (--n >= 0) {
                object[n] = new SingleNameReference((String.valueOf(string) + n).toCharArray(), 0L);
            }
        }
        if (this.methods == null) {
            this.methods = new AbstractMethodDeclaration[]{constructorDeclaration};
        } else {
            object = new AbstractMethodDeclaration[this.methods.length + 1];
            System.arraycopy(this.methods, 0, object, 1, this.methods.length);
            object[0] = constructorDeclaration;
            this.methods = object;
        }
        object = this.binding;
        constructorDeclaration.binding = new MethodBinding(constructorDeclaration.modifiers, n2 == 0 ? Binding.NO_PARAMETERS : typeBindingArray, methodBinding.thrownExceptions, (ReferenceBinding)object);
        constructorDeclaration.binding.modifiers |= 0x4000000;
        constructorDeclaration.scope = new MethodScope(this.scope, constructorDeclaration, true);
        constructorDeclaration.bindArguments();
        constructorDeclaration.constructorCall.resolve(constructorDeclaration.scope);
        MethodBinding[] methodBindingArray2 = methodBindingArray = ((SourceTypeBinding)object).methods();
        int n4 = methodBindingArray.length;
        methodBindingArray = new MethodBinding[n4 + 1];
        System.arraycopy(methodBindingArray2, 0, methodBindingArray, 1, n4);
        methodBindingArray[0] = constructorDeclaration.binding;
        if (++n4 > 1) {
            ReferenceBinding.sortMethods(methodBindingArray, 0, n4);
        }
        ((SourceTypeBinding)object).setMethods(methodBindingArray);
        return constructorDeclaration.binding;
    }

    public FieldDeclaration declarationOf(FieldBinding fieldBinding) {
        if (fieldBinding != null && this.fields != null) {
            int n = 0;
            int n2 = this.fields.length;
            while (n < n2) {
                FieldDeclaration fieldDeclaration = this.fields[n];
                if (fieldDeclaration.binding == fieldBinding) {
                    return fieldDeclaration;
                }
                ++n;
            }
        }
        return null;
    }

    public TypeDeclaration declarationOf(MemberTypeBinding memberTypeBinding) {
        if (memberTypeBinding != null && this.memberTypes != null) {
            int n = 0;
            int n2 = this.memberTypes.length;
            while (n < n2) {
                TypeDeclaration typeDeclaration = this.memberTypes[n];
                if (typeDeclaration.binding == memberTypeBinding) {
                    return typeDeclaration;
                }
                ++n;
            }
        }
        return null;
    }

    public AbstractMethodDeclaration declarationOf(MethodBinding methodBinding) {
        if (methodBinding != null && this.methods != null) {
            int n = 0;
            int n2 = this.methods.length;
            while (n < n2) {
                AbstractMethodDeclaration abstractMethodDeclaration = this.methods[n];
                if (abstractMethodDeclaration.binding == methodBinding) {
                    return abstractMethodDeclaration;
                }
                ++n;
            }
        }
        return null;
    }

    public TypeDeclaration declarationOfType(char[][] cArray) {
        int n = cArray.length;
        if (n < 1 || !CharOperation.equals(cArray[0], this.name)) {
            return null;
        }
        if (n == 1) {
            return this;
        }
        char[][] cArrayArray = new char[n - 1][];
        System.arraycopy(cArray, 1, cArrayArray, 0, n - 1);
        int n2 = 0;
        while (n2 < this.memberTypes.length) {
            TypeDeclaration typeDeclaration = this.memberTypes[n2].declarationOfType(cArrayArray);
            if (typeDeclaration != null) {
                return typeDeclaration;
            }
            ++n2;
        }
        return null;
    }

    public void generateCode(ClassFile classFile) {
        if ((this.bits & 0x2000) != 0) {
            return;
        }
        this.bits |= 0x2000;
        if (this.ignoreFurtherInvestigation) {
            if (this.binding == null) {
                return;
            }
            ClassFile.createProblemType(this, this.scope.referenceCompilationUnit().compilationResult);
            return;
        }
        try {
            int n;
            int n2;
            ClassFile classFile2 = ClassFile.getNewInstance(this.binding);
            classFile2.initialize(this.binding, classFile, false);
            if (this.binding.isMemberType()) {
                classFile2.recordInnerClasses(this.binding);
            } else if (this.binding.isLocalType()) {
                classFile.recordInnerClasses(this.binding);
                classFile2.recordInnerClasses(this.binding);
            }
            classFile2.addFieldInfos();
            if (this.memberTypes != null) {
                n2 = 0;
                n = this.memberTypes.length;
                while (n2 < n) {
                    TypeDeclaration typeDeclaration = this.memberTypes[n2];
                    classFile2.recordInnerClasses(typeDeclaration.binding);
                    typeDeclaration.generateCode(this.scope, classFile2);
                    ++n2;
                }
            }
            classFile2.setForMethodInfos();
            if (this.methods != null) {
                n2 = 0;
                n = this.methods.length;
                while (n2 < n) {
                    this.methods[n2].generateCode(this.scope, classFile2);
                    ++n2;
                }
            }
            classFile2.addSpecialMethods();
            if (this.ignoreFurtherInvestigation) {
                throw new AbortType(this.scope.referenceCompilationUnit().compilationResult, null);
            }
            classFile2.addAttributes();
            this.scope.referenceCompilationUnit().compilationResult.record(this.binding.constantPoolName(), classFile2);
        }
        catch (AbortType abortType) {
            if (this.binding == null) {
                return;
            }
            ClassFile.createProblemType(this, this.scope.referenceCompilationUnit().compilationResult);
        }
    }

    public void generateCode(BlockScope blockScope, CodeStream codeStream) {
        if ((this.bits & Integer.MIN_VALUE) == 0) {
            return;
        }
        if ((this.bits & 0x2000) != 0) {
            return;
        }
        int n = codeStream.position;
        if (this.binding != null) {
            ((NestedTypeBinding)this.binding).computeSyntheticArgumentSlotSizes();
        }
        this.generateCode(codeStream.classFile);
        codeStream.recordPositionsFrom(n, this.sourceStart);
    }

    public void generateCode(ClassScope classScope, ClassFile classFile) {
        if ((this.bits & 0x2000) != 0) {
            return;
        }
        if (this.binding != null) {
            ((NestedTypeBinding)this.binding).computeSyntheticArgumentSlotSizes();
        }
        this.generateCode(classFile);
    }

    public void generateCode(CompilationUnitScope compilationUnitScope) {
        this.generateCode((ClassFile)null);
    }

    public boolean hasErrors() {
        return this.ignoreFurtherInvestigation;
    }

    private void internalAnalyseCode(FlowContext flowContext, FlowInfo flowInfo) {
        int n;
        int n2;
        if (!(!this.binding.isPrivate() && (this.binding.tagBits & 0x30L) != 16L || this.binding.isUsed() || this.scope.referenceCompilationUnit().compilationResult.hasSyntaxError)) {
            this.scope.problemReporter().unusedPrivateType(this);
        }
        InitializationFlowContext initializationFlowContext = new InitializationFlowContext(null, this, this.initializerScope);
        InitializationFlowContext initializationFlowContext2 = new InitializationFlowContext(null, this, this.staticInitializerScope);
        FlowInfo flowInfo2 = flowInfo.unconditionalFieldLessCopy();
        FlowInfo flowInfo3 = flowInfo.unconditionalFieldLessCopy();
        if (this.fields != null) {
            n2 = 0;
            n = this.fields.length;
            while (n2 < n) {
                FieldDeclaration fieldDeclaration = this.fields[n2];
                if (fieldDeclaration.isStatic()) {
                    if ((flowInfo3.tagBits & 1) != 0) {
                        fieldDeclaration.bits &= Integer.MAX_VALUE;
                    }
                    initializationFlowContext2.handledExceptions = Binding.ANY_EXCEPTION;
                    if ((flowInfo3 = fieldDeclaration.analyseCode(this.staticInitializerScope, (FlowContext)initializationFlowContext2, flowInfo3)) == FlowInfo.DEAD_END) {
                        this.staticInitializerScope.problemReporter().initializerMustCompleteNormally(fieldDeclaration);
                        flowInfo3 = FlowInfo.initial(this.maxFieldCount).setReachMode(1);
                    }
                } else {
                    if ((flowInfo2.tagBits & 1) != 0) {
                        fieldDeclaration.bits &= Integer.MAX_VALUE;
                    }
                    initializationFlowContext.handledExceptions = Binding.ANY_EXCEPTION;
                    if ((flowInfo2 = fieldDeclaration.analyseCode(this.initializerScope, (FlowContext)initializationFlowContext, flowInfo2)) == FlowInfo.DEAD_END) {
                        this.initializerScope.problemReporter().initializerMustCompleteNormally(fieldDeclaration);
                        flowInfo2 = FlowInfo.initial(this.maxFieldCount).setReachMode(1);
                    }
                }
                ++n2;
            }
        }
        if (this.memberTypes != null) {
            n2 = 0;
            n = this.memberTypes.length;
            while (n2 < n) {
                if (flowContext != null) {
                    this.memberTypes[n2].analyseCode(this.scope, flowContext, ((FlowInfo)flowInfo2).copy().setReachMode(flowInfo.reachMode()));
                } else {
                    this.memberTypes[n2].analyseCode(this.scope);
                }
                ++n2;
            }
        }
        if (this.methods != null) {
            UnconditionalFlowInfo unconditionalFlowInfo = flowInfo.unconditionalFieldLessCopy();
            FlowInfo flowInfo4 = ((FlowInfo)flowInfo2).unconditionalInits().discardNonFieldInitializations().addInitializationsFrom(unconditionalFlowInfo);
            int n3 = 0;
            int n4 = this.methods.length;
            while (n3 < n4) {
                AbstractMethodDeclaration abstractMethodDeclaration = this.methods[n3];
                if (!abstractMethodDeclaration.ignoreFurtherInvestigation) {
                    if (abstractMethodDeclaration.isInitializationMethod()) {
                        if (abstractMethodDeclaration.isStatic()) {
                            abstractMethodDeclaration.analyseCode(this.scope, (FlowContext)initializationFlowContext2, flowInfo3.unconditionalInits().discardNonFieldInitializations().addInitializationsFrom(unconditionalFlowInfo));
                        } else {
                            ((ConstructorDeclaration)abstractMethodDeclaration).analyseCode(this.scope, initializationFlowContext, flowInfo4.copy(), flowInfo.reachMode());
                        }
                    } else {
                        abstractMethodDeclaration.analyseCode(this.scope, null, flowInfo.copy());
                    }
                }
                ++n3;
            }
        }
        if (this.binding.isEnum() && !this.binding.isAnonymousType()) {
            this.enumValuesSyntheticfield = this.binding.addSyntheticFieldForEnumValues();
        }
    }

    public static final int kind(int n) {
        switch (n & 0x6200) {
            case 512: {
                return 2;
            }
            case 8704: {
                return 4;
            }
            case 16384: {
                return 3;
            }
        }
        return 1;
    }

    public void manageEnclosingInstanceAccessIfNecessary(BlockScope blockScope, FlowInfo flowInfo) {
        if ((flowInfo.tagBits & 1) != 0) {
            return;
        }
        NestedTypeBinding nestedTypeBinding = (NestedTypeBinding)this.binding;
        MethodScope methodScope = blockScope.methodScope();
        if (!methodScope.isStatic && !methodScope.isConstructorCall) {
            nestedTypeBinding.addSyntheticArgumentAndField(nestedTypeBinding.enclosingType());
        }
        if (nestedTypeBinding.isAnonymousType()) {
            NestedTypeBinding nestedTypeBinding2;
            SyntheticArgumentBinding syntheticArgumentBinding;
            ReferenceBinding referenceBinding;
            ReferenceBinding referenceBinding2 = (ReferenceBinding)nestedTypeBinding.superclass.erasure();
            if (!(referenceBinding2.enclosingType() == null || referenceBinding2.isStatic() || referenceBinding2.isLocalType() && ((NestedTypeBinding)referenceBinding2).getSyntheticField(referenceBinding2.enclosingType(), true) == null)) {
                nestedTypeBinding.addSyntheticArgument(referenceBinding2.enclosingType());
            }
            if (!methodScope.isStatic && methodScope.isConstructorCall && blockScope.compilerOptions().complianceLevel >= 0x310000L && (referenceBinding = nestedTypeBinding.enclosingType()).isNestedType() && (syntheticArgumentBinding = (nestedTypeBinding2 = (NestedTypeBinding)referenceBinding).getSyntheticArgument(nestedTypeBinding2.enclosingType(), true)) != null) {
                nestedTypeBinding.addSyntheticArgumentAndField(syntheticArgumentBinding);
            }
        }
    }

    public void manageEnclosingInstanceAccessIfNecessary(ClassScope classScope, FlowInfo flowInfo) {
        if ((flowInfo.tagBits & 1) == 0) {
            NestedTypeBinding nestedTypeBinding = (NestedTypeBinding)this.binding;
            nestedTypeBinding.addSyntheticArgumentAndField(this.binding.enclosingType());
        }
    }

    public final boolean needClassInitMethod() {
        if ((this.bits & 1) != 0) {
            return true;
        }
        switch (TypeDeclaration.kind(this.modifiers)) {
            case 2: 
            case 4: {
                return this.fields != null;
            }
            case 3: {
                return true;
            }
        }
        if (this.fields != null) {
            int n = this.fields.length;
            while (--n >= 0) {
                FieldDeclaration fieldDeclaration = this.fields[n];
                if ((fieldDeclaration.modifiers & 8) == 0) continue;
                return true;
            }
        }
        return false;
    }

    public void parseMethod(Parser parser, CompilationUnitDeclaration compilationUnitDeclaration) {
        int n;
        int n2;
        if (compilationUnitDeclaration.ignoreMethodBodies) {
            return;
        }
        if (this.memberTypes != null) {
            n2 = this.memberTypes.length;
            n = 0;
            while (n < n2) {
                this.memberTypes[n].parseMethod(parser, compilationUnitDeclaration);
                ++n;
            }
        }
        if (this.methods != null) {
            n2 = this.methods.length;
            n = 0;
            while (n < n2) {
                this.methods[n].parseStatements(parser, compilationUnitDeclaration);
                ++n;
            }
        }
        if (this.fields != null) {
            n2 = this.fields.length;
            n = 0;
            while (n < n2) {
                FieldDeclaration fieldDeclaration = this.fields[n];
                switch (fieldDeclaration.getKind()) {
                    case 2: {
                        ((Initializer)fieldDeclaration).parseStatements(parser, this, compilationUnitDeclaration);
                    }
                }
                ++n;
            }
        }
    }

    public StringBuffer print(int n, StringBuffer stringBuffer) {
        if (this.javadoc != null) {
            this.javadoc.print(n, stringBuffer);
        }
        if ((this.bits & 0x200) == 0) {
            TypeDeclaration.printIndent(n, stringBuffer);
            this.printHeader(0, stringBuffer);
        }
        return this.printBody(n, stringBuffer);
    }

    public StringBuffer printBody(int n, StringBuffer stringBuffer) {
        int n2;
        stringBuffer.append(" {");
        if (this.memberTypes != null) {
            n2 = 0;
            while (n2 < this.memberTypes.length) {
                if (this.memberTypes[n2] != null) {
                    stringBuffer.append('\n');
                    this.memberTypes[n2].print(n + 1, stringBuffer);
                }
                ++n2;
            }
        }
        if (this.fields != null) {
            n2 = 0;
            while (n2 < this.fields.length) {
                if (this.fields[n2] != null) {
                    stringBuffer.append('\n');
                    this.fields[n2].print(n + 1, stringBuffer);
                }
                ++n2;
            }
        }
        if (this.methods != null) {
            n2 = 0;
            while (n2 < this.methods.length) {
                if (this.methods[n2] != null) {
                    stringBuffer.append('\n');
                    this.methods[n2].print(n + 1, stringBuffer);
                }
                ++n2;
            }
        }
        stringBuffer.append('\n');
        return TypeDeclaration.printIndent(n, stringBuffer).append('}');
    }

    public StringBuffer printHeader(int n, StringBuffer stringBuffer) {
        int n2;
        TypeDeclaration.printModifiers(this.modifiers, stringBuffer);
        if (this.annotations != null) {
            TypeDeclaration.printAnnotations(this.annotations, stringBuffer);
        }
        switch (TypeDeclaration.kind(this.modifiers)) {
            case 1: {
                stringBuffer.append("class ");
                break;
            }
            case 2: {
                stringBuffer.append("interface ");
                break;
            }
            case 3: {
                stringBuffer.append("enum ");
                break;
            }
            case 4: {
                stringBuffer.append("@interface ");
            }
        }
        stringBuffer.append(this.name);
        if (this.typeParameters != null) {
            stringBuffer.append("<");
            n2 = 0;
            while (n2 < this.typeParameters.length) {
                if (n2 > 0) {
                    stringBuffer.append(", ");
                }
                this.typeParameters[n2].print(0, stringBuffer);
                ++n2;
            }
            stringBuffer.append(">");
        }
        if (this.superclass != null) {
            stringBuffer.append(" extends ");
            this.superclass.print(0, stringBuffer);
        }
        if (this.superInterfaces != null && this.superInterfaces.length > 0) {
            switch (TypeDeclaration.kind(this.modifiers)) {
                case 1: 
                case 3: {
                    stringBuffer.append(" implements ");
                    break;
                }
                case 2: 
                case 4: {
                    stringBuffer.append(" extends ");
                }
            }
            n2 = 0;
            while (n2 < this.superInterfaces.length) {
                if (n2 > 0) {
                    stringBuffer.append(", ");
                }
                this.superInterfaces[n2].print(0, stringBuffer);
                ++n2;
            }
        }
        return stringBuffer;
    }

    public StringBuffer printStatement(int n, StringBuffer stringBuffer) {
        return this.print(n, stringBuffer);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void resolve() {
        var1_1 = this.binding;
        if (var1_1 == null) {
            this.ignoreFurtherInvestigation = true;
            return;
        }
        try {
            block46: {
                block48: {
                    block47: {
                        block44: {
                            var2_2 = this.staticInitializerScope.insideTypeAnnotation;
                            try {
                                this.staticInitializerScope.insideTypeAnnotation = true;
                                TypeDeclaration.resolveAnnotations(this.staticInitializerScope, this.annotations, var1_1);
                            }
                            catch (Throwable var4_3) {
                                var3_6 = null;
                                this.staticInitializerScope.insideTypeAnnotation = var2_2;
                                throw var4_3;
                            }
                            {
                                var3_7 = null;
                                this.staticInitializerScope.insideTypeAnnotation = var2_2;
                                if ((var1_1.getAnnotationTagBits() & 0x400000000000L) == 0L && (var1_1.modifiers & 0x100000) != 0 && this.scope.compilerOptions().sourceLevel >= 0x310000L) {
                                    this.scope.problemReporter().missingDeprecatedAnnotationForType(this);
                                }
                                if ((this.bits & 8) == 0) break block44;
                                this.scope.problemReporter().undocumentedEmptyBlock(this.bodyStart - 1, this.bodyEnd);
                            }
                        }
                        v0 = var3_8 = this.scope.compilerOptions().getSeverity(0x100000000L) != -1 && var1_1.isClass() != false && var1_1.isAbstract() == false && var1_1.findSuperTypeErasingTo(56, false) == null && var1_1.findSuperTypeErasingTo(37, false) != null;
                        if (!var3_8) break block46;
                        var4_4 = this.scope.compilationUnitScope();
                        var5_9 = var1_1.getExactMethod(TypeConstants.WRITEREPLACE, new TypeBinding[0], (CompilationUnitScope)var4_4);
                        if (var5_9 == null || !var5_9.isValidBinding() || var5_9.returnType.id != 1) ** GOTO lbl-1000
                        var6_11 = var5_9.thrownExceptions;
                        if (var5_9.thrownExceptions.length == 1 && var6_11[0].id == 57) {
                            v1 = false;
                        } else lbl-1000:
                        // 2 sources

                        {
                            v1 = var3_8 = true;
                        }
                        if (!var3_8) break block46;
                        var7_13 = 0;
                        var8_14 = 0;
                        var9_15 = this.scope.getType(TypeConstants.JAVA_IO_OBJECTOUTPUTSTREAM, 3);
                        if (!var9_15.isValidBinding()) break block47;
                        var5_9 = var1_1.getExactMethod(TypeConstants.WRITEOBJECT, new TypeBinding[]{var9_15}, (CompilationUnitScope)var4_4);
                        if (var5_9 == null || !var5_9.isValidBinding() || var5_9.modifiers != 2 || var5_9.returnType != TypeBinding.VOID) ** GOTO lbl-1000
                        var6_11 = var5_9.thrownExceptions;
                        if (var5_9.thrownExceptions.length == 1 && var6_11[0].id == 58) {
                            v2 = 1;
                        } else lbl-1000:
                        // 2 sources

                        {
                            v2 = var7_13 = 0;
                        }
                    }
                    if (!(var9_15 = this.scope.getType(TypeConstants.JAVA_IO_OBJECTINPUTSTREAM, 3)).isValidBinding()) break block48;
                    var5_9 = var1_1.getExactMethod(TypeConstants.READOBJECT, new TypeBinding[]{var9_15}, (CompilationUnitScope)var4_4);
                    if (var5_9 == null || !var5_9.isValidBinding() || var5_9.modifiers != 2 || var5_9.returnType != TypeBinding.VOID) ** GOTO lbl-1000
                    var6_11 = var5_9.thrownExceptions;
                    if (var5_9.thrownExceptions.length == 1 && var6_11[0].id == 58) {
                        v3 = 1;
                    } else lbl-1000:
                    // 2 sources

                    {
                        v3 = 0;
                    }
                    var8_14 = v3;
                }
                v4 = var3_8 = var7_13 == 0 || var8_14 == 0;
            }
            if (var1_1.findSuperTypeErasingTo(21, true) != null) {
                var4_4 = var1_1;
                do {
                    if (var4_4.isGenericType()) {
                        this.scope.problemReporter().genericTypeCannotExtendThrowable(this);
                        break;
                    }
                    if (var4_4.isStatic()) break;
                    if (!var4_4.isLocalType()) continue;
                    var5_9 = (NestedTypeBinding)var4_4.erasure();
                    if (var5_9.scope.methodScope().isStatic) break;
                } while ((var4_4 = var4_4.enclosingType()) != null);
            }
            this.maxFieldCount = 0;
            var4_5 = -1;
            var5_10 = false;
            var6_12 = false;
            if (this.typeParameters != null) {
                var7_13 = 0;
                var8_14 = this.typeParameters.length;
                while (var7_13 < var8_14) {
                    this.typeParameters[var7_13].resolve(this.scope);
                    ++var7_13;
                }
            }
            if (this.memberTypes != null) {
                var7_13 = 0;
                var8_14 = this.memberTypes.length;
                while (var7_13 < var8_14) {
                    this.memberTypes[var7_13].resolve(this.scope);
                    ++var7_13;
                }
            }
            if (this.fields != null) {
                var7_13 = 0;
                var8_14 = this.fields.length;
                while (var7_13 < var8_14) {
                    block45: {
                        var9_15 = this.fields[var7_13];
                        switch (var9_15.getKind()) {
                            case 3: {
                                var5_10 = true;
                                if (!(var9_15.initialization instanceof QualifiedAllocationExpression)) {
                                    var6_12 = true;
                                }
                            }
                            case 1: {
                                var10_17 = var9_15.binding;
                                if (var10_17 == null) {
                                    if (var9_15.initialization != null) {
                                        var9_15.initialization.resolve(var9_15.isStatic() != false ? this.staticInitializerScope : this.initializerScope);
                                    }
                                    this.ignoreFurtherInvestigation = true;
                                    break block45;
                                } else {
                                    if (var3_8 && (var10_17.modifiers & 24) == 24 && CharOperation.equals(TypeConstants.SERIALVERSIONUID, var10_17.name) && TypeBinding.LONG == var10_17.type) {
                                        var3_8 = false;
                                    }
                                    ++this.maxFieldCount;
                                    var4_5 = var9_15.binding.id;
                                    break;
                                }
                            }
                            case 2: {
                                ((Initializer)var9_15).lastVisibleFieldID = var4_5 + 1;
                            }
                        }
                        var9_15.resolve(var9_15.isStatic() != false ? this.staticInitializerScope : this.initializerScope);
                    }
                    ++var7_13;
                }
            }
            if (var3_8) {
                this.scope.problemReporter().missingSerialVersion(this);
            }
            switch (TypeDeclaration.kind(this.modifiers)) {
                case 4: {
                    if (this.superclass != null) {
                        this.scope.problemReporter().annotationTypeDeclarationCannotHaveSuperclass(this);
                    }
                    if (this.superInterfaces == null) break;
                    this.scope.problemReporter().annotationTypeDeclarationCannotHaveSuperinterfaces(this);
                    break;
                }
                case 3: {
                    if (!this.binding.isAbstract() || var5_10 && !var6_12) break;
                    var7_13 = 0;
                    var8_14 = this.methods.length;
                    while (var7_13 < var8_14) {
                        var9_15 = this.methods[var7_13];
                        if (var9_15.isAbstract() && var9_15.binding != null) {
                            this.scope.problemReporter().enumAbstractMethodMustBeImplemented((AbstractMethodDeclaration)var9_15);
                        }
                        ++var7_13;
                    }
                    break;
                }
            }
            var7_13 = this.missingAbstractMethods == null ? 0 : this.missingAbstractMethods.length;
            v5 = var8_14 = this.methods == null ? 0 : this.methods.length;
            if (var8_14 + var7_13 > 65535) {
                this.scope.problemReporter().tooManyMethods(this);
            }
            if (this.methods != null) {
                var9_16 = 0;
                var10_18 = this.methods.length;
                while (var9_16 < var10_18) {
                    this.methods[var9_16].resolve(this.scope);
                    ++var9_16;
                }
            }
            if (this.javadoc != null) {
                if (this.scope == null) return;
                if (this.name == TypeConstants.PACKAGE_INFO_NAME) return;
                this.javadoc.resolve(this.scope);
                return;
            }
            if (var1_1 == null) return;
            if (var1_1.isLocalType() != false) return;
            this.scope.problemReporter().javadocMissing(this.sourceStart, this.sourceEnd, var1_1.modifiers);
            return;
        }
        catch (AbortType v6) {
            this.ignoreFurtherInvestigation = true;
            return;
        }
    }

    public void resolve(BlockScope blockScope) {
        if ((this.bits & 0x200) == 0) {
            TypeBinding typeBinding = blockScope.getType(this.name);
            if (typeBinding instanceof ReferenceBinding && typeBinding != this.binding && typeBinding.isValidBinding()) {
                ReferenceBinding referenceBinding = (ReferenceBinding)typeBinding;
                if (referenceBinding instanceof TypeVariableBinding) {
                    blockScope.problemReporter().typeHiding(this, (TypeVariableBinding)referenceBinding);
                } else if (referenceBinding instanceof LocalTypeBinding && ((LocalTypeBinding)referenceBinding).scope.methodScope() == blockScope.methodScope()) {
                    blockScope.problemReporter().duplicateNestedType(this);
                } else if (blockScope.isDefinedInType(referenceBinding)) {
                    blockScope.problemReporter().typeCollidesWithEnclosingType(this);
                } else if (blockScope.isDefinedInSameUnit(referenceBinding)) {
                    blockScope.problemReporter().typeHiding(this, referenceBinding);
                }
            }
            blockScope.addLocalType(this);
        }
        if (this.binding != null) {
            blockScope.referenceCompilationUnit().record((LocalTypeBinding)this.binding);
            this.resolve();
            this.updateMaxFieldCount();
        }
    }

    public void resolve(ClassScope classScope) {
        if (this.binding != null && this.binding instanceof LocalTypeBinding) {
            classScope.referenceCompilationUnit().record((LocalTypeBinding)this.binding);
        }
        this.resolve();
        this.updateMaxFieldCount();
    }

    public void resolve(CompilationUnitScope compilationUnitScope) {
        this.resolve();
        this.updateMaxFieldCount();
    }

    public void tagAsHavingErrors() {
        this.ignoreFurtherInvestigation = true;
    }

    public void traverse(ASTVisitor aSTVisitor, CompilationUnitScope compilationUnitScope) {
        if (this.ignoreFurtherInvestigation) {
            return;
        }
        try {
            if (aSTVisitor.visit(this, compilationUnitScope)) {
                int n;
                int n2;
                if (this.javadoc != null) {
                    this.javadoc.traverse(aSTVisitor, this.scope);
                }
                if (this.annotations != null) {
                    n2 = this.annotations.length;
                    n = 0;
                    while (n < n2) {
                        this.annotations[n].traverse(aSTVisitor, this.staticInitializerScope);
                        ++n;
                    }
                }
                if (this.superclass != null) {
                    this.superclass.traverse(aSTVisitor, this.scope);
                }
                if (this.superInterfaces != null) {
                    n2 = this.superInterfaces.length;
                    n = 0;
                    while (n < n2) {
                        this.superInterfaces[n].traverse(aSTVisitor, this.scope);
                        ++n;
                    }
                }
                if (this.typeParameters != null) {
                    n2 = this.typeParameters.length;
                    n = 0;
                    while (n < n2) {
                        this.typeParameters[n].traverse(aSTVisitor, this.scope);
                        ++n;
                    }
                }
                if (this.memberTypes != null) {
                    n2 = this.memberTypes.length;
                    n = 0;
                    while (n < n2) {
                        this.memberTypes[n].traverse(aSTVisitor, this.scope);
                        ++n;
                    }
                }
                if (this.fields != null) {
                    n2 = this.fields.length;
                    n = 0;
                    while (n < n2) {
                        FieldDeclaration fieldDeclaration = this.fields[n];
                        if (fieldDeclaration.isStatic()) {
                            fieldDeclaration.traverse(aSTVisitor, this.staticInitializerScope);
                        } else {
                            fieldDeclaration.traverse(aSTVisitor, this.initializerScope);
                        }
                        ++n;
                    }
                }
                if (this.methods != null) {
                    n2 = this.methods.length;
                    n = 0;
                    while (n < n2) {
                        this.methods[n].traverse(aSTVisitor, this.scope);
                        ++n;
                    }
                }
            }
            aSTVisitor.endVisit(this, compilationUnitScope);
        }
        catch (AbortType abortType) {}
    }

    public void traverse(ASTVisitor aSTVisitor, BlockScope blockScope) {
        if (this.ignoreFurtherInvestigation) {
            return;
        }
        try {
            if (aSTVisitor.visit(this, blockScope)) {
                int n;
                int n2;
                if (this.javadoc != null) {
                    this.javadoc.traverse(aSTVisitor, this.scope);
                }
                if (this.annotations != null) {
                    n2 = this.annotations.length;
                    n = 0;
                    while (n < n2) {
                        this.annotations[n].traverse(aSTVisitor, this.staticInitializerScope);
                        ++n;
                    }
                }
                if (this.superclass != null) {
                    this.superclass.traverse(aSTVisitor, this.scope);
                }
                if (this.superInterfaces != null) {
                    n2 = this.superInterfaces.length;
                    n = 0;
                    while (n < n2) {
                        this.superInterfaces[n].traverse(aSTVisitor, this.scope);
                        ++n;
                    }
                }
                if (this.typeParameters != null) {
                    n2 = this.typeParameters.length;
                    n = 0;
                    while (n < n2) {
                        this.typeParameters[n].traverse(aSTVisitor, this.scope);
                        ++n;
                    }
                }
                if (this.memberTypes != null) {
                    n2 = this.memberTypes.length;
                    n = 0;
                    while (n < n2) {
                        this.memberTypes[n].traverse(aSTVisitor, this.scope);
                        ++n;
                    }
                }
                if (this.fields != null) {
                    n2 = this.fields.length;
                    n = 0;
                    while (n < n2) {
                        FieldDeclaration fieldDeclaration = this.fields[n];
                        if (!fieldDeclaration.isStatic()) {
                            fieldDeclaration.traverse(aSTVisitor, this.initializerScope);
                        }
                        ++n;
                    }
                }
                if (this.methods != null) {
                    n2 = this.methods.length;
                    n = 0;
                    while (n < n2) {
                        this.methods[n].traverse(aSTVisitor, this.scope);
                        ++n;
                    }
                }
            }
            aSTVisitor.endVisit(this, blockScope);
        }
        catch (AbortType abortType) {}
    }

    public void traverse(ASTVisitor aSTVisitor, ClassScope classScope) {
        if (this.ignoreFurtherInvestigation) {
            return;
        }
        try {
            if (aSTVisitor.visit(this, classScope)) {
                int n;
                int n2;
                if (this.javadoc != null) {
                    this.javadoc.traverse(aSTVisitor, this.scope);
                }
                if (this.annotations != null) {
                    n2 = this.annotations.length;
                    n = 0;
                    while (n < n2) {
                        this.annotations[n].traverse(aSTVisitor, this.staticInitializerScope);
                        ++n;
                    }
                }
                if (this.superclass != null) {
                    this.superclass.traverse(aSTVisitor, this.scope);
                }
                if (this.superInterfaces != null) {
                    n2 = this.superInterfaces.length;
                    n = 0;
                    while (n < n2) {
                        this.superInterfaces[n].traverse(aSTVisitor, this.scope);
                        ++n;
                    }
                }
                if (this.typeParameters != null) {
                    n2 = this.typeParameters.length;
                    n = 0;
                    while (n < n2) {
                        this.typeParameters[n].traverse(aSTVisitor, this.scope);
                        ++n;
                    }
                }
                if (this.memberTypes != null) {
                    n2 = this.memberTypes.length;
                    n = 0;
                    while (n < n2) {
                        this.memberTypes[n].traverse(aSTVisitor, this.scope);
                        ++n;
                    }
                }
                if (this.fields != null) {
                    n2 = this.fields.length;
                    n = 0;
                    while (n < n2) {
                        FieldDeclaration fieldDeclaration = this.fields[n];
                        if (fieldDeclaration.isStatic()) {
                            fieldDeclaration.traverse(aSTVisitor, this.staticInitializerScope);
                        } else {
                            fieldDeclaration.traverse(aSTVisitor, this.initializerScope);
                        }
                        ++n;
                    }
                }
                if (this.methods != null) {
                    n2 = this.methods.length;
                    n = 0;
                    while (n < n2) {
                        this.methods[n].traverse(aSTVisitor, this.scope);
                        ++n;
                    }
                }
            }
            aSTVisitor.endVisit(this, classScope);
        }
        catch (AbortType abortType) {}
    }

    void updateMaxFieldCount() {
        if (this.binding == null) {
            return;
        }
        TypeDeclaration typeDeclaration = this.scope.outerMostClassScope().referenceType();
        if (this.maxFieldCount > typeDeclaration.maxFieldCount) {
            typeDeclaration.maxFieldCount = this.maxFieldCount;
        } else {
            this.maxFieldCount = typeDeclaration.maxFieldCount;
        }
    }

    public boolean isSecondary() {
        return (this.bits & 0x1000) != 0;
    }
}

