/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.compiler.ast;

import org.eclipse.wst.jsdt.internal.compiler.ASTVisitor;
import org.eclipse.wst.jsdt.internal.compiler.ast.ArrayTypeReference;
import org.eclipse.wst.jsdt.internal.compiler.ast.Expression;
import org.eclipse.wst.jsdt.internal.compiler.ast.SingleTypeReference;
import org.eclipse.wst.jsdt.internal.compiler.flow.FlowContext;
import org.eclipse.wst.jsdt.internal.compiler.flow.FlowInfo;
import org.eclipse.wst.jsdt.internal.compiler.impl.Constant;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ArrayBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.BlockScope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ClassScope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ProblemReferenceBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.Scope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.TypeBinding;

public abstract class TypeReference
extends Expression {
    public FlowInfo analyseCode(BlockScope blockScope, FlowContext flowContext, FlowInfo flowInfo) {
        return flowInfo;
    }

    public void aboutToResolve(Scope scope) {
    }

    public static final TypeReference baseTypeReference(int n, int n2) {
        if (n2 == 0) {
            switch (n) {
                case 6: {
                    return new SingleTypeReference(TypeBinding.VOID.simpleName, 0L);
                }
                case 5: {
                    return new SingleTypeReference(TypeBinding.BOOLEAN.simpleName, 0L);
                }
                case 2: {
                    return new SingleTypeReference(TypeBinding.CHAR.simpleName, 0L);
                }
                case 9: {
                    return new SingleTypeReference(TypeBinding.FLOAT.simpleName, 0L);
                }
                case 8: {
                    return new SingleTypeReference(TypeBinding.DOUBLE.simpleName, 0L);
                }
                case 3: {
                    return new SingleTypeReference(TypeBinding.BYTE.simpleName, 0L);
                }
                case 4: {
                    return new SingleTypeReference(TypeBinding.SHORT.simpleName, 0L);
                }
                case 10: {
                    return new SingleTypeReference(TypeBinding.INT.simpleName, 0L);
                }
            }
            return new SingleTypeReference(TypeBinding.LONG.simpleName, 0L);
        }
        switch (n) {
            case 6: {
                return new ArrayTypeReference(TypeBinding.VOID.simpleName, n2, 0L);
            }
            case 5: {
                return new ArrayTypeReference(TypeBinding.BOOLEAN.simpleName, n2, 0L);
            }
            case 2: {
                return new ArrayTypeReference(TypeBinding.CHAR.simpleName, n2, 0L);
            }
            case 9: {
                return new ArrayTypeReference(TypeBinding.FLOAT.simpleName, n2, 0L);
            }
            case 8: {
                return new ArrayTypeReference(TypeBinding.DOUBLE.simpleName, n2, 0L);
            }
            case 3: {
                return new ArrayTypeReference(TypeBinding.BYTE.simpleName, n2, 0L);
            }
            case 4: {
                return new ArrayTypeReference(TypeBinding.SHORT.simpleName, n2, 0L);
            }
            case 10: {
                return new ArrayTypeReference(TypeBinding.INT.simpleName, n2, 0L);
            }
        }
        return new ArrayTypeReference(TypeBinding.LONG.simpleName, n2, 0L);
    }

    public void checkBounds(Scope scope) {
    }

    public abstract TypeReference copyDims(int var1);

    public int dimensions() {
        return 0;
    }

    public abstract char[] getLastToken();

    public char[][] getParameterizedTypeName() {
        return this.getTypeName();
    }

    protected abstract TypeBinding getTypeBinding(Scope var1);

    public abstract char[][] getTypeName();

    public char[] getSimpleTypeName() {
        char[][] cArray = this.getTypeName();
        return cArray[cArray.length - 1];
    }

    public boolean isTypeReference() {
        return true;
    }

    public TypeBinding resolveSuperType(ClassScope classScope) {
        if (this.resolveType(classScope) == null) {
            return null;
        }
        if (this.resolvedType.isTypeVariable()) {
            this.resolvedType = new ProblemReferenceBinding(this.getTypeName(), (ReferenceBinding)this.resolvedType, 9);
            this.reportInvalidType(classScope);
            return null;
        }
        return this.resolvedType;
    }

    public final TypeBinding resolveType(BlockScope blockScope) {
        return this.resolveType(blockScope, true);
    }

    public TypeBinding resolveType(BlockScope blockScope, boolean bl) {
        this.constant = Constant.NotAConstant;
        if (this.resolvedType != null) {
            return this.resolvedType.isValidBinding() ? this.resolvedType : null;
        }
        this.resolvedType = this.getTypeBinding(blockScope);
        TypeBinding typeBinding = this.resolvedType;
        if (typeBinding == null) {
            return null;
        }
        if (!typeBinding.isValidBinding()) {
            this.reportInvalidType(blockScope);
            return null;
        }
        if (typeBinding.isArrayType() && ((ArrayBinding)typeBinding).leafComponentType == TypeBinding.VOID) {
            blockScope.problemReporter().cannotAllocateVoidArray(this);
            return null;
        }
        if (this.isTypeUseDeprecated(typeBinding, blockScope)) {
            this.reportDeprecatedType(typeBinding, blockScope);
        }
        if ((typeBinding = blockScope.environment().convertToRawType(typeBinding)).leafComponentType().isRawType() && (this.bits & 0x40000000) == 0 && blockScope.compilerOptions().getSeverity(0x200000000000L) != -1) {
            blockScope.problemReporter().rawTypeReference(this, typeBinding);
        }
        this.resolvedType = typeBinding;
        return this.resolvedType;
    }

    public TypeBinding resolveType(ClassScope classScope) {
        this.constant = Constant.NotAConstant;
        if (this.resolvedType != null) {
            return this.resolvedType.isValidBinding() ? this.resolvedType : null;
        }
        this.resolvedType = this.getTypeBinding(classScope);
        TypeBinding typeBinding = this.resolvedType;
        if (typeBinding == null) {
            return null;
        }
        if (!typeBinding.isValidBinding()) {
            this.reportInvalidType(classScope);
            return null;
        }
        if (typeBinding.isArrayType() && ((ArrayBinding)typeBinding).leafComponentType == TypeBinding.VOID) {
            classScope.problemReporter().cannotAllocateVoidArray(this);
            return null;
        }
        if (this.isTypeUseDeprecated(typeBinding, classScope)) {
            this.reportDeprecatedType(typeBinding, classScope);
        }
        if ((typeBinding = classScope.environment().convertToRawType(typeBinding)).leafComponentType().isRawType() && (this.bits & 0x40000000) == 0 && classScope.compilerOptions().getSeverity(0x200000000000L) != -1) {
            classScope.problemReporter().rawTypeReference(this, typeBinding);
        }
        this.resolvedType = typeBinding;
        return this.resolvedType;
    }

    public TypeBinding resolveTypeArgument(BlockScope blockScope, ReferenceBinding referenceBinding, int n) {
        return this.resolveType(blockScope, true);
    }

    public TypeBinding resolveTypeArgument(ClassScope classScope, ReferenceBinding referenceBinding, int n) {
        return this.resolveType(classScope);
    }

    protected void reportInvalidType(Scope scope) {
        scope.problemReporter().invalidType(this, this.resolvedType);
    }

    protected void reportDeprecatedType(TypeBinding typeBinding, Scope scope) {
        scope.problemReporter().deprecatedType(typeBinding, this);
    }

    public abstract void traverse(ASTVisitor var1, BlockScope var2);

    public abstract void traverse(ASTVisitor var1, ClassScope var2);
}

