/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.compiler.codegen;

import org.eclipse.wst.jsdt.core.compiler.CharOperation;
import org.eclipse.wst.jsdt.internal.compiler.codegen.CodeStream;
import org.eclipse.wst.jsdt.internal.compiler.codegen.Label;
import org.eclipse.wst.jsdt.internal.compiler.lookup.TypeBinding;

public class ExceptionLabel
extends Label {
    public int[] ranges = new int[]{-1, -1};
    public int count = 0;
    public TypeBinding exceptionType;

    public ExceptionLabel(CodeStream codeStream, TypeBinding typeBinding) {
        super(codeStream);
        this.exceptionType = typeBinding;
    }

    public void place() {
        this.codeStream.registerExceptionHandler(this);
        this.position = this.codeStream.getPosition();
    }

    public void placeEnd() {
        int n = this.codeStream.position;
        if (this.ranges[this.count - 1] == n) {
            --this.count;
        } else {
            this.ranges[this.count++] = n;
        }
    }

    public void placeStart() {
        int n = this.codeStream.position;
        if (this.count > 0 && this.ranges[this.count - 1] == n) {
            --this.count;
            return;
        }
        int n2 = this.ranges.length;
        if (this.count == n2) {
            this.ranges = new int[n2 * 2];
            System.arraycopy(this.ranges, 0, this.ranges, 0, n2);
        }
        this.ranges[this.count++] = n;
    }

    public String toString() {
        String string = this.getClass().getName();
        string = string.substring(string.lastIndexOf(46) + 1);
        StringBuffer stringBuffer = new StringBuffer(string);
        stringBuffer.append('@').append(Integer.toHexString(this.hashCode()));
        stringBuffer.append("(type=").append(this.exceptionType == null ? CharOperation.NO_CHAR : this.exceptionType.readableName());
        stringBuffer.append(", position=").append(this.position);
        stringBuffer.append(", ranges = ");
        if (this.count == 0) {
            stringBuffer.append("[]");
        } else {
            int n = 0;
            while (n < this.count) {
                if ((n & 1) == 0) {
                    stringBuffer.append("[").append(this.ranges[n]);
                } else {
                    stringBuffer.append(",").append(this.ranges[n]).append("]");
                }
                ++n;
            }
            if ((this.count & 1) == 1) {
                stringBuffer.append(",?]");
            }
        }
        stringBuffer.append(')');
        return stringBuffer.toString();
    }
}

