/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.compiler.lookup;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.wst.jsdt.core.UnimplementedException;
import org.eclipse.wst.jsdt.internal.compiler.lookup.CompilationUnitScope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.Scope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.wst.jsdt.internal.infer.InferredType;

public class CombinedSourceTypeBinding
extends SourceTypeBinding {
    SourceTypeBinding[] sourceTypes = new SourceTypeBinding[2];

    public CombinedSourceTypeBinding(Scope scope, SourceTypeBinding sourceTypeBinding, SourceTypeBinding sourceTypeBinding2) {
        super(sourceTypeBinding.compoundName, sourceTypeBinding.fPackage, scope);
        this.sourceTypes[0] = sourceTypeBinding;
        this.sourceTypes[1] = sourceTypeBinding2;
    }

    public void addSourceType(SourceTypeBinding sourceTypeBinding) {
        int n = this.sourceTypes.length;
        this.sourceTypes = new SourceTypeBinding[n + 1];
        System.arraycopy(this.sourceTypes, 0, this.sourceTypes, 0, n);
        this.sourceTypes[n] = sourceTypeBinding;
    }

    public FieldBinding[] fields() {
        ArrayList<FieldBinding> arrayList = new ArrayList<FieldBinding>();
        int n = 0;
        while (n < this.sourceTypes.length) {
            FieldBinding[] fieldBindingArray = this.sourceTypes[n].fields();
            arrayList.addAll(Arrays.asList(fieldBindingArray));
            ++n;
        }
        return arrayList.toArray(new FieldBinding[arrayList.size()]);
    }

    public MethodBinding getExactMethod(char[] cArray, TypeBinding[] typeBindingArray, CompilationUnitScope compilationUnitScope) {
        MethodBinding methodBinding = null;
        int n = 0;
        while (n < this.sourceTypes.length && methodBinding == null) {
            methodBinding = this.sourceTypes[n].getExactMethod(cArray, typeBindingArray, compilationUnitScope);
            ++n;
        }
        return methodBinding;
    }

    public FieldBinding getField(char[] cArray, boolean bl) {
        FieldBinding fieldBinding = null;
        int n = 0;
        while (n < this.sourceTypes.length && fieldBinding == null) {
            fieldBinding = this.sourceTypes[n].getField(cArray, bl);
            ++n;
        }
        return fieldBinding;
    }

    public InferredType getInferredType() {
        throw new UnimplementedException("should not get here");
    }

    public MethodBinding[] getMethods(char[] cArray) {
        ArrayList<MethodBinding> arrayList = new ArrayList<MethodBinding>();
        int n = 0;
        while (n < this.sourceTypes.length) {
            MethodBinding[] methodBindingArray = this.sourceTypes[n].getMethods(cArray);
            arrayList.addAll(Arrays.asList(methodBindingArray));
            ++n;
        }
        return arrayList.toArray(new MethodBinding[arrayList.size()]);
    }

    public boolean hasMemberTypes() {
        int n = 0;
        while (n < this.sourceTypes.length) {
            if (this.sourceTypes[n].hasMemberTypes()) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public boolean isEquivalentTo(TypeBinding typeBinding) {
        return this == typeBinding;
    }

    public ReferenceBinding[] memberTypes() {
        ArrayList<ReferenceBinding> arrayList = new ArrayList<ReferenceBinding>();
        int n = 0;
        while (n < this.sourceTypes.length) {
            ReferenceBinding[] referenceBindingArray = this.sourceTypes[n].memberTypes();
            arrayList.addAll(Arrays.asList(referenceBindingArray));
            ++n;
        }
        return arrayList.toArray(new ReferenceBinding[arrayList.size()]);
    }

    public MethodBinding[] methods() {
        ArrayList<MethodBinding> arrayList = new ArrayList<MethodBinding>();
        int n = 0;
        while (n < this.sourceTypes.length) {
            MethodBinding[] methodBindingArray = this.sourceTypes[n].methods();
            arrayList.addAll(Arrays.asList(methodBindingArray));
            ++n;
        }
        return arrayList.toArray(new MethodBinding[arrayList.size()]);
    }

    public void setFields(FieldBinding[] fieldBindingArray) {
        throw new UnimplementedException("should not get here");
    }

    public void setMethods(MethodBinding[] methodBindingArray) {
        throw new UnimplementedException("should not get here");
    }

    public MethodBinding getExactConstructor(TypeBinding[] typeBindingArray) {
        int n = 0;
        while (n < this.sourceTypes.length) {
            MethodBinding methodBinding = this.sourceTypes[n].getExactConstructor(typeBindingArray);
            if (methodBinding != null && methodBinding.isValidBinding()) {
                return methodBinding;
            }
            ++n;
        }
        return null;
    }

    public boolean contains(ReferenceBinding referenceBinding) {
        int n = 0;
        while (n < this.sourceTypes.length) {
            if (this.sourceTypes[n] == referenceBinding) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public void cleanup() {
        int n = 0;
        while (n < this.sourceTypes.length) {
            this.sourceTypes[n].cleanup();
            ++n;
        }
    }
}

