/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.compiler.lookup;

import org.eclipse.wst.jsdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.TypeVariableBinding;

public class InferenceContext {
    private TypeBinding[][][] collectedSubstitutes;
    MethodBinding genericMethod;
    int depth;
    int status;
    TypeBinding expectedType;
    boolean hasExplicitExpectedType;
    TypeBinding[] substitutes;
    static final int FAILED = 1;
    static final int RAW_SUBSTITUTION = 2;

    public InferenceContext(MethodBinding methodBinding) {
        this.genericMethod = methodBinding;
        TypeVariableBinding[] typeVariableBindingArray = methodBinding.typeVariables;
        int n = typeVariableBindingArray.length;
        this.collectedSubstitutes = new TypeBinding[n][3][];
        this.substitutes = new TypeBinding[n];
    }

    public boolean checkRawSubstitution() {
        if (this.depth > 0) {
            return false;
        }
        this.status = 2;
        return true;
    }

    public TypeBinding[] getSubstitutes(TypeVariableBinding typeVariableBinding, int n) {
        return this.collectedSubstitutes[typeVariableBinding.rank][n];
    }

    public boolean hasUnresolvedTypeArgument() {
        int n = 0;
        int n2 = this.substitutes.length;
        while (n < n2) {
            if (this.substitutes[n] == null) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public void recordSubstitute(TypeVariableBinding typeVariableBinding, TypeBinding typeBinding, int n) {
        block5: {
            int n2;
            TypeBinding[][] typeBindingArray = this.collectedSubstitutes[typeVariableBinding.rank];
            TypeBinding[] typeBindingArray2 = typeBindingArray[n];
            if (typeBindingArray2 == null) {
                n2 = 0;
                typeBindingArray2 = new TypeBinding[1];
            } else {
                n2 = typeBindingArray2.length;
                int n3 = 0;
                while (n3 < n2) {
                    TypeBinding typeBinding2 = typeBindingArray2[n3];
                    if (typeBinding2 == typeBinding) {
                        return;
                    }
                    if (typeBinding2 == null) {
                        typeBindingArray2[n3] = typeBinding;
                        break block5;
                    }
                    ++n3;
                }
                TypeBinding[] typeBindingArray3 = typeBindingArray2;
                typeBindingArray2 = new TypeBinding[n2 + 1];
                System.arraycopy(typeBindingArray3, 0, typeBindingArray2, 0, n2);
            }
            typeBindingArray2[n2] = typeBinding;
            typeBindingArray[n] = typeBindingArray2;
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(20);
        stringBuffer.append("InferenceContex for ");
        int n = 0;
        int n2 = this.genericMethod.typeVariables.length;
        while (n < n2) {
            stringBuffer.append(this.genericMethod.typeVariables[n]);
            ++n;
        }
        stringBuffer.append(this.genericMethod);
        stringBuffer.append("\n\t[status=");
        switch (this.status) {
            case 0: {
                stringBuffer.append("ok]");
                break;
            }
            case 1: {
                stringBuffer.append("failed]");
                break;
            }
            case 2: {
                stringBuffer.append("raw-subst]");
            }
        }
        stringBuffer.append("[depth=").append(this.depth).append(']');
        stringBuffer.append("\n\t[collected={");
        n = 0;
        n2 = this.collectedSubstitutes == null ? 0 : this.collectedSubstitutes.length;
        while (n < n2) {
            TypeBinding[][] typeBindingArray = this.collectedSubstitutes[n];
            int n3 = 0;
            while (n3 < 2) {
                TypeBinding[] typeBindingArray2 = typeBindingArray[n3];
                if (typeBindingArray2 != null) {
                    int n4 = 0;
                    int n5 = typeBindingArray2.length;
                    while (n4 < n5) {
                        stringBuffer.append("\n\t\t").append(this.genericMethod.typeVariables[n].sourceName);
                        switch (n3) {
                            case 0: {
                                stringBuffer.append("=");
                                break;
                            }
                            case 1: {
                                stringBuffer.append("<:");
                                break;
                            }
                            case 2: {
                                stringBuffer.append(">:");
                            }
                        }
                        stringBuffer.append(typeBindingArray2[n4]);
                        ++n4;
                    }
                }
                ++n3;
            }
            ++n;
        }
        stringBuffer.append("}]");
        stringBuffer.append("\n\t[inferred=");
        n = 0;
        n2 = 0;
        int n6 = this.substitutes == null ? 0 : this.substitutes.length;
        while (n2 < n6) {
            if (this.substitutes[n2] != null) {
                ++n;
                stringBuffer.append('{').append(this.genericMethod.typeVariables[n2].sourceName);
                stringBuffer.append("=").append(this.substitutes[n2]).append('}');
            }
            ++n2;
        }
        if (n == 0) {
            stringBuffer.append("{}");
        }
        stringBuffer.append(']');
        return stringBuffer.toString();
    }
}

