/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core;

import org.eclipse.wst.jsdt.core.Flags;
import org.eclipse.wst.jsdt.core.IField;
import org.eclipse.wst.jsdt.core.IMethod;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.core.Signature;
import org.eclipse.wst.jsdt.core.compiler.CharOperation;
import org.eclipse.wst.jsdt.internal.compiler.CompilationResult;
import org.eclipse.wst.jsdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.AnnotationMethodDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.Argument;
import org.eclipse.wst.jsdt.internal.compiler.ast.ArrayQualifiedTypeReference;
import org.eclipse.wst.jsdt.internal.compiler.ast.ArrayTypeReference;
import org.eclipse.wst.jsdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.ConstructorDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.FieldDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.ImportReference;
import org.eclipse.wst.jsdt.internal.compiler.ast.MethodDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.QualifiedTypeReference;
import org.eclipse.wst.jsdt.internal.compiler.ast.SingleTypeReference;
import org.eclipse.wst.jsdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.TypeReference;
import org.eclipse.wst.jsdt.internal.core.PackageFragment;
import org.eclipse.wst.jsdt.internal.core.util.Util;

public class BinaryTypeConverter {
    public static TypeDeclaration buildTypeDeclaration(IType iType, CompilationUnitDeclaration compilationUnitDeclaration, CompilationResult compilationResult) throws JavaModelException {
        PackageFragment packageFragment = (PackageFragment)iType.getPackageFragment();
        char[][] cArray = Util.toCharArrays(packageFragment.names);
        if (cArray.length > 0) {
            compilationUnitDeclaration.currentPackage = new ImportReference(cArray, new long[1], false, 0);
        }
        TypeDeclaration typeDeclaration = BinaryTypeConverter.convert(iType, null, null, compilationResult);
        IType iType2 = iType;
        IType iType3 = iType.getDeclaringType();
        TypeDeclaration typeDeclaration2 = typeDeclaration;
        while (iType3 != null) {
            TypeDeclaration typeDeclaration3 = BinaryTypeConverter.convert(iType3, iType2, typeDeclaration2, compilationResult);
            iType2 = iType3;
            typeDeclaration2 = typeDeclaration3;
            iType3 = iType3.getDeclaringType();
        }
        compilationUnitDeclaration.types = new TypeDeclaration[]{typeDeclaration2};
        return typeDeclaration;
    }

    private static FieldDeclaration convert(IField iField, IType iType) throws JavaModelException {
        FieldDeclaration fieldDeclaration = new FieldDeclaration();
        fieldDeclaration.name = iField.getElementName().toCharArray();
        fieldDeclaration.type = BinaryTypeConverter.createTypeReference(Signature.toString(iField.getTypeSignature()).toCharArray());
        fieldDeclaration.modifiers = iField.getFlags();
        return fieldDeclaration;
    }

    private static AbstractMethodDeclaration convert(IMethod iMethod, IType iType, CompilationResult compilationResult) throws JavaModelException {
        int n;
        AbstractMethodDeclaration abstractMethodDeclaration;
        AbstractMethodDeclaration abstractMethodDeclaration2;
        if (iMethod.isConstructor()) {
            abstractMethodDeclaration2 = new ConstructorDeclaration(compilationResult);
            abstractMethodDeclaration2.isDefaultConstructor = false;
            abstractMethodDeclaration = abstractMethodDeclaration2;
        } else {
            abstractMethodDeclaration2 = iType.isAnnotation() ? new AnnotationMethodDeclaration(compilationResult) : new MethodDeclaration(compilationResult);
            ((MethodDeclaration)abstractMethodDeclaration2).returnType = BinaryTypeConverter.createTypeReference(Signature.toString(iMethod.getReturnType()).toCharArray());
            abstractMethodDeclaration = abstractMethodDeclaration2;
        }
        abstractMethodDeclaration.selector = iMethod.getElementName().toCharArray();
        int n2 = iMethod.getFlags();
        boolean bl = Flags.isVarargs(n2);
        abstractMethodDeclaration.modifiers = n2 & 0xFFFFFF7F;
        String[] stringArray = iMethod.getParameterTypes();
        String[] stringArray2 = iMethod.getParameterNames();
        int n3 = stringArray == null ? 0 : stringArray.length;
        abstractMethodDeclaration.arguments = new Argument[n3];
        int n4 = 0;
        while (n4 < n3) {
            String string = stringArray[n4];
            TypeReference typeReference = BinaryTypeConverter.createTypeReference(Signature.toString(string).toCharArray());
            if (bl && n4 == n3 - 1) {
                typeReference.bits |= 0x4000;
            }
            abstractMethodDeclaration.arguments[n4] = new Argument(stringArray2[n4].toCharArray(), 0L, typeReference, 0);
            ++n4;
        }
        String[] stringArray3 = iMethod.getExceptionTypes();
        int n5 = n = stringArray3 == null ? 0 : stringArray3.length;
        if (n > 0) {
            abstractMethodDeclaration.thrownExceptions = new TypeReference[n];
            int n6 = 0;
            while (n6 < n) {
                abstractMethodDeclaration.thrownExceptions[n6] = BinaryTypeConverter.createTypeReference(Signature.toString(stringArray3[n6]).toCharArray());
                ++n6;
            }
        }
        return abstractMethodDeclaration;
    }

    private static TypeDeclaration convert(IType iType, IType iType2, TypeDeclaration typeDeclaration, CompilationResult compilationResult) throws JavaModelException {
        String[] stringArray;
        TypeDeclaration typeDeclaration2 = new TypeDeclaration(compilationResult);
        if (iType.getDeclaringType() != null) {
            typeDeclaration2.bits |= 0x400;
        }
        typeDeclaration2.name = iType.getElementName().toCharArray();
        typeDeclaration2.modifiers = iType.getFlags();
        if (iType.getSuperclassName() != null) {
            typeDeclaration2.superclass = BinaryTypeConverter.createTypeReference(iType.getSuperclassName().toCharArray());
            typeDeclaration2.superclass.bits |= 0x10;
        }
        int n = (stringArray = iType.getSuperInterfaceNames()) == null ? 0 : stringArray.length;
        typeDeclaration2.superInterfaces = new TypeReference[n];
        int n2 = 0;
        while (n2 < n) {
            typeDeclaration2.superInterfaces[n2] = BinaryTypeConverter.createTypeReference(stringArray[n2].toCharArray());
            typeDeclaration2.superInterfaces[n2].bits |= 0x10;
            ++n2;
        }
        IType[] iTypeArray = iType.getTypes();
        int n3 = iTypeArray == null ? 0 : iTypeArray.length;
        typeDeclaration2.memberTypes = new TypeDeclaration[n3];
        int n4 = 0;
        while (n4 < n3) {
            typeDeclaration2.memberTypes[n4] = iType2 != null && iType2.getFullyQualifiedName().equals(iTypeArray[n4].getFullyQualifiedName()) ? typeDeclaration : BinaryTypeConverter.convert(iTypeArray[n4], null, null, compilationResult);
            ++n4;
        }
        IField[] iFieldArray = iType.getFields();
        int n5 = iFieldArray == null ? 0 : iFieldArray.length;
        typeDeclaration2.fields = new FieldDeclaration[n5];
        int n6 = 0;
        while (n6 < n5) {
            typeDeclaration2.fields[n6] = BinaryTypeConverter.convert(iFieldArray[n6], iType);
            ++n6;
        }
        IMethod[] iMethodArray = iType.getMethods();
        int n7 = iMethodArray == null ? 0 : iMethodArray.length;
        int n8 = 1;
        int n9 = 0;
        while (n9 < n7) {
            if (iMethodArray[n9].isConstructor()) {
                n8 = 0;
                break;
            }
            ++n9;
        }
        n9 = iType.isInterface() ? 1 : 0;
        n8 = n9 != 0 ? 0 : n8;
        typeDeclaration2.methods = new AbstractMethodDeclaration[n7 + n8];
        if (n8 != 0) {
            typeDeclaration2.methods[0] = typeDeclaration2.createDefaultConstructor(false, false);
        }
        boolean bl = false;
        int n10 = 0;
        while (n10 < n7) {
            AbstractMethodDeclaration abstractMethodDeclaration = BinaryTypeConverter.convert(iMethodArray[n10], iType, compilationResult);
            boolean bl2 = abstractMethodDeclaration.isAbstract();
            if (bl2 || n9 != 0) {
                abstractMethodDeclaration.modifiers |= 0x1000000;
            }
            if (bl2) {
                bl = true;
            }
            typeDeclaration2.methods[n8 + n10] = abstractMethodDeclaration;
            ++n10;
        }
        if (bl) {
            typeDeclaration2.bits |= 0x800;
        }
        return typeDeclaration2;
    }

    private static TypeReference createTypeReference(char[] cArray) {
        int n;
        int n2 = n = cArray.length;
        int n3 = 0;
        int n4 = 1;
        int n5 = 0;
        while (n5 < n) {
            switch (cArray[n5]) {
                case '[': {
                    if (n3 == 0) {
                        n2 = n5;
                    }
                    ++n3;
                    break;
                }
                case '.': {
                    ++n4;
                }
            }
            ++n5;
        }
        if (n4 == 1) {
            if (n3 == 0) {
                return new SingleTypeReference(cArray, 0L);
            }
            char[] cArray2 = new char[n2];
            System.arraycopy(cArray, 0, cArray2, 0, n2);
            return new ArrayTypeReference(cArray2, n3, 0L);
        }
        char[][] cArray3 = CharOperation.splitOn('.', cArray, 0, n2);
        if (n3 == 0) {
            return new QualifiedTypeReference(cArray3, new long[cArray3.length]);
        }
        return new ArrayQualifiedTypeReference(cArray3, n3, new long[cArray3.length]);
    }
}

