/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.wst.jsdt.core.IBuffer;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IJavaModelStatus;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.JavaConventions;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.internal.core.JavaElementDelta;
import org.eclipse.wst.jsdt.internal.core.JavaModelOperation;
import org.eclipse.wst.jsdt.internal.core.JavaModelStatus;
import org.eclipse.wst.jsdt.internal.core.util.Messages;
import org.eclipse.wst.jsdt.internal.core.util.Util;

public class CreateCompilationUnitOperation
extends JavaModelOperation {
    protected String fName;
    protected String fSource = null;

    public CreateCompilationUnitOperation(IPackageFragment iPackageFragment, String string, String string2, boolean bl) {
        super(null, new IJavaElement[]{iPackageFragment}, bl);
        this.fName = string;
        this.fSource = string2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void executeOperation() throws JavaModelException {
        block17: {
            block15: {
                try {
                    block16: {
                        this.beginTask(Messages.operation_createUnitProgress, 2);
                        JavaElementDelta javaElementDelta = this.newJavaElementDelta();
                        ICompilationUnit iCompilationUnit = this.getCompilationUnit();
                        IPackageFragment iPackageFragment = (IPackageFragment)this.getParentElement();
                        IContainer iContainer = (IContainer)iPackageFragment.getResource();
                        this.worked(1);
                        IFile iFile = iContainer.getFile((IPath)new Path(this.fName));
                        if (iFile.exists()) {
                            if (!this.force) throw new JavaModelException(new JavaModelStatus(977, Messages.bind(Messages.status_nameCollision, iFile.getFullPath().toString())));
                            IBuffer iBuffer = iCompilationUnit.getBuffer();
                            if (iBuffer == null) {
                                Object var9_9 = null;
                                break block15;
                            }
                            iBuffer.setContents(this.fSource);
                            iCompilationUnit.save((IProgressMonitor)new NullProgressMonitor(), false);
                            this.resultElements = new IJavaElement[]{iCompilationUnit};
                            if (!Util.isExcluded(iCompilationUnit) && iCompilationUnit.getParent().exists()) {
                                int n = 0;
                                while (true) {
                                    if (n >= this.resultElements.length) {
                                        this.addDelta(javaElementDelta);
                                        break;
                                    }
                                    javaElementDelta.changed(this.resultElements[n], 1);
                                    ++n;
                                }
                            }
                        } else {
                            try {
                                String string = null;
                                try {
                                    string = iContainer.getDefaultCharset();
                                }
                                catch (CoreException coreException) {}
                                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string == null ? this.fSource.getBytes() : this.fSource.getBytes(string));
                                this.createFile(iContainer, iCompilationUnit.getElementName(), byteArrayInputStream, this.force);
                                this.resultElements = new IJavaElement[]{iCompilationUnit};
                                if (Util.isExcluded(iCompilationUnit) || !iCompilationUnit.getParent().exists()) break block16;
                                int n = 0;
                                while (true) {
                                    if (n >= this.resultElements.length) {
                                        this.addDelta(javaElementDelta);
                                        break;
                                    }
                                    javaElementDelta.added(this.resultElements[n]);
                                    ++n;
                                }
                            }
                            catch (IOException iOException) {
                                throw new JavaModelException(iOException, 985);
                            }
                        }
                    }
                    this.worked(1);
                    break block17;
                }
                catch (Throwable throwable) {
                    Object var9_10 = null;
                    this.done();
                    throw throwable;
                }
            }
            this.done();
            return;
        }
        Object var9_11 = null;
        this.done();
    }

    protected ICompilationUnit getCompilationUnit() {
        return ((IPackageFragment)this.getParentElement()).getCompilationUnit(this.fName);
    }

    protected ISchedulingRule getSchedulingRule() {
        IResource iResource = this.getCompilationUnit().getResource();
        IWorkspace iWorkspace = iResource.getWorkspace();
        if (iResource.exists()) {
            return iWorkspace.getRuleFactory().modifyRule(iResource);
        }
        return iWorkspace.getRuleFactory().createRule(iResource);
    }

    public IJavaModelStatus verify() {
        if (this.getParentElement() == null) {
            return new JavaModelStatus(968);
        }
        IJavaProject iJavaProject = this.getParentElement().getJavaProject();
        if (JavaConventions.validateCompilationUnitName(this.fName, iJavaProject.getOption("org.eclipse.wst.jsdt.core.compiler.source", true), iJavaProject.getOption("org.eclipse.wst.jsdt.core.compiler.compliance", true)).getSeverity() == 4) {
            return new JavaModelStatus(983, this.fName);
        }
        if (this.fSource == null) {
            return new JavaModelStatus(984);
        }
        return JavaModelStatus.VERIFIED_OK;
    }
}

